/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.subs.impl;

import com.biglybt.core.metasearch.FilterableResult;
import com.biglybt.core.metasearch.Result;
import com.biglybt.core.subs.Subscription;
import com.biglybt.core.subs.SubscriptionException;
import com.biglybt.core.subs.SubscriptionResultFilter;
import com.biglybt.core.subs.SubscriptionUtils;
import com.biglybt.core.subs.impl.SubscriptionImpl;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.util.JSONUtils;
import com.biglybt.util.MapUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.json.simple.JSONObject;

public class SubscriptionResultFilterImpl
implements SubscriptionResultFilter {
    private final SubscriptionImpl subs;
    private String[] textFilters;
    private Pattern[] textFilterPatterns;
    private String[] excludeTextFilters;
    private Pattern[] excludeTextFilterPatterns;
    private long minSeeds = -1L;
    private long maxSeeds = -1L;
    private long minPeers = -1L;
    private long minSize = -1L;
    private long maxSize = -1L;
    private long maxAgeSecs = -1L;
    private String categoryFilter = null;
    private static Pattern[] NO_PATTERNS = new Pattern[0];

    public SubscriptionResultFilterImpl() {
        this.subs = null;
        this.textFilters = new String[0];
        this.textFilterPatterns = NO_PATTERNS;
        this.excludeTextFilters = new String[0];
        this.excludeTextFilterPatterns = NO_PATTERNS;
    }

    public SubscriptionResultFilterImpl(SubscriptionImpl _subs, Map filters) {
        this.subs = _subs;
        try {
            this.textFilters = this.importStrings(filters, "text_filter", " ");
            this.textFilterPatterns = this.getPatterns(this.textFilters);
            this.excludeTextFilters = this.importStrings(filters, "text_filter_out", " ");
            this.excludeTextFilterPatterns = this.getPatterns(this.excludeTextFilters);
            this.minSize = MapUtils.importLong(filters, "min_size", -1L);
            this.maxSize = MapUtils.importLong(filters, "max_size", -1L);
            this.minSeeds = MapUtils.importLong(filters, "min_seeds", -1L);
            this.maxSeeds = MapUtils.importLong(filters, "max_seeds", -1L);
            this.minPeers = MapUtils.importLong(filters, "min_peers", -1L);
            this.maxAgeSecs = MapUtils.importLong(filters, "max_age", -1L);
            String rawCategory = MapUtils.getMapString(filters, "category", null);
            if (rawCategory != null) {
                this.categoryFilter = rawCategory.toLowerCase();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isActive() {
        return this.textFilters.length > 0 || this.excludeTextFilters.length > 0 || this.minSize >= 0L || this.maxSize >= 0L || this.minSeeds >= 0L || this.maxSeeds >= 0L || this.minPeers >= 0L || this.maxAgeSecs >= 0L || this.categoryFilter != null;
    }

    @Override
    public long getMinSize() {
        return this.minSize;
    }

    @Override
    public void setMinSize(long min_size) {
        if (min_size <= 0L) {
            min_size = -1L;
        }
        this.minSize = min_size;
    }

    @Override
    public long getMaxSize() {
        return this.maxSize;
    }

    @Override
    public void setMaxSize(long max_size) {
        if (max_size <= 0L) {
            max_size = -1L;
        }
        this.maxSize = max_size;
    }

    @Override
    public long getMinSeeds() {
        return this.minSeeds;
    }

    @Override
    public void setMinSeeds(long min_seeds) {
        if (min_seeds <= 0L) {
            min_seeds = -1L;
        }
        this.minSeeds = min_seeds;
    }

    @Override
    public long getMaxSeeds() {
        return this.maxSeeds;
    }

    @Override
    public void setMaxSeeds(long max_seeds) {
        if (max_seeds <= 0L) {
            max_seeds = -1L;
        }
        this.maxSeeds = max_seeds;
    }

    @Override
    public long getMinPeers() {
        return this.minPeers;
    }

    @Override
    public void setMinPeers(long min_peers) {
        if (min_peers <= 0L) {
            min_peers = -1L;
        }
        this.minPeers = min_peers;
    }

    @Override
    public long getMaxAgeSecs() {
        return this.maxAgeSecs;
    }

    @Override
    public void setMaxAgeSecs(long max_secs) {
        if (max_secs <= 0L) {
            max_secs = -1L;
        }
        this.maxAgeSecs = max_secs;
    }

    @Override
    public String[] getWithWords() {
        return this.textFilters;
    }

    @Override
    public void setWithWords(String[] with_words) {
        this.textFilters = with_words;
        this.textFilterPatterns = this.getPatterns(this.textFilters);
    }

    @Override
    public String[] getWithoutWords() {
        return this.excludeTextFilters;
    }

    @Override
    public void setWithoutWords(String[] without_words) {
        this.excludeTextFilters = without_words;
        this.excludeTextFilterPatterns = this.getPatterns(this.excludeTextFilters);
    }

    @Override
    public long getDependenciesVersion() {
        long result = 0L;
        List<Subscription> deps = this.getDependsOn();
        for (Subscription dep : deps) {
            result += dep.getMetadataMutationIndicator();
        }
        return result;
    }

    @Override
    public List<Subscription> getDependsOn() {
        return SubscriptionUtils.getDependsOnClosure(this.subs);
    }

    @Override
    public void save() throws SubscriptionException {
        Map map = JSONUtils.decodeJSON(this.subs.getJSON());
        JSONObject filters = new JSONObject();
        map.put("filters", filters);
        this.exportStrings(filters, "text_filter", this.textFilters);
        this.exportStrings(filters, "text_filter_out", this.excludeTextFilters);
        filters.put("min_size", this.minSize);
        filters.put("max_size", this.maxSize);
        filters.put("min_seeds", this.minSeeds);
        filters.put("max_seeds", this.maxSeeds);
        filters.put("min_peers", this.minPeers);
        filters.put("max_age", this.maxAgeSecs);
        this.subs.setDetails(this.subs.getName(false), this.subs.isPublic(), map.toString());
    }

    @Override
    public String getString() {
        String res = this.addString("", "+", this.getString(this.textFilters));
        res = this.addString(res, "-", this.getString(this.excludeTextFilters));
        long kInB = DisplayFormatters.getKinB();
        long mInB = kInB * kInB;
        String mb = DisplayFormatters.getUnit(2);
        res = this.addString(res, "cat=", this.categoryFilter);
        res = this.addString(res, ">=", this.minSize <= 0L ? null : String.valueOf(this.minSize / mInB) + " " + mb);
        res = this.addString(res, "<=", this.maxSize <= 0L ? null : String.valueOf(this.maxSize / mInB) + " " + mb);
        res = this.addString(res, "s>=", this.minSeeds <= 0L ? null : String.valueOf(this.minSeeds));
        res = this.addString(res, "s<=", this.maxSeeds <= 0L ? null : String.valueOf(this.maxSeeds));
        res = this.addString(res, "p>=", this.minPeers <= 0L ? null : String.valueOf(this.minPeers));
        res = this.addString(res, "a<=", this.maxAgeSecs <= 0L ? null : TimeFormatter.format3(this.maxAgeSecs, null, true));
        return res;
    }

    private String addString(String existing, String key, String rest) {
        if (rest == null || rest.length() == 0) {
            return existing;
        }
        String str = String.valueOf(key) + rest;
        if (existing == null || existing.length() == 0) {
            return str;
        }
        return String.valueOf(existing) + "," + str;
    }

    private String getString(String[] strs) {
        String res = "";
        int i = 0;
        while (i < strs.length) {
            res = String.valueOf(res) + (i == 0 ? "" : "&") + strs[i];
            ++i;
        }
        return res;
    }

    private Pattern[] getPatterns(String[] strs) {
        if (strs.length == 0) {
            return NO_PATTERNS;
        }
        Pattern[] pats = new Pattern[strs.length];
        int i = 0;
        while (i < strs.length) {
            try {
                pats[i] = Pattern.compile(strs[i].trim());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++i;
        }
        return pats;
    }

    private String[] importStrings(Map filters, String key, String separator) throws IOException {
        String rawStringFilter = MapUtils.getMapString(filters, key, null);
        if (rawStringFilter != null) {
            StringTokenizer st = new StringTokenizer(rawStringFilter, separator);
            String[] stringFilter = new String[st.countTokens()];
            int i = 0;
            while (i < stringFilter.length) {
                stringFilter[i] = st.nextToken().toLowerCase();
                ++i;
            }
            return stringFilter;
        }
        return new String[0];
    }

    private void exportStrings(Map map, String key, String[] values) {
        if (values == null || values.length == 0) {
            return;
        }
        String encoded = "";
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            encoded = String.valueOf(encoded) + (encoded == "" ? "" : " ") + value;
            ++n2;
        }
        map.put(key, encoded);
    }

    public Result[] filter(Result[] results) {
        ArrayList<Result> filteredResults = new ArrayList<Result>(results.length);
        int i = 0;
        while (i < results.length) {
            Result result = results[i];
            if (!this.isFiltered(result)) {
                filteredResults.add(result);
            }
            ++i;
        }
        Result[] fResults = filteredResults.toArray(new Result[filteredResults.size()]);
        return fResults;
    }

    @Override
    public boolean isFiltered(FilterableResult result) {
        if (this.isFilteredSupport(result)) {
            return true;
        }
        List<Subscription> deps = this.getDependsOn();
        for (Subscription dep : deps) {
            try {
                if (!((SubscriptionImpl)dep).getFilters().isFiltered(result)) continue;
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isFilteredSupport(FilterableResult result) {
        String category;
        Pattern p;
        String name = result.getName();
        if (name == null) {
            return true;
        }
        name = name.toLowerCase();
        boolean valid = true;
        int j = 0;
        while (j < this.textFilters.length) {
            if (!(name.contains(this.textFilters[j]) || (p = this.textFilterPatterns[j]) != null && p.matcher(name).find())) {
                valid = false;
                break;
            }
            ++j;
        }
        if (!valid) {
            return true;
        }
        j = 0;
        while (j < this.excludeTextFilters.length) {
            if (name.contains(this.excludeTextFilters[j])) {
                valid = false;
                break;
            }
            p = this.excludeTextFilterPatterns[j];
            if (p != null && p.matcher(name).find()) {
                valid = false;
                break;
            }
            ++j;
        }
        if (!valid) {
            return true;
        }
        long size = result.getSize();
        if (this.minSize > -1L && size < this.minSize) {
            return true;
        }
        if (this.maxSize > -1L && size > this.maxSize) {
            return true;
        }
        if (this.minSeeds > -1L && (long)result.getNbSeeds() < this.minSeeds) {
            return true;
        }
        if (this.maxSeeds > -1L && (long)result.getNbSeeds() > this.maxSeeds) {
            return true;
        }
        if (this.minPeers > -1L && (long)result.getNbPeers() < this.minPeers) {
            return true;
        }
        if (this.maxAgeSecs > -1L) {
            long time = result.getTime();
            long age_secs = (SystemTime.getCurrentTime() - time) / 1000L;
            if (age_secs > this.maxAgeSecs) {
                return true;
            }
        }
        return this.categoryFilter != null && ((category = result.getCategory()) == null || !category.equalsIgnoreCase(this.categoryFilter));
    }
}

