/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.subs.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.subs.impl.SubscriptionManagerImpl;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.core.xml.util.XUXmlWriter;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.tracker.web.TrackerWebPageRequest;
import com.biglybt.pif.tracker.web.TrackerWebPageResponse;
import com.biglybt.pif.utils.subscriptions.Subscription;
import com.biglybt.pif.utils.subscriptions.SubscriptionManager;
import com.biglybt.pif.utils.subscriptions.SubscriptionResult;
import com.biglybt.plugin.rssgen.RSSGeneratorPlugin;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.Date;

public class SubscriptionRSSFeed
implements RSSGeneratorPlugin.Provider {
    private static final String PROVIDER = "subscriptions";
    private SubscriptionManagerImpl manager;
    private PluginInterface plugin_interface;
    private RSSGeneratorPlugin generator;

    protected SubscriptionRSSFeed(SubscriptionManagerImpl _manager, PluginInterface _plugin_interface) {
        this.manager = _manager;
        this.plugin_interface = _plugin_interface;
        this.generator = RSSGeneratorPlugin.getSingleton();
        if (this.generator != null) {
            RSSGeneratorPlugin.registerProvider(PROVIDER, this);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.manager.isRSSPublishEnabled();
    }

    public String getFeedURL() {
        return this.generator == null ? "Feature Disabled" : String.valueOf(this.generator.getURL()) + PROVIDER;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean generate(TrackerWebPageRequest request2, TrackerWebPageResponse response) throws IOException {
        InetSocketAddress local_address = request2.getLocalAddress();
        if (local_address == null) {
            return false;
        }
        URL url = request2.getAbsoluteURL();
        String path = url.getPath();
        path = path.substring(PROVIDER.length() + 1);
        try {
            SubscriptionManager sman = this.plugin_interface.getUtilities().getSubscriptionManager();
            Subscription[] subs = sman.getSubscriptions();
            OutputStream os = response.getOutputStream();
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(os, "UTF-8"));
            if (path.length() <= 1) {
                response.setContentType("text/html; charset=UTF-8");
                pw.println("<HTML><HEAD><TITLE>" + Constants.APP_NAME + " Subscription Feeds</TITLE></HEAD><BODY>");
                Subscription[] subscriptionArray = subs;
                int n = subs.length;
                int n2 = 0;
                while (n2 < n) {
                    Subscription s = subscriptionArray[n2];
                    if (!s.isSearchTemplate()) {
                        String name = s.getName();
                        pw.println("<LI><A href=\"subscriptions/" + s.getID() + "\">" + name + "</A></LI>");
                    }
                    ++n2;
                }
                pw.println("</BODY></HTML>");
            } else {
                SubscriptionResult result;
                String id = path.substring(1);
                Subscription subscription = null;
                Subscription[] subscriptionArray = subs;
                int name = subs.length;
                int n = 0;
                while (n < name) {
                    Subscription s = subscriptionArray[n];
                    if (s.getID().equals(id)) {
                        subscription = s;
                        break;
                    }
                    ++n;
                }
                if (subscription == null) {
                    response.setReplyStatus(404);
                    return true;
                }
                URL feed_url = url;
                String host = (String)request2.getHeaders().get("host");
                if (host != null) {
                    host = UrlUtils.extractURLHost(host);
                    feed_url = UrlUtils.setHost(url, host);
                }
                response.setContentType("application/xml; charset=UTF-8");
                pw.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
                pw.println("<rss version=\"2.0\" xmlns:vuze=\"http://www.vuze.com\" xmlns:media=\"http://search.yahoo.com/mrss/\" xmlns:atom=\"http://www.w3.org/2005/Atom\" xmlns:itunes=\"http://www.itunes.com/dtds/podcast-1.0.dtd\">");
                pw.println("<channel>");
                String channel_title = String.valueOf(Constants.APP_NAME) + " Subscription: " + this.escape(subscription.getName());
                pw.println("<title>" + channel_title + "</title>");
                pw.println("<link>http://biglybt.com</link>");
                pw.println("<atom:link href=\"" + this.escape(feed_url.toExternalForm()) + "\" rel=\"self\" type=\"application/rss+xml\" />");
                pw.println("<description>" + Constants.APP_NAME + " RSS Feed for subscription " + this.escape(subscription.getName()) + "</description>");
                pw.println("<itunes:image href=\"https://www.biglybt.com/img/biglybt128.png\"/>");
                pw.println("<image><url>https://www.biglybt.com/img/biglybt128.png</url><title>" + channel_title + "</title><link>http://biglybt.com</link></image>");
                SubscriptionResult[] results = subscription.getResults();
                String feed_date_key = "subscriptions.feed_date." + subscription.getID();
                long feed_date = COConfigurationManager.getLongParameter(feed_date_key);
                boolean new_date = false;
                SubscriptionResult[] subscriptionResultArray = results;
                int n3 = results.length;
                int n4 = 0;
                while (n4 < n3) {
                    result = subscriptionResultArray[n4];
                    Date date = (Date)result.getProperty(2);
                    long millis = date.getTime();
                    if (millis > feed_date) {
                        feed_date = millis;
                        new_date = true;
                    }
                    ++n4;
                }
                if (new_date) {
                    COConfigurationManager.setParameter(feed_date_key, feed_date);
                }
                pw.println("<pubDate>" + TimeFormatter.getHTTPDate(feed_date) + "</pubDate>");
                subscriptionResultArray = results;
                n3 = results.length;
                n4 = 0;
                while (n4 < n3) {
                    result = subscriptionResultArray[n4];
                    try {
                        String[] tags;
                        String cat;
                        Long rank;
                        Long peers;
                        Long seeds;
                        String uid;
                        pw.println("<item>");
                        String name2 = (String)result.getProperty(1);
                        pw.println("<title>" + this.escape(name2) + "</title>");
                        Date date = (Date)result.getProperty(2);
                        if (date != null) {
                            pw.println("<pubDate>" + TimeFormatter.getHTTPDate(date.getTime()) + "</pubDate>");
                        }
                        if ((uid = (String)result.getProperty(20)) != null) {
                            pw.println("<guid isPermaLink=\"false\">" + this.escape(uid) + "</guid>");
                        }
                        String link = (String)result.getProperty(12);
                        Long size = (Long)result.getProperty(3);
                        if (link != null) {
                            pw.println("<link>" + this.escape(link) + "</link>");
                            if (size != null) {
                                pw.println("<media:content fileSize=\"" + size + "\" url=\"" + this.escape(link) + "\"/>");
                            }
                        }
                        if (size != null) {
                            pw.println("<vuze:size>" + size + "</vuze:size>");
                        }
                        if ((seeds = (Long)result.getProperty(5)) != null) {
                            pw.println("<vuze:seeds>" + seeds + "</vuze:seeds>");
                        }
                        if ((peers = (Long)result.getProperty(4)) != null) {
                            pw.println("<vuze:peers>" + peers + "</vuze:peers>");
                        }
                        if ((rank = (Long)result.getProperty(17)) != null) {
                            pw.println("<vuze:rank>" + rank + "</vuze:rank>");
                        }
                        if ((cat = (String)result.getProperty(7)) != null && !cat.isEmpty()) {
                            pw.println("<category>" + this.escape(cat) + "</category>");
                        }
                        if ((tags = (String[])result.getProperty(25)) != null) {
                            String[] stringArray = tags;
                            int n5 = tags.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                String tag = stringArray[n6];
                                pw.println("<tag>" + this.escape(tag) + "</tag>");
                                ++n6;
                            }
                        }
                        pw.println("</item>");
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                    ++n4;
                }
                pw.println("</channel>");
                pw.println("</rss>");
            }
            pw.flush();
        }
        catch (Throwable e) {
            Debug.out(e);
            throw new IOException(Debug.getNestedExceptionMessage(e));
        }
        return true;
    }

    protected String escape(String str) {
        return XUXmlWriter.escapeXML(str);
    }

    protected String escapeMultiline(String str) {
        return XUXmlWriter.escapeXML(str.replaceAll("[\r\n]+", "<BR>"));
    }
}

