/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.stats.transfer.impl;

import com.biglybt.core.Core;
import com.biglybt.core.CoreComponent;
import com.biglybt.core.CoreLifecycleAdapter;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.dht.DHT;
import com.biglybt.core.dht.transport.DHTTransportStats;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.global.GlobalManagerStats;
import com.biglybt.core.stats.transfer.StatsFactory;
import com.biglybt.core.stats.transfer.impl.LongTermStatsBase;
import com.biglybt.core.stats.transfer.impl.OverallStatsImpl;
import com.biglybt.core.util.FileUtil;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.PluginManager;
import com.biglybt.plugin.dht.DHTPlugin;

public class LongTermStatsImpl
extends LongTermStatsBase {
    private Core core;
    private GlobalManagerStats gm_stats;
    private DHT[] dhts;
    private long st_p_sent;
    private long st_d_sent;
    private long st_p_received;
    private long st_d_received;
    private long st_dht_sent;
    private long st_dht_received;
    private long ss_p_sent;
    private long ss_d_sent;
    private long ss_p_received;
    private long ss_d_received;
    private long ss_dht_sent;
    private long ss_dht_received;

    public LongTermStatsImpl(Core _core, GlobalManagerStats _gm_stats) {
        super(6);
        this.core = _core;
        this.gm_stats = _gm_stats;
        this.stats_dir = FileUtil.getUserFile("stats");
        _core.addLifecycleListener(new CoreLifecycleAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void componentCreated(Core core, CoreComponent component) {
                if (LongTermStatsImpl.this.destroyed) {
                    core.removeLifecycleListener(this);
                    return;
                }
                if (component instanceof GlobalManager) {
                    LongTermStatsImpl longTermStatsImpl = LongTermStatsImpl.this;
                    synchronized (longTermStatsImpl) {
                        LongTermStatsImpl.this.sessionStart();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopped(Core core) {
                if (LongTermStatsImpl.this.destroyed) {
                    core.removeLifecycleListener(this);
                    return;
                }
                LongTermStatsImpl longTermStatsImpl = LongTermStatsImpl.this;
                synchronized (longTermStatsImpl) {
                    LongTermStatsImpl.this.closing = true;
                    if (LongTermStatsImpl.this.active) {
                        LongTermStatsImpl.this.sessionEnd();
                    }
                }
            }
        });
    }

    private DHT[] getDHTs() {
        if (this.dhts == null) {
            try {
                PluginManager pm = this.core.getPluginManager();
                if (pm.isInitialized()) {
                    PluginInterface dht_pi = pm.getPluginInterfaceByClass(DHTPlugin.class);
                    if (dht_pi == null) {
                        this.dhts = new DHT[0];
                    } else {
                        DHTPlugin plugin = (DHTPlugin)dht_pi.getPlugin();
                        if (!plugin.isInitialising()) {
                            this.dhts = plugin.isEnabled() ? ((DHTPlugin)dht_pi.getPlugin()).getDHTs() : new DHT[0];
                        }
                    }
                }
            }
            catch (Throwable e) {
                this.dhts = new DHT[0];
            }
        }
        return this.dhts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sessionStart() {
        OverallStatsImpl stats2 = (OverallStatsImpl)StatsFactory.getStats();
        LongTermStatsImpl longTermStatsImpl = this;
        synchronized (longTermStatsImpl) {
            DHT[] dhts;
            if (this.closing) {
                return;
            }
            boolean enabled = COConfigurationManager.getBooleanParameter("long.term.stats.enable");
            if (this.active || !enabled) {
                return;
            }
            this.active = true;
            long[] snap = stats2.getLastSnapshot();
            this.ss_d_received = this.gm_stats.getTotalDataBytesReceived();
            this.ss_p_received = this.gm_stats.getTotalProtocolBytesReceived();
            this.ss_d_sent = this.gm_stats.getTotalDataBytesSent();
            this.ss_p_sent = this.gm_stats.getTotalProtocolBytesSent();
            this.ss_dht_sent = 0L;
            this.ss_dht_received = 0L;
            if (this.core.isStarted() && (dhts = this.getDHTs()) != null) {
                DHT[] dHTArray = dhts;
                int n = dhts.length;
                int n2 = 0;
                while (n2 < n) {
                    DHT dht = dHTArray[n2];
                    DHTTransportStats dht_stats = dht.getTransport().getStats();
                    this.ss_dht_sent += dht_stats.getBytesSent();
                    this.ss_dht_received += dht_stats.getBytesReceived();
                    ++n2;
                }
            }
            this.st_p_sent = snap[0] + (this.ss_p_sent - snap[6]);
            this.st_d_sent = snap[1] + (this.ss_d_sent - snap[7]);
            this.st_p_received = snap[2] + (this.ss_p_received - snap[8]);
            this.st_d_received = snap[3] + (this.ss_d_received - snap[9]);
            this.st_dht_sent = snap[4] + (this.ss_dht_sent - snap[10]);
            this.st_dht_received = snap[5] + (this.ss_dht_received - snap[11]);
            this.write(1, new long[]{this.st_p_sent, this.st_d_sent, this.st_p_received, this.st_d_received, this.st_dht_sent, this.st_dht_received});
            this.sessionStartComplete("LongTermStats");
        }
    }

    @Override
    protected void updateStats(int record_type) {
        long current_d_received = this.gm_stats.getTotalDataBytesReceived();
        long current_p_received = this.gm_stats.getTotalProtocolBytesReceived();
        long current_d_sent = this.gm_stats.getTotalDataBytesSent();
        long current_p_sent = this.gm_stats.getTotalProtocolBytesSent();
        long current_dht_sent = 0L;
        long current_dht_received = 0L;
        DHT[] dhts = this.getDHTs();
        if (dhts != null) {
            DHT[] dHTArray = dhts;
            int n = dhts.length;
            int n2 = 0;
            while (n2 < n) {
                DHT dht = dHTArray[n2];
                DHTTransportStats dht_stats = dht.getTransport().getStats();
                current_dht_sent += dht_stats.getBytesSent();
                current_dht_received += dht_stats.getBytesReceived();
                ++n2;
            }
        }
        this.write(record_type, new long[]{current_p_sent - this.ss_p_sent, current_d_sent - this.ss_d_sent, current_p_received - this.ss_p_received, current_d_received - this.ss_d_received, current_dht_sent - this.ss_dht_sent, current_dht_received - this.ss_dht_received});
    }

    @Override
    protected long[] getNewFileSessionStats(long[] line_stats) {
        this.st_p_sent += line_stats[0];
        this.st_d_sent += line_stats[1];
        this.st_p_received += line_stats[2];
        this.st_d_received += line_stats[3];
        this.st_dht_sent += line_stats[4];
        this.st_dht_received += line_stats[5];
        this.ss_p_sent += line_stats[0];
        this.ss_d_sent += line_stats[1];
        this.ss_p_received += line_stats[2];
        this.ss_d_received += line_stats[3];
        this.ss_dht_sent += line_stats[4];
        this.ss_dht_received += line_stats[5];
        long[] st_stats = new long[]{this.st_p_sent, this.st_d_sent, this.st_p_received, this.st_d_received, this.st_dht_sent, this.st_dht_received};
        return st_stats;
    }
}

