/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.speedmanager.impl.v2;

import com.biglybt.core.speedmanager.SpeedManagerLimitEstimate;
import com.biglybt.core.speedmanager.SpeedManagerListener;
import com.biglybt.core.speedmanager.impl.v2.PingSpaceMon;
import com.biglybt.core.speedmanager.impl.v2.SMSearchLogger;
import com.biglybt.core.speedmanager.impl.v2.SpeedLimitMonitor;
import com.biglybt.core.speedmanager.impl.v2.SpeedManagerLogger;

public class SpeedLimitListener
implements SpeedManagerListener {
    final SpeedLimitMonitor mon;

    public SpeedLimitListener(SpeedLimitMonitor limitMonitor) {
        this.mon = limitMonitor;
    }

    @Override
    public void propertyChanged(int property) {
        String type = "unknown";
        if (property == 1) {
            type = "ASN change";
            this.mon.readFromPersistentMap();
            this.mon.updateFromCOConfigManager();
            SMSearchLogger.log("ASN change.");
        } else if (property == 3) {
            type = "download capacity";
            SpeedManagerLimitEstimate pmEst = PingSpaceMon.getDownloadLimit();
            SpeedManagerLimitEstimate smEst = PingSpaceMon.getDownloadEstCapacity();
            SMSearchLogger.log(" download - persistent limit: " + pmEst.getString());
            SMSearchLogger.log(" download - estimated capacity: " + smEst.getString());
            this.mon.notifyDownload(smEst);
        } else if (property == 2) {
            type = "upload capacity";
            SpeedManagerLimitEstimate shortTermLimit = PingSpaceMon.getUploadLimit(false);
            SpeedManagerLimitEstimate pmEst = PingSpaceMon.getUploadLimit(true);
            SpeedManagerLimitEstimate smEst = PingSpaceMon.getUploadEstCapacity();
            SMSearchLogger.log(" upload - short term limit: " + shortTermLimit.getString());
            SMSearchLogger.log(" upload - persistent limit: " + pmEst.getString());
            SMSearchLogger.log(" upload - estimated capacity: " + smEst.getString());
            this.mon.notifyUpload(smEst);
        }
        SpeedManagerLogger.log("Updated from SpeedManagerPingMapper property=" + type);
    }
}

