/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.speedmanager;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.speedmanager.SpeedManagerLimitEstimate;
import com.biglybt.core.util.DisplayFormatters;

public class LimitToTextHelper {
    String msg_text_unknown = MessageText.getString("SpeedView.stats.unknown");
    String msg_text_estimate = MessageText.getString("SpeedView.stats.estimate");
    String msg_text_choke_estimate = MessageText.getString("SpeedView.stats.estimatechoke");
    String msg_text_measured_min;
    String msg_text_measured = MessageText.getString("SpeedView.stats.measured");
    String msg_text_manual;
    String msg_unlimited;
    String[] setable_types;

    public LimitToTextHelper() {
        this.msg_text_measured_min = MessageText.getString("SpeedView.stats.measuredmin");
        this.msg_text_manual = MessageText.getString("SpeedView.stats.manual");
        this.msg_unlimited = MessageText.getString("ConfigView.unlimited");
        this.setable_types = new String[]{"", this.msg_text_estimate, this.msg_text_measured, this.msg_text_manual};
    }

    public String[] getSettableTypes() {
        return this.setable_types;
    }

    public String getSettableType(SpeedManagerLimitEstimate limit) {
        float type = limit.getEstimateType();
        String text = type == -0.1f ? "" : (type == 1.0f ? this.msg_text_manual : (type == 0.9f ? this.msg_text_measured : (type == 0.8f ? this.msg_text_measured : (type == 0.5f ? this.msg_text_estimate : this.msg_text_estimate))));
        return text;
    }

    public String typeToText(float type) {
        String text = type == -0.1f ? this.msg_text_unknown : (type == 1.0f ? this.msg_text_manual : (type == 0.9f ? this.msg_text_measured : (type == 0.8f ? this.msg_text_measured_min : (type == 0.5f ? this.msg_text_choke_estimate : this.msg_text_estimate))));
        return text;
    }

    public float textToType(String text) {
        if (text.equals(this.msg_text_estimate)) {
            return 0.0f;
        }
        if (text.equals(this.msg_text_choke_estimate)) {
            return 0.5f;
        }
        if (text.equals(this.msg_text_measured)) {
            return 0.9f;
        }
        if (text.equals(this.msg_text_manual)) {
            return 1.0f;
        }
        return -0.1f;
    }

    public String getLimitText(SpeedManagerLimitEstimate limit) {
        float type = limit.getEstimateType();
        String text = this.typeToText(type);
        int l = limit.getBytesPerSec();
        if (l == 0) {
            return String.valueOf(this.msg_unlimited) + " (" + text + ")";
        }
        return String.valueOf(DisplayFormatters.formatByteCountToKiBEtcPerSec(l)) + " (" + text + ")";
    }

    public String getUnlimited() {
        return this.msg_unlimited;
    }
}

