/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.proxy.socks.impl;

import com.biglybt.core.proxy.socks.AESocksProxyAddress;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.HostNameToIPResolver;
import java.net.InetAddress;

public class AESocksProxyAddressImpl
implements AESocksProxyAddress {
    protected final String unresolved_address;
    protected InetAddress address;
    protected final int port;

    protected AESocksProxyAddressImpl(String _unresolved_address, InetAddress _address, int _port) {
        this.unresolved_address = _unresolved_address;
        this.address = _address;
        this.port = _port;
        if (this.address == null) {
            int dots = 0;
            boolean ok = true;
            int i = 0;
            while (i < this.unresolved_address.length()) {
                char c = this.unresolved_address.charAt(i);
                if (c == '.') {
                    if (++dots > 3) {
                        ok = false;
                        break;
                    }
                } else {
                    if (!Character.isDigit(c)) {
                        ok = false;
                        break;
                    }
                    if (i > 15) {
                        ok = false;
                        break;
                    }
                }
                ++i;
            }
            if (ok && dots == 3) {
                try {
                    this.address = HostNameToIPResolver.syncResolve(this.unresolved_address);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    @Override
    public String getUnresolvedAddress() {
        return this.unresolved_address;
    }

    @Override
    public InetAddress getAddress() {
        return this.address;
    }

    @Override
    public int getPort() {
        return this.port;
    }
}

