/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.peermanager.utils;

import com.biglybt.core.util.SystemTime;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class PeerMessageLimiter {
    private final HashMap message_counts = new HashMap();

    public boolean countIncomingMessage(String message_id, int max_counts, int time_limit_ms) {
        CountData data = (CountData)this.message_counts.get(message_id);
        if (data == null) {
            data = new CountData(max_counts, time_limit_ms);
            this.message_counts.put(message_id, data);
        }
        long now = SystemTime.getCurrentTime();
        data.counts.addLast(new Long(now));
        if (data.counts.size() > data.max_counts) {
            long cutoff = now - (long)data.time_limit;
            Iterator it = data.counts.iterator();
            while (it.hasNext()) {
                long time = (Long)it.next();
                if (time >= cutoff) break;
                it.remove();
            }
            if (data.counts.size() > data.max_counts) {
                return false;
            }
        }
        return true;
    }

    private static class CountData {
        private final int max_counts;
        private final int time_limit;
        private final LinkedList counts = new LinkedList();

        private CountData(int max_counts, int time_limit) {
            this.max_counts = max_counts;
            this.time_limit = time_limit;
        }
    }
}

