/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.peermanager.utils;

import com.biglybt.core.peermanager.utils.BTPeerIDByteDecoder;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.FeatureAvailability;
import com.biglybt.core.util.HostNameToIPResolver;
import com.biglybt.core.util.IPToHostNameResolver;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class PeerClassifier {
    public static final String CACHE_LOGIC = "CacheLogic";
    private static final Set platform_ips = Collections.synchronizedSet(new HashSet());

    public static String getClientDescription(byte[] peer_id, String net) {
        return BTPeerIDByteDecoder.decode(peer_id, net);
    }

    public static String getPrintablePeerID(byte[] peer_id) {
        return BTPeerIDByteDecoder.getPrintablePeerID(peer_id);
    }

    public static boolean isClientTypeAllowed(String client_description) {
        return true;
    }

    public static boolean fullySupportsFE(String client_description) {
        if (FeatureAvailability.allowAllFEClients()) {
            return true;
        }
        boolean res = !client_description.startsWith("\u00b5") && !client_description.startsWith("Trans");
        return res;
    }

    public static boolean isAzureusIP(String ip) {
        return platform_ips.contains(ip);
    }

    public static void setAzureusIP(String ip) {
        platform_ips.add(ip);
    }

    public static boolean testIfAzureusIP(String ip) {
        String host_address;
        block4: {
            InetAddress address = HostNameToIPResolver.syncResolve(ip);
            host_address = address.getHostAddress();
            if (!platform_ips.contains(host_address)) break block4;
            return true;
        }
        try {
            String name = IPToHostNameResolver.syncResolve(ip, 10000);
            if (Constants.isAppDomain(name)) {
                platform_ips.add(host_address);
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }
}

