/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.peermanager.utils;

class BTPeerIDByteDecoderUtils {
    BTPeerIDByteDecoderUtils() {
    }

    public static String decodeMnemonic(char c) {
        switch (c) {
            case 'B': 
            case 'b': {
                return "Beta";
            }
            case 'X': 
            case 'Z': 
            case 'x': {
                return "(Dev)";
            }
        }
        return null;
    }

    public static String decodeNumericValueOfByte(byte b) {
        return String.valueOf(b & 0xFF);
    }

    public static String decodeNumericValueOfByte(byte b, int min_digits) {
        String result = BTPeerIDByteDecoderUtils.decodeNumericValueOfByte(b);
        while (result.length() < min_digits) {
            result = "0" + result;
        }
        return result;
    }

    public static String decodeNumericChar(char c) {
        String result = BTPeerIDByteDecoderUtils.decodeAlphaNumericChar(c);
        if (result == null || result.length() == 1) {
            return result;
        }
        return null;
    }

    public static String intchar(char c) {
        String result = BTPeerIDByteDecoderUtils.decodeNumericChar(c);
        if (result == null) {
            throw new IllegalArgumentException("not an integer character: " + c);
        }
        return result;
    }

    public static String decodeAlphaNumericChar(char c) {
        if ('0' <= c && c <= '9') {
            return String.valueOf(c);
        }
        if ('A' <= c && c <= 'Z') {
            return String.valueOf(10 + (c - 65));
        }
        if ('a' <= c && c <= 'z') {
            return String.valueOf(36 + (c - 65));
        }
        if (c == '.') {
            return "62";
        }
        return null;
    }

    public static boolean isAzStyle(String peer_id) {
        if (peer_id.charAt(0) != '-') {
            return false;
        }
        if (peer_id.charAt(7) == '-') {
            return true;
        }
        if (peer_id.substring(1, 3).equals("FG")) {
            return true;
        }
        if (peer_id.substring(1, 3).equals("LH")) {
            return true;
        }
        if (peer_id.substring(1, 3).equals("NE")) {
            return true;
        }
        if (peer_id.substring(1, 3).equals("KT")) {
            return true;
        }
        return peer_id.substring(1, 3).equals("SP");
    }

    public static boolean isShadowStyle(String peer_id) {
        if (peer_id.charAt(5) != '-') {
            return false;
        }
        if (!Character.isLetter(peer_id.charAt(0))) {
            return false;
        }
        if (!Character.isDigit(peer_id.charAt(1)) && peer_id.charAt(1) != '-') {
            return false;
        }
        int last_ver_num_index = 4;
        while (last_ver_num_index > 0) {
            if (peer_id.charAt(last_ver_num_index) != '-') break;
            --last_ver_num_index;
        }
        int i = 1;
        while (i <= last_ver_num_index) {
            char c = peer_id.charAt(i);
            if (c == '-') {
                return false;
            }
            if (BTPeerIDByteDecoderUtils.decodeAlphaNumericChar(c) == null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isMainlineStyle(String peer_id) {
        return peer_id.charAt(2) == '-' && peer_id.charAt(7) == '-' && (peer_id.charAt(4) == '-' || peer_id.charAt(5) == '-');
    }

    public static boolean isPossibleSpoofClient(String peer_id) {
        return peer_id.endsWith("UDP0") || peer_id.endsWith("HTTPBT");
    }

    public static String getMainlineStyleVersionNumber(String peer_id) {
        boolean two_digit_in_middle = peer_id.charAt(5) == '-';
        String middle_part = BTPeerIDByteDecoderUtils.decodeNumericChar(peer_id.charAt(3));
        if (two_digit_in_middle) {
            middle_part = BTPeerIDByteDecoderUtils.join(middle_part, BTPeerIDByteDecoderUtils.decodeNumericChar(peer_id.charAt(4)));
        }
        return BTPeerIDByteDecoderUtils.joinAsDotted(BTPeerIDByteDecoderUtils.decodeNumericChar(peer_id.charAt(1)), middle_part, BTPeerIDByteDecoderUtils.decodeNumericChar(peer_id.charAt(two_digit_in_middle ? 6 : 5)));
    }

    public static String getShadowStyleVersionNumber(String peer_id) {
        String ver_number = BTPeerIDByteDecoderUtils.decodeAlphaNumericChar(peer_id.charAt(1));
        if (ver_number == null) {
            return null;
        }
        int i = 2;
        while (i < 6 && ver_number != null) {
            char c = peer_id.charAt(i);
            if (c == '-') break;
            if ((ver_number = BTPeerIDByteDecoderUtils.joinAsDotted(ver_number, BTPeerIDByteDecoderUtils.decodeAlphaNumericChar(peer_id.charAt(i)))) == null) {
                return null;
            }
            ++i;
        }
        while (ver_number.endsWith(".0")) {
            ver_number = ver_number.substring(0, ver_number.length() - 2);
        }
        return ver_number;
    }

    public static String decodeAzStyleVersionNumber(String version_data, String version_scheme) {
        char a = version_data.charAt(0);
        char b = version_data.charAt(1);
        char c = version_data.charAt(2);
        char d = version_data.charAt(3);
        if (version_scheme == "transmission") {
            version_scheme = version_data.startsWith("000") ? "3.4" : (version_data.startsWith("00") ? "2.34" : "1.23 [4]");
        }
        if (version_scheme == "1.2.3.4") {
            return String.valueOf(BTPeerIDByteDecoderUtils.decodeAlphaNumericChar(a)) + "." + BTPeerIDByteDecoderUtils.decodeAlphaNumericChar(b) + "." + BTPeerIDByteDecoderUtils.decodeAlphaNumericChar(c) + "." + BTPeerIDByteDecoderUtils.decodeAlphaNumericChar(d);
        }
        if (version_scheme == "1.2.3" || version_scheme == "1.2.3 [4]" || version_scheme == "1.23 [4]") {
            String mnemonic;
            String result = version_scheme == "1.23 [4]" ? String.valueOf(BTPeerIDByteDecoderUtils.intchar(a)) + "." + BTPeerIDByteDecoderUtils.intchar(b) + BTPeerIDByteDecoderUtils.intchar(c) : String.valueOf(BTPeerIDByteDecoderUtils.intchar(a)) + "." + BTPeerIDByteDecoderUtils.intchar(b) + "." + BTPeerIDByteDecoderUtils.intchar(c);
            if ((version_scheme == "1.2.3 [4]" || version_scheme == "1.23 [4]") && (mnemonic = BTPeerIDByteDecoderUtils.decodeMnemonic(d)) != null) {
                result = String.valueOf(result) + " " + mnemonic;
            }
            return result;
        }
        if (version_scheme == "12.34") {
            return String.valueOf(a == '0' ? "" : BTPeerIDByteDecoderUtils.intchar(a)) + BTPeerIDByteDecoderUtils.intchar(b) + "." + BTPeerIDByteDecoderUtils.intchar(c) + BTPeerIDByteDecoderUtils.intchar(d);
        }
        if (version_scheme == "2.3.4") {
            return String.valueOf(BTPeerIDByteDecoderUtils.intchar(b)) + "." + BTPeerIDByteDecoderUtils.intchar(c) + "." + BTPeerIDByteDecoderUtils.intchar(d);
        }
        if (version_scheme == "2.33.4") {
            return String.valueOf(BTPeerIDByteDecoderUtils.decodeAlphaNumericChar(a)) + "." + BTPeerIDByteDecoderUtils.decodeAlphaNumericChar(b) + "." + BTPeerIDByteDecoderUtils.decodeAlphaNumericChar(c);
        }
        if (version_scheme == "2.34") {
            return String.valueOf(BTPeerIDByteDecoderUtils.intchar(b)) + "." + BTPeerIDByteDecoderUtils.intchar(c) + BTPeerIDByteDecoderUtils.intchar(d);
        }
        if (version_scheme == "1.23.4") {
            return String.valueOf(BTPeerIDByteDecoderUtils.intchar(a)) + "." + BTPeerIDByteDecoderUtils.intchar(b) + BTPeerIDByteDecoderUtils.intchar(c) + "." + BTPeerIDByteDecoderUtils.intchar(d);
        }
        if (version_scheme == "1.2.3=[RD].4") {
            switch (c) {
                case 'R': {
                    return String.valueOf(BTPeerIDByteDecoderUtils.intchar(a)) + "." + BTPeerIDByteDecoderUtils.intchar(b) + " RC" + BTPeerIDByteDecoderUtils.intchar(d);
                }
                case 'D': {
                    return String.valueOf(BTPeerIDByteDecoderUtils.intchar(a)) + "." + BTPeerIDByteDecoderUtils.intchar(b) + " Dev";
                }
            }
            return String.valueOf(BTPeerIDByteDecoderUtils.intchar(a)) + "." + BTPeerIDByteDecoderUtils.intchar(b);
        }
        if (version_scheme.equals("1.234")) {
            return String.valueOf(BTPeerIDByteDecoderUtils.intchar(a)) + "." + BTPeerIDByteDecoderUtils.intchar(b) + BTPeerIDByteDecoderUtils.intchar(c) + BTPeerIDByteDecoderUtils.intchar(d);
        }
        if (version_scheme.equals("1.2(34)")) {
            return String.valueOf(BTPeerIDByteDecoderUtils.intchar(a)) + "." + BTPeerIDByteDecoderUtils.intchar(b) + "(" + BTPeerIDByteDecoderUtils.intchar(c) + BTPeerIDByteDecoderUtils.intchar(d) + ")";
        }
        if (version_scheme.equals("1.2.34")) {
            return String.valueOf(BTPeerIDByteDecoderUtils.intchar(a)) + "." + BTPeerIDByteDecoderUtils.intchar(b) + "." + BTPeerIDByteDecoderUtils.intchar(c) + BTPeerIDByteDecoderUtils.intchar(d);
        }
        if (version_scheme.equals("v1234")) {
            return "v" + BTPeerIDByteDecoderUtils.intchar(a) + BTPeerIDByteDecoderUtils.intchar(b) + BTPeerIDByteDecoderUtils.intchar(c) + BTPeerIDByteDecoderUtils.intchar(d);
        }
        if (version_scheme.equals("1.2")) {
            return String.valueOf(BTPeerIDByteDecoderUtils.intchar(a)) + "." + BTPeerIDByteDecoderUtils.intchar(b);
        }
        if (version_scheme.equals("3.4")) {
            return String.valueOf(BTPeerIDByteDecoderUtils.intchar(c)) + "." + BTPeerIDByteDecoderUtils.intchar(d);
        }
        if (version_scheme.equals("12.3-4")) {
            return String.valueOf(BTPeerIDByteDecoderUtils.decodeAlphaNumericChar(a)) + BTPeerIDByteDecoderUtils.decodeAlphaNumericChar(b) + "." + BTPeerIDByteDecoderUtils.decodeAlphaNumericChar(c) + "-" + BTPeerIDByteDecoderUtils.decodeAlphaNumericChar(d);
        }
        if (version_scheme == "v1.2.3.4") {
            return "v" + BTPeerIDByteDecoderUtils.decodeAzStyleVersionNumber(version_data, "1.2.3.4");
        }
        throw new RuntimeException("unknown AZ style version number scheme - " + version_scheme);
    }

    public static String getTwoByteThreePartVersion(byte b1, byte b2) {
        String min_part = BTPeerIDByteDecoderUtils.decodeNumericValueOfByte(b2, 2);
        return BTPeerIDByteDecoderUtils.joinAsDotted(BTPeerIDByteDecoderUtils.decodeNumericValueOfByte(b1), min_part.substring(0, 1), min_part.substring(1, 2));
    }

    public static String extractReadableVersionSubstringFromPeerID(String peer_id) {
        int i = 0;
        while (i < peer_id.length()) {
            char c = peer_id.charAt(i);
            if (!Character.isLetter(c) && !Character.isDigit(c) && c != '.') {
                return peer_id.substring(0, i);
            }
            ++i;
        }
        return peer_id;
    }

    public static String decodeCustomVersionNumber(String version_data, String version_scheme) {
        if (version_scheme == "abcde") {
            return version_data;
        }
        if (version_scheme == "a.b.c.d.e" || version_scheme == "abcde -> a.b.c.d.e") {
            int inc_size = version_scheme == "a.b.c.d.e" ? 2 : 1;
            String result = version_data.substring(0, 1);
            int i = 0 + inc_size;
            while (i < version_data.length()) {
                result = BTPeerIDByteDecoderUtils.joinAsDotted(result, String.valueOf(version_data.charAt(i)));
                i += inc_size;
            }
            return result;
        }
        if (version_scheme == "abcde -> n.o.p.q.r") {
            String result = "";
            int i = 0;
            while (i < version_data.length()) {
                char c = version_data.charAt(i);
                String str = c >= 'a' ? String.valueOf(c - 97 + 10) : String.valueOf(c);
                result = result.isEmpty() ? str : BTPeerIDByteDecoderUtils.joinAsDotted(result, str);
                ++i;
            }
            return result;
        }
        if (version_scheme == "abcde -> ab.cd") {
            String result = "";
            int i = 0;
            while (i < version_data.length()) {
                String s = version_data.substring(i, i + 2);
                if (i == 0) {
                    if (s.charAt(0) == '0') {
                        s = s.substring(1);
                    }
                    result = s;
                } else {
                    result = BTPeerIDByteDecoderUtils.joinAsDotted(result, s);
                }
                i += 2;
            }
            return result;
        }
        if (version_scheme == "BOW-STYLE") {
            if (version_data.equals("A0C")) {
                return "1.0.6";
            }
            if (version_data.equals("A0B")) {
                return "1.0.5";
            }
            throw new RuntimeException("Unknown BitsOnWheels version number - " + version_data);
        }
        if (version_scheme == "abcd -> a.b.cd") {
            char[] chars = version_data.toCharArray();
            return String.valueOf(chars[0]) + "." + chars[1] + "." + chars[2] + chars[3];
        }
        if (version_scheme == "abcdef -> a.b.c-edf") {
            char[] chars = version_data.toCharArray();
            return String.valueOf(chars[0]) + "." + chars[1] + "." + chars[2] + "-" + chars[3] + chars[4] + chars[5];
        }
        if (version_scheme == "a-bb-d") {
            char[] chars = version_data.toCharArray();
            return String.valueOf(chars[0]) + "." + chars[2] + chars[3] + "." + chars[5];
        }
        throw new RuntimeException("unknown custom version number scheme - " + version_scheme);
    }

    private static String join(String a, String b) {
        if (a == null) {
            return null;
        }
        if (b == null) {
            return null;
        }
        return String.valueOf(a) + b;
    }

    private static String joinAsDotted(String a, String b) {
        if (a == null) {
            return null;
        }
        if (b == null) {
            return null;
        }
        return String.valueOf(a) + "." + b;
    }

    private static String joinAsDotted(String a, String b, String c) {
        if (a == null) {
            return null;
        }
        if (b == null) {
            return null;
        }
        if (c == null) {
            return null;
        }
        return String.valueOf(a) + "." + b + "." + c;
    }
}

