/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.peermanager.messaging.bittorrent;

import com.biglybt.core.networkmanager.RawMessage;
import com.biglybt.core.peermanager.messaging.Message;
import com.biglybt.core.peermanager.messaging.MessageException;
import com.biglybt.core.peermanager.messaging.bittorrent.BTMessage;
import com.biglybt.core.peermanager.utils.PeerClassifier;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.DirectByteBufferPool;
import com.biglybt.core.util.RandomUtils;

public class BTHandshake
implements BTMessage,
RawMessage {
    public static final String PROTOCOL = "BitTorrent protocol";
    private static final byte[] BT_RESERVED = new byte[8];
    private static final byte[] LT_RESERVED;
    public static final byte[] AZ_RESERVED;
    public static final int BT_RESERVED_MODE = 0;
    public static final int LT_RESERVED_MODE = 1;
    public static final int AZ_RESERVED_MODE = 2;
    private static final byte[][] RESERVED;
    public static final boolean FAST_EXTENSION_ENABLED = true;
    private DirectByteBuffer buffer = null;
    private String description = null;
    private final byte[] reserved_bytes;
    private final byte[] datahash_bytes;
    private final byte[] peer_id_bytes;
    private final byte version;

    static {
        byte[] byArray = new byte[8];
        byArray[5] = 16;
        LT_RESERVED = byArray;
        byte[] byArray2 = new byte[8];
        byArray2[0] = -128;
        byArray2[5] = 19;
        AZ_RESERVED = byArray2;
        RESERVED = new byte[][]{BT_RESERVED, LT_RESERVED, AZ_RESERVED};
        BTHandshake.setFastExtensionEnabled(true);
    }

    public static void setMainlineDHTEnabled(boolean enabled) {
        if (enabled) {
            BTHandshake.LT_RESERVED[7] = (byte)(LT_RESERVED[7] | 1);
            BTHandshake.AZ_RESERVED[7] = (byte)(AZ_RESERVED[7] | 1);
        } else {
            BTHandshake.LT_RESERVED[7] = (byte)(LT_RESERVED[7] & 0xFE);
            BTHandshake.AZ_RESERVED[7] = (byte)(AZ_RESERVED[7] & 0xFE);
        }
    }

    public static void setFastExtensionEnabled(boolean enabled) {
        if (enabled) {
            BTHandshake.LT_RESERVED[7] = (byte)(LT_RESERVED[7] | 4);
            BTHandshake.AZ_RESERVED[7] = (byte)(AZ_RESERVED[7] | 4);
        } else {
            BTHandshake.LT_RESERVED[7] = (byte)(LT_RESERVED[7] & 0xF3);
            BTHandshake.AZ_RESERVED[7] = (byte)(AZ_RESERVED[7] & 0xF3);
        }
    }

    private static byte[] duplicate(byte[] b) {
        byte[] r = new byte[b.length];
        System.arraycopy(b, 0, r, 0, b.length);
        return r;
    }

    public BTHandshake(byte[] data_hash, byte[] peer_id, int reserved_mode, byte version) {
        this(BTHandshake.duplicate(RESERVED[reserved_mode]), data_hash, peer_id, version);
    }

    private BTHandshake(byte[] reserved, byte[] data_hash, byte[] peer_id, byte version) {
        this.reserved_bytes = reserved;
        this.datahash_bytes = data_hash;
        this.peer_id_bytes = peer_id;
        this.version = version;
    }

    private void constructBuffer() {
        this.buffer = DirectByteBufferPool.getBuffer((byte)16, 68);
        this.buffer.put((byte)11, (byte)PROTOCOL.length());
        this.buffer.put((byte)11, PROTOCOL.getBytes());
        this.buffer.put((byte)11, this.reserved_bytes);
        this.buffer.put((byte)11, this.datahash_bytes);
        this.buffer.put((byte)11, this.peer_id_bytes);
        this.buffer.flip((byte)11);
    }

    public byte[] getReserved() {
        return this.reserved_bytes;
    }

    public byte[] getDataHash() {
        return this.datahash_bytes;
    }

    public byte[] getPeerId() {
        return this.peer_id_bytes;
    }

    @Override
    public String getID() {
        return "BT_HANDSHAKE";
    }

    @Override
    public byte[] getIDBytes() {
        return BTMessage.ID_BT_HANDSHAKE_BYTES;
    }

    @Override
    public String getFeatureID() {
        return "BT1";
    }

    @Override
    public int getFeatureSubID() {
        return 10;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public byte getVersion() {
        return this.version;
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            this.description = "BT_HANDSHAKE of dataID: " + ByteFormatter.nicePrint(this.datahash_bytes, true) + " peerID: " + PeerClassifier.getPrintablePeerID(this.peer_id_bytes);
        }
        return this.description;
    }

    @Override
    public DirectByteBuffer[] getData() {
        if (this.buffer == null) {
            this.constructBuffer();
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    @Override
    public Message deserialize(DirectByteBuffer data, byte version) throws MessageException {
        if (data == null) {
            throw new MessageException("[" + this.getID() + "] decode error: data == null");
        }
        if (data.remaining((byte)11) != 68) {
            throw new MessageException("[" + this.getID() + "] decode error: payload.remaining[" + data.remaining((byte)11) + "] != 68");
        }
        if (data.get((byte)11) != (byte)PROTOCOL.length()) {
            throw new MessageException("[" + this.getID() + "] decode error: payload.get() != (byte)PROTOCOL.length()");
        }
        byte[] header = new byte[PROTOCOL.getBytes().length];
        data.get((byte)11, header);
        if (!PROTOCOL.equals(new String(header))) {
            throw new MessageException("[" + this.getID() + "] decode error: invalid protocol given: " + new String(header));
        }
        byte[] reserved = new byte[8];
        data.get((byte)11, reserved);
        byte[] infohash = new byte[20];
        data.get((byte)11, infohash);
        byte[] peerid = new byte[20];
        data.get((byte)11, peerid);
        data.returnToPool();
        if (peerid[0] == 0 && peerid[1] == 0) {
            boolean ok = false;
            int i = 2;
            while (i < 20) {
                if (peerid[i] != 0) {
                    ok = true;
                    break;
                }
                ++i;
            }
            if (!ok) {
                byte[] x = "-#@0000-".getBytes();
                RandomUtils.nextBytes(peerid);
                System.arraycopy(x, 0, peerid, 0, x.length);
            }
        }
        return new BTHandshake(reserved, infohash, peerid, version);
    }

    @Override
    public DirectByteBuffer[] getRawData() {
        if (this.buffer == null) {
            this.constructBuffer();
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    @Override
    public int getPriority() {
        return 2;
    }

    @Override
    public boolean isNoDelay() {
        return true;
    }

    @Override
    public void setNoDelay() {
    }

    @Override
    public Message[] messagesToRemove() {
        return null;
    }

    @Override
    public void destroy() {
        if (this.buffer != null) {
            this.buffer.returnToPool();
        }
    }

    @Override
    public Message getBaseMessage() {
        return this;
    }
}

