/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.peermanager.messaging;

import com.biglybt.core.peermanager.messaging.MessageException;
import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.DirectByteBufferPool;
import java.util.Map;

public class MessagingUtil {
    public static DirectByteBuffer convertPayloadToBencodedByteStream(Map payload, byte alloc_id) {
        byte[] raw_payload;
        try {
            raw_payload = BEncoder.encode(payload);
            if (raw_payload == null || raw_payload.length == 0) {
                throw new Exception("Encoding failed");
            }
        }
        catch (Throwable t) {
            System.err.println("Payload encoding failed: " + payload);
            Debug.out(t);
            raw_payload = new byte[]{};
        }
        DirectByteBuffer buffer = DirectByteBufferPool.getBuffer(alloc_id, raw_payload.length);
        buffer.put((byte)11, raw_payload);
        buffer.flip((byte)11);
        return buffer;
    }

    public static Map convertBencodedByteStreamToPayload(DirectByteBuffer stream, int min_size, String id) throws MessageException {
        if (stream == null) {
            throw new MessageException("[" + id + "] decode error: stream == null");
        }
        if (stream.remaining((byte)11) < min_size) {
            throw new MessageException("[" + id + "] decode error: stream.remaining[" + stream.remaining((byte)11) + "] < " + min_size);
        }
        byte[] raw = new byte[stream.remaining((byte)11)];
        stream.get((byte)11, raw);
        try {
            Map<String, Object> result = BDecoder.decode(raw);
            stream.returnToPool();
            return result;
        }
        catch (Throwable t) {
            throw new MessageException("[" + id + "] payload stream b-decode error: " + t.getMessage());
        }
    }
}

