/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.peer;

import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.disk.DiskManagerReadRequest;
import com.biglybt.core.networkmanager.LimitedRateGroup;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManagerAdapter;
import com.biglybt.core.peer.PEPeerManagerListener;
import com.biglybt.core.peer.PEPeerManagerStats;
import com.biglybt.core.peer.PEPeerStats;
import com.biglybt.core.peer.PEPiece;
import com.biglybt.core.peer.impl.PEPeerTransport;
import com.biglybt.core.peer.util.PeerIdentityDataID;
import com.biglybt.core.peermanager.peerdb.PeerExchangerItem;
import com.biglybt.core.peermanager.piecepicker.PiecePicker;
import com.biglybt.core.tracker.TrackerPeerSource;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerResponse;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.pif.peers.PeerDescriptor;
import java.util.List;
import java.util.Map;

public interface PEPeerManager {
    public int getUID();

    public DiskManager getDiskManager();

    public PiecePicker getPiecePicker();

    public PEPeerManagerAdapter getAdapter();

    public void start();

    public void stopAll();

    public byte[] getHash();

    public String getDisplayName();

    public PeerIdentityDataID getPeerIdentityDataID();

    public byte[] getPeerId();

    public int[] getAvailability();

    public int getAvailability(int var1);

    public float getAvgAvail();

    public float getMinAvailability();

    public float getMinAvailability(int var1);

    public long getAvailWentBadTime();

    public long getBytesUnavailable();

    public boolean hasDownloadablePiece();

    public int getBytesQueuedForUpload();

    public int getNbPeersWithUploadQueued();

    public int getNbPeersWithUploadBlocked();

    public int getNbPeersUnchoked();

    public int getNbPeersUnchoking();

    public int getNbPieces();

    public PEPiece[] getPieces();

    public PEPiece getPiece(int var1);

    public PEPeerManagerStats getStats();

    public void processTrackerResponse(TRTrackerAnnouncerResponse var1);

    public int getNbPeers();

    public int getNbSeeds();

    public int getPieceLength(int var1);

    public long getRemaining();

    public int getHiddenPiece();

    public long getHiddenBytes();

    public long getETA(boolean var1);

    public String getElapsedTime();

    public long getTimeStarted(boolean var1);

    public long getTimeStartedSeeding(boolean var1);

    public String getConnectHealth(boolean var1);

    public void addListener(PEPeerManagerListener var1);

    public void removeListener(PEPeerManagerListener var1);

    public void addPiece(PEPiece var1, int var2, PEPeer var3);

    public boolean needsMD5CheckOnCompletion(int var1);

    public boolean isSeeding();

    public boolean isMetadataDownload();

    public int getTorrentInfoDictSize();

    public void setTorrentInfoDictSize(int var1);

    public boolean isSuperSeedMode();

    public boolean canToggleSuperSeedMode();

    public void setSuperSeedMode(boolean var1);

    public boolean seedPieceRecheck();

    public int getNbRemoteTCPConnections();

    public int getNbRemoteUDPConnections();

    public int getNbRemoteUTPConnections();

    public long getLastRemoteConnectionTime();

    public int getMaxNewConnectionsAllowed(String var1);

    public boolean hasPotentialConnections();

    public void dataBytesReceived(PEPeer var1, int var2);

    public void dataBytesSent(PEPeer var1, int var2);

    public void protocolBytesSent(PEPeer var1, int var2);

    public void protocolBytesReceived(PEPeer var1, int var2);

    public void discarded(PEPeer var1, int var2);

    public PEPeerStats createPeerStats(PEPeer var1);

    public PEPeer getMyPeer();

    public List<PEPeer> getPeers();

    public List<PEPeer> getPeers(String var1);

    public int getPendingPeerCount();

    public PeerDescriptor[] getPendingPeers();

    public PeerDescriptor[] getPendingPeers(String var1);

    public void addPeer(PEPeer var1);

    public void addPeer(String var1, int var2, int var3, boolean var4, Map var5) throws Exception;

    public void peerDiscovered(String var1, String var2, int var3, int var4, boolean var5);

    default public void removePeer(PEPeer peer, String reason) {
        this.removePeer(peer, reason, 0);
    }

    public void removePeer(PEPeer var1, String var2, int var3);

    public void informFullyConnected(PEPeer var1);

    public DiskManagerReadRequest createDiskManagerRequest(int var1, int var2, int var3);

    public void requestCanceled(DiskManagerReadRequest var1);

    public boolean requestExists(String var1, int var2, int var3, int var4);

    public boolean validatePieceReply(PEPeerTransport var1, int var2, int var3, DirectByteBuffer var4);

    public void writeBlock(int var1, int var2, DirectByteBuffer var3, Object var4, boolean var5);

    public boolean isWritten(int var1, int var2);

    public boolean isInEndGameMode();

    public void peerConnectionClosed(PEPeerTransport var1, boolean var2, boolean var3);

    public PeerExchangerItem createPeerExchangeConnection(PEPeerTransport var1);

    public void peerVerifiedAsSelf(PEPeerTransport var1);

    public LimitedRateGroup getUploadLimitedRateGroup();

    public LimitedRateGroup getDownloadLimitedRateGroup();

    public int getEffectiveUploadRateLimitBytesPerSecond();

    public int getUploadRateLimitBytesPerSecond();

    public int getDownloadRateLimitBytesPerSecond();

    public Object getData(String var1);

    public void setData(String var1, Object var2);

    public int getAverageCompletionInThousandNotation();

    public int getMaxCompletionInThousandNotation(boolean var1);

    public PEPeerTransport getTransportFromIdentity(byte[] var1);

    public PEPeerTransport getTransportFromAddress(String var1);

    public boolean getPreferUDP();

    public void setPreferUDP(boolean var1);

    public void addRateLimiter(LimitedRateGroup var1, boolean var2);

    public void removeRateLimiter(LimitedRateGroup var1, boolean var2);

    public TrackerPeerSource getTrackerPeerSource();

    public boolean isPeerSourceEnabled(String var1);

    public boolean isNetworkEnabled(String var1);

    public int getPartitionID();

    public void setMaskDownloadCompletion(Boolean var1);

    public void removeAllPeers(String var1, int var2);

    public boolean isDestroyed();

    public void generateEvidence(IndentWriter var1);

    public void setStatsReceiver(StatsReceiver var1);

    public static interface StatsReceiver {
        public void receiveStats(PEPeer var1, Map var2);
    }
}

