/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.pairing.impl;

import com.biglybt.core.pairing.PairedServiceRequestHandler;
import com.biglybt.core.pairing.impl.PairingManagerTunnelHandler;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.SystemTime;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloader;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloaderFactory;
import com.biglybt.pifimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class PairManagerTunnel {
    static final ResourceDownloaderFactory rdf = ResourceDownloaderFactoryImpl.getSingleton();
    final PairingManagerTunnelHandler tunnel_handler;
    private final String tunnel_key;
    private final InetAddress originator;
    private final String sid;
    private final PairedServiceRequestHandler request_handler;
    private final SecretKeySpec key;
    final String tunnel_url;
    private final String endpoint_url;
    private long last_active = SystemTime.getMonotonousTime();
    private volatile boolean close_requested;
    private final long create_time = SystemTime.getMonotonousTime();
    private long last_request_time;
    private long request_count;
    private long bytes_in;
    private long bytes_out;
    private long last_fail_duration_secs = 0L;
    private int consec_fails = 0;

    protected PairManagerTunnel(PairingManagerTunnelHandler _tunnel_handler, String _tunnel_key, InetAddress _originator, String _sid, PairedServiceRequestHandler _request_handler, SecretKeySpec _key, String _tunnel_url, String _endpoint_url) {
        this.tunnel_handler = _tunnel_handler;
        this.tunnel_key = _tunnel_key;
        this.originator = _originator;
        this.sid = _sid;
        this.request_handler = _request_handler;
        this.key = _key;
        this.tunnel_url = _tunnel_url;
        this.endpoint_url = _endpoint_url;
        new AEThread2("PairManagerTunnel:runner"){

            @Override
            public void run() {
                try {
                    String current_reply_params = null;
                    byte[] current_reply_data = null;
                    while (!PairManagerTunnel.this.close_requested) {
                        if (PairManagerTunnel.this.consec_fails > 1) {
                            try {
                                Thread.sleep((1 << PairManagerTunnel.this.consec_fails - 1) * 1000);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        long start_time = SystemTime.getMonotonousTime();
                        try {
                            String url_str = String.valueOf(PairManagerTunnel.this.tunnel_url) + "?server=true" + (current_reply_params == null ? "" : current_reply_params);
                            if (PairManagerTunnel.this.last_fail_duration_secs > 0L) {
                                url_str = String.valueOf(url_str) + "&last_fail=" + PairManagerTunnel.this.last_fail_duration_secs;
                                PairManagerTunnel.this.last_fail_duration_secs = 0L;
                            }
                            byte[] bytes_to_send = current_reply_data == null ? new byte[]{} : current_reply_data;
                            PairManagerTunnel pairManagerTunnel = PairManagerTunnel.this;
                            pairManagerTunnel.bytes_out = pairManagerTunnel.bytes_out + (long)bytes_to_send.length;
                            ResourceDownloader rd = rdf.create(new URL(url_str), bytes_to_send);
                            rd.setProperty("URL_Connection", "Keep-Alive");
                            rd.setProperty("URL_Read_Timeout", 300000);
                            byte[] data = FileUtil.readInputStreamAsByteArray(rd.download());
                            if (PairManagerTunnel.this.close_requested) {
                                break;
                            }
                            PairManagerTunnel pairManagerTunnel2 = PairManagerTunnel.this;
                            pairManagerTunnel2.bytes_in = pairManagerTunnel2.bytes_in + (long)data.length;
                            long now = SystemTime.getMonotonousTime();
                            PairManagerTunnel.this.last_active = now;
                            current_reply_params = null;
                            current_reply_data = null;
                            List cookies = (List)rd.getProperty("URL_Set-Cookie");
                            boolean cookie_found = false;
                            if (cookies != null) {
                                for (String cookie : cookies) {
                                    String name = "vuze_pair_server_reqs=";
                                    if (!cookie.startsWith("vuze_pair_server_reqs=")) continue;
                                    cookie_found = true;
                                    String value = cookie.substring("vuze_pair_server_reqs=".length());
                                    int pos = value.indexOf(59);
                                    String[] bits = (value = value.substring(0, pos)).split("&");
                                    if (bits.length <= 0) continue;
                                    current_reply_params = "";
                                    int data_pos = 0;
                                    ArrayList<byte[]> replies = new ArrayList<byte[]>();
                                    int reply_length = 0;
                                    String[] stringArray = bits;
                                    int n = bits.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String bit = stringArray[n2];
                                        String[] temp = bit.split("=");
                                        if (temp.length == 2) {
                                            String lhs = temp[0].toLowerCase();
                                            if (lhs.startsWith("seq")) {
                                                int seq = Integer.parseInt(lhs.substring(3));
                                                int len = Integer.parseInt(temp[1]);
                                                PairManagerTunnel.this.last_request_time = now;
                                                PairManagerTunnel pairManagerTunnel3 = PairManagerTunnel.this;
                                                pairManagerTunnel3.request_count = pairManagerTunnel3.request_count + 1L;
                                                byte[] reply = PairManagerTunnel.this.processRequest(data, data_pos, len);
                                                replies.add(reply);
                                                reply_length += reply.length;
                                                data_pos += len;
                                                current_reply_params = String.valueOf(current_reply_params) + "&seq" + seq + "=" + reply.length;
                                            } else if (!lhs.equals("keepalive") && lhs.equals("close")) {
                                                PairManagerTunnel.this.close_requested = true;
                                            }
                                        }
                                        ++n2;
                                    }
                                    current_reply_data = new byte[reply_length];
                                    data_pos = 0;
                                    for (byte[] reply : replies) {
                                        System.arraycopy(reply, 0, current_reply_data, data_pos, reply.length);
                                        data_pos += reply.length;
                                    }
                                }
                            }
                            if (!cookie_found) {
                                throw new Exception("Cookie missing from reply");
                            }
                            PairManagerTunnel.this.consec_fails = 0;
                        }
                        catch (Throwable e) {
                            long fail_time = SystemTime.getMonotonousTime();
                            PairManagerTunnel.this.last_fail_duration_secs = (fail_time - start_time) / 1000L;
                            if (PairManagerTunnel.this.isTimeout(e) && PairManagerTunnel.this.last_fail_duration_secs >= 20L) {
                                PairManagerTunnel.this.consec_fails = 0;
                                continue;
                            }
                            Debug.out(e);
                            PairManagerTunnel pairManagerTunnel = PairManagerTunnel.this;
                            pairManagerTunnel.consec_fails = pairManagerTunnel.consec_fails + 1;
                            if (PairManagerTunnel.this.consec_fails <= 3) continue;
                            break;
                        }
                    }
                }
                finally {
                    PairManagerTunnel.this.tunnel_handler.closeTunnel(PairManagerTunnel.this);
                }
            }
        }.start();
    }

    private boolean isTimeout(Throwable e) {
        if (e == null) {
            return false;
        }
        if (e instanceof SocketTimeoutException) {
            return true;
        }
        String message = e.getMessage();
        if (message != null && ((message = message.toLowerCase(Locale.US)).contains("timed out") || message.contains("timeout"))) {
            return true;
        }
        return this.isTimeout(e.getCause());
    }

    private byte[] processRequest(byte[] request2, int offset, int length) {
        try {
            byte[] IV = new byte[16];
            System.arraycopy(request2, offset, IV, 0, IV.length);
            Cipher decipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            decipher.init(2, (Key)this.key, new IvParameterSpec(IV));
            byte[] decrypted = decipher.doFinal(request2, offset + 16, length - 16);
            byte[] reply_bytes = this.request_handler.handleRequest(this.originator, this.endpoint_url, decrypted);
            Cipher encipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            encipher.init(1, this.key);
            AlgorithmParameters params = encipher.getParameters();
            byte[] IV2 = params.getParameterSpec(IvParameterSpec.class).getIV();
            byte[] enc = encipher.doFinal(reply_bytes);
            byte[] rep_bytes = new byte[IV2.length + enc.length];
            System.arraycopy(IV2, 0, rep_bytes, 0, IV2.length);
            System.arraycopy(enc, 0, rep_bytes, IV2.length, enc.length);
            return rep_bytes;
        }
        catch (Throwable e) {
            Debug.out(e);
            return new byte[0];
        }
    }

    protected String getKey() {
        return this.tunnel_key;
    }

    protected long getLastActive() {
        return this.last_active;
    }

    protected void destroy() {
        this.close_requested = true;
    }

    protected String getString() {
        long now = SystemTime.getMonotonousTime();
        return "url=" + this.tunnel_url + ", age=" + (now - this.create_time) + ", last_req=" + (this.last_request_time == 0L ? "never" : String.valueOf(now - this.last_request_time)) + ", reqs=" + this.request_count + ", in=" + DisplayFormatters.formatByteCountToKiBEtc(this.bytes_in) + ", out=" + DisplayFormatters.formatByteCountToKiBEtc(this.bytes_out) + ", lf_secs=" + this.last_fail_duration_secs + ", consec_fail=" + this.consec_fails;
    }
}

