/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.networkmanager.impl.tcp;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.networkmanager.VirtualChannelSelector;
import com.biglybt.core.networkmanager.admin.NetworkAdmin;
import com.biglybt.core.networkmanager.impl.tcp.IncomingSocketChannelManager;
import com.biglybt.core.networkmanager.impl.tcp.TCPConnectionManager;
import com.biglybt.core.stats.CoreStats;
import com.biglybt.core.stats.CoreStatsProvider;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemTime;
import java.nio.channels.CancelledKeyException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TCPNetworkManager {
    static int WRITE_SELECT_LOOP_TIME = 25;
    static int WRITE_SELECT_MIN_LOOP_TIME = 0;
    static int READ_SELECT_LOOP_TIME = 25;
    static int READ_SELECT_MIN_LOOP_TIME = 0;
    protected static int tcp_mss_size;
    private static final TCPNetworkManager instance;
    public static boolean TCP_INCOMING_ENABLED;
    public static boolean TCP_OUTGOING_ENABLED;
    final VirtualChannelSelector read_selector = new VirtualChannelSelector("TCP network manager reader", 1, true);
    final VirtualChannelSelector write_selector = new VirtualChannelSelector("TCP network manager writer", 4, true);
    private final TCPConnectionManager connect_disconnect_manager = new TCPConnectionManager();
    private final IncomingSocketChannelManager default_incoming_socketchannel_manager = new IncomingSocketChannelManager("TCP.Listen.Port", "TCP.Listen.Port.Enable");
    private List<IncomingSocketChannelManager> additional_incoming_socketchannel_managers;
    long read_select_count;
    long write_select_count;

    static {
        instance = new TCPNetworkManager();
        COConfigurationManager.addAndFireParameterListeners(new String[]{"TCP.Listen.Port.Enable", "network.tcp.connect.outbound.enable"}, new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                TCP_INCOMING_ENABLED = TCP_OUTGOING_ENABLED = COConfigurationManager.getBooleanParameter("TCP.Listen.Port.Enable");
                if (TCP_OUTGOING_ENABLED) {
                    TCP_OUTGOING_ENABLED = COConfigurationManager.getBooleanParameter("network.tcp.connect.outbound.enable");
                }
            }
        });
        COConfigurationManager.addAndFireParameterListeners(new String[]{"network.tcp.read.select.time", "network.tcp.read.select.min.time", "network.tcp.write.select.time", "network.tcp.write.select.min.time"}, new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                WRITE_SELECT_LOOP_TIME = COConfigurationManager.getIntParameter("network.tcp.write.select.time");
                WRITE_SELECT_MIN_LOOP_TIME = COConfigurationManager.getIntParameter("network.tcp.write.select.min.time");
                READ_SELECT_LOOP_TIME = COConfigurationManager.getIntParameter("network.tcp.read.select.time");
                READ_SELECT_MIN_LOOP_TIME = COConfigurationManager.getIntParameter("network.tcp.read.select.min.time");
            }
        });
    }

    public static TCPNetworkManager getSingleton() {
        return instance;
    }

    public static int getTcpMssSize() {
        return tcp_mss_size;
    }

    public static void refreshRates(int min_rate) {
        tcp_mss_size = COConfigurationManager.getIntParameter("network.tcp.mtu.size") - 40;
        if (tcp_mss_size > min_rate) {
            tcp_mss_size = min_rate - 1;
        }
        if (tcp_mss_size < 512) {
            tcp_mss_size = 512;
        }
    }

    protected TCPNetworkManager() {
        COConfigurationManager.setParameter("TCP.Listen.AdditionalPorts", new ArrayList());
        this.additional_incoming_socketchannel_managers = new ArrayList<IncomingSocketChannelManager>();
        HashSet<String> types = new HashSet<String>();
        types.add("net.tcp.select.read.count");
        types.add("net.tcp.select.write.count");
        CoreStats.registerProvider(types, new CoreStatsProvider(){

            public void updateStats(Set types, Map values) {
                if (types.contains("net.tcp.select.read.count")) {
                    values.put("net.tcp.select.read.count", new Long(TCPNetworkManager.this.read_select_count));
                }
                if (types.contains("net.tcp.select.write.count")) {
                    values.put("net.tcp.select.write.count", new Long(TCPNetworkManager.this.write_select_count));
                }
            }
        });
        AEThread2 read_selector_thread = new AEThread2("ReadController:ReadSelector", true){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            if (READ_SELECT_MIN_LOOP_TIME > 0) {
                                long start = SystemTime.getHighPrecisionCounter();
                                TCPNetworkManager.this.read_selector.select(READ_SELECT_LOOP_TIME);
                                long duration = SystemTime.getHighPrecisionCounter() - start;
                                long sleep = (long)READ_SELECT_MIN_LOOP_TIME - (duration /= 1000000L);
                                if (sleep > 0L) {
                                    try {
                                        Thread.sleep(sleep);
                                    }
                                    catch (Throwable throwable) {}
                                }
                            } else {
                                TCPNetworkManager.this.read_selector.select(READ_SELECT_LOOP_TIME);
                            }
                            ++TCPNetworkManager.this.read_select_count;
                        }
                    }
                    catch (Throwable t) {
                        if (t instanceof CancelledKeyException) continue;
                        Debug.out("readSelectorLoop() EXCEPTION: ", t);
                        continue;
                    }
                    break;
                }
            }
        };
        read_selector_thread.setPriority(8);
        read_selector_thread.start();
        AEThread2 write_selector_thread = new AEThread2("WriteController:WriteSelector", true){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            if (WRITE_SELECT_MIN_LOOP_TIME > 0) {
                                long start = SystemTime.getHighPrecisionCounter();
                                TCPNetworkManager.this.write_selector.select(WRITE_SELECT_LOOP_TIME);
                                long duration = SystemTime.getHighPrecisionCounter() - start;
                                long sleep = (long)WRITE_SELECT_MIN_LOOP_TIME - (duration /= 1000000L);
                                if (sleep <= 0L) continue;
                                try {
                                    Thread.sleep(sleep);
                                }
                                catch (Throwable throwable) {}
                                continue;
                            }
                            TCPNetworkManager.this.write_selector.select(WRITE_SELECT_LOOP_TIME);
                            ++TCPNetworkManager.this.write_select_count;
                        }
                    }
                    catch (Throwable t) {
                        Debug.out("writeSelectorLoop() EXCEPTION: ", t);
                        continue;
                    }
                    break;
                }
            }
        };
        write_selector_thread.setPriority(8);
        write_selector_thread.start();
    }

    public IncomingSocketChannelManager getDefaultIncomingSocketManager() {
        return this.default_incoming_socketchannel_manager;
    }

    public TCPConnectionManager getConnectDisconnectManager() {
        return this.connect_disconnect_manager;
    }

    public VirtualChannelSelector getReadSelector() {
        return this.read_selector;
    }

    public VirtualChannelSelector getWriteSelector() {
        return this.write_selector;
    }

    public boolean isDefaultTCPListenerEnabled() {
        return this.default_incoming_socketchannel_manager.isEnabled();
    }

    public int getDefaultTCPListeningPortNumber() {
        return this.default_incoming_socketchannel_manager.getTCPListeningPortNumber();
    }

    public long getLastIncomingNonLocalConnectionTime() {
        return this.default_incoming_socketchannel_manager.getLastNonLocalConnectionTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAdditionalTCPListeningPortNumber(List<Integer> excluded_ports) {
        List<IncomingSocketChannelManager> list = this.additional_incoming_socketchannel_managers;
        synchronized (list) {
            for (IncomingSocketChannelManager x : this.additional_incoming_socketchannel_managers) {
                int port = x.getTCPListeningPortNumber();
                if (excluded_ports.contains(port)) continue;
                return port;
            }
            try {
                int new_port = NetworkAdmin.getSingleton().getBindablePort(0);
                int new_id = this.additional_incoming_socketchannel_managers.size() + 1;
                String key = "TCP.Listen.AdditionalPort." + new_id;
                COConfigurationManager.setParameter(key, new_port);
                IncomingSocketChannelManager manager = new IncomingSocketChannelManager(key, "TCP.Listen.Port.Enable");
                this.additional_incoming_socketchannel_managers.add(manager);
                List port_list = COConfigurationManager.getListParameter("TCP.Listen.AdditionalPorts", new ArrayList());
                port_list.add(new Long(new_port));
                COConfigurationManager.setParameter("TCP.Listen.AdditionalPorts", port_list);
                return new_port;
            }
            catch (Throwable e) {
                Debug.out(e);
                return 0;
            }
        }
    }
}

