/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.networkmanager.impl;

import com.biglybt.core.networkmanager.impl.ProtocolDecoder;
import com.biglybt.core.networkmanager.impl.ProtocolDecoderAdapter;
import com.biglybt.core.networkmanager.impl.ProtocolDecoderInitial;
import com.biglybt.core.networkmanager.impl.TransportHelper;
import java.nio.ByteBuffer;

public class TransportCryptoManager {
    private static final TransportCryptoManager instance = new TransportCryptoManager();

    public static TransportCryptoManager getSingleton() {
        return instance;
    }

    public void manageCrypto(TransportHelper transport, byte[][] shared_secrets, boolean is_incoming, ByteBuffer initial_data, final HandshakeListener listener) {
        try {
            new ProtocolDecoderInitial(transport, shared_secrets, !is_incoming, initial_data, new ProtocolDecoderAdapter(){

                @Override
                public int getMaximumPlainHeaderLength() {
                    return listener.getMaximumPlainHeaderLength();
                }

                @Override
                public int matchPlainHeader(ByteBuffer buffer) {
                    return listener.matchPlainHeader(buffer);
                }

                @Override
                public void gotSecret(byte[] session_secret) {
                    listener.gotSecret(session_secret);
                }

                @Override
                public void decodeComplete(ProtocolDecoder decoder, ByteBuffer remaining_initial_data) {
                    listener.handshakeSuccess(decoder, remaining_initial_data);
                }

                @Override
                public void decodeFailed(ProtocolDecoder decoder, Throwable cause) {
                    listener.handshakeFailure(cause);
                }
            });
        }
        catch (Throwable e) {
            listener.handshakeFailure(e);
        }
    }

    public static interface HandshakeListener {
        public static final int MATCH_NONE = 1;
        public static final int MATCH_CRYPTO_NO_AUTO_FALLBACK = 2;
        public static final int MATCH_CRYPTO_AUTO_FALLBACK = 3;

        public void handshakeSuccess(ProtocolDecoder var1, ByteBuffer var2);

        public void handshakeFailure(Throwable var1);

        public void gotSecret(byte[] var1);

        public int getMaximumPlainHeaderLength();

        public int matchPlainHeader(ByteBuffer var1);
    }
}

