/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.networkmanager.admin.impl;

import com.biglybt.core.networkmanager.admin.NetworkAdminException;
import com.biglybt.core.networkmanager.admin.NetworkAdminSpeedTestScheduledTest;
import com.biglybt.core.networkmanager.admin.NetworkAdminSpeedTestScheduledTestListener;
import com.biglybt.core.networkmanager.admin.NetworkAdminSpeedTestScheduler;
import com.biglybt.core.networkmanager.admin.NetworkAdminSpeedTesterResult;
import com.biglybt.core.networkmanager.admin.impl.NetworkAdminSpeedTestScheduledTestImpl;
import com.biglybt.core.networkmanager.admin.impl.NetworkAdminSpeedTesterBTImpl;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pifimpl.local.PluginInitializer;

public class NetworkAdminSpeedTestSchedulerImpl
implements NetworkAdminSpeedTestScheduler {
    private static NetworkAdminSpeedTestSchedulerImpl instance = null;
    NetworkAdminSpeedTestScheduledTestImpl currentTest = null;

    public static synchronized NetworkAdminSpeedTestScheduler getInstance() {
        if (instance == null) {
            instance = new NetworkAdminSpeedTestSchedulerImpl();
        }
        return instance;
    }

    private NetworkAdminSpeedTestSchedulerImpl() {
        NetworkAdminSpeedTesterBTImpl.initialise();
    }

    @Override
    public void initialise() {
        NetworkAdminSpeedTesterBTImpl.startUp();
    }

    @Override
    public synchronized NetworkAdminSpeedTestScheduledTest getCurrentTest() {
        return this.currentTest;
    }

    @Override
    public synchronized NetworkAdminSpeedTestScheduledTest scheduleTest(int type) throws NetworkAdminException {
        if (this.currentTest != null) {
            throw new NetworkAdminException("Test already scheduled");
        }
        if (type != 1) {
            throw new NetworkAdminException("Unknown test type");
        }
        PluginInterface plugin = PluginInitializer.getDefaultInterface();
        this.currentTest = new NetworkAdminSpeedTestScheduledTestImpl(plugin, new NetworkAdminSpeedTesterBTImpl(plugin));
        this.currentTest.getTester().setMode(type);
        this.currentTest.addListener(new NetworkAdminSpeedTestScheduledTestListener(){

            @Override
            public void stage(NetworkAdminSpeedTestScheduledTest test, String step) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void complete(NetworkAdminSpeedTestScheduledTest test) {
                NetworkAdminSpeedTestSchedulerImpl networkAdminSpeedTestSchedulerImpl = NetworkAdminSpeedTestSchedulerImpl.this;
                synchronized (networkAdminSpeedTestSchedulerImpl) {
                    NetworkAdminSpeedTestSchedulerImpl.this.currentTest = null;
                }
            }
        });
        return this.currentTest;
    }

    @Override
    public NetworkAdminSpeedTesterResult getLastResult(int type) {
        if (type == 1) {
            return NetworkAdminSpeedTesterBTImpl.getLastResult();
        }
        Debug.out("Unknown test type");
        return null;
    }
}

