/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.networkmanager.admin.impl;

import com.biglybt.core.networkmanager.admin.NetworkAdminASN;
import com.biglybt.core.networkmanager.admin.NetworkAdminException;
import com.biglybt.core.util.Debug;
import java.net.Inet4Address;
import java.net.InetAddress;

public class NetworkAdminASNImpl
implements NetworkAdminASN {
    private final boolean ipv4;
    private final String as;
    private String asn;
    private final String bgp_prefix;

    protected NetworkAdminASNImpl(boolean _ipv4, String _as, String _asn, String _bgp) {
        this.ipv4 = _ipv4;
        this.as = _as;
        this.asn = _asn;
        this.bgp_prefix = _bgp;
    }

    protected boolean isIPv4() {
        return this.ipv4;
    }

    @Override
    public String getAS() {
        return this.as == null ? "" : this.as;
    }

    @Override
    public String getASName() {
        return this.asn == null ? "" : this.asn;
    }

    protected void setASName(String s) {
        this.asn = s;
    }

    @Override
    public String getBGPPrefix() {
        return this.bgp_prefix == null ? "" : this.bgp_prefix;
    }

    @Override
    public InetAddress getBGPStartAddress() {
        if (this.bgp_prefix == null) {
            return null;
        }
        try {
            return this.getCIDRStartAddress();
        }
        catch (NetworkAdminException e) {
            Debug.out(e);
            return null;
        }
    }

    protected InetAddress getCIDRStartAddress() throws NetworkAdminException {
        int pos = this.bgp_prefix.indexOf(47);
        try {
            return InetAddress.getByName(this.bgp_prefix.substring(0, pos));
        }
        catch (Throwable e) {
            throw new NetworkAdminException("Parse failure for '" + this.bgp_prefix + "'", e);
        }
    }

    protected InetAddress getCIDREndAddress() throws NetworkAdminException {
        int pos = this.bgp_prefix.indexOf(47);
        try {
            InetAddress start = InetAddress.getByName(this.bgp_prefix.substring(0, pos));
            int cidr_mask = Integer.parseInt(this.bgp_prefix.substring(pos + 1));
            byte[] bytes = start.getAddress();
            int i = cidr_mask;
            while (i < bytes.length * 8) {
                int n = i / 8;
                bytes[n] = (byte)(bytes[n] | 1 << 7 - i % 8);
                ++i;
            }
            return InetAddress.getByAddress(bytes);
        }
        catch (Throwable e) {
            throw new NetworkAdminException("Parse failure for '" + this.bgp_prefix + "'", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean matchesCIDR(InetAddress address) {
        if (this.bgp_prefix == null || this.bgp_prefix.length() == 0) {
            return false;
        }
        boolean isv4 = address instanceof Inet4Address;
        if (isv4 != this.ipv4) {
            return false;
        }
        try {
            int pos = this.bgp_prefix.indexOf(47);
            InetAddress start = InetAddress.getByName(this.bgp_prefix.substring(0, pos));
            int cidr_mask = Integer.parseInt(this.bgp_prefix.substring(pos + 1));
            byte[] prefix = start.getAddress();
            byte[] bytes = address.getAddress();
            int i = 0;
            while (true) {
                if (i >= cidr_mask) {
                    return true;
                }
                byte mask = (byte)(1 << 7 - i % 8);
                int b1 = prefix[i / 8] & mask;
                int b2 = bytes[i / 8] & mask;
                if (b1 != b2) {
                    return false;
                }
                ++i;
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return false;
        }
    }

    @Override
    public InetAddress getBGPEndAddress() {
        if (this.bgp_prefix == null) {
            return null;
        }
        try {
            return this.getCIDREndAddress();
        }
        catch (NetworkAdminException e) {
            Debug.out(e);
            return null;
        }
    }

    @Override
    public boolean sameAs(NetworkAdminASN other) {
        return this.getAS().equals(other.getAS());
    }

    @Override
    public String getString() {
        return "as=" + this.getAS() + ",asn=" + this.getASName() + ", bgp_prefx=" + this.getBGPPrefix() + "[" + this.getBGPStartAddress() + "-" + this.getBGPEndAddress() + "]";
    }
}

