/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.ipfilter.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.ipfilter.BannedIp;
import com.biglybt.core.ipfilter.BlockedIp;
import com.biglybt.core.ipfilter.IPFilterListener;
import com.biglybt.core.ipfilter.IpFilter;
import com.biglybt.core.ipfilter.IpFilterExternalHandler;
import com.biglybt.core.ipfilter.IpFilterManagerFactory;
import com.biglybt.core.ipfilter.IpRange;
import com.biglybt.core.ipfilter.impl.BlockedIpImpl;
import com.biglybt.core.ipfilter.impl.IPAddressRangeManagerV4;
import com.biglybt.core.ipfilter.impl.IPAddressRangeManagerV6;
import com.biglybt.core.ipfilter.impl.IPBannerImpl;
import com.biglybt.core.ipfilter.impl.IpFilterAutoLoaderImpl;
import com.biglybt.core.ipfilter.impl.IpRangeImpl;
import com.biglybt.core.ipfilter.impl.IpRangeV4Impl;
import com.biglybt.core.ipfilter.impl.IpRangeV6Impl;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AddressUtils;
import com.biglybt.core.util.AsyncDispatcher;
import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.ByteArrayHashMap;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.FrequencyLimitedDispatcher;
import com.biglybt.core.util.HostNameToIPResolver;
import com.biglybt.core.util.SystemTime;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class IpFilterImpl
implements IpFilter {
    protected static final LogIDs LOGID = LogIDs.CORE;
    protected static final LogIDs LOGID_NWMAN = LogIDs.NWMAN;
    private static final int MAX_BLOCKS_TO_REMEMBER = 500;
    private static IpFilterImpl ipFilter;
    static final AEMonitor class_mon;
    private final IPAddressRangeManagerV4 range_manager_v4 = new IPAddressRangeManagerV4();
    private final IPAddressRangeManagerV6 range_manager_v6 = new IPAddressRangeManagerV6();
    private final LinkedList ipsBlocked;
    private int num_ips_blocked = 0;
    private int num_ips_blocked_loggable = 0;
    private long last_update_time;
    private final IPBannerImpl ipBanner;
    final CopyOnWriteList<IPFilterListener> listenerz = new CopyOnWriteList(true);
    private final CopyOnWriteList<IpFilterExternalHandler> external_handlers = new CopyOnWriteList();
    final FrequencyLimitedDispatcher blockedListChangedDispatcher;
    private final IpFilterAutoLoaderImpl ipFilterAutoLoader;
    boolean ip_filter_enabled;
    boolean ip_filter_allow;
    private ByteArrayHashMap<String> excluded_hashes = new ByteArrayHashMap();

    static {
        class_mon = new AEMonitor("IpFilter:class");
    }

    private IpFilterImpl() {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Ip Filter Allow", "Ip Filter Enabled"}, new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                IpFilterImpl.this.ip_filter_enabled = COConfigurationManager.getBooleanParameter("Ip Filter Enabled");
                IpFilterImpl.this.ip_filter_allow = COConfigurationManager.getBooleanParameter("Ip Filter Allow");
                if (parameterName != null && parameterName.equals("Ip Filter Enabled")) {
                    for (IPFilterListener listener : IpFilterImpl.this.listenerz) {
                        listener.IPFilterEnabledChanged(IpFilterImpl.this.ip_filter_enabled);
                    }
                }
            }
        });
        ipFilter = this;
        this.ipsBlocked = new LinkedList();
        this.blockedListChangedDispatcher = new FrequencyLimitedDispatcher(new AERunnable(){
            AsyncDispatcher disp = new AsyncDispatcher(1000);

            @Override
            public void runSupport() {
                this.disp.dispatch(AERunnable.create(() -> {
                    for (IPFilterListener listener : IpFilterImpl.this.listenerz) {
                        try {
                            listener.IPBlockedListChanged(IpFilterImpl.this);
                        }
                        catch (Exception e) {
                            Debug.out(e);
                        }
                    }
                }));
            }
        }, 10000);
        this.ipFilterAutoLoader = new IpFilterAutoLoaderImpl(this);
        this.ipBanner = new IPBannerImpl(this);
        try {
            this.loadFilters(true, true);
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
        COConfigurationManager.addParameterListener(new String[]{"Ip Filter Allow", "Ip Filter Enabled"}, new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                IpFilterImpl.this.markAsUpToDate();
            }
        });
    }

    public static IpFilter getInstance() {
        try {
            class_mon.enter();
            if (ipFilter == null) {
                ipFilter = new IpFilterImpl();
            }
            IpFilterImpl ipFilterImpl = ipFilter;
            return ipFilterImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    @Override
    public File getFile() {
        return FileUtil.getUserFile("filters.config");
    }

    @Override
    public void reload() throws Exception {
        this.reload(true);
    }

    @Override
    public void reloadSync() throws Exception {
        this.reload(false);
    }

    public void reload(boolean allowAsyncDownloading) throws Exception {
        if (COConfigurationManager.getBooleanParameter("Ip Filter Clear On Reload")) {
            this.range_manager_v4.clearAllEntries();
            this.range_manager_v6.clearAllEntries();
            IpFilterManagerFactory.getSingleton().deleteAllDescriptions();
        }
        this.markAsUpToDate();
        this.loadFilters(allowAsyncDownloading, false);
    }

    @Override
    public void save() throws Exception {
        try {
            class_mon.enter();
            HashMap map = new HashMap();
            ArrayList filters = new ArrayList();
            map.put("ranges", filters);
            List<Iterator> iters = Arrays.asList(this.range_manager_v4.getEntries().iterator(), this.range_manager_v6.getEntries().iterator());
            for (Iterator iter : iters) {
                while (iter.hasNext()) {
                    IpRangeImpl range = (IpRangeImpl)iter.next();
                    if (!range.isValid() || range.isSessionOnly()) continue;
                    String description = range.getDescription();
                    String startIp = range.getStartIp();
                    String endIp = range.getEndIp();
                    HashMap<String, Object> mapRange = new HashMap<String, Object>();
                    mapRange.put("description", description.getBytes("UTF-8"));
                    mapRange.put("start", startIp);
                    mapRange.put("end", endIp);
                    if (!range.isV4()) {
                        mapRange.put("type", 2L);
                    }
                    filters.add(mapRange);
                }
            }
            try (FileOutputStream fos = null;){
                File filtersFile = FileUtil.getUserFile("filters.config");
                fos = FileUtil.newFileOutputStream(filtersFile);
                fos.write(BEncoder.encode(map));
            }
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadFilters(boolean allowAsyncDownloading, boolean loadOldWhileAsyncDownloading) throws Exception {
        block26: {
            startTime = System.currentTimeMillis();
            this.ipFilterAutoLoader.loadOtherFilters(allowAsyncDownloading, loadOldWhileAsyncDownloading);
            if (this.getNbRanges() > 0) {
                Logger.log(new LogEvent(IpFilterImpl.LOGID, String.valueOf(System.currentTimeMillis() - startTime) + "ms for " + this.getNbRanges() + ". now loading norm"));
            }
            IpFilterImpl.class_mon.enter();
            new_ipRanges = new ArrayList<IpRangeV4Impl>(1024);
            fin = null;
            bin = null;
            filtersFile = FileUtil.getUserFile("filters.config");
            if (!filtersFile.exists()) break block26;
            fin = FileUtil.newFileInputStream(filtersFile);
            bin = new BufferedInputStream(fin, 16384);
            map = BDecoder.decode(bin);
            list = (List)map.get("ranges");
            if (list == null) {
            }
            iter = list.listIterator();
            if (true) ** GOTO lbl53
        }
        finally {
            if (bin != null) {
                try {
                    bin.close();
                }
                catch (Throwable var19_10) {}
            }
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (Throwable var19_11) {}
            }
            it = new_ipRanges.iterator();
            if (true) ** GOTO lbl41
        }
        finally {
            IpFilterImpl.class_mon.exit();
        }
        do {
            ((IpRange)it.next()).checkValid();
lbl41:
            // 2 sources

        } while (it.hasNext());
        return;
        do {
            range = (Map)iter.next();
            description = new String((byte[])range.get("description"), "UTF-8");
            startIp = new String((byte[])range.get("start"));
            endIp = new String((byte[])range.get("end"));
            type = (Number)range.get("type");
            ipRange /* !! */  = type == null || type.intValue() == 1 ? new IpRangeV4Impl(description, startIp, endIp, false) : new IpRangeV6Impl(description, startIp, endIp, false);
            ipRange /* !! */ .setAddedToRangeList(true);
            new_ipRanges.add(ipRange /* !! */ );
lbl53:
            // 2 sources

        } while (iter.hasNext());
    }

    @Override
    public boolean isInRange(String ipAddress) {
        return this.isInRange(ipAddress, "", null);
    }

    @Override
    public boolean isInRange(String ipAddress, String torrent_name, byte[] torrent_hash) {
        return this.isInRange(ipAddress, torrent_name, torrent_hash, true);
    }

    @Override
    public boolean isInRange(String ipAddress, String torrent_name, byte[] torrent_hash, boolean loggable) {
        IpRange explict_deny;
        boolean allow;
        block20: {
            if (this.ipBanner.isBanned(ipAddress)) {
                return true;
            }
            if (!this.isEnabled()) {
                return false;
            }
            if (ipAddress.equals("127.0.0.1")) {
                return false;
            }
            if (AddressUtils.isLANLocalAddress(ipAddress) == 1) {
                return false;
            }
            if (torrent_hash != null && this.excluded_hashes.containsKey(torrent_hash)) {
                return false;
            }
            allow = this.ip_filter_allow;
            try {
                if (!HostNameToIPResolver.isNonDNSName(ipAddress)) break block20;
                return false;
            }
            catch (Throwable e) {
                Debug.out(e);
                return false;
            }
        }
        InetAddress ia = HostNameToIPResolver.syncResolve(ipAddress);
        IpRange match = ia instanceof Inet4Address ? this.range_manager_v4.isInRange((Inet4Address)ia) : this.range_manager_v6.isInRange((Inet6Address)ia);
        if ((match == null || allow) && (explict_deny = this.checkExternalHandlers(torrent_hash, ipAddress)) != null) {
            match = explict_deny;
            allow = false;
        }
        if (match != null) {
            if (!allow) {
                if (AENetworkClassifier.categoriseAddress(ipAddress) != "Public") {
                    return false;
                }
                if (this.addBlockedIP(new BlockedIpImpl(ipAddress, match, torrent_name, loggable), torrent_hash, loggable)) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID_NWMAN, "Ip Blocked : " + ipAddress + ", in range : " + match));
                    }
                    return true;
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID_NWMAN, 1, "Ip Blocking Denied : " + ipAddress + ", in range : " + match));
                }
                return false;
            }
            return false;
        }
        if (allow) {
            if (AENetworkClassifier.categoriseAddress(ipAddress) != "Public") {
                return false;
            }
            if (this.addBlockedIP(new BlockedIpImpl(ipAddress, null, torrent_name, loggable), torrent_hash, loggable)) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID_NWMAN, "Ip Blocked : " + ipAddress + ", not in any range"));
                }
                return true;
            }
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID_NWMAN, 1, "Ip Blocking Denied : " + ipAddress + ", not in any range"));
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean isInRange(InetAddress ipAddress, String torrent_name, byte[] torrent_hash, boolean loggable) {
        IpRange explicit_deny;
        if (this.ipBanner.isBanned(ipAddress)) {
            return true;
        }
        if (!this.isEnabled()) {
            return false;
        }
        if (ipAddress.isLoopbackAddress() || ipAddress.isLinkLocalAddress() || ipAddress.isSiteLocalAddress()) {
            return false;
        }
        if (AddressUtils.isLANLocalAddress(new InetSocketAddress(ipAddress, 0)) == 1) {
            return false;
        }
        if (torrent_hash != null && this.excluded_hashes.containsKey(torrent_hash)) {
            return false;
        }
        boolean allow = this.ip_filter_allow;
        IpRange match = ipAddress instanceof Inet4Address ? this.range_manager_v4.isInRange((Inet4Address)ipAddress) : this.range_manager_v6.isInRange((Inet6Address)ipAddress);
        if ((match == null || allow) && (explicit_deny = this.checkExternalHandlers(torrent_hash, ipAddress)) != null) {
            match = explicit_deny;
            allow = false;
        }
        if (match != null) {
            if (!allow) {
                if (this.addBlockedIP(new BlockedIpImpl(ipAddress.getHostAddress(), match, torrent_name, loggable), torrent_hash, loggable)) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID_NWMAN, "Ip Blocked : " + ipAddress + ", in range : " + match));
                    }
                    return true;
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID_NWMAN, 1, "Ip Blocking Denied: " + ipAddress + ", in range : " + match));
                }
                return false;
            }
            return false;
        }
        if (allow) {
            if (this.addBlockedIP(new BlockedIpImpl(ipAddress.getHostAddress(), null, torrent_name, loggable), torrent_hash, loggable)) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID_NWMAN, "Ip Blocked : " + ipAddress + ", not in any range"));
                }
                return true;
            }
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID_NWMAN, 1, "Ip Blocking Denied : " + ipAddress + ", not in any range"));
            }
            return false;
        }
        return false;
    }

    protected IpRange checkExternalHandlers(byte[] torrent_hash, String address) {
        if (this.external_handlers.size() > 0) {
            try {
                InetAddress ia = HostNameToIPResolver.syncResolve(address);
                return this.checkExternalHandlers(torrent_hash, ia);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        return null;
    }

    protected IpRange checkExternalHandlers(byte[] torrent_hash, InetAddress address) {
        if (this.external_handlers.size() > 0) {
            Iterator<IpFilterExternalHandler> it = this.external_handlers.iterator();
            while (it.hasNext()) {
                if (!it.next().isBlocked(torrent_hash, address)) continue;
                String ip = address.getHostAddress();
                if (address instanceof Inet4Address) {
                    return new IpRangeV4Impl("External handler", ip, ip, true);
                }
                return new IpRangeV6Impl("External handler", (Inet6Address)address, true);
            }
        }
        return null;
    }

    private boolean addBlockedIP(BlockedIp ip, byte[] torrent_hash, boolean loggable) {
        if (torrent_hash != null) {
            for (IPFilterListener listener : this.listenerz) {
                try {
                    if (listener.canIPBeBlocked(ip.getBlockedIp(), torrent_hash)) continue;
                    return false;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        try {
            class_mon.enter();
            this.ipsBlocked.addLast(ip);
            ++this.num_ips_blocked;
            if (loggable) {
                ++this.num_ips_blocked_loggable;
            }
            if (this.ipsBlocked.size() > 500) {
                this.ipsBlocked.removeFirst();
            }
        }
        finally {
            class_mon.exit();
        }
        return true;
    }

    @Override
    public boolean getInRangeAddressesAreAllowed() {
        return this.ip_filter_allow;
    }

    @Override
    public void setInRangeAddressesAreAllowed(boolean b) {
        COConfigurationManager.setParameter("Ip Filter Allow", b);
    }

    @Override
    public IpRange[] getRanges() {
        try {
            class_mon.enter();
            List entries_v4 = this.range_manager_v4.getEntries();
            List entries_v6 = this.range_manager_v6.getEntries();
            ArrayList entries = new ArrayList(entries_v4.size() + entries_v6.size());
            entries.addAll(entries_v4);
            entries.addAll(entries_v6);
            IpRange[] res = new IpRange[entries.size()];
            entries.toArray(res);
            IpRange[] ipRangeArray = res;
            return ipRangeArray;
        }
        finally {
            class_mon.exit();
        }
    }

    @Override
    public IpRange createRange(int addressType, boolean sessionOnly) {
        return addressType == 1 ? new IpRangeV4Impl("", "", "", sessionOnly) : new IpRangeV6Impl("", "", "", sessionOnly);
    }

    @Override
    public void addRange(IpRange range) {
        try {
            class_mon.enter();
            ((IpRangeImpl)range).setAddedToRangeList(true);
            range.checkValid();
        }
        finally {
            class_mon.exit();
        }
        this.markAsUpToDate();
    }

    @Override
    public void removeRange(IpRange range) {
        try {
            class_mon.enter();
            IpRangeImpl r = (IpRangeImpl)range;
            r.setAddedToRangeList(false);
            if (r.isV4()) {
                this.range_manager_v4.removeRange((IpRangeV4Impl)range);
            } else {
                this.range_manager_v6.removeRange((IpRangeV6Impl)range);
            }
        }
        finally {
            class_mon.exit();
        }
        this.markAsUpToDate();
    }

    @Override
    public int getNbRanges() {
        return this.range_manager_v4.getEntryCount() + this.range_manager_v6.getEntryCount();
    }

    protected void setValidOrNot(IpRange range, boolean valid) {
        IpRangeImpl r = (IpRangeImpl)range;
        try {
            class_mon.enter();
            if (!r.getAddedToRangeList()) {
                return;
            }
        }
        finally {
            class_mon.exit();
        }
        if (valid) {
            if (r.isV4()) {
                this.range_manager_v4.addRange((IpRangeV4Impl)range);
            } else {
                this.range_manager_v6.addRange((IpRangeV6Impl)range);
            }
        } else if (r.isV4()) {
            this.range_manager_v4.removeRange((IpRangeV4Impl)range);
        } else {
            this.range_manager_v6.removeRange((IpRangeV6Impl)range);
        }
    }

    @Override
    public int getNbIpsBlocked() {
        return this.num_ips_blocked;
    }

    @Override
    public int getNbIpsBlockedAndLoggable() {
        return this.num_ips_blocked_loggable;
    }

    @Override
    public boolean ban(String ipAddress, String torrent_name, boolean manual) {
        return this.ban(ipAddress, torrent_name, manual, 0);
    }

    @Override
    public BlockedIp[] getBlockedIps() {
        try {
            class_mon.enter();
            BlockedIp[] res = new BlockedIp[this.ipsBlocked.size()];
            this.ipsBlocked.toArray(res);
            BlockedIp[] blockedIpArray = res;
            return blockedIpArray;
        }
        finally {
            class_mon.exit();
        }
    }

    @Override
    public void clearBlockedIPs() {
        try {
            class_mon.enter();
            this.ipsBlocked.clear();
            this.num_ips_blocked = 0;
            this.num_ips_blocked_loggable = 0;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addExcludedHash(byte[] hash) {
        IpFilterImpl ipFilterImpl = this;
        synchronized (ipFilterImpl) {
            if (this.excluded_hashes.containsKey(hash)) {
                return;
            }
            ByteArrayHashMap<String> copy = new ByteArrayHashMap<String>();
            for (byte[] k : this.excluded_hashes.keys()) {
                copy.put(k, "");
            }
            copy.put(hash, "");
            this.excluded_hashes = copy;
        }
        this.markAsUpToDate();
        Logger.log(new LogEvent(LOGID, "Added " + ByteFormatter.encodeString(hash) + " to excluded set"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeExcludedHash(byte[] hash) {
        IpFilterImpl ipFilterImpl = this;
        synchronized (ipFilterImpl) {
            if (!this.excluded_hashes.containsKey(hash)) {
                return;
            }
            ByteArrayHashMap<String> copy = new ByteArrayHashMap<String>();
            for (byte[] k : this.excluded_hashes.keys()) {
                copy.put(k, "");
            }
            copy.remove(hash);
            this.excluded_hashes = copy;
        }
        this.markAsUpToDate();
        Logger.log(new LogEvent(LOGID, "Removed " + ByteFormatter.encodeString(hash) + " from excluded set"));
    }

    @Override
    public boolean isEnabled() {
        return this.ip_filter_enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        COConfigurationManager.setParameter("Ip Filter Enabled", enabled);
    }

    protected void markAsUpToDate() {
        this.last_update_time = SystemTime.getCurrentTime();
        this.blockedListChangedDispatcher.dispatch();
    }

    @Override
    public long getLastUpdateTime() {
        return this.last_update_time;
    }

    @Override
    public void addListener(IPFilterListener l) {
        this.listenerz.add(l);
    }

    @Override
    public void removeListener(IPFilterListener l) {
        this.listenerz.remove(l);
    }

    @Override
    public void addExternalHandler(IpFilterExternalHandler h) {
        this.external_handlers.add(h);
    }

    @Override
    public void removeExternalHandler(IpFilterExternalHandler h) {
        this.external_handlers.remove(h);
    }

    protected CopyOnWriteList<IPFilterListener> getListeners() {
        return this.listenerz;
    }

    protected void banListChanged() {
        for (IPFilterListener listener : this.listenerz) {
            try {
                listener.IPBanListChanged(this);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public boolean ban(String ipAddress, String torrent_name, boolean manual, int for_mins) {
        return this.ipBanner.ban(ipAddress, torrent_name, manual, for_mins);
    }

    @Override
    public void clearBannedIps() {
        this.ipBanner.clearBannedIps();
    }

    @Override
    public BannedIp[] getBannedIps() {
        return this.ipBanner.getBannedIps();
    }

    @Override
    public int getNbBannedIps() {
        return this.ipBanner.getNbBannedIps();
    }

    @Override
    public boolean unban(String ipAddress) {
        return this.ipBanner.unban(ipAddress);
    }

    @Override
    public boolean unban(String ipAddress, boolean block) {
        return this.ipBanner.unban(ipAddress, block);
    }
}

