/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.ipfilter.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.ipfilter.BannedIp;
import com.biglybt.core.ipfilter.IPFilterListener;
import com.biglybt.core.ipfilter.impl.BannedIpImpl;
import com.biglybt.core.ipfilter.impl.IpFilterImpl;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.tracker.protocol.PRHelpers;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.HostNameToIPResolver;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class IPBannerImpl {
    private static final long BAN_IP_PERSIST_TIME = 604800000L;
    static final AEMonitor class_mon = IpFilterImpl.class_mon;
    private final IpFilterImpl ipFilter;
    private final Map<Integer, BannedIpImpl> bannedIps_v4 = new HashMap<Integer, BannedIpImpl>();
    private final Map<InetAddress, BannedIpImpl> bannedIps_v6 = new HashMap<InetAddress, BannedIpImpl>();
    private final Map<String, BannedIpImpl> bannedIps_other = new HashMap<String, BannedIpImpl>();
    TimerEventPeriodic unban_timer;
    final Map<Long, List<String>> unban_map = new TreeMap<Long, List<String>>();
    final Map<String, Long> unban_map_reverse = new HashMap<String, Long>();

    protected IPBannerImpl(IpFilterImpl _ipFilter) {
        this.ipFilter = _ipFilter;
        try {
            this.loadBannedIPs();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected void loadBannedIPs() {
        if (!COConfigurationManager.getBooleanParameter("Ip Filter Banning Persistent")) {
            return;
        }
        try {
            try {
                class_mon.enter();
                Map map = FileUtil.readResilientConfigFile("banips.config");
                List ips = (List)map.get("ips");
                if (ips != null) {
                    long now = SystemTime.getCurrentTime();
                    int i = 0;
                    while (i < ips.size()) {
                        Map entry = (Map)ips.get(i);
                        String ip = new String((byte[])entry.get("ip"));
                        String desc = new String((byte[])entry.get("desc"), "UTF-8");
                        Long ltime = (Long)entry.get("time");
                        long time = ltime;
                        boolean drop = false;
                        if (time > now) {
                            time = now;
                        } else if (now - time >= 604800000L) {
                            drop = true;
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(IpFilterImpl.LOGID, 0, "Persistent ban dropped as too old : " + ip + ", " + desc));
                            }
                        }
                        if (!drop) {
                            BannedIpImpl bip = new BannedIpImpl(ip, desc, time);
                            Object oa = this.decodeAddress(ip);
                            if (oa instanceof Integer) {
                                this.bannedIps_v4.put((Integer)oa, bip);
                            } else if (oa instanceof InetAddress) {
                                this.bannedIps_v6.put((InetAddress)oa, bip);
                            } else {
                                this.bannedIps_other.put((String)oa, bip);
                            }
                        }
                        ++i;
                    }
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                class_mon.exit();
            }
        }
        finally {
            class_mon.exit();
        }
    }

    protected void saveBannedIPs() {
        if (COConfigurationManager.getBooleanParameter("Ip Filter Banning Persistent")) {
            try {
                try {
                    class_mon.enter();
                    HashMap map = new HashMap();
                    ArrayList ips = new ArrayList();
                    List<Iterator> its = Arrays.asList(this.bannedIps_v4.values().iterator(), this.bannedIps_v6.values().iterator(), this.bannedIps_other.values().iterator());
                    for (Iterator it : its) {
                        while (it.hasNext()) {
                            BannedIpImpl bip = (BannedIpImpl)it.next();
                            if (bip.isTemporary()) continue;
                            HashMap<String, Object> entry = new HashMap<String, Object>();
                            entry.put("ip", bip.getIp());
                            entry.put("desc", bip.getTorrentName().getBytes("UTF-8"));
                            entry.put("time", new Long(bip.getBanningTime()));
                            ips.add(entry);
                        }
                    }
                    map.put("ips", ips);
                    FileUtil.writeResilientConfigFile("banips.config", map);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    class_mon.exit();
                }
            }
            finally {
                class_mon.exit();
            }
        }
    }

    protected boolean isBanned(InetAddress ipAddress) {
        Object oa = this.decodeAddress(ipAddress);
        try {
            class_mon.enter();
            if (oa instanceof Integer) {
                boolean bl = this.bannedIps_v4.containsKey((Integer)oa);
                return bl;
            }
            boolean bl = this.bannedIps_v6.containsKey(ipAddress);
            return bl;
        }
        finally {
            class_mon.exit();
        }
    }

    protected boolean isBanned(String ipAddress) {
        Object oa = this.decodeAddress(ipAddress);
        try {
            class_mon.enter();
            if (oa instanceof Integer) {
                boolean bl = this.bannedIps_v4.containsKey((Integer)oa);
                return bl;
            }
            if (oa instanceof InetAddress) {
                boolean bl = this.bannedIps_v6.containsKey((InetAddress)oa);
                return bl;
            }
            boolean bl = this.bannedIps_other.containsKey((String)oa);
            return bl;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean ban(String ipAddress, String torrent_name, boolean manual, int for_mins) {
        void var9_18;
        if (!manual) {
            for (IPFilterListener listener : this.ipFilter.getListeners()) {
                try {
                    if (listener.canIPBeBanned(ipAddress)) continue;
                    return false;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        boolean block_ban = false;
        ArrayList<Object> new_bans = new ArrayList<Object>();
        boolean temporary = for_mins > 0;
        Object oa = this.decodeAddress(ipAddress);
        try {
            Object new_ban;
            class_mon.enter();
            if (oa instanceof Integer) {
                Integer n = (Integer)oa;
                if (this.bannedIps_v4.get(n) == null) {
                    new_ban = new BannedIpImpl(ipAddress, torrent_name, temporary);
                    new_bans.add(new_ban);
                    this.bannedIps_v4.put(n, (BannedIpImpl)new_ban);
                    long l_address = n.intValue();
                    if (l_address < 0L) {
                        l_address += 0x100000000L;
                    }
                    long start = l_address & 0xFFFFFFFFFFFFFF00L;
                    long end = start + 256L;
                    int hits = 0;
                    long i = start;
                    while (i < end) {
                        Integer a = new Integer((int)i);
                        if (this.bannedIps_v4.get(a) != null) {
                            ++hits;
                        }
                        ++i;
                    }
                    int hit_limit = COConfigurationManager.getIntParameter("Ip Filter Ban Block Limit");
                    if (hits >= hit_limit) {
                        block_ban = true;
                        long i2 = start;
                        while (i2 < end) {
                            Integer a = new Integer((int)i2);
                            if (this.bannedIps_v4.get(a) == null) {
                                BannedIpImpl new_block_ban = new BannedIpImpl(PRHelpers.intToAddress((int)i2), String.valueOf(torrent_name) + " [block ban]", temporary);
                                new_bans.add(new_block_ban);
                                this.bannedIps_v4.put(a, new_block_ban);
                            }
                            ++i2;
                        }
                    }
                }
            } else if (oa instanceof InetAddress) {
                InetAddress inetAddress = (InetAddress)oa;
                if (this.bannedIps_v6.get(inetAddress) == null) {
                    new_ban = new BannedIpImpl(ipAddress, torrent_name, temporary);
                    new_bans.add(new_ban);
                    this.bannedIps_v6.put(inetAddress, (BannedIpImpl)new_ban);
                }
            } else {
                String string = (String)oa;
                if (this.bannedIps_other.get(string) == null) {
                    new_ban = new BannedIpImpl(ipAddress, torrent_name, temporary);
                    new_bans.add(new_ban);
                    this.bannedIps_other.put(string, (BannedIpImpl)new_ban);
                }
            }
            if (!new_bans.isEmpty()) {
                if (temporary) {
                    for (BannedIpImpl bannedIpImpl : new_bans) {
                        this.addTemporaryBan(bannedIpImpl, for_mins);
                    }
                }
                this.saveBannedIPs();
            }
        }
        finally {
            class_mon.exit();
        }
        boolean bl = false;
        while (var9_18 < new_bans.size()) {
            BannedIp entry = (BannedIp)new_bans.get((int)var9_18);
            for (IPFilterListener listener : this.ipFilter.getListeners()) {
                try {
                    listener.IPBanned(entry);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            ++var9_18;
        }
        if (new_bans.size() > 0) {
            this.ipFilter.banListChanged();
        }
        return block_ban;
    }

    private void addTemporaryBan(BannedIpImpl ban, int mins) {
        List<String> list;
        if (this.unban_timer == null) {
            this.unban_timer = SimpleTimer.addPeriodicEvent("Unbanner", 30000L, new TimerEventPerformer(){

                @Override
                public void perform(TimerEvent event2) {
                    ArrayList<String> to_unban = new ArrayList<String>();
                    try {
                        class_mon.enter();
                        long now = SystemTime.getMonotonousTime();
                        Iterator<Map.Entry<Long, List<String>>> it = IPBannerImpl.this.unban_map.entrySet().iterator();
                        while (it.hasNext()) {
                            Map.Entry<Long, List<String>> entry = it.next();
                            if (entry.getKey() > now) break;
                            it.remove();
                            for (String ip : entry.getValue()) {
                                IPBannerImpl.this.unban_map_reverse.remove(ip);
                                to_unban.add(ip);
                            }
                        }
                        if (IPBannerImpl.this.unban_map.size() == 0) {
                            IPBannerImpl.this.unban_timer.cancel();
                            IPBannerImpl.this.unban_timer = null;
                        }
                    }
                    finally {
                        class_mon.exit();
                    }
                    for (String ip : to_unban) {
                        IPBannerImpl.this.unban(ip);
                    }
                }
            });
        }
        String ip = ban.getIp();
        long expiry = SystemTime.getMonotonousTime() + (long)(mins * 60) * 1000L;
        expiry = (expiry + 29999L) / 30000L * 30000L;
        Long old_expiry = this.unban_map_reverse.get(ip);
        if (old_expiry != null && (list = this.unban_map.get(old_expiry)) != null) {
            list.remove(ip);
            if (list.size() == 0) {
                this.unban_map.remove(old_expiry);
            }
        }
        this.unban_map_reverse.put(ip, expiry);
        list = this.unban_map.get(expiry);
        if (list == null) {
            list = new ArrayList<String>(1);
            this.unban_map.put(expiry, list);
        }
        list.add(ip);
    }

    public BannedIp[] getBannedIps() {
        try {
            class_mon.enter();
            ArrayList<BannedIpImpl> ips = new ArrayList<BannedIpImpl>(this.getNbBannedIps());
            ips.addAll(this.bannedIps_v4.values());
            ips.addAll(this.bannedIps_v6.values());
            ips.addAll(this.bannedIps_other.values());
            BannedIp[] res = new BannedIp[ips.size()];
            ips.toArray(res);
            BannedIp[] bannedIpArray = res;
            return bannedIpArray;
        }
        finally {
            class_mon.exit();
        }
    }

    public int getNbBannedIps() {
        return this.bannedIps_v4.size() + this.bannedIps_v6.size() + this.bannedIps_other.size();
    }

    public void clearBannedIps() {
        try {
            class_mon.enter();
            this.bannedIps_v4.clear();
            this.bannedIps_v6.clear();
            this.bannedIps_other.clear();
            this.unban_map.clear();
            this.unban_map_reverse.clear();
            this.saveBannedIPs();
        }
        finally {
            class_mon.exit();
        }
        this.ipFilter.banListChanged();
    }

    public boolean unban(String ipAddress) {
        boolean hit = false;
        Object oa = this.decodeAddress(ipAddress);
        try {
            class_mon.enter();
            BannedIpImpl entry = oa instanceof Integer ? this.bannedIps_v4.remove((Integer)oa) : (oa instanceof InetAddress ? this.bannedIps_v6.remove((InetAddress)oa) : this.bannedIps_other.remove((String)oa));
            if (entry != null) {
                hit = true;
                if (!entry.isTemporary()) {
                    this.saveBannedIPs();
                }
            }
        }
        finally {
            class_mon.exit();
        }
        if (hit) {
            this.ipFilter.banListChanged();
        }
        return hit;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean unban(String ipAddress, boolean block) {
        boolean hit;
        block18: {
            hit = false;
            Object oa = this.decodeAddress(ipAddress);
            if (block && oa instanceof Integer) {
                int address = (Integer)oa;
                long l_address = address;
                if (l_address < 0L) {
                    l_address += 0x100000000L;
                }
                long start = l_address & 0xFFFFFFFFFFFFFF00L;
                long end = start + 256L;
                try {
                    class_mon.enter();
                    long i = start;
                    while (true) {
                        if (i >= end) {
                            if (hit) {
                                this.saveBannedIPs();
                            }
                            break block18;
                        }
                        Integer a = new Integer((int)i);
                        if (this.bannedIps_v4.remove(a) != null) {
                            hit = true;
                        }
                        ++i;
                    }
                }
                finally {
                    class_mon.exit();
                }
            }
            try {
                class_mon.enter();
                if (oa instanceof Integer) {
                    hit = this.bannedIps_v4.remove((Integer)oa) != null;
                } else if (oa instanceof InetAddress) {
                    hit = this.bannedIps_v6.remove((InetAddress)oa) != null;
                } else {
                    boolean bl = hit = this.bannedIps_other.remove((String)oa) != null;
                }
                if (hit) {
                    hit = true;
                    this.saveBannedIPs();
                }
            }
            finally {
                class_mon.exit();
            }
        }
        if (hit) {
            this.ipFilter.banListChanged();
        }
        return hit;
    }

    private Object decodeAddress(String address) {
        try {
            if (HostNameToIPResolver.isNonDNSName(address)) {
                return address;
            }
            return this.decodeAddress(HostNameToIPResolver.syncResolve(address));
        }
        catch (Throwable e) {
            return address;
        }
    }

    private Object decodeAddress(InetAddress address) {
        if (address instanceof Inet4Address) {
            return PRHelpers.addressToInt(address);
        }
        return address;
    }
}

