/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.ipfilter.impl;

import com.biglybt.core.ipfilter.IpRange;
import com.biglybt.core.ipfilter.impl.IpRangeV6Impl;
import com.biglybt.core.util.IdentityHashSet;
import com.biglybt.core.util.SystemTime;
import java.net.Inet6Address;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class IPAddressRangeManagerV6 {
    private Set<IpRangeV6Impl> ranges = new IdentityHashSet<IpRangeV6Impl>();
    private volatile int range_count;
    private IpRangeV6Impl[] sorted_ranges;
    protected boolean rebuild_required;
    protected long last_rebuild_time = -1L;
    private Comparator<IpRangeV6Impl> range_comparator = new Comparator<IpRangeV6Impl>(){

        @Override
        public int compare(IpRangeV6Impl o1, IpRangeV6Impl o2) {
            return o1.compareStartIpTo(o2);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRange(IpRangeV6Impl range) {
        Set<IpRangeV6Impl> set = this.ranges;
        synchronized (set) {
            if (this.ranges.add(range)) {
                this.range_count = this.ranges.size();
            }
            this.rebuild_required = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeRange(IpRangeV6Impl range) {
        Set<IpRangeV6Impl> set = this.ranges;
        synchronized (set) {
            if (this.ranges.remove(range)) {
                this.range_count = this.ranges.size();
            }
            this.rebuild_required = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getEntries() {
        Set<IpRangeV6Impl> set = this.ranges;
        synchronized (set) {
            return new ArrayList<IpRangeV6Impl>(this.ranges);
        }
    }

    protected int getEntryCount() {
        return this.range_count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearAllEntries() {
        Set<IpRangeV6Impl> set = this.ranges;
        synchronized (set) {
            this.ranges.clear();
            this.range_count = 0;
            this.rebuild_required = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuild() {
        Set<IpRangeV6Impl> set = this.ranges;
        synchronized (set) {
            if (this.ranges.isEmpty()) {
                this.sorted_ranges = null;
            } else {
                this.sorted_ranges = new IpRangeV6Impl[this.ranges.size()];
                this.ranges.toArray(this.sorted_ranges);
                Arrays.sort(this.sorted_ranges, this.range_comparator);
                HashSet<IpRangeV6Impl> temp = new HashSet<IpRangeV6Impl>(this.ranges);
                int i = 0;
                while (i < this.sorted_ranges.length - 1) {
                    IpRangeV6Impl r1 = this.sorted_ranges[i];
                    int j = i + 1;
                    while (j < this.sorted_ranges.length) {
                        IpRangeV6Impl r2 = this.sorted_ranges[j];
                        if (!r1.isInRange(r2.getStartPrefix())) break;
                        temp.remove(r2);
                        ++i;
                        ++j;
                    }
                    ++i;
                }
                if (temp.size() < this.ranges.size()) {
                    this.sorted_ranges = new IpRangeV6Impl[temp.size()];
                    temp.toArray(this.sorted_ranges);
                    Arrays.sort(this.sorted_ranges, this.range_comparator);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IpRange isInRange(Inet6Address ia) {
        if (this.range_count == 0) {
            return null;
        }
        IpRangeV6Impl ia_range = new IpRangeV6Impl("", ia, true);
        Set<IpRangeV6Impl> set = this.ranges;
        synchronized (set) {
            IpRangeV6Impl range;
            block9: {
                if (this.rebuild_required) {
                    long now = SystemTime.getMonotonousTime();
                    if (this.last_rebuild_time == -1L || (now - this.last_rebuild_time) / 1000L > (long)(this.range_count / 2000)) {
                        this.last_rebuild_time = now;
                        this.rebuild_required = false;
                        this.rebuild();
                    }
                }
                if (this.sorted_ranges != null) break block9;
                return null;
            }
            int res = Arrays.binarySearch(this.sorted_ranges, ia_range, this.range_comparator);
            if (res >= 0) {
                return this.sorted_ranges[res];
            }
            int prev = -res - 2;
            if (prev >= 0 && (range = this.sorted_ranges[prev]).isInRange(ia.getAddress())) {
                return range;
            }
        }
        return null;
    }
}

