/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.internat;

import com.biglybt.core.internat.LocaleUtilDecoder;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.Constants;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.Arrays;

public class LocaleUtilDecoderReal
implements LocaleUtilDecoder {
    protected final CharsetDecoder decoder;
    protected final int index;
    private AEMonitor this_mon = new AEMonitor("LUDR");

    protected LocaleUtilDecoderReal(int _index, CharsetDecoder _decoder) {
        this.index = _index;
        this.decoder = _decoder;
    }

    @Override
    public String getName() {
        return this.decoder.charset().name();
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public String tryDecode(byte[] array, boolean lax) {
        try {
            CoderResult cr;
            ByteBuffer bb = ByteBuffer.wrap(array);
            CharBuffer cb = CharBuffer.allocate(array.length);
            this.this_mon.enter();
            try {
                cr = this.decoder.decode(bb, cb, true);
            }
            finally {
                this.this_mon.exit();
            }
            if (!cr.isError()) {
                cb.flip();
                String str = cb.toString();
                if (lax) {
                    return str;
                }
                byte[] b2 = str.getBytes(this.getName());
                if (Arrays.equals(array, b2)) {
                    return str;
                }
            }
        }
        finally {
            return null;
        }
    }

    @Override
    public String decodeString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            CoderResult cr;
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            CharBuffer cb = CharBuffer.allocate(bytes.length);
            this.this_mon.enter();
            try {
                cr = this.decoder.decode(bb, cb, true);
            }
            finally {
                this.this_mon.exit();
            }
            if (!cr.isError()) {
                cb.flip();
                String str = cb.toString();
                byte[] b2 = str.getBytes(this.decoder.charset().name());
                if (Arrays.equals(bytes, b2)) {
                    return str;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new String(bytes, Constants.DEFAULT_ENCODING_CHARSET);
    }
}

