/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.instancemanager.impl;

import com.biglybt.core.config.COConfigurationListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.instancemanager.ClientInstanceManagerAdapter;
import com.biglybt.core.instancemanager.impl.ClientInstanceImpl;
import com.biglybt.core.instancemanager.impl.ClientInstanceManagerImpl;
import com.biglybt.core.networkmanager.admin.NetworkAdmin;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SHA1Simple;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.core.util.SystemTime;
import com.biglybt.plugin.dht.DHTPlugin;
import com.biglybt.plugin.dht.DHTPluginContact;
import com.biglybt.plugin.dht.DHTPluginListener;
import com.biglybt.plugin.upnp.UPnPPlugin;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ClientMyInstanceImpl
extends ClientInstanceImpl {
    public static final long FORCE_READ_EXT_MIN = 28800000L;
    public static final long UPNP_READ_MIN = 300000L;
    final ClientInstanceManagerAdapter adapter;
    final ClientInstanceManagerImpl manager;
    private String id;
    InetAddress internal_address;
    private int tcp_port;
    private int udp_port;
    private int udp_non_data_port;
    private long last_upnp_read;
    InetAddress dht_address;
    long dht_address_time;
    private long last_force_read_ext;
    private InetAddress last_external_address;

    protected ClientMyInstanceImpl(ClientInstanceManagerAdapter _adapter, ClientInstanceManagerImpl _manager) {
        this.adapter = _adapter;
        this.manager = _manager;
        this.id = this.adapter.getID();
        if (this.id.length() == 0) {
            this.id = "" + SystemTime.getCurrentTime();
        }
        this.id = ByteFormatter.encodeString(new SHA1Simple().calculateHash(this.id.getBytes()));
        COConfigurationManager.addListener(new COConfigurationListener(){

            @Override
            public void configurationSaved() {
                ClientMyInstanceImpl.this.readConfig(false);
            }
        });
        this.readConfig(true);
        this.adapter.addListener(new ClientInstanceManagerAdapter.StateListener(){

            @Override
            public void started() {
                DHTPlugin dht = ClientMyInstanceImpl.this.adapter.getDHTPlugin();
                if (dht != null) {
                    dht.addListener(new DHTPluginListener(){

                        @Override
                        public void localAddressChanged(DHTPluginContact local_contact) {
                            InetAddress latest_dht_address = local_contact.getAddress().getAddress();
                            if (ClientMyInstanceImpl.this.sameFamily((this).ClientMyInstanceImpl.this.internal_address, latest_dht_address)) {
                                (this).ClientMyInstanceImpl.this.dht_address = latest_dht_address;
                                (this).ClientMyInstanceImpl.this.dht_address_time = SystemTime.getCurrentTime();
                                (this).ClientMyInstanceImpl.this.manager.informChanged(ClientMyInstanceImpl.this);
                            }
                        }
                    });
                }
            }

            @Override
            public void stopped() {
            }
        });
    }

    void readConfig(boolean first_time) {
        InetAddress new_internal_address = NetworkAdmin.getSingleton().getSingleHomedServiceBindAddress();
        if (new_internal_address == null) {
            try {
                new_internal_address = InetAddress.getByName("0.0.0.0");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        int[] ports = this.adapter.getPorts();
        int new_tcp_port = ports[0];
        int new_udp_port = ports[1];
        int new_udp_non_data_port = ports[2];
        boolean same = true;
        if (!first_time) {
            same = this.internal_address.equals(new_internal_address) && this.tcp_port == new_tcp_port && this.udp_port == new_udp_port && this.udp_non_data_port == new_udp_non_data_port;
        }
        this.internal_address = new_internal_address;
        this.tcp_port = new_tcp_port;
        this.udp_port = new_udp_port;
        this.udp_non_data_port = new_udp_non_data_port;
        if (!same) {
            this.manager.informChanged(this);
        }
    }

    private InetAddress readExternalAddress() {
        boolean ok_to_try_ext;
        long now;
        InetAddress external_address;
        block27: {
            long cache_time;
            ClientInstanceManagerAdapter.VCPublicAddress a;
            external_address = null;
            if (this.manager.isClosing()) {
                external_address = this.last_external_address;
                if (external_address == null) {
                    try {
                        external_address = InetAddress.getByName("127.0.0.1");
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                return external_address;
            }
            DHTPlugin dht = this.adapter.getDHTPlugin();
            if (this.dht_address != null && this.dht_address_time <= SystemTime.getCurrentTime() && (a = this.adapter.getVCPublicAddress()) != null && (cache_time = a.getCacheTime()) <= this.dht_address_time) {
                external_address = this.dht_address;
            }
            if (external_address == null && (dht == null || dht.getStatus() != 3) && (a = this.adapter.getVCPublicAddress()) != null) {
                try {
                    external_address = InetAddress.getByName(a.getAddress());
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            if (external_address == null && dht != null) {
                try {
                    InetAddress latest_dht_address = dht.getLocalAddress().getAddress().getAddress();
                    if (this.sameFamily(this.internal_address, latest_dht_address)) {
                        external_address = latest_dht_address;
                    }
                }
                catch (Throwable latest_dht_address) {
                    // empty catch block
                }
            }
            if (this.last_force_read_ext > (now = SystemTime.getCurrentTime())) {
                this.last_force_read_ext = now;
            }
            boolean bl = ok_to_try_ext = now - this.last_force_read_ext > 28800000L;
            if (external_address == null && this.last_external_address != null) {
                if (this.last_upnp_read > now) {
                    this.last_upnp_read = now;
                }
                if (now - this.last_upnp_read > 300000L || ok_to_try_ext) {
                    this.last_upnp_read = now;
                    try {
                        UPnPPlugin upnp = this.adapter.getUPnPPlugin();
                        if (upnp == null) break block27;
                        String[] addresses = upnp.getExternalIPAddresses();
                        int i = 0;
                        while (i < addresses.length) {
                            if (addresses[i].equals(this.last_external_address.getHostAddress())) {
                                external_address = this.last_external_address;
                                break;
                            }
                            ++i;
                        }
                    }
                    catch (Throwable upnp) {
                        // empty catch block
                    }
                }
            }
        }
        if (external_address == null && ok_to_try_ext) {
            this.last_force_read_ext = now;
            external_address = this.adapter.getPublicAddress();
        }
        if (external_address == null) {
            if (this.last_external_address != null) {
                external_address = this.last_external_address;
            } else {
                try {
                    external_address = InetAddress.getByName("127.0.0.1");
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        } else {
            this.last_external_address = external_address;
        }
        return external_address;
    }

    boolean sameFamily(InetAddress a1, InetAddress a2) {
        return a1 instanceof Inet4Address == a2 instanceof Inet4Address;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getApplicationID() {
        return String.valueOf(SystemProperties.getApplicationIdentifier()) + "_" + SystemProperties.getApplicationVersion();
    }

    @Override
    public InetAddress getInternalAddress() {
        return this.internal_address;
    }

    public List getInternalAddresses() {
        ArrayList<InetAddress> l = new ArrayList<InetAddress>();
        if (this.internal_address != null) {
            l.add(this.internal_address);
        }
        return l;
    }

    @Override
    public InetAddress getExternalAddress() {
        return this.readExternalAddress();
    }

    @Override
    public int getTCPListenPort() {
        return this.tcp_port;
    }

    @Override
    public int getUDPListenPort() {
        return this.udp_port;
    }

    @Override
    public int getUDPNonDataListenPort() {
        return this.udp_non_data_port;
    }

    @Override
    public Map<String, Object> getProperties() {
        return COConfigurationManager.getMapParameter("instance.manager.props", null);
    }
}

