/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.impl;

import com.biglybt.core.Core;
import com.biglybt.core.CoreComponent;
import com.biglybt.core.CoreException;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreLifecycleAdapter;
import com.biglybt.core.CoreLifecycleListener;
import com.biglybt.core.CoreOperation;
import com.biglybt.core.CoreOperationListener;
import com.biglybt.core.CoreOperationTask;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.backup.BackupManagerFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.config.impl.TransferSpeedValidator;
import com.biglybt.core.custom.CustomizationManagerFactory;
import com.biglybt.core.dht.DHT;
import com.biglybt.core.dht.DHTListener;
import com.biglybt.core.dht.speed.DHTSpeedTester;
import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.disk.DiskManagerFactory;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.global.GlobalManagerAdapter;
import com.biglybt.core.global.GlobalManagerFactory;
import com.biglybt.core.global.GlobalManagerStats;
import com.biglybt.core.global.GlobalMangerProgressListener;
import com.biglybt.core.instancemanager.ClientInstanceManager;
import com.biglybt.core.instancemanager.ClientInstanceManagerAdapter;
import com.biglybt.core.instancemanager.ClientInstanceManagerFactory;
import com.biglybt.core.instancemanager.ClientInstanceTracked;
import com.biglybt.core.internat.LocaleUtil;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.ipfilter.IpFilterManager;
import com.biglybt.core.ipfilter.IpFilterManagerFactory;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.nat.NATTraverser;
import com.biglybt.core.networkmanager.NetworkManager;
import com.biglybt.core.networkmanager.admin.NetworkAdmin;
import com.biglybt.core.networkmanager.admin.NetworkAdminNetworkInterface;
import com.biglybt.core.networkmanager.admin.NetworkAdminNetworkInterfaceAddress;
import com.biglybt.core.networkmanager.admin.NetworkAdminPropertyChangeListener;
import com.biglybt.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.biglybt.core.networkmanager.impl.udp.UDPNetworkManager;
import com.biglybt.core.pairing.PairingManagerFactory;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peermanager.PeerManager;
import com.biglybt.core.peermanager.nat.PeerNATTraverser;
import com.biglybt.core.proxy.AEProxyFactory;
import com.biglybt.core.proxy.AEProxySelectorFactory;
import com.biglybt.core.security.BGSpongy;
import com.biglybt.core.security.CryptoManager;
import com.biglybt.core.security.CryptoManagerFactory;
import com.biglybt.core.security.SESecurityManager;
import com.biglybt.core.speedmanager.SpeedLimitHandler;
import com.biglybt.core.speedmanager.SpeedManager;
import com.biglybt.core.speedmanager.SpeedManagerAdapter;
import com.biglybt.core.speedmanager.SpeedManagerFactory;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.tracker.AllTrackersManager;
import com.biglybt.core.tracker.client.TRTrackerAnnouncer;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerResponse;
import com.biglybt.core.tracker.host.TRHost;
import com.biglybt.core.tracker.host.TRHostFactory;
import com.biglybt.core.update.ClientRestarterFactory;
import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AETemporaryFileHandler;
import com.biglybt.core.util.AEThread;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DelayedEvent;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.ListenerManager;
import com.biglybt.core.util.ListenerManagerDispatcher;
import com.biglybt.core.util.NonDaemonTaskRunner;
import com.biglybt.core.util.SHA1Simple;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.ThreadPool;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.core.versioncheck.VersionCheckClient;
import com.biglybt.core.vuzefile.VuzeFile;
import com.biglybt.core.vuzefile.VuzeFileComponent;
import com.biglybt.core.vuzefile.VuzeFileHandler;
import com.biglybt.core.vuzefile.VuzeFileProcessor;
import com.biglybt.pif.PluginEvent;
import com.biglybt.pif.PluginEventListener;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.PluginManager;
import com.biglybt.pif.PluginManagerDefaults;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pif.torrent.TorrentDownloader;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.utils.DelayedTask;
import com.biglybt.pif.utils.PowerManagementListener;
import com.biglybt.pif.utils.ScriptProvider;
import com.biglybt.pif.utils.StaticUtilities;
import com.biglybt.pifimpl.PluginUtils;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.pifimpl.local.clientid.ClientIDPlugin;
import com.biglybt.pifimpl.local.download.DownloadImpl;
import com.biglybt.pifimpl.local.download.DownloadManagerImpl;
import com.biglybt.pifimpl.local.utils.UtilitiesImpl;
import com.biglybt.platform.PlatformManager;
import com.biglybt.platform.PlatformManagerCapabilities;
import com.biglybt.platform.PlatformManagerFactory;
import com.biglybt.platform.PlatformManagerListener;
import com.biglybt.plugin.dht.DHTPlugin;
import com.biglybt.plugin.startstoprules.defaultplugin.DefaultRankCalculator;
import com.biglybt.plugin.startstoprules.defaultplugin.StartStopRulesDefaultPlugin;
import com.biglybt.plugin.tracker.dht.DHTTrackerPlugin;
import com.biglybt.plugin.upnp.UPnPPlugin;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.util.MapUtils;
import java.io.File;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class CoreImpl
implements Core {
    public static final boolean DEBUG_STARTUPTIME = System.getProperty("DEBUG_STARTUPTIME", "0").equals("1");
    static final LogIDs LOGID = LogIDs.CORE;
    protected static Core singleton;
    protected static final AEMonitor class_mon;
    private static final String DM_ANNOUNCE_KEY = "Core:announce_key";
    private static final boolean LOAD_PLUGINS_IN_OTHER_THREAD = false;
    static List<CoreRunningListener> coreRunningListeners;
    static final AEMonitor mon_coreRunningListeners;
    private static long lastDebugTime;
    final PluginInitializer pi;
    GlobalManager global_manager;
    private final ClientInstanceManager instance_manager;
    SpeedManager speed_manager;
    private final CryptoManager crypto_manager;
    private final NATTraverser nat_traverser;
    private final long create_time;
    private volatile boolean started;
    volatile boolean stopped;
    volatile boolean restarting;
    private final CopyOnWriteList<CoreLifecycleListener> lifecycle_listeners = new CopyOnWriteList();
    private boolean ll_started;
    private final List<CoreOperationListener> operation_listeners = new ArrayList<CoreOperationListener>();
    private final CopyOnWriteList<CoreOperation> operations = new CopyOnWriteList();
    private final CopyOnWriteList<PowerManagementListener> power_listeners = new CopyOnWriteList();
    final AESemaphore stopping_sem = new AESemaphore("Core::stopping");
    private final AEMonitor this_mon = new AEMonitor("Core");
    boolean ca_shutdown_computer_after_stop = false;
    long ca_last_time_downloading = -1L;
    long ca_last_time_seeding = -1L;
    private boolean ra_restarting = false;
    private long ra_last_total_data = -1L;
    private long ra_last_data_time = 0L;
    private boolean prevent_sleep_remove_trigger = false;
    private FileLock file_lock;
    long start = SystemTime.getMonotonousTime();
    private boolean js_plugin_install_tried;

    static {
        class_mon = new AEMonitor("Core:class");
        coreRunningListeners = new ArrayList<CoreRunningListener>(1);
        mon_coreRunningListeners = new AEMonitor("CoreCreationListeners");
        lastDebugTime = 0L;
    }

    public static Core create() throws CoreException {
        try {
            class_mon.enter();
            if (singleton != null) {
                throw new CoreException(String.valueOf(Constants.APP_NAME) + " core already instantiated");
            }
            Core core = singleton = new CoreImpl();
            return core;
        }
        finally {
            class_mon.exit();
        }
    }

    public static boolean isCoreAvailable() {
        return singleton != null;
    }

    public static boolean isCoreRunning() {
        return singleton != null && singleton.isStarted();
    }

    public static Core getSingleton() throws CoreException {
        if (singleton == null) {
            throw new CoreException("core not instantiated");
        }
        return singleton;
    }

    protected CoreImpl() {
        try {
            this.create_time = SystemTime.getCurrentTime();
            if (DEBUG_STARTUPTIME) {
                lastDebugTime = System.currentTimeMillis();
            }
            COConfigurationManager.initialise();
            if (DEBUG_STARTUPTIME) {
                CoreImpl.logTime("ConfigMan.init");
            }
            MessageText.loadBundle();
            if (DEBUG_STARTUPTIME) {
                CoreImpl.logTime("MessageText");
            }
            AEDiagnostics.startup(COConfigurationManager.getBooleanParameter("diags.enable.pending.writes", false));
            COConfigurationManager.setParameter("diags.enable.pending.writes", false);
            AEDiagnostics.markDirty();
            AETemporaryFileHandler.startup();
            AEThread2.setOurThread();
            COConfigurationManager.setParameter("azureus.application.directory", FileUtil.newFile(SystemProperties.getApplicationPath(), new String[0]).getAbsolutePath());
            COConfigurationManager.setParameter("azureus.user.directory", FileUtil.newFile(SystemProperties.getUserPath(), new String[0]).getAbsolutePath());
            this.crypto_manager = CryptoManagerFactory.getSingleton();
            PlatformManagerFactory.getPlatformManager().addListener(new PlatformManagerListener(){

                @Override
                public int eventOccurred(int type) {
                    if (type == 1) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "Platform manager requested shutdown"));
                        }
                        COConfigurationManager.save();
                        CoreImpl.this.requestStop();
                        return 0;
                    }
                    if (type == 2) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "Platform manager requested suspend"));
                        }
                        COConfigurationManager.save();
                    } else if (type == 3) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "Platform manager requested resume"));
                        }
                        CoreImpl.this.announceAll(true);
                    }
                    return -1;
                }
            });
            CustomizationManagerFactory.getSingleton().initialize();
            this.canStart(15);
            AEProxySelectorFactory.getSelector();
            if (DEBUG_STARTUPTIME) {
                CoreImpl.logTime("Init1");
            }
            DiskManagerFactory.initialise(this);
            NetworkManager.getSingleton();
            if (DEBUG_STARTUPTIME) {
                CoreImpl.logTime("Init NetworkManager");
            }
            PeerManager.getSingleton();
            if (DEBUG_STARTUPTIME) {
                CoreImpl.logTime("Init PeerManager");
            }
            new ClientIDPlugin().initialize(this);
            this.pi = PluginInitializer.getSingleton(this);
            if (DEBUG_STARTUPTIME) {
                CoreImpl.logTime("Init PluginInitializer");
            }
            AEProxyFactory.initialise(this);
            BGSpongy.initialize(this);
            this.instance_manager = ClientInstanceManagerFactory.getSingleton(new ClientInstanceManagerAdapter(){

                @Override
                public String getID() {
                    return COConfigurationManager.getStringParameter("ID", "");
                }

                @Override
                public InetAddress getPublicAddress() {
                    return PluginInitializer.getDefaultInterface().getUtilities().getPublicAddress();
                }

                @Override
                public int[] getPorts() {
                    return new int[]{TCPNetworkManager.getSingleton().getDefaultTCPListeningPortNumber(), UDPNetworkManager.getSingleton().getUDPListeningPortNumber(), UDPNetworkManager.getSingleton().getUDPNonDataListeningPortNumber()};
                }

                @Override
                public ClientInstanceManagerAdapter.VCPublicAddress getVCPublicAddress() {
                    return new ClientInstanceManagerAdapter.VCPublicAddress(){
                        private final VersionCheckClient vcc = VersionCheckClient.getSingleton();

                        @Override
                        public String getAddress() {
                            return this.vcc.getExternalIpAddress(true, false);
                        }

                        @Override
                        public long getCacheTime() {
                            return VersionCheckClient.getSingleton().getCacheTime(false);
                        }
                    };
                }

                @Override
                public ClientInstanceTracked.TrackTarget track(byte[] hash) {
                    List<DownloadManager> dms = CoreImpl.this.getGlobalManager().getDownloadManagers();
                    Iterator<DownloadManager> it = dms.iterator();
                    DownloadManager matching_dm = null;
                    try {
                        while (it.hasNext()) {
                            DownloadManager dm = it.next();
                            TOTorrent torrent = dm.getTorrent();
                            if (torrent == null) continue;
                            byte[] sha1_hash = (byte[])dm.getUserData("AZInstanceManager::sha1_hash");
                            if (sha1_hash == null) {
                                sha1_hash = new SHA1Simple().calculateHash(torrent.getHash());
                                dm.setUserData("AZInstanceManager::sha1_hash", sha1_hash);
                            }
                            if (!Arrays.equals(hash, sha1_hash)) continue;
                            matching_dm = dm;
                            break;
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    if (matching_dm == null) {
                        return null;
                    }
                    if (!matching_dm.getDownloadState().isPeerSourceEnabled("Plugin")) {
                        return null;
                    }
                    int dm_state = matching_dm.getState();
                    if (dm_state == 100 || dm_state == 70) {
                        return null;
                    }
                    try {
                        final DownloadImpl target = DownloadManagerImpl.getDownloadStatic(matching_dm);
                        final boolean is_seed = matching_dm.isDownloadComplete(true);
                        return new ClientInstanceTracked.TrackTarget(){

                            @Override
                            public Object getTarget() {
                                return target;
                            }

                            @Override
                            public boolean isSeed() {
                                return is_seed;
                            }
                        };
                    }
                    catch (Throwable e) {
                        return null;
                    }
                }

                @Override
                public DHTPlugin getDHTPlugin() {
                    PluginInterface pi = CoreImpl.this.getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
                    if (pi != null) {
                        return (DHTPlugin)pi.getPlugin();
                    }
                    return null;
                }

                @Override
                public UPnPPlugin getUPnPPlugin() {
                    PluginInterface pi = CoreImpl.this.getPluginManager().getPluginInterfaceByClass(UPnPPlugin.class);
                    if (pi != null) {
                        return (UPnPPlugin)pi.getPlugin();
                    }
                    return null;
                }

                @Override
                public void addListener(final ClientInstanceManagerAdapter.StateListener listener) {
                    CoreImpl.this.addLifecycleListener(new CoreLifecycleAdapter(){

                        @Override
                        public void started(Core core) {
                            listener.started();
                        }

                        @Override
                        public void stopping(Core core) {
                            listener.stopped();
                        }
                    });
                }
            });
            if (DEBUG_STARTUPTIME) {
                CoreImpl.logTime("Init instance_manager");
            }
            if (COConfigurationManager.getBooleanParameter("speedmanager.enable", true)) {
                this.speed_manager = SpeedManagerFactory.createSpeedManager(this, new SpeedManagerAdapter(){
                    private static final int UPLOAD_SPEED_ADJUST_MIN_KB_SEC = 10;
                    private static final int DOWNLOAD_SPEED_ADJUST_MIN_KB_SEC = 300;
                    private boolean setting_limits;

                    @Override
                    public int getCurrentProtocolUploadSpeed(int average_period) {
                        if (CoreImpl.this.global_manager != null) {
                            GlobalManagerStats stats2 = CoreImpl.this.global_manager.getStats();
                            return stats2.getProtocolSendRateNoLAN(average_period);
                        }
                        return 0;
                    }

                    @Override
                    public int getCurrentDataUploadSpeed(int average_period) {
                        if (CoreImpl.this.global_manager != null) {
                            GlobalManagerStats stats2 = CoreImpl.this.global_manager.getStats();
                            return stats2.getDataSendRateNoLAN(average_period);
                        }
                        return 0;
                    }

                    @Override
                    public int getCurrentProtocolDownloadSpeed(int average_period) {
                        if (CoreImpl.this.global_manager != null) {
                            GlobalManagerStats stats2 = CoreImpl.this.global_manager.getStats();
                            return stats2.getProtocolReceiveRateNoLAN(average_period);
                        }
                        return 0;
                    }

                    @Override
                    public int getCurrentDataDownloadSpeed(int average_period) {
                        if (CoreImpl.this.global_manager != null) {
                            GlobalManagerStats stats2 = CoreImpl.this.global_manager.getStats();
                            return stats2.getDataReceiveRateNoLAN(average_period);
                        }
                        return 0;
                    }

                    @Override
                    public int getCurrentUploadLimit() {
                        String key = TransferSpeedValidator.getActiveUploadParameter(CoreImpl.this.global_manager);
                        int k_per_second = COConfigurationManager.getIntParameter(key);
                        int bytes_per_second = k_per_second == 0 ? Integer.MAX_VALUE : k_per_second * 1024;
                        return bytes_per_second;
                    }

                    @Override
                    public void setCurrentUploadLimit(int bytes_per_second) {
                        if (bytes_per_second != this.getCurrentUploadLimit()) {
                            String key = TransferSpeedValidator.getActiveUploadParameter(CoreImpl.this.global_manager);
                            int k_per_second = bytes_per_second == Integer.MAX_VALUE ? 0 : (bytes_per_second + 1023) / 1024;
                            if (k_per_second > 0) {
                                k_per_second = Math.max(k_per_second, 10);
                            }
                            COConfigurationManager.setParameter(key, k_per_second);
                        }
                    }

                    @Override
                    public int getCurrentDownloadLimit() {
                        return TransferSpeedValidator.getGlobalDownloadRateLimitBytesPerSecond();
                    }

                    @Override
                    public void setCurrentDownloadLimit(int bytes_per_second) {
                        if (bytes_per_second == Integer.MAX_VALUE) {
                            bytes_per_second = 0;
                        }
                        if (bytes_per_second > 0) {
                            bytes_per_second = Math.max(bytes_per_second, 307200);
                        }
                        TransferSpeedValidator.setGlobalDownloadRateLimitBytesPerSecond(bytes_per_second);
                    }

                    @Override
                    public Object getLimits() {
                        String up_key = TransferSpeedValidator.getActiveUploadParameter(CoreImpl.this.global_manager);
                        String down_key = TransferSpeedValidator.getDownloadParameter();
                        return new Object[]{up_key, new Integer(COConfigurationManager.getIntParameter(up_key)), down_key, new Integer(COConfigurationManager.getIntParameter(down_key))};
                    }

                    @Override
                    public void setLimits(Object limits, boolean do_up, boolean do_down) {
                        if (limits == null) {
                            return;
                        }
                        try {
                            if (this.setting_limits) {
                                return;
                            }
                            this.setting_limits = true;
                            Object[] bits = (Object[])limits;
                            if (do_up) {
                                COConfigurationManager.setParameter((String)bits[0], (Integer)bits[1]);
                            }
                            if (do_down) {
                                COConfigurationManager.setParameter((String)bits[2], (Integer)bits[3]);
                            }
                        }
                        finally {
                            this.setting_limits = false;
                        }
                    }
                });
                if (DEBUG_STARTUPTIME) {
                    CoreImpl.logTime("SpeedManager");
                }
            }
            this.nat_traverser = new NATTraverser(this);
            PeerNATTraverser.initialise(this);
            BackupManagerFactory.getManager(this);
            AEDiagnostics.postStartup(this);
            if (DEBUG_STARTUPTIME) {
                CoreImpl.logTime("BackupManagerFactory,NATTraverser");
            }
            SimpleTimer.addEvent("Core:gc", SystemTime.getOffsetTime(60000L), new TimerEventPerformer(){

                @Override
                public void perform(TimerEvent event2) {
                    System.gc();
                }
            });
        }
        catch (Throwable e) {
            Debug.out("Initialisation failed", e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private static void logTime(String s) {
        long diff = System.currentTimeMillis() - lastDebugTime;
        if (diff > 19L) {
            System.out.println("Core: " + diff + "ms] " + s);
        }
        lastDebugTime = System.currentTimeMillis();
    }

    @Override
    public long getCreateTime() {
        return this.create_time;
    }

    protected void announceAll(boolean force) {
        PluginInterface dht_tracker_pi;
        Logger.log(new LogEvent(LOGID, "Updating trackers"));
        GlobalManager gm = this.getGlobalManager();
        if (gm != null) {
            List<DownloadManager> downloads = gm.getDownloadManagers();
            long now = SystemTime.getCurrentTime();
            int i = 0;
            while (i < downloads.size()) {
                DownloadManager dm = downloads.get(i);
                Long last_announce_l = (Long)dm.getUserData(DM_ANNOUNCE_KEY);
                long last_announce = last_announce_l == null ? this.create_time : last_announce_l;
                TRTrackerAnnouncer an = dm.getTrackerClient();
                if (an != null) {
                    TRTrackerAnnouncerResponse last_announce_response = an.getLastResponse();
                    if (now - last_announce > 900000L || last_announce_response == null || last_announce_response.getStatus() == 0 || force) {
                        dm.setUserData(DM_ANNOUNCE_KEY, new Long(now));
                        Logger.log(new LogEvent(LOGID, "    updating tracker for " + dm.getDisplayName()));
                        dm.requestTrackerAnnounce(true);
                    }
                }
                ++i;
            }
        }
        if ((dht_tracker_pi = this.getPluginManager().getPluginInterfaceByClass(DHTTrackerPlugin.class)) != null) {
            ((DHTTrackerPlugin)dht_tracker_pi.getPlugin()).announceAll();
        }
    }

    @Override
    public LocaleUtil getLocaleUtil() {
        return LocaleUtil.getSingleton();
    }

    @Override
    public File getLockFile() {
        return FileUtil.newFile(SystemProperties.getUserPath(), ".azlock");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean canStart(int max_wait_secs) {
        if (System.getProperty(SystemProperties.SYSPROP_INSTANCE_LOCK_DISABLE, "0").equals("1")) {
            return true;
        }
        CoreImpl coreImpl = this;
        synchronized (coreImpl) {
            if (this.file_lock != null) {
                return true;
            }
            File lock_file = this.getLockFile();
            try {
                RandomAccessFile raf = new RandomAccessFile(lock_file, "rw");
                FileChannel channel2 = raf.getChannel();
                int i = 0;
                while (i < max_wait_secs) {
                    this.file_lock = channel2.tryLock();
                    if (this.file_lock != null) {
                        return true;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    ++i;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        }
    }

    @Override
    public void start() throws CoreException {
        CoreRunningListener[] runningListeners;
        String sDelayCore;
        if (!this.canStart(15)) {
            throw new CoreException("Core: already started (alternative process)");
        }
        AEThread2.setOurThread();
        try {
            this.this_mon.enter();
            if (this.started) {
                throw new CoreException("Core: already started");
            }
            if (this.stopped) {
                throw new CoreException("Core: already stopped");
            }
            this.started = true;
        }
        finally {
            this.this_mon.exit();
        }
        if ("1".equals(System.getProperty(SystemProperties.SYSPROP_SAFEMODE))) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Safe mode enabled"));
            }
            Constants.isSafeMode = true;
            System.setProperty(SystemProperties.SYSPROP_LOADPLUGINS, "0");
            System.setProperty(SystemProperties.SYSPROP_DISABLEDOWNLOADS, "1");
            System.setProperty(SystemProperties.SYSPROP_SKIP_SWTCHECK, "1");
            Logger.log(new LogAlert(false, 1, "You are running " + Constants.APP_NAME + " in safe mode - you " + "can change your configuration, but any downloads added will " + "not be remembered when you close " + Constants.APP_NAME + "."));
        }
        if ((sDelayCore = System.getProperty("delay.core", null)) != null) {
            try {
                long delayCore = Long.parseLong(sDelayCore);
                Thread.sleep(delayCore);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        AEThread2 pluginload = new AEThread2("PluginLoader", true){

            @Override
            public void run() {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Loading of Plugins starts"));
                }
                CoreImpl.this.pi.loadPlugins(CoreImpl.this, false, !"0".equals(System.getProperty(SystemProperties.SYSPROP_LOADPLUGINS)), true, true);
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Loading of Plugins complete"));
                }
            }
        };
        pluginload.run();
        this.global_manager = GlobalManagerFactory.create(this, null);
        if (this.stopped) {
            System.err.println("Core stopped while starting");
            return;
        }
        if (this.stopped) {
            System.err.println("Core stopped while starting");
            return;
        }
        VuzeFileHandler.getSingleton().addProcessor(new VuzeFileProcessor(){

            @Override
            public void process(VuzeFile[] files, int expected_types) {
                int i = 0;
                while (i < files.length) {
                    VuzeFile vf = files[i];
                    VuzeFileComponent[] comps = vf.getComponents();
                    int j = 0;
                    while (j < comps.length) {
                        VuzeFileComponent comp2 = comps[j];
                        int comp_type = comp2.getType();
                        if (comp_type == 2048) {
                            PluginInterface default_pi = CoreImpl.this.getPluginManager().getDefaultPluginInterface();
                            Map map = comp2.getContent();
                            try {
                                Torrent torrent;
                                String url = MapUtils.getMapString(map, "torrent_url", null);
                                if (url != null) {
                                    TorrentDownloader dl = default_pi.getTorrentManager().getURLDownloader(new URL(url));
                                    torrent = dl.download();
                                } else {
                                    String tf = MapUtils.getMapString(map, "torrent_file", null);
                                    if (tf != null) {
                                        File file = FileUtil.newFile(tf, new String[0]);
                                        if (!file.canRead() || file.isDirectory()) {
                                            throw new Exception("torrent_file '" + tf + "' is invalid");
                                        }
                                        torrent = default_pi.getTorrentManager().createFromBEncodedFile(file);
                                    } else {
                                        throw new Exception("torrent_url or torrent_file must be specified");
                                    }
                                }
                                File dest = null;
                                String save_folder = MapUtils.getMapString(map, "save_folder", null);
                                if (save_folder != null) {
                                    dest = FileUtil.newFile(save_folder, torrent.getName());
                                } else {
                                    String save_file = MapUtils.getMapString(map, "save_file", null);
                                    if (save_file != null) {
                                        dest = FileUtil.newFile(save_file, new String[0]);
                                    }
                                }
                                if (dest != null) {
                                    dest.getParentFile().mkdirs();
                                }
                                default_pi.getDownloadManager().addDownload(torrent, null, dest);
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                            comp2.setProcessed();
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        });
        this.triggerLifeCycleComponentCreated(this.global_manager);
        this.pi.initialisePlugins();
        if (this.stopped) {
            System.err.println("Core stopped while starting");
            return;
        }
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "Initializing Plugins complete"));
        }
        try {
            PluginInterface dht_pi = this.getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
            if (dht_pi != null) {
                dht_pi.addEventListener(new PluginEventListener(){
                    private boolean first_dht = true;

                    @Override
                    public void handleEvent(PluginEvent ev) {
                        if (ev.getType() == 1024 && this.first_dht) {
                            this.first_dht = false;
                            DHT dht = (DHT)ev.getValue();
                            dht.addListener(new DHTListener(){

                                @Override
                                public void speedTesterAvailable(DHTSpeedTester tester) {
                                    if ((this).CoreImpl.this.speed_manager != null) {
                                        (this).CoreImpl.this.speed_manager.setSpeedTester(tester);
                                    }
                                }
                            });
                            CoreImpl.this.global_manager.addListener(new GlobalManagerAdapter(){

                                @Override
                                public void seedingStatusChanged(boolean seeding_only_mode, boolean b) {
                                    this.checkConfig();
                                }
                            });
                            COConfigurationManager.addAndFireParameterListeners(new String[]{"Auto Upload Speed Enabled", "Auto Upload Speed Seeding Enabled"}, new ParameterListener(){

                                @Override
                                public void parameterChanged(String parameterName) {
                                    this.checkConfig();
                                }
                            });
                        }
                    }

                    protected void checkConfig() {
                        if (CoreImpl.this.speed_manager != null) {
                            CoreImpl.this.speed_manager.setEnabled(TransferSpeedValidator.isAutoSpeedActive(CoreImpl.this.global_manager));
                        }
                    }
                });
            }
        }
        catch (Throwable dht_pi) {
            // empty catch block
        }
        if (COConfigurationManager.getBooleanParameter("Resume Downloads On Start")) {
            this.global_manager.resumeDownloads();
        }
        VersionCheckClient.getSingleton().initialise();
        this.instance_manager.initialize();
        NetworkManager.getSingleton().initialize(this);
        SpeedLimitHandler.getSingleton(this);
        Runtime.getRuntime().addShutdownHook(new AEThread("Shutdown Hook"){

            @Override
            public void runSupport() {
                Logger.log(new LogEvent(LOGID, "Shutdown hook triggered"));
                CoreImpl.this.stop();
            }
        });
        DelayedTask delayed_task = UtilitiesImpl.addDelayedTask("Core", new Runnable(){

            @Override
            public void run() {
                new AEThread2("core:delayTask", true){

                    @Override
                    public void run() {
                        AEDiagnostics.checkDumpsAndNatives();
                        COConfigurationManager.setParameter("diags.enable.pending.writes", true);
                        AEDiagnostics.flushPendingLogs();
                        NetworkAdmin na = NetworkAdmin.getSingleton();
                        na.runInitialChecks(CoreImpl.this);
                        na.addPropertyChangeListener(new NetworkAdminPropertyChangeListener(){
                            private String last_as;

                            @Override
                            public void propertyChanged(String property) {
                                NetworkAdmin na = NetworkAdmin.getSingleton();
                                if (property.equals("Network Interfaces")) {
                                    boolean found_usable = false;
                                    NetworkAdminNetworkInterface[] intf = na.getInterfaces();
                                    int i = 0;
                                    while (i < intf.length) {
                                        NetworkAdminNetworkInterfaceAddress[] addresses = intf[i].getAddresses();
                                        int j = 0;
                                        while (j < addresses.length) {
                                            if (!addresses[j].isLoopback()) {
                                                found_usable = true;
                                            }
                                            ++j;
                                        }
                                        ++i;
                                    }
                                    if (!found_usable) {
                                        return;
                                    }
                                    Logger.log(new LogEvent(LOGID, "Network interfaces have changed (new=" + na.getNetworkInterfacesAsString() + ")"));
                                    CoreImpl.this.announceAll(false);
                                } else if (property.equals("AS")) {
                                    String as = na.getCurrentASN().getAS();
                                    if (this.last_as == null) {
                                        this.last_as = as;
                                    } else if (!as.equals(this.last_as)) {
                                        Logger.log(new LogEvent(LOGID, "AS has changed (new=" + as + ")"));
                                        this.last_as = as;
                                        CoreImpl.this.announceAll(false);
                                    }
                                }
                            }
                        });
                        CoreImpl.this.setupSleepAndCloseActions();
                    }
                }.start();
            }
        });
        delayed_task.queue();
        if (this.stopped) {
            System.err.println("Core stopped while starting");
            return;
        }
        PairingManagerFactory.getSingleton();
        mon_coreRunningListeners.enter();
        try {
            if (coreRunningListeners == null) {
                runningListeners = new CoreRunningListener[]{};
            } else {
                runningListeners = coreRunningListeners.toArray(new CoreRunningListener[0]);
                coreRunningListeners = null;
            }
        }
        finally {
            mon_coreRunningListeners.exit();
        }
        new AEThread2("Plugin Init Complete", false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            public void run() {
                try {
                    PlatformManagerFactory.getPlatformManager().startup(CoreImpl.this);
                }
                catch (Throwable e) {
                    Debug.out("PlatformManager: init failed", e);
                }
                var2_3 = CoreImpl.access$0(CoreImpl.this);
                synchronized (var2_3) {
                    it = CoreImpl.access$0(CoreImpl.this).iterator();
                    CoreImpl.access$1(CoreImpl.this, true);
                    // MONITOREXIT @DISABLED, blocks:[1, 4] lbl11 : MonitorExitStatement: MONITOREXIT : var2_3
                    if (true) ** GOTO lbl23
                }
                do {
                    try {
                        listener = (CoreLifecycleListener)it.next();
                        if (listener.requiresPluginInitCompleteBeforeStartedEvent()) continue;
                        listener.started(CoreImpl.this);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
lbl23:
                    // 4 sources

                } while (it.hasNext());
                CoreImpl.this.pi.initialisationComplete();
                it = CoreImpl.access$0(CoreImpl.this).iterator();
                while (it.hasNext()) {
                    try {
                        listener = (CoreLifecycleListener)it.next();
                        if (!listener.requiresPluginInitCompleteBeforeStartedEvent()) continue;
                        listener.started(CoreImpl.this);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        }.start();
        ThreadPool tp2 = new ThreadPool("Trigger CoreRunning Listeners", 3);
        CoreRunningListener[] coreRunningListenerArray = runningListeners;
        int n = runningListeners.length;
        int n2 = 0;
        while (n2 < n) {
            final CoreRunningListener l = coreRunningListenerArray[n2];
            try {
                tp2.run(new AERunnable(){

                    @Override
                    public void runSupport() {
                        l.coreRunning(CoreImpl.this);
                    }
                });
            }
            catch (Throwable t) {
                Debug.out(t);
            }
            ++n2;
        }
    }

    @Override
    public boolean isInitThread() {
        return AEThread2.isOurThread(Thread.currentThread());
    }

    @Override
    public boolean isStarted() {
        mon_coreRunningListeners.enter();
        try {
            boolean bl = this.started && coreRunningListeners == null;
            return bl;
        }
        finally {
            mon_coreRunningListeners.exit();
        }
    }

    @Override
    public void triggerLifeCycleComponentCreated(CoreComponent component) {
        Iterator<CoreLifecycleListener> it = this.lifecycle_listeners.iterator();
        while (it.hasNext()) {
            try {
                it.next().componentCreated(this, component);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    private void runNonDaemon(final Runnable r) throws CoreException {
        if (!Thread.currentThread().isDaemon()) {
            r.run();
        } else {
            final AESemaphore sem = new AESemaphore("Core:runNonDaemon");
            final Throwable[] error = new Throwable[1];
            new AEThread2("Core:runNonDaemon", false){

                @Override
                public void run() {
                    try {
                        try {
                            r.run();
                        }
                        catch (Throwable e) {
                            error[0] = e;
                            sem.release();
                        }
                    }
                    finally {
                        sem.release();
                    }
                }
            }.start();
            sem.reserve();
            if (error[0] != null) {
                if (error[0] instanceof CoreException) {
                    throw (CoreException)error[0];
                }
                throw new CoreException("Operation failed", error[0]);
            }
        }
    }

    @Override
    public void stop() throws CoreException {
        this.stop(new CoreOperationTask.ProgressCallbackAdapter());
    }

    @Override
    public void stop(final CoreOperationTask.ProgressCallback callback) throws CoreException {
        this.runNonDaemon(new AERunnable(){

            @Override
            public void runSupport() {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Stop operation starts"));
                }
                CoreImpl.this.stopSupport(false, true, callback);
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    void stopSupport(final boolean for_restart, final boolean apply_updates, final CoreOperationTask.ProgressCallback callback) throws CoreException {
        Logger.setClosing();
        AEDiagnostics.flushPendingLogs();
        wait_and_return = false;
        try {
            this.this_mon.enter();
            if (this.stopped) {
                COConfigurationManager.save();
                wait_and_return = true;
            } else {
                this.stopped = true;
                if (!this.started) {
                    Logger.log(new LogEvent(CoreImpl.LOGID, "Core not started"));
                    if (AEDiagnostics.isDirty()) {
                        AEDiagnostics.markClean();
                    }
                    this.stopping_sem.releaseForever();
                    return;
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
        if (wait_and_return) {
            Logger.log(new LogEvent(CoreImpl.LOGID, "Waiting for stop to complete"));
            this.stopping_sem.reserve();
            return;
        }
        stall_mins = Math.max(2, COConfigurationManager.getIntParameter("Force Terminate After Mins"));
        stall_millis = stall_mins * 60 * 1000;
        last_progress = new AtomicLong(SystemTime.getMonotonousTime());
        SimpleTimer.addEvent("ShutFail", SystemTime.getOffsetTime(60000L), new TimerEventPerformer(){
            boolean die_die_die;

            @Override
            public void perform(TimerEvent event2) {
                if (System.getProperty(SystemProperties.SYSPROP_LOGGING_DISABLE_STOP_ON_SLOW_CLOSE, "0").equals("0")) {
                    Logger.setClosingTakingTooLong();
                }
                while (SystemTime.getMonotonousTime() - last_progress.get() < stall_millis) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                AEDiagnostics.dumpThreads();
                if (this.die_die_die) {
                    Debug.out("Shutdown blocked, force exiting");
                    CoreImpl.this.stopping_sem.releaseForever();
                    if (for_restart) {
                        ClientRestarterFactory.create(CoreImpl.this).restart(false);
                    } else if (apply_updates && CoreImpl.this.getPluginManager().getDefaultPluginInterface().getUpdateManager().getInstallers().length > 0) {
                        ClientRestarterFactory.create(CoreImpl.this).restart(true);
                    }
                    if (CoreImpl.this.ca_shutdown_computer_after_stop) {
                        if (apply_updates) {
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        try {
                            PlatformManagerFactory.getPlatformManager().shutdown(1);
                        }
                        catch (Throwable e) {
                            Debug.out("PlatformManager: shutdown failed", e);
                        }
                    }
                    SESecurityManager.exitVM(0);
                }
                this.die_die_die = true;
                SimpleTimer.addEvent("ShutFail", SystemTime.getOffsetTime(30000L), this);
            }
        });
        sync_listeners = new ArrayList<CoreLifecycleListener>();
        async_listeners = new ArrayList<CoreLifecycleListener>();
        for (CoreLifecycleListener l : this.lifecycle_listeners) {
            if (l.syncInvokeRequired()) {
                sync_listeners.add(l);
                continue;
            }
            async_listeners.add(l);
        }
        progress = 125;
        callback.setSubTaskName(MessageText.getString("label.starting.closedown"));
        callback.setProgress(progress);
        try {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(CoreImpl.LOGID, "Invoking synchronous 'stopping' listeners"));
            }
            i = 0;
            while (i < sync_listeners.size()) {
                try {
                    ((CoreLifecycleListener)sync_listeners.get(i)).stopping(this);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                last_progress.set(SystemTime.getMonotonousTime());
                ++i;
            }
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(CoreImpl.LOGID, "Invoking asynchronous 'stopping' listeners"));
            }
            ListenerManager.dispatchWithTimeout(async_listeners, new ListenerManagerDispatcher(){

                public void dispatch(Object listener, int type, Object value) {
                    ((CoreLifecycleListener)listener).stopping(CoreImpl.this);
                    last_progress.set(SystemTime.getMonotonousTime());
                }
            }, 10000L);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(CoreImpl.LOGID, "Waiting for quiescence pre gm stop"));
            }
            NonDaemonTaskRunner.waitUntilIdle();
            last_progress.set(SystemTime.getMonotonousTime());
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(CoreImpl.LOGID, "Stopping global manager"));
            }
            progress = 250;
            callback.setSubTaskName(MessageText.getString("label.stopping.downloads"));
            callback.setProgress(progress);
            if (this.global_manager != null) {
                p_start = 250;
                p_end = 699;
                this.global_manager.stopGlobalManager(new GlobalMangerProgressListener(){

                    @Override
                    public void reportPercent(int percent) {
                        callback.setProgress(p_start + (p_end - p_start) * percent / 100);
                        last_progress.set(SystemTime.getMonotonousTime());
                    }

                    @Override
                    public void reportCurrentTask(String currentTask) {
                        callback.setSubTaskName(currentTask);
                        last_progress.set(SystemTime.getMonotonousTime());
                    }
                });
            }
            last_progress.set(SystemTime.getMonotonousTime());
            at = AllTrackersManager.getAllTrackers();
            progress = 750;
            wait_secs = COConfigurationManager.getIntParameter("Tracker Client Closedown Timeout");
            callback.setSubTaskName(MessageText.getString("label.waiting.tracker.updates", new String[]{String.valueOf(wait_secs)}));
            callback.setProgress(progress);
            active_req = at.getActiveRequestCount();
            announce_stats = at.getAnnounceStats();
            scheduled_req = announce_stats.getPrivateScheduledCount() + announce_stats.getPublicScheduledCount();
            total_req = active_req + scheduled_req;
            if (total_req > 0) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(CoreImpl.LOGID, "Waiting for tracker updates, " + active_req + "/" + scheduled_req + " outstanding"));
                }
                at_start = SystemTime.getMonotonousTime();
                current_req = total_req;
                p_start = 750;
                p_end = 899;
                ** if (wait_secs <= 0) goto lbl108
                while (SystemTime.getMonotonousTime() - at_start <= (long)(wait_secs * 1000)) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Throwable var24_35) {
                        // empty catch block
                    }
                    latest_active = at.getActiveRequestCount();
                    announce_stats = at.getAnnounceStats();
                    latest_scheduled = announce_stats.getPrivateScheduledCount() + announce_stats.getPublicScheduledCount();
                    latest_req = latest_active + latest_scheduled;
                    if (latest_req == 0) break;
                    if (latest_req >= current_req) continue;
                    current_req = latest_req;
                    percent = (total_req - current_req) * 100 / total_req;
                    callback.setProgress(p_start + (p_end - p_start) * percent / 100);
                    last_progress.set(SystemTime.getMonotonousTime());
lbl-1000:
                    // 2 sources

                    {
                    }
                }
            }
lbl108:
            // 5 sources

            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(CoreImpl.LOGID, "Invoking synchronous 'stopped' listeners"));
            }
            progress = 900;
            callback.setSubTaskName(MessageText.getString("label.finalising.closedown"));
            callback.setProgress(progress);
            i = 0;
            while (i < sync_listeners.size()) {
                try {
                    ((CoreLifecycleListener)sync_listeners.get(i)).stopped(this);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                last_progress.set(SystemTime.getMonotonousTime());
                ++i;
            }
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(CoreImpl.LOGID, "Invoking asynchronous 'stopped' listeners"));
            }
            ListenerManager.dispatchWithTimeout(async_listeners, new ListenerManagerDispatcher(){

                public void dispatch(Object listener, int type, Object value) {
                    ((CoreLifecycleListener)listener).stopped(CoreImpl.this);
                    last_progress.set(SystemTime.getMonotonousTime());
                }
            }, 10000L);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(CoreImpl.LOGID, "Waiting for quiescence post gm stop"));
            }
            NonDaemonTaskRunner.waitUntilIdle();
            last_progress.set(SystemTime.getMonotonousTime());
            AEDiagnostics.markClean();
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(CoreImpl.LOGID, "Stop operation completes"));
            }
            if (apply_updates && this.getPluginManager().getDefaultPluginInterface().getUpdateManager().getInstallers().length > 0) {
                ClientRestarterFactory.create(this).restart(true);
            }
            if (System.getProperty("skip.shutdown.nondeamon.check", "0").equals("1")) {
                return;
            }
            try {
                c = Class.forName("sun.awt.AWTAutoShutdown");
                if (c != null) {
                    c.getMethod("notifyToolkitThreadFree", new Class[0]).invoke(null, new Object[0]);
                }
            }
            catch (Throwable c) {
                // empty catch block
            }
            if (this.ca_shutdown_computer_after_stop) {
                if (apply_updates) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (Throwable c) {
                        // empty catch block
                    }
                }
                try {
                    PlatformManagerFactory.getPlatformManager().shutdown(1);
                }
                catch (Throwable e) {
                    Debug.out("PlatformManager: shutdown failed", e);
                }
            }
            try {
                tg = Thread.currentThread().getThreadGroup();
                while (tg.getParent() != null) {
                    tg = tg.getParent();
                }
                threads = new Thread[tg.activeCount() + 1024];
                tg.enumerate(threads, true);
                bad_found = false;
                i = 0;
                while (i < threads.length) {
                    t = threads[i];
                    if (t != null && t.isAlive() && t != Thread.currentThread() && !t.isDaemon() && !AEThread2.isOurThread(t)) {
                        bad_found = true;
                        break;
                    }
                    ++i;
                }
                if (bad_found) {
                    new AEThread2("VMKiller", true){

                        @Override
                        public void run() {
                            try {
                                int loops = 0;
                                while (true) {
                                    ThreadGroup tg = Thread.currentThread().getThreadGroup();
                                    Thread[] threads = new Thread[tg.activeCount() + 1024];
                                    tg.enumerate(threads, true);
                                    ArrayList<String> bad = new ArrayList<String>();
                                    String bad_found = "";
                                    int i = 0;
                                    while (i < threads.length) {
                                        Thread t = threads[i];
                                        if (t != null && t.isAlive() && !t.isDaemon() && !AEThread2.isOurThread(t)) {
                                            String details = t.getName();
                                            bad.add(details);
                                            StackTraceElement[] trace = t.getStackTrace();
                                            if (trace.length > 0) {
                                                details = String.valueOf(details) + "[";
                                                int j = 0;
                                                while (j < trace.length) {
                                                    details = String.valueOf(details) + (j == 0 ? "" : ",") + trace[j];
                                                    ++j;
                                                }
                                                details = String.valueOf(details) + "]";
                                            }
                                            bad_found = String.valueOf(bad_found) + (bad_found.length() == 0 ? "" : ", ") + details;
                                        }
                                        ++i;
                                    }
                                    if (bad.size() == 1 && ((String)bad.get(0)).equals("Launcher::bootstrap")) {
                                        Debug.outNoStack("Only non-daemon bootstrap thread remaining, exiting...");
                                        SESecurityManager.exitVM(0);
                                        break;
                                    }
                                    if (loops == 10) {
                                        Debug.out("Non-daemon thread(s) found: '" + bad_found + "' - force closing VM");
                                        SESecurityManager.exitVM(0);
                                        break;
                                    }
                                    Thread.sleep(1000L);
                                    ++loops;
                                }
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                    }.start();
                }
            }
            catch (Throwable var19_29) {}
        }
        finally {
            this.stopping_sem.releaseForever();
        }
    }

    @Override
    public void requestStop() throws CoreException {
        if (this.stopped) {
            return;
        }
        this.runNonDaemon(new AERunnable(){

            @Override
            public void runSupport() {
                boolean in_progress = false;
                for (CoreLifecycleListener l : CoreImpl.this.lifecycle_listeners) {
                    if (l.stopRequested(CoreImpl.this)) {
                        in_progress = true;
                        continue;
                    }
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, 1, "Request to stop the core has been denied"));
                    }
                    return;
                }
                if (!in_progress) {
                    CoreImpl.this.stop();
                }
            }
        });
    }

    @Override
    public void restart() throws CoreException {
        this.restart(new CoreOperationTask.ProgressCallbackAdapter());
    }

    @Override
    public void restart(final CoreOperationTask.ProgressCallback callback) throws CoreException {
        this.runNonDaemon(new AERunnable(){

            @Override
            public void runSupport() {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Restart operation starts"));
                }
                CoreImpl.this.checkRestartSupported();
                CoreImpl.this.restarting = true;
                CoreImpl.this.stopSupport(true, false, callback);
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Restart operation: stop complete,restart initiated"));
                }
                ClientRestarterFactory.create(CoreImpl.this).restart(false);
            }
        });
    }

    @Override
    public void requestRestart() throws CoreException {
        if (this.stopped) {
            return;
        }
        this.runNonDaemon(new AERunnable(){

            @Override
            public void runSupport() {
                CoreImpl.this.checkRestartSupported();
                boolean in_progress = false;
                for (CoreLifecycleListener l : CoreImpl.this.lifecycle_listeners) {
                    if (l.restartRequested(CoreImpl.this)) {
                        in_progress = true;
                        continue;
                    }
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, 1, "Request to restart the core has been denied"));
                    }
                    return;
                }
                if (!in_progress) {
                    CoreImpl.this.restart();
                }
            }
        });
    }

    @Override
    public boolean isStopping() {
        return this.stopped;
    }

    @Override
    public boolean isRestarting() {
        return this.restarting;
    }

    @Override
    public void checkRestartSupported() throws CoreException {
        if (this.getPluginManager().getPluginInterfaceByClass("com.biglybt.update.UpdaterPatcher") == null) {
            Logger.log(new LogAlert(true, 3, "Can't restart without the 'azupdater' plugin installed"));
            throw new CoreException("Can't restart without the 'azupdater' plugin installed");
        }
    }

    @Override
    public void saveState() {
        GlobalManager gm = this.global_manager;
        if (gm != null) {
            gm.saveState();
        }
        COConfigurationManager.save();
    }

    @Override
    public GlobalManager getGlobalManager() throws CoreException {
        if (this.global_manager == null) {
            throw new CoreException("Core not running");
        }
        return this.global_manager;
    }

    @Override
    public TRHost getTrackerHost() throws CoreException {
        return TRHostFactory.getSingleton();
    }

    @Override
    public PluginManagerDefaults getPluginManagerDefaults() throws CoreException {
        return PluginManager.getDefaults();
    }

    @Override
    public PluginManager getPluginManager() throws CoreException {
        return PluginInitializer.getDefaultInterface().getPluginManager();
    }

    @Override
    public IpFilterManager getIpFilterManager() throws CoreException {
        return IpFilterManagerFactory.getSingleton();
    }

    @Override
    public ClientInstanceManager getInstanceManager() {
        return this.instance_manager;
    }

    @Override
    public SpeedManager getSpeedManager() {
        return this.speed_manager;
    }

    @Override
    public CryptoManager getCryptoManager() {
        return this.crypto_manager;
    }

    @Override
    public NATTraverser getNATTraverser() {
        return this.nat_traverser;
    }

    void setupSleepAndCloseActions() {
        if (PlatformManagerFactory.getPlatformManager().hasCapability(PlatformManagerCapabilities.PreventComputerSleep)) {
            COConfigurationManager.addAndFireParameterListeners(new String[]{"Prevent Sleep Downloading", "Prevent Sleep FP Seeding", "Prevent Sleep Tag"}, new ParameterListener(){
                private TimerEventPeriodic timer_event;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void parameterChanged(String parameterName) {
                    22 var2_2 = this;
                    synchronized (var2_2) {
                        String tag;
                        boolean active;
                        boolean dl = COConfigurationManager.getBooleanParameter("Prevent Sleep Downloading");
                        boolean se = COConfigurationManager.getBooleanParameter("Prevent Sleep FP Seeding");
                        boolean bl = active = dl || se;
                        if (!active && !(tag = COConfigurationManager.getStringParameter("Prevent Sleep Tag")).trim().isEmpty()) {
                            active = true;
                        }
                        try {
                            CoreImpl.this.setPreventComputerSleep(PlatformManagerFactory.getPlatformManager(), active, "config change");
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                        if (!active) {
                            if (this.timer_event != null) {
                                this.timer_event.cancel();
                                this.timer_event = null;
                            }
                        } else if (this.timer_event == null) {
                            this.timer_event = SimpleTimer.addPeriodicEvent("core:sleepAct", 120000L, new TimerEventPerformer(){

                                @Override
                                public void perform(TimerEvent event2) {
                                    if (!(this).CoreImpl.this.stopped) {
                                        CoreImpl.this.checkSleepActions();
                                    }
                                }
                            });
                        }
                    }
                }
            });
        }
        COConfigurationManager.addAndFireParameterListeners(new String[]{"On Downloading Complete Do", "On Seeding Complete Do", "Auto Restart When Idle"}, new ParameterListener(){
            private TimerEventPeriodic timer_event;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void parameterChanged(String parameterName) {
                String dl_act = COConfigurationManager.getStringParameter("On Downloading Complete Do");
                String se_act = COConfigurationManager.getStringParameter("On Seeding Complete Do");
                int restart_after = COConfigurationManager.getIntParameter("Auto Restart When Idle");
                23 var5_5 = this;
                synchronized (var5_5) {
                    boolean dl_nothing = dl_act.equals("Nothing");
                    boolean se_nothing = se_act.equals("Nothing");
                    if (dl_nothing) {
                        CoreImpl.this.ca_last_time_downloading = -1L;
                    }
                    if (se_nothing) {
                        CoreImpl.this.ca_last_time_seeding = -1L;
                    }
                    if (dl_nothing && se_nothing && restart_after == 0) {
                        if (this.timer_event != null) {
                            this.timer_event.cancel();
                            this.timer_event = null;
                        }
                    } else {
                        if (this.timer_event == null) {
                            this.timer_event = SimpleTimer.addPeriodicEvent("core:closeAct", 30000L, new TimerEventPerformer(){

                                @Override
                                public void perform(TimerEvent event2) {
                                    if (!(this).CoreImpl.this.stopped && !CoreImpl.this.checkRestartAction()) {
                                        CoreImpl.this.checkCloseActions();
                                    }
                                }
                            });
                        }
                        CoreImpl.this.checkCloseActions();
                    }
                }
            }
        });
    }

    protected void checkSleepActions() {
        boolean ps_downloading = COConfigurationManager.getBooleanParameter("Prevent Sleep Downloading");
        boolean ps_fp_seed = COConfigurationManager.getBooleanParameter("Prevent Sleep FP Seeding");
        String tag_name = COConfigurationManager.getStringParameter("Prevent Sleep Tag");
        Tag ps_tag = null;
        if (!(tag_name = tag_name.trim()).isEmpty()) {
            ps_tag = TagManagerFactory.getTagManager().getTagType(3).getTag(tag_name, true);
        }
        String declining_subsystems = "";
        for (PowerManagementListener l : this.power_listeners) {
            try {
                if (l.requestPowerStateChange(1, null)) continue;
                declining_subsystems = String.valueOf(declining_subsystems) + (declining_subsystems.length() == 0 ? "" : ",") + l.getPowerName();
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        PlatformManager platform = PlatformManagerFactory.getPlatformManager();
        if (declining_subsystems.length() == 0 && !ps_downloading && !ps_fp_seed && ps_tag == null) {
            if (platform.getPreventComputerSleep()) {
                this.setPreventComputerSleep(platform, false, "configuration change");
            }
            return;
        }
        boolean prevent_sleep = false;
        String prevent_reason = null;
        if (declining_subsystems.length() > 0) {
            prevent_sleep = true;
            prevent_reason = "subsystems declined sleep: " + declining_subsystems;
        } else if (ps_tag != null && ps_tag.getTaggedCount() > 0) {
            prevent_sleep = true;
            prevent_reason = "tag '" + tag_name + "' has entries";
        } else {
            List<DownloadManager> managers = this.getGlobalManager().getDownloadManagers();
            for (DownloadManager manager : managers) {
                PEPeerManager pm;
                int state = manager.getState();
                if (state == 55 || manager.getDownloadState().getFlag(512L)) {
                    if (!ps_downloading) continue;
                    prevent_sleep = true;
                    prevent_reason = "active downloads";
                    break;
                }
                if (state == 50 && (pm = manager.getPeerManager()) != null) {
                    if (pm.hasDownloadablePiece()) {
                        if (ps_downloading) {
                            prevent_sleep = true;
                            prevent_reason = "active downloads";
                            break;
                        }
                    } else {
                        state = 60;
                    }
                }
                if (state != 60 || !ps_fp_seed) continue;
                DiskManager disk_manager = manager.getDiskManager();
                if (disk_manager != null && disk_manager.getCompleteRecheckStatus() != -1) {
                    if (!ps_downloading) continue;
                    prevent_sleep = true;
                    prevent_reason = "active downloads";
                    break;
                }
                try {
                    DefaultRankCalculator calc = StartStopRulesDefaultPlugin.getRankCalculator(PluginCoreUtils.wrap(manager));
                    if (!calc.getCachedIsFP()) continue;
                    prevent_sleep = true;
                    prevent_reason = "first-priority seeding";
                    break;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (prevent_sleep != platform.getPreventComputerSleep()) {
            if (prevent_sleep) {
                this.prevent_sleep_remove_trigger = false;
            } else if (!this.prevent_sleep_remove_trigger) {
                this.prevent_sleep_remove_trigger = true;
                return;
            }
            if (prevent_reason == null) {
                prevent_reason = ps_downloading && ps_fp_seed ? "no active downloads or first-priority seeding" : (ps_downloading ? "no active downloads" : "no active first-priority seeding");
            }
            this.setPreventComputerSleep(platform, prevent_sleep, prevent_reason);
        }
    }

    void setPreventComputerSleep(PlatformManager platform, boolean prevent_sleep, String prevent_reason) {
        for (PowerManagementListener l : this.power_listeners) {
            try {
                l.informPowerStateChange(1, new Object[]{prevent_sleep, prevent_reason});
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        Logger.log(new LogEvent(LOGID, "Computer sleep prevented state changed to '" + prevent_sleep + "' due to " + prevent_reason));
        try {
            platform.setPreventComputerSleep(prevent_sleep);
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    protected boolean checkRestartAction() {
        if (this.ra_restarting) {
            return true;
        }
        int restart_after = COConfigurationManager.getIntParameter("Auto Restart When Idle");
        if (restart_after > 0) {
            List<DownloadManager> managers = this.getGlobalManager().getDownloadManagers();
            boolean active = false;
            for (DownloadManager manager : managers) {
                int state = manager.getState();
                if (state != 50 && state != 60) continue;
                active = true;
                break;
            }
            if (active) {
                GlobalManagerStats stats2 = this.global_manager.getStats();
                long totals = stats2.getTotalDataBytesReceived() + stats2.getTotalDataBytesSent();
                long now = SystemTime.getMonotonousTime();
                if (totals == this.ra_last_total_data) {
                    if (now - this.ra_last_data_time >= (long)(60000 * restart_after)) {
                        UIFunctions ui_functions;
                        this.ra_restarting = true;
                        String message = MessageText.getString("core.restart.alert", new String[]{String.valueOf(restart_after)});
                        if (COConfigurationManager.getBooleanParameter("Auto Restart When Idle Prompt") && (ui_functions = UIFunctionsManager.getUIFunctions()) != null) {
                            ui_functions.forceNotify(0, null, message, null, new Object[0], -1);
                        }
                        Logger.log(new LogAlert(false, 0, message));
                        new DelayedEvent("CoreRestart", 10000L, new AERunnable(){

                            @Override
                            public void runSupport() {
                                CoreImpl.this.requestRestart();
                            }
                        });
                        return true;
                    }
                } else {
                    this.ra_last_total_data = totals;
                    this.ra_last_data_time = now;
                }
            } else {
                this.ra_last_total_data = -1L;
            }
        } else {
            this.ra_last_total_data = -1L;
        }
        return false;
    }

    protected void checkCloseActions() {
        String se_act;
        List<DownloadManager> managers = this.getGlobalManager().getDownloadManagers();
        boolean is_downloading = false;
        boolean is_seeding = false;
        for (DownloadManager manager : managers) {
            if (manager.isPaused()) {
                return;
            }
            if (manager.getDownloadState().getFlag(512L)) {
                return;
            }
            if (manager.getDownloadState().getFlag(16L)) continue;
            int state = manager.getState();
            if (state == 55) {
                is_downloading = true;
                continue;
            }
            if (state == 50) {
                PEPeerManager pm = manager.getPeerManager();
                if (pm != null) {
                    if (pm.hasDownloadablePiece()) {
                        is_downloading = true;
                    } else {
                        state = 60;
                    }
                }
            } else if (!manager.isDownloadComplete(false) && state != 70 && state != 100) {
                is_downloading = true;
            }
            if (state != 60) continue;
            DiskManager disk_manager = manager.getDiskManager();
            if (disk_manager != null && disk_manager.getCompleteRecheckStatus() != -1) {
                is_downloading = true;
                continue;
            }
            is_seeding = true;
        }
        long now = SystemTime.getMonotonousTime();
        if (is_downloading) {
            this.ca_last_time_downloading = now;
            this.ca_last_time_seeding = -1L;
        } else if (is_seeding) {
            this.ca_last_time_seeding = now;
        }
        String dl_act = COConfigurationManager.getStringParameter("On Downloading Complete Do");
        if (!dl_act.equals("Nothing") && this.ca_last_time_downloading >= 0L && !is_downloading && now - this.ca_last_time_downloading >= 30000L) {
            this.executeInternalCloseAction(true, true, dl_act, null);
        }
        if (!(se_act = COConfigurationManager.getStringParameter("On Seeding Complete Do")).equals("Nothing") && this.ca_last_time_seeding >= 0L && !is_seeding && now - this.ca_last_time_seeding >= 30000L) {
            this.executeInternalCloseAction(true, false, se_act, null);
        }
    }

    @Override
    public void executeCloseAction(String action, String reason) {
        this.executeInternalCloseAction(false, false, action, reason);
    }

    private void executeInternalCloseAction(boolean obey_reset, boolean download_trigger, String action, String reason) {
        UIManager ui_manager;
        this.ca_last_time_downloading = -1L;
        this.ca_last_time_seeding = -1L;
        String type_str = reason == null ? MessageText.getString(download_trigger ? "core.shutdown.dl" : "core.shutdown.se") : reason;
        String action_str = MessageText.getString("ConfigView.label.stop." + action);
        String message = MessageText.getString("core.shutdown.alert", new String[]{action_str, type_str});
        UIFunctions ui_functions = UIFunctionsManager.getUIFunctions();
        if (ui_functions != null) {
            ui_functions.forceNotify(0, null, message, null, new Object[0], -1);
        }
        Logger.log(new LogAlert(false, 0, message));
        if (COConfigurationManager.getBooleanParameter("Prompt To Abort Shutdown") && (ui_manager = StaticUtilities.getUIManager(30000L)) != null) {
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("auto-close-ms", 30000);
            if (ui_manager.showMessageBox("core.shutdown.prompt.title", "core.shutdown.prompt.msg", 66L, options) == 2L) {
                return;
            }
        }
        this.executeCloseActionSupport(obey_reset, download_trigger, action, reason);
    }

    private void executeCloseActionSupport(boolean obey_reset, final boolean download_trigger, final String action, String reason) {
        boolean reset;
        this.ca_last_time_downloading = -1L;
        this.ca_last_time_seeding = -1L;
        boolean bl = reset = obey_reset && COConfigurationManager.getBooleanParameter("Stop Triggers Auto Reset");
        if (reset) {
            if (download_trigger) {
                COConfigurationManager.setParameter("On Downloading Complete Do", "Nothing");
            } else {
                COConfigurationManager.setParameter("On Seeding Complete Do", "Nothing");
            }
        }
        new DelayedEvent("CoreShutdown", 10000L, new AERunnable(){

            @Override
            public void runSupport() {
                Logger.log(new LogEvent(LOGID, "Executing close action '" + action + "' due to " + (download_trigger ? "downloading" : "seeding") + " completion"));
                if (action.equals("QuitVuze")) {
                    CoreImpl.this.requestStop();
                } else if (action.equals("Sleep") || action.equals("Hibernate")) {
                    CoreImpl.this.announceAll(true);
                    try {
                        PlatformManagerFactory.getPlatformManager().shutdown(action.equals("Sleep") ? 4 : 2);
                    }
                    catch (Throwable e) {
                        Debug.out("PlatformManager: shutdown failed", e);
                    }
                } else if (action.equals("Shutdown")) {
                    CoreImpl.this.ca_shutdown_computer_after_stop = true;
                    CoreImpl.this.requestStop();
                } else if (action.startsWith("RunScript")) {
                    String script = download_trigger ? COConfigurationManager.getStringParameter("On Downloading Complete Script", "") : COConfigurationManager.getStringParameter("On Seeding Complete Script", "");
                    CoreImpl.this.executeScript(script, action, download_trigger);
                } else {
                    Debug.out("Unknown close action '" + action + "'");
                }
            }
        });
    }

    void executeScript(String script, String action, boolean download_trigger) {
        String script_type = "";
        if (script.length() >= 10 && script.substring(0, 10).toLowerCase(Locale.US).startsWith("javascript")) {
            int p1 = script.indexOf(40);
            int p2 = script.lastIndexOf(41);
            if (p1 != -1 && p2 != -1) {
                if ((script = script.substring(p1 + 1, p2).trim()).startsWith("\"") && script.endsWith("\"")) {
                    script = script.substring(1, script.length() - 1);
                }
                script = script.replaceAll("\\\\\"", "\"");
                script_type = "javascript";
            }
        }
        File script_file = null;
        if (script_type == "" && !(script_file = FileUtil.newFile(script.trim(), new String[0])).isFile()) {
            Logger.log(new LogEvent(LOGID, "Script failed to run - '" + script_file + "' isn't a valid script file"));
            Debug.out("Invalid script: " + script_file);
            return;
        }
        try {
            boolean close_vuze = action.equals("RunScriptAndClose");
            if (!close_vuze) {
                this.announceAll(true);
            }
            if (script_file != null) {
                this.getPluginManager().getDefaultPluginInterface().getUtilities().createProcess(script_file.getAbsolutePath());
            } else {
                boolean provider_found = false;
                List<ScriptProvider> providers = CoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface().getUtilities().getScriptProviders();
                for (ScriptProvider p : providers) {
                    if (p.getScriptType() != script_type) continue;
                    provider_found = true;
                    HashMap<String, Object> bindings = new HashMap<String, Object>();
                    String intent = "shutdown(\"" + action + "\")";
                    bindings.put("intent", intent);
                    bindings.put("is_downloading_complete", download_trigger);
                    p.eval(script, bindings);
                }
                if (!provider_found && !this.js_plugin_install_tried) {
                    this.js_plugin_install_tried = true;
                    PluginUtils.installJavaScriptPlugin();
                }
            }
            if (close_vuze) {
                this.requestStop();
            }
        }
        catch (Throwable e) {
            Logger.log(new LogAlert(true, 3, "Script failed to run - '" + script + "'", e));
            Debug.out("Invalid script: " + script, e);
        }
    }

    @Override
    public void executeOperation(final int type, final CoreOperationTask task2) {
        CoreOperation op = new CoreOperation(){

            @Override
            public int getOperationType() {
                return type;
            }

            @Override
            public CoreOperationTask getTask() {
                return task2;
            }
        };
        boolean run_it = true;
        try {
            this.addOperation(op);
            for (CoreOperationListener l : this.operation_listeners) {
                if (!l.operationExecuteRequest(op)) continue;
                run_it = false;
                break;
            }
            if (run_it) {
                task2.run(op);
            }
        }
        finally {
            if (run_it) {
                this.removeOperation(op);
            }
        }
    }

    @Override
    public void addOperation(CoreOperation op) {
        this.operations.add(op);
        for (CoreOperationListener l : this.operation_listeners) {
            try {
                l.operationAdded(op);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    @Override
    public void removeOperation(CoreOperation op) {
        if (this.operations.remove(op)) {
            for (CoreOperationListener l : this.operation_listeners) {
                try {
                    l.operationRemoved(op);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
    }

    @Override
    public List<CoreOperation> getOperations() {
        return this.operations.getList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLifecycleListener(CoreLifecycleListener l) {
        boolean lls;
        CopyOnWriteList<CoreLifecycleListener> copyOnWriteList = this.lifecycle_listeners;
        synchronized (copyOnWriteList) {
            this.lifecycle_listeners.add(l);
            lls = this.ll_started;
        }
        if (this.global_manager != null) {
            l.componentCreated(this, this.global_manager);
        }
        if (lls) {
            l.started(this);
        }
    }

    @Override
    public void removeLifecycleListener(CoreLifecycleListener l) {
        this.lifecycle_listeners.remove(l);
    }

    @Override
    public void addOperationListener(CoreOperationListener l) {
        this.operation_listeners.add(l);
    }

    @Override
    public void removeOperationListener(CoreOperationListener l) {
        this.operation_listeners.remove(l);
    }

    public static void addCoreRunningListener(CoreRunningListener l) {
        mon_coreRunningListeners.enter();
        try {
            if (coreRunningListeners != null) {
                coreRunningListeners.add(l);
                return;
            }
        }
        finally {
            mon_coreRunningListeners.exit();
        }
        l.coreRunning(CoreImpl.getSingleton());
    }

    @Override
    public void addPowerManagementListener(PowerManagementListener listener) {
        this.power_listeners.add(listener);
    }

    @Override
    public void removePowerManagementListener(PowerManagementListener listener) {
        this.power_listeners.remove(listener);
    }

    static /* synthetic */ void access$1(CoreImpl coreImpl, boolean bl) {
        coreImpl.ll_started = bl;
    }
}

