/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.global.impl;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.dht.DHT;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerPeerListener;
import com.biglybt.core.global.GlobalManagerAdapter;
import com.biglybt.core.global.GlobalManagerStats;
import com.biglybt.core.global.impl.GlobalManagerImpl;
import com.biglybt.core.networkmanager.admin.NetworkAdmin;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerListener;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.PEPeerStats;
import com.biglybt.core.peer.util.PeerUtils;
import com.biglybt.core.peermanager.piecepicker.util.BitFlags;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AddressUtils;
import com.biglybt.core.util.AsyncDispatcher;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.GeneralUtils;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.average.Average;
import com.biglybt.core.util.average.AverageFactory;
import com.biglybt.pif.PluginInterface;
import com.biglybt.plugin.dht.DHTPlugin;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class GlobalManagerStatsImpl
implements GlobalManagerStats,
SimpleTimer.TimerTickReceiver {
    private final GlobalManagerImpl manager;
    private long smooth_last_sent;
    private long smooth_last_received;
    private int current_smoothing_window = GeneralUtils.getSmoothUpdateWindow();
    private int current_smoothing_interval = GeneralUtils.getSmoothUpdateInterval();
    private GeneralUtils.SmoothAverage smoothed_receive_rate = GeneralUtils.getSmoothAverage();
    private GeneralUtils.SmoothAverage smoothed_send_rate = GeneralUtils.getSmoothAverage();
    private long total_data_bytes_received;
    private long total_protocol_bytes_received;
    private long totalDiscarded;
    private long total_data_bytes_sent;
    private long total_protocol_bytes_sent;
    private int data_send_speed_at_close;
    private final com.biglybt.core.util.Average data_receive_speed = com.biglybt.core.util.Average.getInstance(1000, 10);
    private final com.biglybt.core.util.Average protocol_receive_speed = com.biglybt.core.util.Average.getInstance(1000, 10);
    private final com.biglybt.core.util.Average data_receive_speed_no_lan = com.biglybt.core.util.Average.getInstance(1000, 10);
    private final com.biglybt.core.util.Average protocol_receive_speed_no_lan = com.biglybt.core.util.Average.getInstance(1000, 10);
    private final com.biglybt.core.util.Average data_send_speed = com.biglybt.core.util.Average.getInstance(1000, 10);
    private final com.biglybt.core.util.Average protocol_send_speed = com.biglybt.core.util.Average.getInstance(1000, 10);
    private final com.biglybt.core.util.Average data_send_speed_no_lan = com.biglybt.core.util.Average.getInstance(1000, 10);
    private final com.biglybt.core.util.Average protocol_send_speed_no_lan = com.biglybt.core.util.Average.getInstance(1000, 10);
    private static final Object PEER_DATA_INIT_KEY = new Object();
    private static final Object PEER_DATA_KEY = new Object();
    private static final Object PEER_DATA_FINAL_KEY = new Object();
    private static final Object DOWNLOAD_DATA_KEY = new Object();
    private Map<DownloadManager, List<PEPeer>> removed_peers = new IdentityHashMap<DownloadManager, List<PEPeer>>();
    private Map<String, GlobalManagerStats.CountryDetails> country_details = new ConcurrentHashMap<String, GlobalManagerStats.CountryDetails>();
    private CountryDetailsImpl country_total = new CountryDetailsImpl("");
    private AtomicInteger country_details_seq = new AtomicInteger();
    private String country_my_cc = "";
    private AsyncDispatcher stats_dispatcher;
    private ConcurrentHashMap<InetAddress, GlobalManagerStats.RemoteStats> pending_stats;
    private static final long STATS_HISTORY_MAX_AGE = 1800000L;
    private static final long STATS_HISTORY_MAX_SAMPLES = 1000L;
    private static final long MAX_ALLOWED_BYTES_PER_MIN = 0xF00000000L;
    private Map<String, Map<String, long[]>> aggregate_stats;
    private int sequence;
    private long total_received_overall;
    private long total_sent_overall;
    private volatile AggregateStatsImpl as_remote_latest;
    private DHT dht_biglybt;
    private LinkedList<HistoryEntry> stats_history;
    private Set<InetAddress> stats_history_addresses;
    private AggregateStatsWrapper as_remote_wrapper;
    private AggregateStatsWrapper as_local_wrapper;

    protected GlobalManagerStatsImpl() {
        this.country_details.put(this.country_total.cc, this.country_total);
        this.stats_dispatcher = new AsyncDispatcher("GMStats", 1000);
        this.pending_stats = new ConcurrentHashMap();
        this.aggregate_stats = new ConcurrentHashMap<String, Map<String, long[]>>();
        this.as_remote_latest = new AggregateStatsImpl(this.sequence++);
        this.stats_history = new LinkedList();
        this.stats_history_addresses = new HashSet<InetAddress>();
        this.as_remote_wrapper = new AggregateStatsWrapper(false);
        this.as_local_wrapper = new AggregateStatsWrapper(true);
        this.manager = null;
    }

    protected GlobalManagerStatsImpl(GlobalManagerImpl _manager) {
        this.country_details.put(this.country_total.cc, this.country_total);
        this.stats_dispatcher = new AsyncDispatcher("GMStats", 1000);
        this.pending_stats = new ConcurrentHashMap();
        this.aggregate_stats = new ConcurrentHashMap<String, Map<String, long[]>>();
        this.as_remote_latest = new AggregateStatsImpl(this.sequence++);
        this.stats_history = new LinkedList();
        this.stats_history_addresses = new HashSet<InetAddress>();
        this.as_remote_wrapper = new AggregateStatsWrapper(false);
        this.as_local_wrapper = new AggregateStatsWrapper(true);
        this.manager = _manager;
        this.load();
        this.manager.addListener(new GlobalManagerAdapter(){

            @Override
            public void downloadManagerAdded(final DownloadManager dm) {
                dm.setUserData(DOWNLOAD_DATA_KEY, new AggregateStatsDownloadWrapper());
                dm.addPeerListener(new DownloadManagerPeerListener(){

                    @Override
                    public void peerAdded(PEPeer peer) {
                        if (peer.getPeerState() == 30) {
                            this.saveInitialStats(peer);
                        } else {
                            peer.addListener(new PEPeerListener(){

                                @Override
                                public void stateChanged(PEPeer peer, int new_state) {
                                    if (new_state == 30) {
                                        this.saveInitialStats(peer);
                                        peer.removeListener(this);
                                    }
                                }

                                @Override
                                public void sentBadChunk(PEPeer peer, int piece_num, int total_bad_chunks) {
                                }

                                @Override
                                public void removeAvailability(PEPeer peer, BitFlags peerHavePieces) {
                                }

                                @Override
                                public void addAvailability(PEPeer peer, BitFlags peerHavePieces) {
                                }
                            });
                        }
                    }

                    private void saveInitialStats(PEPeer peer) {
                        long recv;
                        PEPeerStats stats2 = peer.getStats();
                        long sent = stats2.getTotalDataBytesSent();
                        if (sent + (recv = stats2.getTotalDataBytesReceived()) > 0L) {
                            peer.setUserData(PEER_DATA_INIT_KEY, new long[]{sent, recv});
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void peerRemoved(PEPeer peer) {
                        long recv;
                        PEPeerStats stats2 = peer.getStats();
                        long sent = stats2.getTotalDataBytesSent();
                        if (sent + (recv = stats2.getTotalDataBytesReceived()) > 0L) {
                            peer.setUserData(PEER_DATA_FINAL_KEY, new long[]{sent, recv});
                            Object object = PEER_DATA_KEY;
                            synchronized (object) {
                                LinkedList<PEPeer> peers = (LinkedList<PEPeer>)GlobalManagerStatsImpl.this.removed_peers.get(dm);
                                if (peers == null) {
                                    peers = new LinkedList<PEPeer>();
                                    GlobalManagerStatsImpl.this.removed_peers.put(dm, peers);
                                }
                                peers.add(peer);
                            }
                        }
                    }

                    @Override
                    public void peerManagerWillBeAdded(PEPeerManager manager) {
                    }

                    @Override
                    public void peerManagerRemoved(PEPeerManager manager) {
                    }

                    @Override
                    public void peerManagerAdded(PEPeerManager manager) {
                    }
                });
            }
        }, true);
        SimpleTimer.addTickReceiver(this);
    }

    protected void load() {
        this.data_send_speed_at_close = COConfigurationManager.getIntParameter("globalmanager.stats.send.speed.at.close", 0);
    }

    protected void save() {
        COConfigurationManager.setParameter("globalmanager.stats.send.speed.at.close", this.getDataSendRate());
    }

    @Override
    public int getDataSendRateAtClose() {
        return this.data_send_speed_at_close;
    }

    @Override
    public void discarded(int length) {
        this.totalDiscarded += (long)length;
    }

    @Override
    public void dataBytesReceived(int length, boolean LAN) {
        this.total_data_bytes_received += (long)length;
        if (!LAN) {
            this.data_receive_speed_no_lan.addValue(length);
        }
        this.data_receive_speed.addValue(length);
    }

    @Override
    public void protocolBytesReceived(int length, boolean LAN) {
        this.total_protocol_bytes_received += (long)length;
        if (!LAN) {
            this.protocol_receive_speed_no_lan.addValue(length);
        }
        this.protocol_receive_speed.addValue(length);
    }

    @Override
    public void dataBytesSent(int length, boolean LAN) {
        this.total_data_bytes_sent += (long)length;
        if (!LAN) {
            this.data_send_speed_no_lan.addValue(length);
        }
        this.data_send_speed.addValue(length);
    }

    @Override
    public void protocolBytesSent(int length, boolean LAN) {
        this.total_protocol_bytes_sent += (long)length;
        if (!LAN) {
            this.protocol_send_speed_no_lan.addValue(length);
        }
        this.protocol_send_speed.addValue(length);
    }

    @Override
    public int getDataReceiveRate() {
        return (int)this.data_receive_speed.getAverage();
    }

    @Override
    public int getDataReceiveRateNoLAN() {
        return (int)this.data_receive_speed_no_lan.getAverage();
    }

    @Override
    public int getDataReceiveRateNoLAN(int average_period) {
        return (int)(average_period <= 0 ? this.data_receive_speed_no_lan.getAverage() : this.data_receive_speed_no_lan.getAverage(average_period));
    }

    @Override
    public int getProtocolReceiveRate() {
        return (int)this.protocol_receive_speed.getAverage();
    }

    @Override
    public int getProtocolReceiveRateNoLAN() {
        return (int)this.protocol_receive_speed_no_lan.getAverage();
    }

    @Override
    public int getProtocolReceiveRateNoLAN(int average_period) {
        return (int)(average_period <= 0 ? this.protocol_receive_speed_no_lan.getAverage() : this.protocol_receive_speed_no_lan.getAverage(average_period));
    }

    @Override
    public int getDataAndProtocolReceiveRate() {
        return (int)(this.protocol_receive_speed.getAverage() + this.data_receive_speed.getAverage());
    }

    @Override
    public int getDataSendRate() {
        return (int)this.data_send_speed.getAverage();
    }

    @Override
    public int getDataSendRateNoLAN() {
        return (int)this.data_send_speed_no_lan.getAverage();
    }

    @Override
    public int getDataSendRateNoLAN(int average_period) {
        return (int)(average_period <= 0 ? this.data_send_speed_no_lan.getAverage() : this.data_send_speed_no_lan.getAverage(average_period));
    }

    @Override
    public int getProtocolSendRate() {
        return (int)this.protocol_send_speed.getAverage();
    }

    @Override
    public int getProtocolSendRateNoLAN() {
        return (int)this.protocol_send_speed_no_lan.getAverage();
    }

    @Override
    public int getProtocolSendRateNoLAN(int average_period) {
        return (int)(average_period <= 0 ? this.protocol_send_speed_no_lan.getAverage() : this.protocol_send_speed_no_lan.getAverage(average_period));
    }

    @Override
    public int getDataAndProtocolSendRate() {
        return (int)(this.protocol_send_speed.getAverage() + this.data_send_speed.getAverage());
    }

    @Override
    public long getTotalDataBytesSent() {
        return this.total_data_bytes_sent;
    }

    @Override
    public long getTotalProtocolBytesSent() {
        return this.total_protocol_bytes_sent;
    }

    @Override
    public long getTotalDataBytesReceived() {
        return this.total_data_bytes_received;
    }

    @Override
    public long getTotalProtocolBytesReceived() {
        return this.total_protocol_bytes_received;
    }

    public long getTotalDiscardedRaw() {
        return this.totalDiscarded;
    }

    @Override
    public long getTotalSwarmsPeerRate(boolean downloading, boolean seeding) {
        return this.manager.getTotalSwarmsPeerRate(downloading, seeding);
    }

    @Override
    public long getSmoothedSendRate() {
        return this.smoothed_send_rate.getAverage();
    }

    @Override
    public long getSmoothedReceiveRate() {
        return this.smoothed_receive_rate.getAverage();
    }

    @Override
    public Iterator<GlobalManagerStats.CountryDetails> getCountryDetails() {
        return this.country_details.values().iterator();
    }

    @Override
    public void tick(long mono_now, int tick_count) {
        if (tick_count % this.current_smoothing_interval == 0) {
            int current_window = GeneralUtils.getSmoothUpdateWindow();
            if (this.current_smoothing_window != current_window) {
                this.current_smoothing_window = current_window;
                this.current_smoothing_interval = GeneralUtils.getSmoothUpdateInterval();
                this.smoothed_receive_rate = GeneralUtils.getSmoothAverage();
                this.smoothed_send_rate = GeneralUtils.getSmoothAverage();
            }
            long up = this.total_data_bytes_sent + this.total_protocol_bytes_sent;
            long down = this.total_data_bytes_received + this.total_protocol_bytes_received;
            this.smoothed_send_rate.addValue(up - this.smooth_last_sent);
            this.smoothed_receive_rate.addValue(down - this.smooth_last_received);
            this.smooth_last_sent = up;
            this.smooth_last_received = down;
        }
        if (tick_count % 60 == 0) {
            this.stats_dispatcher.dispatch(new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void runSupport() {
                    List peers;
                    AggregateStatsDownloadWrapper as;
                    try {
                        InetAddress ia = NetworkAdmin.getSingleton().getDefaultPublicAddress();
                        String[] dets = PeerUtils.getCountryDetails(ia);
                        if (dets != null && dets.length > 0) {
                            GlobalManagerStatsImpl.this.country_my_cc = dets[0];
                        }
                    }
                    catch (Throwable ia) {
                        // empty catch block
                    }
                    List<DownloadManager> all_dms = GlobalManagerStatsImpl.this.manager.getDownloadManagers();
                    ArrayList<AggregateStatsDownloadWrapper> dms_list = new ArrayList<AggregateStatsDownloadWrapper>(all_dms.size() * 2);
                    ArrayList<List> peer_lists = new ArrayList<List>(all_dms.size() * 2);
                    Object object = PEER_DATA_KEY;
                    synchronized (object) {
                        if (!GlobalManagerStatsImpl.this.removed_peers.isEmpty()) {
                            for (Map.Entry entry : GlobalManagerStatsImpl.this.removed_peers.entrySet()) {
                                as = (AggregateStatsDownloadWrapper)((DownloadManager)entry.getKey()).getUserData(DOWNLOAD_DATA_KEY);
                                dms_list.add(as);
                                peer_lists.add((List)entry.getValue());
                            }
                            GlobalManagerStatsImpl.this.removed_peers.clear();
                        }
                    }
                    ArrayList<AggregateStatsDownloadWrapper> dms_complete = new ArrayList<AggregateStatsDownloadWrapper>(all_dms.size());
                    for (DownloadManager dm : all_dms) {
                        PEPeerManager pm;
                        as = (AggregateStatsDownloadWrapper)dm.getUserData(DOWNLOAD_DATA_KEY);
                        if (as != null) {
                            dms_complete.add(as);
                        }
                        if ((pm = dm.getPeerManager()) == null || (peers = pm.getPeers()).isEmpty()) continue;
                        dms_list.add(as);
                        peer_lists.add(peers);
                    }
                    HashSet<CountryDetailsImpl> updated = new HashSet<CountryDetailsImpl>();
                    HashMap<String, long[]> updates = new HashMap<String, long[]>();
                    int i = 0;
                    while (i < dms_list.size()) {
                        AggregateStatsDownloadWrapper dms = (AggregateStatsDownloadWrapper)dms_list.get(i);
                        peers = (List)peer_lists.get(i);
                        for (PEPeer peer : peers) {
                            long diff_recv;
                            long diff_sent;
                            long[] final_data;
                            long recv;
                            PEPeerStats stats2;
                            long sent;
                            int peer_state = peer.getPeerState();
                            if (peer_state != 30 && peer_state != 40 && peer_state != 50 || peer.isLANLocal() && !AddressUtils.isExplicitLANRateLimitAddress(peer.getIp()) || (sent = (stats2 = peer.getStats()).getTotalDataBytesSent()) + (recv = stats2.getTotalDataBytesReceived()) <= 0L) continue;
                            PeerDetails details = (PeerDetails)peer.getUserData(PEER_DATA_KEY);
                            if (details == null) {
                                String[] dets = PeerUtils.getCountryDetails(peer);
                                details = new PeerDetails(dets == null || dets.length < 1 ? "??" : dets[0]);
                                long[] init_data = (long[])peer.getUserData(PEER_DATA_INIT_KEY);
                                if (init_data != null) {
                                    details.sent = init_data[0];
                                    details.recv = init_data[1];
                                }
                                peer.setUserData(PEER_DATA_KEY, details);
                            }
                            if ((final_data = (long[])peer.getUserData(PEER_DATA_FINAL_KEY)) != null) {
                                sent = final_data[0];
                                recv = final_data[1];
                            }
                            if ((diff_sent = sent - details.sent) + (diff_recv = recv - details.recv) > 0L) {
                                String cc = details.cc;
                                long[] totals = (long[])updates.get(cc);
                                if (totals == null) {
                                    totals = new long[]{diff_sent, diff_recv};
                                    updates.put(cc, totals);
                                } else {
                                    totals[0] = totals[0] + diff_sent;
                                    totals[1] = totals[1] + diff_recv;
                                }
                                if (dms != null) {
                                    totals = (long[])dms.updates.get(cc);
                                    if (totals == null) {
                                        totals = new long[]{diff_sent, diff_recv};
                                        dms.updates.put(cc, totals);
                                    } else {
                                        totals[0] = totals[0] + diff_sent;
                                        totals[1] = totals[1] + diff_recv;
                                    }
                                }
                            }
                            details.sent = sent;
                            details.recv = recv;
                        }
                        ++i;
                    }
                    for (AggregateStatsDownloadWrapper dms : dms_complete) {
                        dms.updateComplete();
                    }
                    long total_diff_sent = 0L;
                    long total_diff_recv = 0L;
                    for (Map.Entry entry : updates.entrySet()) {
                        String cc = (String)entry.getKey();
                        long[] totals = (long[])entry.getValue();
                        long diff_sent = totals[0];
                        long diff_recv = totals[1];
                        CountryDetailsImpl cd = (CountryDetailsImpl)GlobalManagerStatsImpl.this.country_details.get(cc);
                        if (cd == null) {
                            cd = new CountryDetailsImpl(cc);
                            GlobalManagerStatsImpl.this.country_details.put(cc, cd);
                        }
                        updated.add(cd);
                        if (diff_sent > 0L) {
                            cd.last_sent = diff_sent;
                            cd.total_sent += diff_sent;
                            cd.sent_average.update(diff_sent);
                            total_diff_sent += diff_sent;
                        } else {
                            cd.last_sent = 0L;
                            cd.sent_average.update(diff_sent);
                        }
                        if (diff_recv > 0L) {
                            cd.last_recv = diff_recv;
                            cd.total_recv += diff_recv;
                            cd.recv_average.update(diff_recv);
                            total_diff_recv += diff_recv;
                            continue;
                        }
                        cd.last_recv = 0L;
                        cd.recv_average.update(diff_recv);
                    }
                    updated.add(GlobalManagerStatsImpl.this.country_total);
                    if (total_diff_sent > 0L) {
                        ((GlobalManagerStatsImpl)GlobalManagerStatsImpl.this).country_total.last_sent = total_diff_sent;
                        ((GlobalManagerStatsImpl)GlobalManagerStatsImpl.this).country_total.total_sent += total_diff_sent;
                        ((GlobalManagerStatsImpl)GlobalManagerStatsImpl.this).country_total.sent_average.update(total_diff_sent);
                    } else {
                        ((GlobalManagerStatsImpl)GlobalManagerStatsImpl.this).country_total.last_sent = 0L;
                        ((GlobalManagerStatsImpl)GlobalManagerStatsImpl.this).country_total.sent_average.update(0.0);
                    }
                    if (total_diff_recv > 0L) {
                        ((GlobalManagerStatsImpl)GlobalManagerStatsImpl.this).country_total.last_recv = total_diff_recv;
                        ((GlobalManagerStatsImpl)GlobalManagerStatsImpl.this).country_total.total_recv += total_diff_recv;
                        ((GlobalManagerStatsImpl)GlobalManagerStatsImpl.this).country_total.recv_average.update(total_diff_recv);
                    } else {
                        ((GlobalManagerStatsImpl)GlobalManagerStatsImpl.this).country_total.last_recv = 0L;
                        ((GlobalManagerStatsImpl)GlobalManagerStatsImpl.this).country_total.recv_average.update(0.0);
                    }
                    for (GlobalManagerStats.CountryDetails cd : GlobalManagerStatsImpl.this.country_details.values()) {
                        if (updated.contains(cd)) continue;
                        CountryDetailsImpl cdi = (CountryDetailsImpl)cd;
                        cdi.last_recv = 0L;
                        cdi.last_sent = 0L;
                        cdi.recv_average.update(0.0);
                        cdi.sent_average.update(0.0);
                    }
                    GlobalManagerStatsImpl.this.country_details_seq.incrementAndGet();
                }
            });
        }
        if (tick_count % 10 == 0) {
            this.stats_dispatcher.dispatch(new AERunnable(){

                @Override
                public void runSupport() {
                    Iterator it = GlobalManagerStatsImpl.this.pending_stats.values().iterator();
                    while (it.hasNext()) {
                        GlobalManagerStats.RemoteStats stats2 = (GlobalManagerStats.RemoteStats)it.next();
                        it.remove();
                        GlobalManagerStatsImpl.this.addRemoteStats(stats2);
                    }
                }
            });
        }
    }

    @Override
    public void receiveRemoteStats(GlobalManagerStats.RemoteStats stats2) {
        this.pending_stats.put(stats2.getRemoteAddress(), stats2);
    }

    private void addRemoteStats(GlobalManagerStats.RemoteStats stats2) {
        GlobalManagerStats.RemoteCountryStats[] rcs = stats2.getStats();
        if (rcs.length == 0) {
            return;
        }
        InetAddress address = stats2.getRemoteAddress();
        if (this.stats_history_addresses.contains(address)) {
            return;
        }
        String[] o_details = PeerUtils.getCountryDetails(address);
        String originator_cc = o_details == null || o_details.length < 1 ? "??" : o_details[0];
        Map<String, long[]> map = this.aggregate_stats.get(originator_cc);
        boolean added = false;
        GlobalManagerStats.RemoteCountryStats[] remoteCountryStatsArray = rcs;
        int n = rcs.length;
        int n2 = 0;
        while (n2 < n) {
            GlobalManagerStats.RemoteCountryStats rc = remoteCountryStatsArray[n2];
            String cc = rc.getCC();
            long recv = rc.getAverageReceivedBytes();
            long sent = rc.getAverageSentBytes();
            if (recv < 0L || recv > 0xF00000000L) {
                recv = 0L;
            }
            if (sent < 0L || sent > 0xF00000000L) {
                sent = 0L;
            }
            if (sent + recv > 0L) {
                long[] val;
                if (cc.isEmpty()) {
                    this.total_received_overall += recv;
                    this.total_sent_overall += sent;
                }
                if (map == null) {
                    map = new ConcurrentHashMap<String, long[]>();
                    this.aggregate_stats.put(originator_cc, map);
                }
                if ((val = map.get(cc)) == null) {
                    map.put(cc, new long[]{recv, sent});
                } else {
                    val[0] = val[0] + recv;
                    val[1] = val[1] + sent;
                }
                added = true;
            }
            ++n2;
        }
        if (added) {
            HistoryEntry entry = new HistoryEntry(originator_cc, stats2);
            this.stats_history.addLast(entry);
            this.stats_history_addresses.add(address);
        }
        boolean things_are_borked = false;
        ArrayList<HistoryEntry> to_remove = new ArrayList<HistoryEntry>();
        long now = SystemTime.getMonotonousTime();
        Iterator it = this.stats_history.iterator();
        while (it.hasNext()) {
            HistoryEntry entry = (HistoryEntry)it.next();
            if ((long)this.stats_history.size() <= 1000L && now - entry.time <= 1800000L) break;
            it.remove();
            this.stats_history_addresses.remove(entry.address);
            to_remove.add(entry);
        }
        for (HistoryEntry entry : to_remove) {
            String originator_cc2 = entry.cc;
            Map<String, long[]> map2 = this.aggregate_stats.get(originator_cc2);
            if (map2 == null) {
                things_are_borked = true;
                Debug.out("inconsistent");
                break;
            }
            GlobalManagerStats.RemoteCountryStats[] remoteCountryStatsArray2 = entry.stats;
            int n3 = entry.stats.length;
            int n4 = 0;
            while (n4 < n3) {
                GlobalManagerStats.RemoteCountryStats rc = remoteCountryStatsArray2[n4];
                String cc = rc.getCC();
                long recv = rc.getAverageReceivedBytes();
                long sent = rc.getAverageSentBytes();
                if (recv < 0L || recv > 0xF00000000L) {
                    recv = 0L;
                }
                if (sent < 0L || sent > 0xF00000000L) {
                    sent = 0L;
                }
                if (recv + sent > 0L) {
                    long[] val = map2.get(cc);
                    if (val == null) {
                        things_are_borked = true;
                        Debug.out("inconsistent");
                    } else {
                        long new_recv = val[0] - recv;
                        long new_sent = val[1] - sent;
                        if (new_recv < 0L || new_sent < 0L) {
                            things_are_borked = true;
                            Debug.out("inconsistent");
                        } else {
                            if (cc.isEmpty()) {
                                this.total_received_overall -= recv;
                                this.total_sent_overall -= sent;
                            }
                            if (new_recv + new_sent == 0L) {
                                map2.remove(cc);
                            } else {
                                val[0] = new_recv;
                                val[1] = new_sent;
                            }
                        }
                    }
                }
                ++n4;
            }
            if (!map2.isEmpty()) continue;
            this.aggregate_stats.remove(originator_cc2);
        }
        if (things_are_borked) {
            this.stats_history.clear();
            this.stats_history_addresses.clear();
            this.aggregate_stats.clear();
            this.total_received_overall = 0L;
            this.total_sent_overall = 0L;
        }
        if (this.dht_biglybt == null) {
            try {
                PluginInterface dht_pi = CoreFactory.getSingleton().getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
                if (dht_pi != null) {
                    this.dht_biglybt = ((DHTPlugin)dht_pi.getPlugin()).getDHT(4);
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        this.as_remote_latest = new AggregateStatsImpl(this.stats_history.size(), this.dht_biglybt == null ? 0 : (int)this.dht_biglybt.getControl().getStats().getEstimatedDHTSize(), this.sequence++, this.total_received_overall, this.total_sent_overall, this.aggregate_stats);
    }

    @Override
    public GlobalManagerStats.AggregateStats getAggregateRemoteStats() {
        return this.as_remote_wrapper;
    }

    @Override
    public GlobalManagerStats.AggregateStats getAggregateLocalStats() {
        return this.as_local_wrapper;
    }

    @Override
    public GlobalManagerStats.AggregateStats getAggregateLocalStats(DownloadManager dm) {
        GlobalManagerStats.AggregateStats as = (GlobalManagerStats.AggregateStats)dm.getUserData(DOWNLOAD_DATA_KEY);
        if (as == null) {
            Debug.out("AggregateStats are null for " + dm.getDisplayName());
        }
        return as;
    }

    private class AggregateStatsDownloadWrapper
    implements GlobalManagerStats.AggregateStats {
        private AtomicInteger dl_country_details_seq = new AtomicInteger();
        private Map<String, CountryDetailsImpl> dl_country_details = new ConcurrentHashMap<String, CountryDetailsImpl>();
        private int last_local_seq = -1;
        private Map<String, Map<String, long[]>> as_local_latest = new HashMap<String, Map<String, long[]>>();
        private Map<String, long[]> updates = new HashMap<String, long[]>();
        private boolean inactive;

        AggregateStatsDownloadWrapper() {
        }

        protected void updateComplete() {
            if (this.updates.isEmpty()) {
                if (!this.inactive) {
                    boolean has_active = false;
                    for (CountryDetailsImpl countryDetailsImpl : this.dl_country_details.values()) {
                        countryDetailsImpl.last_recv = 0L;
                        countryDetailsImpl.last_sent = 0L;
                        if (countryDetailsImpl.recv_average.update(0.0) != 0.0) {
                            has_active = true;
                        }
                        if (countryDetailsImpl.sent_average.update(0.0) == 0.0) continue;
                        has_active = true;
                    }
                    if (!has_active) {
                        this.inactive = true;
                    }
                    this.dl_country_details_seq.incrementAndGet();
                }
                return;
            }
            this.inactive = false;
            try {
                HashSet<CountryDetailsImpl> updated = new HashSet<CountryDetailsImpl>();
                for (Map.Entry<String, long[]> entry : this.updates.entrySet()) {
                    String cc = entry.getKey();
                    long[] totals = entry.getValue();
                    long diff_sent = totals[0];
                    long diff_recv = totals[1];
                    CountryDetailsImpl cd = this.dl_country_details.get(cc);
                    if (cd == null) {
                        cd = new CountryDetailsImpl(cc);
                        this.dl_country_details.put(cc, cd);
                    }
                    updated.add(cd);
                    if (diff_sent > 0L) {
                        cd.last_sent = diff_sent;
                        cd.total_sent += diff_sent;
                        cd.sent_average.update(diff_sent);
                    } else {
                        cd.last_sent = 0L;
                        cd.sent_average.update(diff_sent);
                    }
                    if (diff_recv > 0L) {
                        cd.last_recv = diff_recv;
                        cd.total_recv += diff_recv;
                        cd.recv_average.update(diff_recv);
                        continue;
                    }
                    cd.last_recv = 0L;
                    cd.recv_average.update(diff_recv);
                }
                for (GlobalManagerStats.CountryDetails countryDetails : this.dl_country_details.values()) {
                    if (updated.contains(countryDetails)) continue;
                    CountryDetailsImpl cdi = (CountryDetailsImpl)countryDetails;
                    cdi.last_recv = 0L;
                    cdi.last_sent = 0L;
                    cdi.recv_average.update(0.0);
                    cdi.sent_average.update(0.0);
                }
                this.dl_country_details_seq.incrementAndGet();
            }
            finally {
                this.updates.clear();
            }
        }

        @Override
        public int getSamples() {
            return -1;
        }

        @Override
        public int getEstimatedPopulation() {
            return -1;
        }

        @Override
        public int getSequence() {
            int seq = this.dl_country_details_seq.get();
            if (seq != this.last_local_seq) {
                Iterator<CountryDetailsImpl> it = this.dl_country_details.values().iterator();
                HashMap<String, Map<String, long[]>> my_sample = new HashMap<String, Map<String, long[]>>();
                HashMap<String, long[]> my_stats = new HashMap<String, long[]>();
                my_sample.put(GlobalManagerStatsImpl.this.country_my_cc, my_stats);
                while (it.hasNext()) {
                    GlobalManagerStats.CountryDetails cd = it.next();
                    my_stats.put(cd.getCC(), new long[]{cd.getAverageReceived(), cd.getAverageSent(), cd.getTotalReceived(), cd.getTotalSent()});
                }
                this.as_local_latest = my_sample;
                this.last_local_seq = seq;
            }
            return seq;
        }

        @Override
        public long getLatestReceived() {
            return -1L;
        }

        @Override
        public long getLatestSent() {
            return -1L;
        }

        @Override
        public Map<String, Map<String, long[]>> getStats() {
            return this.as_local_latest;
        }
    }

    private static class AggregateStatsImpl
    implements GlobalManagerStats.AggregateStats {
        final int samples;
        final int population;
        final int sequence;
        final long latest_received;
        final long latest_sent;
        final Map<String, Map<String, long[]>> stats;

        AggregateStatsImpl(int _sequence) {
            this.samples = 0;
            this.population = 0;
            this.sequence = _sequence;
            this.latest_received = 0L;
            this.latest_sent = 0L;
            this.stats = new HashMap<String, Map<String, long[]>>();
        }

        AggregateStatsImpl(int _samples, int _population, int _sequence, long _latest_received, long _latest_sent, Map<String, Map<String, long[]>> _stats) {
            this.samples = _samples;
            this.population = _population;
            this.sequence = _sequence;
            this.latest_received = _latest_received;
            this.latest_sent = _latest_sent;
            this.stats = _stats;
        }

        @Override
        public int getSamples() {
            return this.samples;
        }

        @Override
        public int getEstimatedPopulation() {
            return this.population;
        }

        @Override
        public int getSequence() {
            return this.sequence;
        }

        @Override
        public long getLatestReceived() {
            return this.latest_received;
        }

        @Override
        public long getLatestSent() {
            return this.latest_sent;
        }

        @Override
        public Map<String, Map<String, long[]>> getStats() {
            return this.stats;
        }
    }

    private class AggregateStatsWrapper
    implements GlobalManagerStats.AggregateStats {
        final boolean is_local;
        private int last_local_seq = -1;
        private Map<String, Map<String, long[]>> as_local_latest = new HashMap<String, Map<String, long[]>>();

        AggregateStatsWrapper(boolean _is_local) {
            this.is_local = _is_local;
        }

        @Override
        public int getSamples() {
            if (this.is_local) {
                return -1;
            }
            return GlobalManagerStatsImpl.this.as_remote_latest.getSamples();
        }

        @Override
        public int getEstimatedPopulation() {
            if (this.is_local) {
                return -1;
            }
            return GlobalManagerStatsImpl.this.as_remote_latest.getEstimatedPopulation();
        }

        @Override
        public int getSequence() {
            if (this.is_local) {
                int seq = GlobalManagerStatsImpl.this.country_details_seq.get();
                if (seq != this.last_local_seq) {
                    Iterator<GlobalManagerStats.CountryDetails> it = GlobalManagerStatsImpl.this.getCountryDetails();
                    HashMap<String, Map<String, long[]>> my_sample = new HashMap<String, Map<String, long[]>>();
                    HashMap<String, long[]> my_stats = new HashMap<String, long[]>();
                    my_sample.put(GlobalManagerStatsImpl.this.country_my_cc, my_stats);
                    while (it.hasNext()) {
                        GlobalManagerStats.CountryDetails cd = it.next();
                        my_stats.put(cd.getCC(), new long[]{cd.getAverageReceived(), cd.getAverageSent(), cd.getTotalReceived(), cd.getTotalSent()});
                    }
                    this.as_local_latest = my_sample;
                    this.last_local_seq = seq;
                }
                return seq;
            }
            return GlobalManagerStatsImpl.this.as_remote_latest.getSequence();
        }

        @Override
        public long getLatestReceived() {
            if (this.is_local) {
                return -1L;
            }
            return GlobalManagerStatsImpl.this.as_remote_latest.getLatestReceived();
        }

        @Override
        public long getLatestSent() {
            if (this.is_local) {
                return -1L;
            }
            return GlobalManagerStatsImpl.this.as_remote_latest.getLatestSent();
        }

        @Override
        public Map<String, Map<String, long[]>> getStats() {
            if (this.is_local) {
                return this.as_local_latest;
            }
            return GlobalManagerStatsImpl.this.as_remote_latest.getStats();
        }
    }

    private static class CountryDetailsImpl
    implements GlobalManagerStats.CountryDetails {
        String cc;
        long total_sent;
        long total_recv;
        long last_sent;
        long last_recv;
        Average sent_average = AverageFactory.MovingImmediateAverage(3);
        Average recv_average = AverageFactory.MovingImmediateAverage(3);

        CountryDetailsImpl(String _cc) {
            this.cc = _cc;
        }

        @Override
        public String getCC() {
            return this.cc;
        }

        @Override
        public long getTotalSent() {
            return this.total_sent;
        }

        @Override
        public long getLatestSent() {
            return this.last_sent;
        }

        @Override
        public long getAverageSent() {
            return (long)this.sent_average.getAverage();
        }

        @Override
        public long getTotalReceived() {
            return this.total_recv;
        }

        @Override
        public long getLatestReceived() {
            return this.last_recv;
        }

        @Override
        public long getAverageReceived() {
            return (long)this.recv_average.getAverage();
        }

        public String toString() {
            return "sent: " + this.total_sent + "/" + this.last_sent + "/" + (long)this.sent_average.getAverage() + ", " + "recv: " + this.total_recv + "/" + this.last_recv + "/" + (long)this.recv_average.getAverage();
        }
    }

    private static class HistoryEntry {
        final long time = SystemTime.getMonotonousTime();
        final InetAddress address;
        final String cc;
        final GlobalManagerStats.RemoteCountryStats[] stats;

        private HistoryEntry(String _cc, GlobalManagerStats.RemoteStats _stats) {
            this.cc = _cc;
            this.address = _stats.getRemoteAddress();
            this.stats = _stats.getStats();
        }
    }

    private static class PeerDetails {
        String cc;
        long sent;
        long recv;

        PeerDetails(String _cc) {
            this.cc = _cc;
        }
    }
}

