/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.global;

public interface GlobalMangerProgressListener {
    public void reportCurrentTask(String var1);

    public void reportPercent(int var1);

    public static class GlobalMangerProgressAdapter
    implements GlobalMangerProgressListener {
        private final GlobalMangerProgressListener delegate;
        private final int start_percent;
        private final int range;

        public GlobalMangerProgressAdapter() {
            this.delegate = null;
            this.start_percent = -1;
            this.range = -1;
        }

        public GlobalMangerProgressAdapter(GlobalMangerProgressListener _delegate, int _start_percent, int _end_percent) {
            this.delegate = _delegate;
            this.start_percent = _start_percent;
            this.range = _end_percent - _start_percent;
        }

        @Override
        public void reportCurrentTask(String currentTask) {
            if (this.delegate != null) {
                this.delegate.reportCurrentTask(currentTask);
            }
        }

        @Override
        public void reportPercent(int percent) {
            if (this.delegate != null) {
                if (this.range == -1) {
                    this.delegate.reportPercent(percent);
                } else {
                    this.delegate.reportPercent(this.start_percent + this.range * percent / 100);
                }
            }
        }
    }
}

