/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.download.impl;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.category.Category;
import com.biglybt.core.category.CategoryManager;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.disk.DiskManagerFactory;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerException;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.download.DownloadManagerStateAttributeListener;
import com.biglybt.core.download.impl.DownloadManagerDefaultPaths;
import com.biglybt.core.download.impl.DownloadManagerImpl;
import com.biglybt.core.ipfilter.IpFilterManagerFactory;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.LogRelation;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.peer.PEPeerSource;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentAnnounceURLGroup;
import com.biglybt.core.torrent.TOTorrentAnnounceURLSet;
import com.biglybt.core.torrent.TOTorrentException;
import com.biglybt.core.torrent.TOTorrentFile;
import com.biglybt.core.torrent.TOTorrentListener;
import com.biglybt.core.tracker.client.TRTrackerAnnouncer;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.CopyOnWriteMap;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.LightHashMap;
import com.biglybt.core.util.LinkFileMap;
import com.biglybt.core.util.RandomUtils;
import com.biglybt.core.util.StringInterner;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TorrentUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class DownloadManagerStateImpl
implements DownloadManagerState,
ParameterListener {
    private static final int VER_INCOMING_PEER_SOURCE = 1;
    private static final int VER_HOLE_PUNCH_PEER_SOURCE = 2;
    private static final int VER_CURRENT = 2;
    private static final LogIDs LOGID = LogIDs.DISK;
    private static final String RESUME_KEY = "resume";
    private static final String RESUME_HISTORY_KEY = "resume_history";
    private static final String TRACKER_CACHE_KEY = "tracker_cache";
    private static final String ATTRIBUTE_KEY = "attributes";
    private static final String AZUREUS_PROPERTIES_KEY = "azureus_properties";
    private static final String AZUREUS_PRIVATE_PROPERTIES_KEY = "azureus_private_properties";
    private static final File ACTIVE_DIR;
    public static boolean SUPPRESS_FIXUP_ERRORS;
    private static boolean disable_interim_saves;
    private static final Random random;
    private static final Map default_parameters;
    private static final Map default_attributes;
    private static boolean debug_on;
    private static final AEMonitor class_mon;
    static final Map<HashWrapper, DownloadManagerStateImpl> state_map;
    private static final Map global_state_cache;
    private static final ArrayList global_state_cache_wrappers;
    private static final CopyOnWriteMap<String, CopyOnWriteList<DownloadManagerStateAttributeListener>> global_listeners_read_map_cow;
    private static final CopyOnWriteMap<String, CopyOnWriteList<DownloadManagerStateAttributeListener>> global_listeners_write_map_cow;
    private DownloadManagerImpl download_manager;
    private final TorrentUtils.ExtendedTorrent torrent;
    private boolean write_required_soon;
    private long write_required_sometime = -1L;
    private Category category;
    private final CopyOnWriteMap<String, CopyOnWriteList<DownloadManagerStateAttributeListener>> listeners_read_map_cow = new CopyOnWriteMap();
    private final CopyOnWriteMap<String, CopyOnWriteList<DownloadManagerStateAttributeListener>> listeners_write_map_cow = new CopyOnWriteMap();
    private Map parameters;
    private Map attributes;
    private final AEMonitor this_mon = new AEMonitor("DownloadManagerState");
    private int supressWrites = 0;
    private boolean recovered;
    private static final ThreadLocal tls_wbr;
    private int transient_flags;
    private Map<String, Object> transient_attributes = new HashMap<String, Object>();
    private volatile WeakReference<LinkFileMap> file_link_cache = null;

    static {
        SUPPRESS_FIXUP_ERRORS = false;
        ACTIVE_DIR = FileUtil.getUserFile("active");
        if (!ACTIVE_DIR.exists()) {
            FileUtil.mkdirs(ACTIVE_DIR);
        }
        COConfigurationManager.addAndFireParameterListener("Disable Interim Download State Save", n -> {
            disable_interim_saves = COConfigurationManager.getBooleanParameter(n);
        });
        random = RandomUtils.SECURE_RANDOM;
        default_parameters = new HashMap();
        int i = 0;
        while (i < PARAMETERS.length) {
            default_parameters.put(PARAMETERS[i][0], PARAMETERS[i][1]);
            ++i;
        }
        default_attributes = new HashMap();
        i = 0;
        while (i < ATTRIBUTE_DEFAULTS.length) {
            default_attributes.put(ATTRIBUTE_DEFAULTS[i][0], ATTRIBUTE_DEFAULTS[i][1]);
            ++i;
        }
        TorrentUtils.registerMapFluff(new String[]{TRACKER_CACHE_KEY, RESUME_KEY, RESUME_HISTORY_KEY});
        class_mon = new AEMonitor("DownloadManagerState:class");
        state_map = new HashMap<HashWrapper, DownloadManagerStateImpl>();
        ParameterListener listener = new ParameterListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void parameterChanged(String parameterName) {
                ArrayList<DownloadManagerStateImpl> states;
                Map<HashWrapper, DownloadManagerStateImpl> map = state_map;
                synchronized (map) {
                    states = new ArrayList<DownloadManagerStateImpl>(state_map.values());
                }
                for (DownloadManagerStateImpl state : states) {
                    try {
                        state.parameterChanged(parameterName);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        };
        COConfigurationManager.addParameterListener("Max.Peer.Connections.Per.Torrent.When.Seeding", listener);
        COConfigurationManager.addParameterListener("Max.Peer.Connections.Per.Torrent.When.Seeding.Enable", listener);
        COConfigurationManager.addParameterListener("Max.Peer.Connections.Per.Torrent", listener);
        COConfigurationManager.addParameterListener("Max Uploads", listener);
        COConfigurationManager.addParameterListener("Max Uploads Seeding", listener);
        COConfigurationManager.addParameterListener("Max Seeds Per Torrent", listener);
        COConfigurationManager.addParameterListener("enable.seedingonly.maxuploads", listener);
        global_state_cache = new HashMap();
        global_state_cache_wrappers = new ArrayList();
        global_listeners_read_map_cow = new CopyOnWriteMap();
        global_listeners_write_map_cow = new CopyOnWriteMap();
        tls_wbr = new ThreadLocal(){

            public Object initialValue() {
                return new ArrayList(1);
            }
        };
    }

    public static void setDebugOn(boolean on) {
        debug_on = on;
    }

    private static Object getDefaultOverride(String name, Object value) {
        if (name == "max.uploads.when.seeding.enabled") {
            if (COConfigurationManager.getBooleanParameter("enable.seedingonly.maxuploads")) {
                value = Boolean.TRUE;
            }
        } else if (name == "max.uploads.when.seeding") {
            int def = COConfigurationManager.getIntParameter("Max Uploads Seeding");
            value = new Integer(def);
        } else if (name == "max.uploads") {
            int def = COConfigurationManager.getIntParameter("Max Uploads");
            value = new Integer(def);
        } else if (name == "max.peers") {
            int def = COConfigurationManager.getIntParameter("Max.Peer.Connections.Per.Torrent");
            value = new Integer(def);
        } else if (name == "max.peers.when.seeding.enabled") {
            if (COConfigurationManager.getBooleanParameter("Max.Peer.Connections.Per.Torrent.When.Seeding.Enable")) {
                value = Boolean.TRUE;
            }
        } else if (name == "max.peers.when.seeding") {
            int def = COConfigurationManager.getIntParameter("Max.Peer.Connections.Per.Torrent.When.Seeding");
            value = new Integer(def);
        } else if (name == "max.seeds") {
            value = new Integer(COConfigurationManager.getIntParameter("Max Seeds Per Torrent"));
        } else if (name == "rand") {
            long rand = random.nextLong();
            value = new Long(rand);
        }
        return value;
    }

    public static Integer getIntParameterDefault(String name) {
        Object value = default_parameters.get(name);
        if (value != null) {
            value = DownloadManagerStateImpl.getDefaultOverride(name, value);
        }
        return value instanceof Number ? Integer.valueOf(((Number)value).intValue()) : null;
    }

    public static Boolean getBooleanParameterDefault(String name) {
        Object value = default_parameters.get(name);
        if (value != null) {
            value = DownloadManagerStateImpl.getDefaultOverride(name, value);
        }
        return value instanceof Boolean ? (Boolean)value : null;
    }

    private static DownloadManagerStateImpl getDownloadState(DownloadManagerImpl download_manager, TOTorrent original_torrent, TorrentUtils.ExtendedTorrent target_torrent) throws TOTorrentException {
        byte[] hash = target_torrent.getHash();
        DownloadManagerStateImpl res = null;
        try {
            class_mon.enter();
            HashWrapper hash_wrapper = new HashWrapper(hash);
            res = state_map.get(hash_wrapper);
            if (res == null) {
                res = new DownloadManagerStateImpl(download_manager, target_torrent);
                state_map.put(hash_wrapper, res);
                if (debug_on) {
                    FileUtil.log("    dms created");
                }
            } else {
                if (debug_on) {
                    FileUtil.log("    dms found in state_map");
                }
                if (res.getDownloadManager() == null && download_manager != null) {
                    res.setDownloadManager(download_manager);
                }
                if (original_torrent != null) {
                    res.mergeTorrentDetails(original_torrent);
                }
            }
        }
        finally {
            class_mon.exit();
        }
        return res;
    }

    public static DownloadManagerState getDownloadState(TOTorrent original_torrent) throws TOTorrentException {
        byte[] torrent_hash = original_torrent.getHash();
        TorrentUtils.ExtendedTorrent saved_state = null;
        File saved_file = DownloadManagerStateImpl.getStateFile(torrent_hash);
        boolean was_corrupt = false;
        if (saved_file.exists()) {
            try {
                saved_state = TorrentUtils.readDelegateFromFile(saved_file, false);
            }
            catch (Throwable e) {
                was_corrupt = true;
                Debug.out("Failed to load download state for " + saved_file, e);
            }
        }
        if (saved_state == null) {
            DownloadManagerStateImpl.copyTorrentToActive(original_torrent, saved_file, was_corrupt);
            saved_state = TorrentUtils.readDelegateFromFile(saved_file, false);
        }
        DownloadManagerStateImpl state = DownloadManagerStateImpl.getDownloadState(null, original_torrent, saved_state);
        if (was_corrupt) {
            state.setRecovered();
        }
        return state;
    }

    protected static DownloadManagerState getDownloadState(DownloadManagerImpl download_manager, String torrent_file, byte[] torrent_hash, boolean inactive) throws TOTorrentException {
        boolean discard_pieces;
        boolean bl = discard_pieces = state_map.size() > 32;
        if (debug_on) {
            FileUtil.log("getDownloadState: hash = " + (torrent_hash == null ? "null" : String.valueOf(ByteFormatter.encodeString(torrent_hash)) + ", file = " + torrent_file));
        }
        TorrentUtils.ExtendedTorrent original_torrent = null;
        TorrentUtils.ExtendedTorrent saved_state = null;
        if (torrent_hash != null) {
            File saved_file = DownloadManagerStateImpl.getStateFile(torrent_hash);
            if (saved_file.exists()) {
                if (debug_on) {
                    FileUtil.log("    saved state 1 exists");
                }
                try {
                    Map cached_state = (Map)global_state_cache.remove(new HashWrapper(torrent_hash));
                    if (cached_state != null) {
                        if (debug_on) {
                            FileUtil.log("    saved state 1: got cached state");
                        }
                        CachedStateWrapper wrapper2 = new CachedStateWrapper(download_manager, torrent_file, torrent_hash, cached_state, inactive);
                        global_state_cache_wrappers.add(wrapper2);
                        saved_state = wrapper2;
                    } else {
                        saved_state = TorrentUtils.readDelegateFromFile(saved_file, discard_pieces);
                        if (debug_on) {
                            FileUtil.log("    saved state 1: read from " + saved_file);
                        }
                    }
                }
                catch (Throwable e) {
                    Debug.out("Failed to load download state for " + saved_file, e);
                }
            } else if (debug_on) {
                FileUtil.log("    saved state 1 doesn't exist");
            }
        }
        boolean was_corrupt = false;
        if (saved_state == null) {
            original_torrent = TorrentUtils.readDelegateFromFile(FileUtil.newFile(torrent_file, new String[0]), discard_pieces);
            torrent_hash = original_torrent.getHash();
            File saved_file = DownloadManagerStateImpl.getStateFile(torrent_hash);
            if (saved_file.exists()) {
                if (debug_on) {
                    FileUtil.log("    saved state 2 exists");
                }
                try {
                    saved_state = TorrentUtils.readDelegateFromFile(saved_file, discard_pieces);
                    if (debug_on) {
                        FileUtil.log("    saved state 2: read from " + saved_file);
                    }
                }
                catch (Throwable e) {
                    was_corrupt = true;
                    Debug.out("Failed to load download state for " + saved_file);
                }
            } else if (debug_on) {
                FileUtil.log("    saved state 2 doesn't exist");
            }
            if (saved_state == null) {
                DownloadManagerStateImpl.copyTorrentToActive(original_torrent, saved_file, was_corrupt);
                saved_state = TorrentUtils.readDelegateFromFile(saved_file, discard_pieces);
                if (debug_on) {
                    FileUtil.log("    saved state 3: read from " + saved_file);
                }
            }
        }
        DownloadManagerStateImpl res = DownloadManagerStateImpl.getDownloadState(download_manager, original_torrent, saved_state);
        if (was_corrupt) {
            res.setRecovered();
        }
        if (inactive) {
            res.setActive(false);
        }
        return res;
    }

    private static void copyTorrentToActive(TOTorrent torrent_file, File state_file, boolean was_corrupt) throws TOTorrentException {
        TorrentUtils.copyToFile(torrent_file, state_file);
        if (was_corrupt) {
            Logger.log(new LogAlert((Object)torrent_file, true, 3, "Recovered download from original torrent: " + TorrentUtils.getLocalisedName(torrent_file)));
        }
        if (COConfigurationManager.getBooleanParameter("Save Torrent Files") && COConfigurationManager.getBooleanParameter("Delete Saved Torrent Files")) {
            try {
                String file_str = TorrentUtils.getTorrentFileName(torrent_file, false);
                if (file_str != null) {
                    File file = FileUtil.newFile(file_str, new String[0]);
                    File torrentDir = FileUtil.newFile(COConfigurationManager.getDirectoryParameter("General_sDefaultTorrent_Directory"), new String[0]);
                    if (torrentDir.isDirectory() && torrentDir.equals(file.getParentFile())) {
                        file.delete();
                        FileUtil.newFile(String.valueOf(file.getAbsolutePath()) + ".bak", new String[0]).delete();
                    }
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    protected static File getStateFile(byte[] torrent_hash) {
        return FileUtil.newFile(ACTIVE_DIR, String.valueOf(ByteFormatter.encodeString(torrent_hash)) + ".dat");
    }

    protected static File getGlobalStateFile() {
        return FileUtil.newFile(ACTIVE_DIR, "cache.dat");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void loadGlobalStateCache() {
        File file = DownloadManagerStateImpl.getGlobalStateFile();
        if (!file.canRead()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                FileInputStream fis = FileUtil.newFileInputStream(file);
                try {
                    try (BufferedInputStream is = new BufferedInputStream(new GZIPInputStream(fis));){
                        try {
                            Map<String, Object> map = BDecoder.decode(is);
                            List cache = (List)map.get("state");
                            if (cache != null) {
                                int i = 0;
                                while (i < cache.size()) {
                                    Map entry = (Map)cache.get(i);
                                    byte[] hash = (byte[])entry.get("hash");
                                    if (hash != null) {
                                        global_state_cache.put(new HashWrapper(hash), entry);
                                    }
                                    ++i;
                                }
                            }
                        }
                        catch (IOException e) {
                            Debug.printStackTrace(e);
                        }
                    }
                    if (fis == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fis == null) throw throwable;
                    fis.close();
                    throw throwable;
                }
                fis.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public static void saveGlobalStateCache() {
        try {
            try {
                class_mon.enter();
                HashMap map = new HashMap();
                ArrayList<Map> cache = new ArrayList<Map>();
                map.put("state", cache);
                for (DownloadManagerState downloadManagerState : state_map.values()) {
                    DownloadManager dm = downloadManagerState.getDownloadManager();
                    if (dm == null || !dm.isPersistent()) continue;
                    try {
                        Map state = CachedStateWrapper.export(downloadManagerState);
                        cache.add(state);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(FileUtil.newFileOutputStream(DownloadManagerStateImpl.getGlobalStateFile()));
                try {
                    gZIPOutputStream.write(BEncoder.encode(map));
                    gZIPOutputStream.close();
                }
                catch (IOException e) {
                    Debug.printStackTrace(e);
                    try {
                        gZIPOutputStream.close();
                    }
                    catch (IOException iOException) {
                    }
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                class_mon.exit();
            }
        }
        finally {
            class_mon.exit();
        }
    }

    public static void discardGlobalStateCache() {
        DownloadManagerStateImpl.getGlobalStateFile().delete();
        int i = 0;
        while (i < global_state_cache_wrappers.size()) {
            ((CachedStateWrapper)global_state_cache_wrappers.get(i)).clearCache();
            ++i;
        }
        global_state_cache_wrappers.clear();
        global_state_cache_wrappers.trimToSize();
    }

    public static void importDownloadState(File source_dir, byte[] download_hash) throws DownloadManagerException {
        String hash_str = ByteFormatter.encodeString(download_hash);
        String state_file = String.valueOf(hash_str) + ".dat";
        File target_state_file = FileUtil.newFile(ACTIVE_DIR, state_file);
        File source_state_file = FileUtil.newFile(source_dir, state_file);
        if (!source_state_file.exists()) {
            throw new DownloadManagerException("Source state file missing: " + source_state_file);
        }
        if (target_state_file.exists()) {
            target_state_file.delete();
        }
        if (!FileUtil.copyFile(source_state_file, target_state_file)) {
            throw new DownloadManagerException("Failed to copy state file: " + source_state_file + " -> " + target_state_file);
        }
        File source_state_dir = FileUtil.newFile(source_dir, hash_str);
        if (source_state_dir.exists()) {
            try {
                FileUtil.copyFileOrDirectory(source_state_dir, ACTIVE_DIR);
            }
            catch (Throwable e) {
                target_state_file.delete();
                throw new DownloadManagerException("Failed to copy state dir: " + source_dir + " -> " + ACTIVE_DIR, e);
            }
        }
    }

    public static void deleteDownloadState(byte[] download_hash, boolean delete_cache) throws DownloadManagerException {
        DownloadManagerStateImpl.deleteDownloadState(ACTIVE_DIR, download_hash);
        if (delete_cache) {
            try {
                class_mon.enter();
                HashWrapper wrapper2 = new HashWrapper(download_hash);
                state_map.remove(wrapper2);
            }
            finally {
                class_mon.exit();
            }
        }
    }

    public static void deleteDownloadState(File source_dir, byte[] download_hash) throws DownloadManagerException {
        String hash_str = ByteFormatter.encodeString(download_hash);
        String state_file = String.valueOf(hash_str) + ".dat";
        File target_state_file = FileUtil.newFile(source_dir, state_file);
        if (target_state_file.exists() && !target_state_file.delete()) {
            throw new DownloadManagerException("Failed to delete state file: " + target_state_file);
        }
        File target_state_file_bak = FileUtil.newFile(source_dir, String.valueOf(state_file) + ".bak");
        if (target_state_file_bak.exists() && !target_state_file_bak.delete()) {
            throw new DownloadManagerException("Failed to delete state backup file: " + target_state_file_bak);
        }
        File target_state_dir = FileUtil.newFile(source_dir, hash_str);
        if (target_state_dir.exists() && !FileUtil.recursiveDelete(target_state_dir)) {
            throw new DownloadManagerException("Failed to delete state dir: " + target_state_dir);
        }
    }

    protected DownloadManagerStateImpl(DownloadManagerImpl _download_manager, TorrentUtils.ExtendedTorrent _torrent) {
        long flags;
        int version;
        Category cat;
        String cat_string;
        this.download_manager = _download_manager;
        this.torrent = _torrent;
        this.attributes = this.torrent.getAdditionalMapProperty(ATTRIBUTE_KEY);
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        if ((cat_string = this.getStringAttribute("category")) != null && (cat = CategoryManager.getCategory(cat_string)) != null) {
            this.setCategory(cat);
        }
        this.parameters = this.getMapAttribute("parameters");
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
        if ((version = this.getIntAttribute("version")) < 2) {
            if (this.getPeerSources().length > 0) {
                if (PEPeerSource.isPeerSourceEnabledByDefault("HolePunch")) {
                    this.setPeerSourceEnabled("HolePunch", true);
                }
            } else {
                this.setPeerSources(PEPeerSource.getDefaultEnabledPeerSources());
            }
        }
        if (((flags = this.getFlags()) & 0x100L) != 0L) {
            try {
                IpFilterManagerFactory.getSingleton().getIPFilter().addExcludedHash(this.torrent.getHash());
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        if (version < 2) {
            this.setIntAttribute("version", 2);
        }
    }

    @Override
    public void parameterChanged(String parameterName) {
        this.informWritten("parameters");
    }

    @Override
    public DownloadManager getDownloadManager() {
        return this.download_manager;
    }

    protected void setDownloadManager(DownloadManagerImpl dm) {
        this.download_manager = dm;
    }

    @Override
    public File getStateFile() {
        try {
            File parent = FileUtil.newFile(ACTIVE_DIR, ByteFormatter.encodeString(this.torrent.getHash()));
            return StringInterner.internFile(parent);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    private void setRecovered() {
        this.recovered = true;
    }

    @Override
    public boolean getAndClearRecoveredStatus() {
        if (this.recovered) {
            this.recovered = false;
            return true;
        }
        return false;
    }

    @Override
    public void clearTrackerResponseCache() {
        this.setTrackerResponseCache(new HashMap());
    }

    @Override
    public Map getTrackerResponseCache() {
        HashMap tracker_response_cache = null;
        tracker_response_cache = this.torrent.getAdditionalMapProperty(TRACKER_CACHE_KEY);
        if (tracker_response_cache == null) {
            tracker_response_cache = new HashMap();
        }
        return tracker_response_cache;
    }

    @Override
    public void setTrackerResponseCache(Map value) {
        try {
            boolean changed;
            this.this_mon.enter();
            boolean bl = changed = !BEncoder.mapsAreIdentical(value, this.getTrackerResponseCache());
            if (changed) {
                this.setDirty(false);
                this.torrent.setAdditionalMapProperty(TRACKER_CACHE_KEY, value);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public Map getResumeData() {
        try {
            this.this_mon.enter();
            Map map = this.torrent.getAdditionalMapProperty(RESUME_KEY);
            return map;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void clearResumeData() {
        this.setResumeData(null);
    }

    @Override
    public void setResumeData(Map new_data) {
        boolean changed = false;
        try {
            long new_resume_state;
            boolean existing_was_valid;
            this.this_mon.enter();
            Map existing_data = this.torrent.getAdditionalMapProperty(RESUME_KEY);
            boolean bl = existing_was_valid = existing_data != null && DiskManagerFactory.isTorrentResumeDataValid(this);
            if (new_data == null) {
                new_resume_state = 1L;
                if (existing_data != null) {
                    this.torrent.removeAdditionalProperty(RESUME_KEY);
                    changed = true;
                }
            } else {
                changed = !BEncoder.mapsAreIdentical(existing_data, new_data);
                this.torrent.setAdditionalMapProperty(RESUME_KEY, new_data);
                boolean complete = DiskManagerFactory.isTorrentResumeDataComplete(this);
                new_resume_state = complete ? 2 : 1;
            }
            if (this.getLongAttribute("resumecomplete") != new_resume_state) {
                this.setLongAttribute("resumecomplete", new_resume_state);
                changed = true;
            }
            if (changed) {
                if (existing_was_valid) {
                    ArrayList<Map> h_resumes;
                    ArrayList<Long> h_dates;
                    HashMap history = this.torrent.getAdditionalMapProperty(RESUME_HISTORY_KEY);
                    if (history == null) {
                        history = new HashMap();
                        h_dates = new ArrayList<Long>();
                        h_resumes = new ArrayList<Map>();
                        history.put("dates", h_dates);
                        history.put("resumes", h_resumes);
                    } else {
                        h_dates = (ArrayList<Long>)history.get("dates");
                        h_resumes = (ArrayList<Map>)history.get("resumes");
                    }
                    boolean found = false;
                    for (Map m : h_resumes) {
                        if (!BEncoder.mapsAreIdentical(existing_data, m)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        h_dates.add(SystemTime.getCurrentTime());
                        h_resumes.add(existing_data);
                        if (h_dates.size() > 3) {
                            h_dates.remove(0);
                            h_resumes.remove(0);
                        }
                        this.torrent.setAdditionalMapProperty(RESUME_HISTORY_KEY, history);
                    }
                }
                this.setDirty(false);
            }
        }
        finally {
            this.this_mon.exit();
        }
        if (!disable_interim_saves || changed) {
            this.saveSupport(false, false);
        }
    }

    @Override
    public boolean isResumeDataComplete() {
        long state = this.getLongAttribute("resumecomplete");
        if (state == 0L) {
            boolean complete = DiskManagerFactory.isTorrentResumeDataComplete(this);
            this.setLongAttribute("resumecomplete", complete ? 2 : 1);
            return complete;
        }
        return state == 2L;
    }

    @Override
    public List<DownloadManagerState.ResumeHistory> getResumeDataHistory() {
        ArrayList<DownloadManagerState.ResumeHistory> result = new ArrayList<DownloadManagerState.ResumeHistory>();
        try {
            this.this_mon.enter();
            Map history = this.torrent.getAdditionalMapProperty(RESUME_HISTORY_KEY);
            if (history != null) {
                List h_dates = (List)history.get("dates");
                List h_resumes = (List)history.get("resumes");
                int pos = 0;
                Map existing_data = this.getResumeData();
                for (Long date : h_dates) {
                    Map resume = (Map)h_resumes.get(pos++);
                    if (existing_data != null && BEncoder.mapsAreIdentical(existing_data, resume)) continue;
                    result.add(new ResumeHistoryImpl(date, resume));
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
        return result;
    }

    @Override
    public void restoreResumeData(DownloadManagerState.ResumeHistory history) {
        this.download_manager.restoreResumeData(((ResumeHistoryImpl)history).resume_data);
    }

    @Override
    public TOTorrent getTorrent() {
        return this.torrent;
    }

    @Override
    public void setActive(boolean active) {
        this.torrent.setDiscardFluff(!active);
    }

    @Override
    public void discardFluff() {
        this.torrent.setDiscardFluff(true);
    }

    @Override
    public boolean exportState(File target_dir) {
        try {
            this.this_mon.enter();
            this.saveSupport(false, true);
            byte[] hash = this.torrent.getHash();
            String hash_str = ByteFormatter.encodeString(hash);
            String state_file = String.valueOf(hash_str) + ".dat";
            File existing_state_file = FileUtil.newFile(ACTIVE_DIR, state_file);
            File target_state_file = FileUtil.newFile(target_dir, state_file);
            if (!FileUtil.copyFile(existing_state_file, target_state_file)) {
                throw new IOException("Failed to copy state file");
            }
            File existing_state_dir = FileUtil.newFile(ACTIVE_DIR, hash_str);
            if (existing_state_dir.exists()) {
                FileUtil.copyFileOrDirectory(existing_state_dir, target_dir);
            }
            return true;
        }
        catch (Throwable e) {
            Debug.out(e);
            return false;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void suppressStateSave(boolean suppress) {
        if (suppress) {
            ++this.supressWrites;
        } else if (this.supressWrites > 0) {
            --this.supressWrites;
        }
    }

    private void setDirty(boolean slightly) {
        if (slightly) {
            if (this.write_required_sometime == -1L) {
                this.write_required_sometime = SystemTime.getMonotonousTime();
            }
        } else {
            this.write_required_soon = true;
        }
    }

    @Override
    public void save(boolean interim) {
        this.saveSupport(interim, false);
    }

    protected void saveSupport(boolean interim, boolean force) {
        boolean do_write;
        if (!force) {
            if (this.supressWrites > 0) {
                return;
            }
            if (interim && disable_interim_saves) {
                return;
            }
        }
        try {
            this.this_mon.enter();
            do_write = this.write_required_soon ? true : (this.write_required_sometime != -1L ? (interim ? SystemTime.getMonotonousTime() - this.write_required_sometime > 300000L : true) : false);
            if (do_write) {
                this.write_required_soon = false;
                this.write_required_sometime = -1L;
            }
        }
        finally {
            this.this_mon.exit();
        }
        if (do_write) {
            try {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "Saving state for download '" + TorrentUtils.getLocalisedName(this.torrent) + "'"));
                }
                this.torrent.setAdditionalMapProperty(ATTRIBUTE_KEY, this.attributes);
                TorrentUtils.writeToFile(this.torrent, true);
            }
            catch (Throwable e) {
                Logger.log(new LogEvent((Object)this.torrent, LOGID, "Saving state", e));
            }
        }
    }

    @Override
    public void delete() {
        try {
            try {
                boolean removed;
                class_mon.enter();
                HashWrapper wrapper2 = this.torrent.getHashWrapper();
                boolean bl = removed = state_map.remove(wrapper2) != null;
                if (debug_on) {
                    FileUtil.log("deleteDownloadState: hash = " + (wrapper2 == null ? "null" : ByteFormatter.encodeString(wrapper2.getBytes())) + ", removed=" + removed);
                }
                TorrentUtils.delete(this.torrent);
                String hash_str = ByteFormatter.encodeString(wrapper2.getBytes());
                String state_file = String.valueOf(hash_str) + ".dat";
                File target_state_file = FileUtil.newFile(ACTIVE_DIR, state_file);
                if (target_state_file.exists() && !target_state_file.delete()) {
                    throw new DownloadManagerException("Failed to delete state file: " + state_file);
                }
                FileUtil.newFile(ACTIVE_DIR, String.valueOf(state_file) + ".bak").delete();
                File dir = FileUtil.newFile(ACTIVE_DIR, hash_str);
                if (dir.exists() && dir.isDirectory()) {
                    FileUtil.recursiveDelete(dir);
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                class_mon.exit();
            }
        }
        finally {
            class_mon.exit();
        }
    }

    protected void mergeTorrentDetails(TOTorrent other_torrent) {
        try {
            boolean write = TorrentUtils.mergeAnnounceURLs(other_torrent, this.torrent);
            if (write) {
                TRTrackerAnnouncer client;
                this.saveSupport(false, false);
                if (this.download_manager != null && (client = this.download_manager.getTrackerClient()) != null) {
                    client.resetTrackerUrl(false);
                }
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    @Override
    public void setFlag(long flag, boolean set) {
        long new_value;
        long old_value = this.getLongAttribute("flags");
        if (old_value != (new_value = set ? old_value | flag : old_value & (flag ^ 0xFFFFFFFFFFFFFFFFL))) {
            this.setLongAttribute("flags", new_value);
            if ((old_value & 0x100L) != (new_value & 0x100L)) {
                try {
                    if ((new_value & 0x100L) != 0L) {
                        IpFilterManagerFactory.getSingleton().getIPFilter().addExcludedHash(this.torrent.getHash());
                    } else {
                        IpFilterManagerFactory.getSingleton().getIPFilter().removeExcludedHash(this.torrent.getHash());
                    }
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
    }

    @Override
    public boolean getFlag(long flag) {
        long value = this.getLongAttribute("flags");
        return (value & flag) != 0L;
    }

    @Override
    public long getFlags() {
        return this.getLongAttribute("flags");
    }

    @Override
    public void setTransientFlag(long flag, boolean set) {
        long old_value = this.transient_flags;
        long new_value = set ? old_value | flag : old_value & (flag ^ 0xFFFFFFFFFFFFFFFFL);
        if (old_value != new_value) {
            this.transient_flags = (int)new_value;
            this.informWritten("t_flags");
        }
    }

    @Override
    public boolean getTransientFlag(long flag) {
        return ((long)this.transient_flags & flag) != 0L;
    }

    @Override
    public long getTransientFlags() {
        return this.transient_flags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getTransientAttribute(String name) {
        Map<String, Object> map = this.transient_attributes;
        synchronized (map) {
            return this.transient_attributes.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransientAttribute(String name, Object value) {
        Map<String, Object> map = this.transient_attributes;
        synchronized (map) {
            this.transient_attributes.put(name, value);
        }
    }

    @Override
    public boolean parameterExists(String name) {
        return this.parameters.containsKey(name);
    }

    @Override
    public void setParameterDefault(String name) {
        try {
            this.this_mon.enter();
            Object value = this.parameters.get(name);
            if (value == null) {
                return;
            }
            this.parameters = new LightHashMap(this.parameters);
            this.parameters.remove(name);
        }
        finally {
            this.this_mon.exit();
        }
        this.setMapAttribute("parameters", this.parameters);
    }

    @Override
    public long getLongParameter(String name) {
        try {
            this.this_mon.enter();
            Object value = this.parameters.get(name);
            if (value == null) {
                value = default_parameters.get(name);
                if (value == null) {
                    Debug.out("Unknown parameter '" + name + "' - must be defined in DownloadManagerState");
                    return 0L;
                }
                value = DownloadManagerStateImpl.getDefaultOverride(name, value);
                if (name == "rand") {
                    this.setLongParameter(name, (Long)value);
                }
            }
            if (value instanceof Boolean) {
                long l = (Boolean)value != false ? 1 : 0;
                return l;
            }
            if (value instanceof Integer) {
                long l = ((Integer)value).longValue();
                return l;
            }
            if (value instanceof Long) {
                long l = (Long)value;
                return l;
            }
            Debug.out("Invalid parameter value for '" + name + "' - " + value);
            return 0L;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void setLongParameter(String name, long value) {
        Object default_value = default_parameters.get(name);
        if (default_value == null) {
            Debug.out("Unknown parameter '" + name + "' - must be defined in DownloadManagerState");
        }
        try {
            this.this_mon.enter();
            this.parameters = new LightHashMap(this.parameters);
            this.parameters.put(name, new Long(value));
            this.setMapAttribute("parameters", this.parameters);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public int getIntParameter(String name) {
        return (int)this.getLongParameter(name);
    }

    @Override
    public void setIntParameter(String name, int value) {
        this.setLongParameter(name, value);
    }

    @Override
    public boolean getBooleanParameter(String name) {
        return this.getLongParameter(name) != 0L;
    }

    @Override
    public void setBooleanParameter(String name, boolean value) {
        this.setLongParameter(name, value ? 1 : 0);
    }

    @Override
    public void setAttribute(String name, String value) {
        this.setAttribute(name, value, true);
    }

    @Override
    public void setAttribute(String name, String value, boolean set_dirty) {
        if (name.equals("category")) {
            if (value == null) {
                this.setCategory(null);
            } else {
                Category cat = CategoryManager.getCategory(value);
                if (cat == null) {
                    cat = CategoryManager.createCategory(value);
                }
                this.setCategory(cat);
            }
            return;
        }
        if (name.equals("relativepath") && value.length() > 0) {
            File relative_path_file = FileUtil.newFile(value, new String[0]);
            value = (relative_path_file = DownloadManagerDefaultPaths.normaliseRelativePath(relative_path_file)) == null ? "" : relative_path_file.getPath();
        }
        this.setStringAttribute(name, value, set_dirty);
    }

    @Override
    public String getAttribute(String name) {
        if (name.equals("category")) {
            Category cat = this.getCategory();
            if (cat == null) {
                return null;
            }
            if (cat == CategoryManager.getCategory(2)) {
                return null;
            }
            return cat.getName();
        }
        return this.getStringAttribute(name);
    }

    @Override
    public Category getCategory() {
        return this.category;
    }

    @Override
    public void setCategory(Category cat) {
        DownloadManager dm;
        if (cat == this.category) {
            return;
        }
        if (cat != null && cat.getType() != 0 && (cat = null) == this.category) {
            return;
        }
        Category oldCategory = this.category == null ? CategoryManager.getCategory(2) : this.category;
        this.category = cat;
        if (oldCategory != null) {
            oldCategory.removeManager(this);
        }
        if ((dm = this.getDownloadManager()) != null && !dm.isDestroyed()) {
            if (this.category != null) {
                this.category.addManager(this);
            } else {
                CategoryManager.getCategory(2).addManager(this);
            }
        }
        if (this.category != null) {
            this.setStringAttribute("category", this.category.getName(), true);
        } else {
            this.setStringAttribute("category", null, true);
        }
    }

    @Override
    public String getTrackerClientExtensions() {
        return this.getStringAttribute("trackerclientextensions");
    }

    @Override
    public void setTrackerClientExtensions(String value) {
        this.setStringAttribute("trackerclientextensions", value, true);
    }

    @Override
    public String getDisplayName() {
        return this.getStringAttribute("displayname");
    }

    @Override
    public void setDisplayName(String value) {
        this.setStringAttribute("displayname", value, true);
    }

    @Override
    public String getUserComment() {
        return this.getStringAttribute("comment");
    }

    @Override
    public void setUserComment(String value) {
        this.setStringAttribute("comment", value, true);
    }

    @Override
    public String getRelativeSavePath() {
        return this.getStringAttribute("relativepath");
    }

    @Override
    public DiskManagerFileInfo getPrimaryFile() {
        int primaryIndex = -1;
        DiskManagerFileInfo[] fileInfo2 = this.download_manager.getDiskManagerFileInfoSet().getFiles();
        if (this.hasAttribute("primaryfileidx")) {
            primaryIndex = this.getIntAttribute("primaryfileidx");
        }
        if (primaryIndex < 0 || primaryIndex >= fileInfo2.length) {
            primaryIndex = -1;
            if (fileInfo2.length > 0) {
                int idxBiggest = -1;
                long lBiggest = -1L;
                int numChecked = 0;
                int i = 0;
                while (i < fileInfo2.length && numChecked < 10) {
                    if (!fileInfo2[i].isSkipped()) {
                        ++numChecked;
                        if (fileInfo2[i].getLength() > lBiggest) {
                            lBiggest = fileInfo2[i].getLength();
                            idxBiggest = i;
                        }
                    }
                    ++i;
                }
                if (idxBiggest >= 0) {
                    primaryIndex = idxBiggest;
                }
            }
            if (primaryIndex >= 0) {
                this.setPrimaryFile(fileInfo2[primaryIndex]);
            }
        }
        if (primaryIndex >= 0) {
            return fileInfo2[primaryIndex];
        }
        return null;
    }

    @Override
    public void setPrimaryFile(DiskManagerFileInfo dmfi) {
        this.setIntAttribute("primaryfileidx", dmfi.getIndex());
    }

    @Override
    public String[] getNetworks() {
        List values = this.getListAttributeSupport("networks");
        ArrayList<String> res = new ArrayList<String>();
        int i = 0;
        while (i < values.size()) {
            String nw = (String)values.get(i);
            int j = 0;
            while (j < AENetworkClassifier.AT_NETWORKS.length) {
                String nn = AENetworkClassifier.AT_NETWORKS[j];
                if (nn.equals(nw)) {
                    res.add(nn);
                }
                ++j;
            }
            ++i;
        }
        String[] x = new String[res.size()];
        res.toArray(x);
        return x;
    }

    @Override
    public boolean isNetworkEnabled(String network) {
        List values = this.getListAttributeSupport("networks");
        return values.contains(network);
    }

    @Override
    public void setNetworks(String[] networks) {
        if (networks == null) {
            networks = new String[]{};
        }
        ArrayList l = new ArrayList();
        Collections.addAll(l, networks);
        this.setListAttribute("networks", l);
    }

    @Override
    public void setNetworkEnabled(String network, boolean enabled) {
        ArrayList<String> l;
        List values = this.getListAttributeSupport("networks");
        boolean alreadyEnabled = values.contains(network);
        if (enabled && !alreadyEnabled) {
            l = new ArrayList(values.size() + 1);
            l.addAll(values);
            l.add(network);
            this.setListAttribute("networks", l);
        }
        if (!enabled && alreadyEnabled) {
            l = new ArrayList<String>(values);
            l.remove(network);
            this.setListAttribute("networks", l);
        }
    }

    @Override
    public String[] getPeerSources() {
        List values = this.getListAttributeSupport("peersources");
        ArrayList<String> res = new ArrayList<String>();
        int i = 0;
        while (i < values.size()) {
            String ps = (String)values.get(i);
            int j = 0;
            while (j < PEPeerSource.PS_SOURCES.length) {
                String x = PEPeerSource.PS_SOURCES[j];
                if (x.equals(ps)) {
                    res.add(x);
                }
                ++j;
            }
            ++i;
        }
        String[] x = new String[res.size()];
        res.toArray(x);
        return x;
    }

    @Override
    public boolean isPeerSourceEnabled(String peerSource) {
        List values = this.getListAttributeSupport("peersources");
        return values.contains(peerSource);
    }

    @Override
    public boolean isPeerSourcePermitted(String peerSource) {
        if (peerSource.equals("DHT") && (TorrentUtils.getPrivate(this.torrent) || !TorrentUtils.getDHTBackupEnabled(this.torrent))) {
            return false;
        }
        if (peerSource.equals("PeerExchange") && TorrentUtils.getPrivate(this.torrent)) {
            return false;
        }
        List values = this.getListAttributeSupport("peersourcesdenied");
        return values == null || !values.contains(peerSource);
    }

    @Override
    public void setPeerSourcePermitted(String peerSource, boolean enabled) {
        ArrayList<String> values;
        if (!this.getFlag(32L)) {
            Logger.log(new LogEvent(this.torrent, LOGID, "Attempt to modify permitted peer sources denied as disabled '" + TorrentUtils.getLocalisedName(this.torrent) + "'"));
            return;
        }
        if (!enabled) {
            this.setPeerSourceEnabled(peerSource, false);
        }
        if ((values = this.getListAttributeSupport("peersourcesdenied")) == null) {
            if (!enabled) {
                values = new ArrayList<String>();
                values.add(peerSource);
                this.setListAttribute("peersourcesdenied", values);
            }
        } else {
            if (enabled) {
                values.remove(peerSource);
            } else if (!values.contains(peerSource)) {
                values.add(peerSource);
            }
            this.setListAttribute("peersourcesdenied", values);
        }
    }

    @Override
    public void setPeerSources(String[] ps) {
        if (ps == null) {
            ps = new String[]{};
        }
        ArrayList<String> l = new ArrayList<String>();
        int i = 0;
        while (i < ps.length) {
            String p = ps[i];
            if (this.isPeerSourcePermitted(p)) {
                l.add(ps[i]);
            }
            ++i;
        }
        this.setListAttribute("peersources", l);
    }

    @Override
    public void setPeerSourceEnabled(String source, boolean enabled) {
        ArrayList<String> l;
        if (enabled && !this.isPeerSourcePermitted(source)) {
            return;
        }
        List values = this.getListAttributeSupport("peersources");
        boolean alreadyEnabled = values.contains(source);
        if (enabled && !alreadyEnabled) {
            l = new ArrayList(values.size() + 1);
            l.addAll(values);
            l.add(source);
            this.setListAttribute("peersources", l);
        }
        if (!enabled && alreadyEnabled) {
            l = new ArrayList<String>(values);
            l.remove(source);
            this.setListAttribute("peersources", l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFileLink(int source_index, File link_source, File link_destination) {
        LinkFileMap links = this.getFileLinks();
        File existing = links.get(source_index, link_source);
        if (link_destination == null ? existing == null : existing != null && existing.getAbsolutePath().equals(link_destination.getAbsolutePath())) {
            return;
        }
        links.put(source_index, link_source, link_destination);
        ArrayList<String> list = new ArrayList<String>();
        Iterator<LinkFileMap.Entry> it = links.entryIterator();
        while (it.hasNext()) {
            LinkFileMap.Entry entry = it.next();
            int index = entry.getIndex();
            File source = entry.getFromFile();
            File target = entry.getToFile();
            String str = String.valueOf(index) + "\n" + source + "\n" + (target == null ? "" : target.toString());
            list.add(str);
        }
        DownloadManagerStateImpl downloadManagerStateImpl = this;
        synchronized (downloadManagerStateImpl) {
            this.file_link_cache = new WeakReference<LinkFileMap>(links);
        }
        this.setListAttribute("filelinks2", list);
        this.download_manager.informLocationChange(source_index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFileLinks(List<Integer> source_indexes, List<File> link_sources, List<File> link_destinations) {
        LinkFileMap links = this.getFileLinks();
        boolean changed = false;
        int i = 0;
        while (i < link_sources.size()) {
            int source_index = source_indexes.get(i);
            File link_source = link_sources.get(i);
            File link_destination = link_destinations.get(i);
            File existing = links.get(source_index, link_source);
            if (!(link_destination == null ? existing == null : existing != null && existing.getAbsolutePath().equals(link_destination.getAbsolutePath()))) {
                links.put(source_index, link_source, link_destination);
                changed = true;
            }
            ++i;
        }
        if (!changed) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        Iterator<LinkFileMap.Entry> it = links.entryIterator();
        while (it.hasNext()) {
            LinkFileMap.Entry entry = it.next();
            int index = entry.getIndex();
            File source = entry.getFromFile();
            File target = entry.getToFile();
            String str = String.valueOf(index) + "\n" + source + "\n" + (target == null ? "" : target.toString());
            list.add(str);
        }
        DownloadManagerStateImpl downloadManagerStateImpl = this;
        synchronized (downloadManagerStateImpl) {
            this.file_link_cache = new WeakReference<LinkFileMap>(links);
        }
        this.setListAttribute("filelinks2", list);
        this.download_manager.informLocationChange(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearFileLinks() {
        LinkFileMap links = this.getFileLinks();
        ArrayList<String> list = new ArrayList<String>();
        Iterator<LinkFileMap.Entry> it = links.entryIterator();
        boolean changed = false;
        while (it.hasNext()) {
            LinkFileMap.Entry entry = it.next();
            int index = entry.getIndex();
            File source = entry.getFromFile();
            File target = entry.getToFile();
            if (target != null) {
                changed = true;
            }
            String str = String.valueOf(index) + "\n" + source + "\n";
            list.add(str);
        }
        if (changed) {
            DownloadManagerStateImpl downloadManagerStateImpl = this;
            synchronized (downloadManagerStateImpl) {
                this.file_link_cache = null;
            }
            this.setListAttribute("filelinks2", list);
            this.download_manager.informLocationChange(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getFileLink(int source_index, File link_source) {
        LinkFileMap map = null;
        WeakReference<LinkFileMap> ref = this.file_link_cache;
        if (ref != null) {
            map = (LinkFileMap)ref.get();
        }
        if (map == null) {
            map = this.getFileLinks();
            DownloadManagerStateImpl downloadManagerStateImpl = this;
            synchronized (downloadManagerStateImpl) {
                this.file_link_cache = new WeakReference<LinkFileMap>(map);
            }
        }
        File res = map.get(source_index, link_source);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkFileMap getFileLinks() {
        LinkFileMap map = null;
        WeakReference<LinkFileMap> ref = this.file_link_cache;
        if (ref != null) {
            map = (LinkFileMap)ref.get();
        }
        if (map == null) {
            map = this.getFileLinksSupport();
            DownloadManagerStateImpl downloadManagerStateImpl = this;
            synchronized (downloadManagerStateImpl) {
                this.file_link_cache = new WeakReference<LinkFileMap>(map);
            }
        }
        return map;
    }

    private LinkFileMap getFileLinksSupport() {
        LinkFileMap res = new LinkFileMap();
        List new_values = this.getListAttributeSupport("filelinks2");
        if (new_values.size() > 0) {
            int i = 0;
            while (i < new_values.size()) {
                String entry = (String)new_values.get(i);
                String[] bits = entry.split("\n");
                if (bits.length >= 2) {
                    try {
                        File target;
                        int index = Integer.parseInt(bits[0].trim());
                        File source = FileUtil.newFile(bits[1], new String[0]);
                        File file = target = bits.length < 3 ? null : FileUtil.newFile(bits[2], new String[0]);
                        if (index >= 0) {
                            res.put(index, source, target);
                        } else {
                            res.putMigration(source, target);
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                ++i;
            }
        } else {
            List old_values = this.getListAttributeSupport("filelinks");
            int i = 0;
            while (i < old_values.size()) {
                String entry = (String)old_values.get(i);
                int sep = entry.indexOf("\n");
                if (sep != -1) {
                    File target = sep == entry.length() - 1 ? null : FileUtil.newFile(entry.substring(sep + 1), new String[0]);
                    res.putMigration(FileUtil.newFile(entry.substring(0, sep), new String[0]), target);
                }
                ++i;
            }
        }
        return res;
    }

    @Override
    public int getFileFlags(int file_index) {
        Map map = this.getMapAttribute("ff");
        if (map == null) {
            return 0;
        }
        String key = String.valueOf(file_index);
        Number result = (Number)map.get(key);
        return result == null ? 0 : result.intValue();
    }

    @Override
    public void setFileFlags(int file_index, int flags) {
        Map<String, Integer> map = this.getMapAttribute("ff");
        map = map == null ? new HashMap<String, Integer>() : BEncoder.cloneMap(map);
        String key = String.valueOf(file_index);
        if (flags == 0) {
            map.remove(key);
            if (map.isEmpty()) {
                map = null;
            }
        } else {
            map.put(key, flags);
        }
        this.setMapAttribute("ff", map);
    }

    @Override
    public boolean isOurContent() {
        Map mapAttr = this.getMapAttribute("Plugin.azdirector.ContentMap");
        return mapAttr != null && mapAttr.containsKey("DIRECTOR PUBLISH");
    }

    protected String getStringAttribute(String attribute_name) {
        this.informWillRead(attribute_name);
        try {
            this.this_mon.enter();
            if (!(this.attributes.get(attribute_name) instanceof byte[])) {
                return null;
            }
            byte[] bytes = (byte[])this.attributes.get(attribute_name);
            if (bytes == null) {
                return null;
            }
            String string = new String(bytes, Constants.DEFAULT_ENCODING_CHARSET);
            return string;
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void setStringAttribute(String attribute_name, String attribute_value, boolean set_dirty) {
        boolean changed = false;
        try {
            this.this_mon.enter();
            if (attribute_value == null) {
                if (this.attributes.containsKey(attribute_name)) {
                    this.attributes.remove(attribute_name);
                    changed = true;
                    if (set_dirty) {
                        this.setDirty(attribute_name == "agsc");
                    }
                }
            } else {
                byte[] existing_bytes = (byte[])this.attributes.get(attribute_name);
                byte[] new_bytes = attribute_value.getBytes(Constants.DEFAULT_ENCODING_CHARSET);
                if (existing_bytes == null || !Arrays.equals(existing_bytes, new_bytes)) {
                    this.attributes.put(attribute_name, new_bytes);
                    changed = true;
                    if (set_dirty) {
                        this.setDirty(attribute_name == "agsc");
                    }
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
        if (changed) {
            this.informWritten(attribute_name);
        }
    }

    @Override
    public long getLongAttribute(String attribute_name) {
        this.informWillRead(attribute_name);
        try {
            this.this_mon.enter();
            Long l = (Long)this.attributes.get(attribute_name);
            if (l == null) {
                Object def = default_attributes.get(attribute_name);
                if (def != null) {
                    if (def instanceof Long) {
                        long l2 = (Long)def;
                        return l2;
                    }
                    if (def instanceof Integer) {
                        long l3 = ((Integer)def).longValue();
                        return l3;
                    }
                    Debug.out("unknown default type " + def);
                } else if (attribute_name == "file.expand") {
                    boolean featured = TorrentUtils.isFeaturedContent(this.torrent);
                    long res = featured ? 1 : 0;
                    this.attributes.put(attribute_name, new Long(res));
                    this.setDirty(false);
                    long l4 = res;
                    return l4;
                }
                return 0L;
            }
            long l5 = l;
            return l5;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void setLongAttribute(String attribute_name, long attribute_value) {
        boolean changed = false;
        try {
            this.this_mon.enter();
            Long existing_value = (Long)this.attributes.get(attribute_name);
            if (existing_value == null || existing_value != attribute_value) {
                boolean is_scrape_cache;
                this.attributes.put(attribute_name, new Long(attribute_value));
                changed = true;
                boolean set_dirty = true;
                boolean bl = is_scrape_cache = attribute_name == "scrapecache";
                if (is_scrape_cache && this.download_manager.getGlobalManager().isStopping() && this.download_manager.getState() == 70) {
                    set_dirty = false;
                }
                if (set_dirty) {
                    this.setDirty(is_scrape_cache);
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
        if (changed) {
            this.informWritten(attribute_name);
        }
    }

    @Override
    public void setListAttribute(String name, String[] values) {
        List<Object> list = values == null ? null : Arrays.asList((Object[])values.clone());
        this.setListAttribute(name, list);
    }

    @Override
    public String getListAttribute(String name, int idx) {
        if (name.equals("networks") || name.equals("peersources")) {
            throw new UnsupportedOperationException("not supported right now, implement it yourself :P");
        }
        this.informWillRead(name);
        try {
            this.this_mon.enter();
            List values = (List)this.attributes.get(name);
            if (values == null || idx >= values.size() || idx < 0) {
                return null;
            }
            Object o = values.get(idx);
            if (o instanceof byte[]) {
                byte[] bytes = (byte[])o;
                String s = StringInterner.intern(new String(bytes, Constants.DEFAULT_ENCODING_CHARSET));
                values.set(idx, s);
                String string = s;
                return string;
            }
            if (o instanceof String) {
                String string = (String)o;
                return string;
            }
        }
        finally {
            this.this_mon.exit();
        }
        return null;
    }

    @Override
    public String[] getListAttribute(String attribute_name) {
        if (attribute_name == "networks") {
            return this.getNetworks();
        }
        if (attribute_name == "peersources") {
            return this.getPeerSources();
        }
        List l = this.getListAttributeSupport(attribute_name);
        if (l == null) {
            return null;
        }
        String[] res = new String[l.size()];
        try {
            res = l.toArray(res);
        }
        catch (ArrayStoreException e) {
            Debug.out("getListAttribute( " + attribute_name + ") - object isnt String - " + e);
            return null;
        }
        return res;
    }

    protected List getListAttributeSupport(String attribute_name) {
        this.informWillRead(attribute_name);
        try {
            this.this_mon.enter();
            List values = (List)this.attributes.get(attribute_name);
            ArrayList<String> res = new ArrayList<String>(values != null ? values.size() : 0);
            if (values != null) {
                int i = 0;
                while (i < values.size()) {
                    Object o = values.get(i);
                    if (o instanceof byte[]) {
                        byte[] bytes = (byte[])o;
                        String s = StringInterner.intern(new String(bytes, Constants.DEFAULT_ENCODING_CHARSET));
                        res.add(s);
                        values.set(i, s);
                    } else if (o instanceof String) {
                        res.add((String)o);
                    }
                    ++i;
                }
            }
            ArrayList<String> arrayList = res;
            return arrayList;
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void setListAttribute(String attribute_name, List attribute_value) {
        boolean changed = false;
        try {
            this.this_mon.enter();
            if (attribute_value == null) {
                if (this.attributes.containsKey(attribute_name)) {
                    this.attributes.remove(attribute_name);
                    changed = true;
                    this.setDirty(false);
                }
            } else {
                List old_value = this.getListAttributeSupport(attribute_name);
                if (old_value == null || old_value.size() != attribute_value.size()) {
                    this.attributes.put(attribute_name, attribute_value);
                    changed = true;
                    this.setDirty(false);
                } else {
                    if (old_value == attribute_value) {
                        Debug.out("setListAttribute: should clone?");
                    }
                    boolean bl = changed = !BEncoder.listsAreIdentical(old_value, attribute_value);
                    if (changed) {
                        this.setDirty(false);
                        this.attributes.put(attribute_name, attribute_value);
                    }
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
        if (changed) {
            this.informWritten(attribute_name);
        }
    }

    @Override
    public Map getMapAttribute(String attribute_name) {
        this.informWillRead(attribute_name);
        try {
            Map value;
            this.this_mon.enter();
            Map map = value = (Map)this.attributes.get(attribute_name);
            return map;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void setMapAttribute(String attribute_name, Map attribute_value) {
        this.setMapAttribute(attribute_name, attribute_value, false);
    }

    protected void setMapAttribute(String attribute_name, Map attribute_value, boolean disable_change_notification) {
        boolean changed = false;
        try {
            this.this_mon.enter();
            if (attribute_value == null) {
                if (this.attributes.containsKey(attribute_name)) {
                    this.attributes.remove(attribute_name);
                    changed = true;
                    this.setDirty(false);
                }
            } else {
                Map old_value = this.getMapAttribute(attribute_name);
                if (old_value == null || old_value.size() != attribute_value.size()) {
                    this.attributes.put(attribute_name, attribute_value);
                    changed = true;
                    this.setDirty(false);
                } else {
                    if (old_value == attribute_value) {
                        Debug.out("setMapAttribute: should clone?");
                    }
                    boolean bl = changed = !BEncoder.mapsAreIdentical(old_value, attribute_value);
                    if (changed) {
                        this.setDirty(false);
                        this.attributes.put(attribute_name, attribute_value);
                    }
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
        if (changed && !disable_change_notification) {
            this.informWritten(attribute_name);
        }
    }

    @Override
    public boolean hasAttribute(String name) {
        try {
            this.this_mon.enter();
            if (this.attributes == null) {
                return false;
            }
            boolean bl = this.attributes.containsKey(name);
            return bl;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void removeAttribute(String attribute_name) {
        boolean changed = false;
        try {
            this.this_mon.enter();
            if (this.attributes != null && this.attributes.remove(attribute_name) != null) {
                changed = true;
            }
        }
        finally {
            this.this_mon.exit();
        }
        if (changed) {
            this.informWritten(attribute_name);
        }
    }

    @Override
    public void setIntAttribute(String name, int value) {
        this.setLongAttribute(name, value);
    }

    @Override
    public int getIntAttribute(String name) {
        return (int)this.getLongAttribute(name);
    }

    @Override
    public void setBooleanAttribute(String name, boolean value) {
        this.setLongAttribute(name, value ? 1 : 0);
    }

    @Override
    public boolean getBooleanAttribute(String name) {
        return this.getLongAttribute(name) != 0L;
    }

    public static DownloadManagerState getDownloadState(DownloadManager dm) {
        return new nullState(dm);
    }

    protected void informWritten(String attribute_name) {
        ArrayList<CopyOnWriteList<DownloadManagerStateAttributeListener>> list = new ArrayList<CopyOnWriteList<DownloadManagerStateAttributeListener>>();
        list.add(global_listeners_write_map_cow.get(attribute_name));
        list.add(global_listeners_write_map_cow.get(null));
        list.add(this.listeners_write_map_cow.get(attribute_name));
        list.add(this.listeners_write_map_cow.get(null));
        for (CopyOnWriteList copyOnWriteList : list) {
            if (copyOnWriteList == null) continue;
            for (DownloadManagerStateAttributeListener l : copyOnWriteList.getList()) {
                try {
                    l.attributeEventOccurred(this.download_manager, attribute_name, 1);
                }
                catch (Throwable t) {
                    Debug.printStackTrace(t);
                }
            }
        }
    }

    protected void informWillRead(String attribute_name) {
        List will_be_read_list = (List)tls_wbr.get();
        if (!will_be_read_list.contains(attribute_name)) {
            will_be_read_list.add(attribute_name);
            try {
                ArrayList<CopyOnWriteList<DownloadManagerStateAttributeListener>> list = new ArrayList<CopyOnWriteList<DownloadManagerStateAttributeListener>>();
                list.add(global_listeners_read_map_cow.get(attribute_name));
                list.add(global_listeners_read_map_cow.get(null));
                list.add(this.listeners_read_map_cow.get(attribute_name));
                list.add(this.listeners_read_map_cow.get(null));
                for (CopyOnWriteList copyOnWriteList : list) {
                    if (copyOnWriteList == null) continue;
                    for (DownloadManagerStateAttributeListener l : copyOnWriteList.getList()) {
                        try {
                            l.attributeEventOccurred(this.download_manager, attribute_name, 2);
                        }
                        catch (Throwable t) {
                            Debug.printStackTrace(t);
                        }
                    }
                }
            }
            finally {
                will_be_read_list.remove(attribute_name);
            }
        }
    }

    @Override
    public void addListener(DownloadManagerStateAttributeListener l, String attribute, int event_type) {
        CopyOnWriteMap<String, CopyOnWriteList<DownloadManagerStateAttributeListener>> map_to_use = event_type == 2 ? this.listeners_read_map_cow : this.listeners_write_map_cow;
        CopyOnWriteList<DownloadManagerStateAttributeListener> lst = map_to_use.get(attribute);
        if (lst == null) {
            lst = new CopyOnWriteList();
            map_to_use.put(attribute, lst);
        }
        lst.add(l);
    }

    @Override
    public void removeListener(DownloadManagerStateAttributeListener l, String attribute, int event_type) {
        CopyOnWriteMap<String, CopyOnWriteList<DownloadManagerStateAttributeListener>> map_to_use = event_type == 2 ? this.listeners_read_map_cow : this.listeners_write_map_cow;
        CopyOnWriteList<DownloadManagerStateAttributeListener> lst = map_to_use.get(attribute);
        if (lst != null) {
            lst.remove(l);
        }
    }

    public static void addGlobalListener(DownloadManagerStateAttributeListener l, String attribute, int event_type) {
        CopyOnWriteMap<String, CopyOnWriteList<DownloadManagerStateAttributeListener>> map_to_use = event_type == 2 ? global_listeners_read_map_cow : global_listeners_write_map_cow;
        CopyOnWriteList<DownloadManagerStateAttributeListener> lst = map_to_use.get(attribute);
        if (lst == null) {
            lst = new CopyOnWriteList();
            map_to_use.put(attribute, lst);
        }
        lst.add(l);
    }

    public static void removeGlobalListener(DownloadManagerStateAttributeListener l, String attribute, int event_type) {
        CopyOnWriteMap<String, CopyOnWriteList<DownloadManagerStateAttributeListener>> map_to_use = event_type == 2 ? global_listeners_read_map_cow : global_listeners_write_map_cow;
        CopyOnWriteList<DownloadManagerStateAttributeListener> lst = map_to_use.get(attribute);
        if (lst != null) {
            lst.remove(l);
        }
    }

    @Override
    public void generateEvidence(IndentWriter writer) {
        writer.println("DownloadManagerState");
        try {
            writer.indent();
            writer.println("parameters=" + this.parameters);
            writer.println("flags=" + this.getFlags());
            DiskManagerFileInfo primaryFile = this.getPrimaryFile();
            if (primaryFile != null) {
                writer.println("primary file=" + Debug.secretFileName(primaryFile.getFile(true).getAbsolutePath()));
            }
        }
        finally {
            writer.exdent();
        }
    }

    @Override
    public void dump(IndentWriter writer) {
        writer.println("attributes: " + this.parameters);
    }

    protected static class CachedStateWrapper
    extends LogRelation
    implements TorrentUtils.ExtendedTorrent {
        final DownloadManagerImpl download_manager;
        final String torrent_file;
        HashWrapper torrent_hash_wrapper;
        Map cache;
        Map cache_attributes;
        Map cache_azp;
        Map cache_azpp;
        volatile TorrentUtils.ExtendedTorrent delegate;
        TOTorrentException fixup_failure;
        boolean discard_pieces;
        boolean logged_failure;
        Integer torrent_type;
        Boolean simple_torrent;
        long size;
        Boolean is_private;
        int file_count;
        URL announce_url;
        cacheGroup announce_group;
        List<TOTorrentListener> pending_listeners;
        volatile boolean discard_fluff;

        protected CachedStateWrapper(DownloadManagerImpl _download_manager, String _torrent_file, byte[] _torrent_hash, Map _cache, boolean _force_piece_discard) {
            List ag;
            byte[] au;
            Long l_priv;
            Long l_size;
            Long fc;
            Long st;
            this.download_manager = _download_manager;
            this.torrent_file = _torrent_file;
            this.torrent_hash_wrapper = new HashWrapper(_torrent_hash);
            this.cache = _cache;
            this.cache_attributes = (Map)this.cache.get(DownloadManagerStateImpl.ATTRIBUTE_KEY);
            this.cache_azp = (Map)this.cache.get("azp");
            this.cache_azpp = (Map)this.cache.get("azpp");
            if (_force_piece_discard) {
                this.discard_pieces = true;
            } else {
                Long l_fp = (Long)this.cache.get("dp");
                if (l_fp != null) {
                    this.discard_pieces = l_fp == 1L;
                }
            }
            Long tt = (Long)this.cache.get("tt");
            if (tt != null) {
                this.torrent_type = tt.intValue();
            }
            if ((st = (Long)this.cache.get("simple")) != null) {
                this.simple_torrent = st == 1L;
            }
            if ((fc = (Long)this.cache.get("fc")) != null) {
                this.file_count = fc.intValue();
            }
            if ((l_size = (Long)this.cache.get("size")) != null) {
                this.size = l_size;
            }
            if ((l_priv = (Long)this.cache.get("priv")) != null) {
                this.is_private = l_priv != 0L;
            }
            if ((au = (byte[])this.cache.get("au")) != null) {
                try {
                    this.announce_url = StringInterner.internURL(new URL(new String(au, "UTF-8")));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if ((ag = (List)this.cache.get("ag")) != null) {
                try {
                    this.announce_group = this.importGroup(ag);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        protected static Map export(DownloadManagerState dms) throws TOTorrentException {
            HashMap<String, Object> cache = new HashMap<String, Object>();
            TOTorrent state = dms.getTorrent();
            cache.put("hash", state.getHash());
            cache.put("name", state.getName());
            cache.put("utf8name", state.getUTF8Name() == null ? "" : state.getUTF8Name());
            cache.put("comment", state.getComment());
            cache.put("createdby", state.getCreatedBy());
            cache.put("size", new Long(state.getSize()));
            cache.put("priv", new Long(state.getPrivate() ? 1 : 0));
            cache.put("encoding", state.getAdditionalStringProperty("encoding"));
            cache.put("torrent filename", state.getAdditionalStringProperty("torrent filename"));
            cache.put(DownloadManagerStateImpl.ATTRIBUTE_KEY, state.getAdditionalMapProperty(DownloadManagerStateImpl.ATTRIBUTE_KEY));
            cache.put("azp", state.getAdditionalMapProperty(DownloadManagerStateImpl.AZUREUS_PROPERTIES_KEY));
            cache.put("azpp", state.getAdditionalMapProperty(DownloadManagerStateImpl.AZUREUS_PRIVATE_PROPERTIES_KEY));
            try {
                cache.put("au", state.getAnnounceURL().toExternalForm());
                cache.put("ag", CachedStateWrapper.exportGroup(state.getAnnounceURLGroup()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            boolean discard_pieces = dms.isResumeDataComplete();
            TOTorrent t = dms.getTorrent();
            if (t instanceof CachedStateWrapper) {
                Integer tt;
                Boolean simple_torrent;
                CachedStateWrapper csw = (CachedStateWrapper)t;
                if (!discard_pieces) {
                    boolean bl = discard_pieces = csw.peekPieces() == null;
                }
                if ((simple_torrent = csw.simple_torrent) != null) {
                    cache.put("simple", new Long(simple_torrent != false ? 1 : 0));
                } else {
                    Debug.out("Failed to cache simple state");
                }
                int fc = csw.file_count;
                if (fc > 0) {
                    cache.put("fc", new Long(fc));
                }
                if ((tt = csw.torrent_type) != null) {
                    cache.put("tt", new Long(tt.intValue()));
                } else {
                    Debug.out("Failed to cache torrent type");
                }
            } else if (t instanceof TorrentUtils.torrentDelegate) {
                cache.put("simple", new Long(t.isSimpleTorrent() ? 1 : 0));
                cache.put("fc", t.getFileCount());
                cache.put("tt", new Long(t.getTorrentType()));
            } else {
                Debug.out("Hmm, torrent isn't cache-state-wrapper, it is " + t);
            }
            cache.put("dp", new Long(discard_pieces ? 1 : 0));
            return cache;
        }

        protected static List exportGroup(TOTorrentAnnounceURLGroup group) {
            TOTorrentAnnounceURLSet[] sets = group.getAnnounceURLSets();
            ArrayList result = new ArrayList();
            int i = 0;
            while (i < sets.length) {
                TOTorrentAnnounceURLSet set = sets[i];
                URL[] urls = set.getAnnounceURLs();
                if (urls.length > 0) {
                    ArrayList<String> s = new ArrayList<String>(urls.length);
                    int j = 0;
                    while (j < urls.length) {
                        s.add(urls[j].toExternalForm());
                        ++j;
                    }
                    result.add(s);
                }
                ++i;
            }
            return result;
        }

        protected cacheGroup importGroup(List l) throws Exception {
            return new cacheGroup(l);
        }

        protected void clearCache() {
            this.cache = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean fixup() {
            try {
                if (this.delegate == null) {
                    CachedStateWrapper cachedStateWrapper = this;
                    synchronized (cachedStateWrapper) {
                        if (this.delegate == null) {
                            if (this.fixup_failure != null) {
                                throw this.fixup_failure;
                            }
                            this.delegate = this.loadRealState();
                            if (this.discard_fluff) {
                                this.delegate.setDiscardFluff(this.discard_fluff);
                            }
                            if (this.cache != null) {
                                Debug.out("Cache miss forced fixup");
                            }
                            this.cache = null;
                            if (this.cache_attributes != null) {
                                this.delegate.setAdditionalMapProperty(DownloadManagerStateImpl.ATTRIBUTE_KEY, this.cache_attributes);
                                this.cache_attributes = null;
                            }
                            if (this.cache_azp != null) {
                                this.delegate.setAdditionalMapProperty(DownloadManagerStateImpl.AZUREUS_PROPERTIES_KEY, this.cache_azp);
                                this.cache_azp = null;
                            }
                            if (this.cache_azpp != null) {
                                this.delegate.setAdditionalMapProperty(DownloadManagerStateImpl.AZUREUS_PRIVATE_PROPERTIES_KEY, this.cache_azpp);
                                this.cache_azpp = null;
                            }
                            this.announce_url = null;
                            if (this.announce_group != null) {
                                this.announce_group.fixGroup();
                                this.announce_group = null;
                            }
                            if (this.pending_listeners != null) {
                                for (TOTorrentListener l : this.pending_listeners) {
                                    this.delegate.addListener(l);
                                }
                                this.pending_listeners = null;
                            }
                        }
                    }
                }
                return true;
            }
            catch (TOTorrentException e) {
                this.fixup_failure = e;
                if (this.download_manager != null) {
                    this.download_manager.setTorrentInvalid(e);
                } else if (!this.logged_failure) {
                    this.logged_failure = true;
                    Debug.out("Torrent can't be loaded: " + Debug.getNestedExceptionMessage(e));
                }
                return false;
            }
        }

        protected TorrentUtils.ExtendedTorrent loadRealState() throws TOTorrentException {
            File saved_file;
            if (!SUPPRESS_FIXUP_ERRORS && Constants.isCVSVersion() && !Thread.currentThread().isDaemon()) {
                Debug.outNoStack(Debug.getCompressedStackTrace(new Exception(){

                    @Override
                    public String toString() {
                        return "Premature fixup?";
                    }
                }, 2, 10, true), true);
            }
            if ((saved_file = DownloadManagerStateImpl.getStateFile(this.torrent_hash_wrapper.getBytes())).exists()) {
                try {
                    return TorrentUtils.readDelegateFromFile(saved_file, this.discard_pieces);
                }
                catch (Throwable e) {
                    Debug.out("Failed to load download state for " + saved_file);
                }
            }
            TOTorrent original_torrent = TorrentUtils.readFromFile(FileUtil.newFile(this.torrent_file, new String[0]), true);
            this.torrent_hash_wrapper = original_torrent.getHashWrapper();
            saved_file = DownloadManagerStateImpl.getStateFile(this.torrent_hash_wrapper.getBytes());
            boolean was_corrupt = false;
            if (saved_file.exists()) {
                try {
                    return TorrentUtils.readDelegateFromFile(saved_file, this.discard_pieces);
                }
                catch (Throwable e) {
                    was_corrupt = true;
                    Debug.out("Failed to load download state for " + saved_file);
                }
            }
            DownloadManagerStateImpl.copyTorrentToActive(original_torrent, saved_file, was_corrupt);
            if (was_corrupt && this.download_manager != null) {
                this.download_manager.setFailed("Recovered from original torrent");
            }
            return TorrentUtils.readDelegateFromFile(saved_file, this.discard_pieces);
        }

        @Override
        public byte[] getName() {
            byte[] name;
            Map c = this.cache;
            if (c != null && (name = (byte[])c.get("name")) != null) {
                return name;
            }
            if (this.fixup()) {
                return this.delegate.getName();
            }
            return ("Error - " + Debug.getNestedExceptionMessage(this.fixup_failure)).getBytes();
        }

        @Override
        public String getUTF8Name() {
            byte[] name;
            Map c = this.cache;
            if (c != null && (name = (byte[])c.get("utf8name")) != null) {
                String utf8name;
                try {
                    utf8name = new String(name, "utf8");
                }
                catch (UnsupportedEncodingException e) {
                    return null;
                }
                if (utf8name.length() == 0) {
                    return null;
                }
                return utf8name;
            }
            if (this.fixup()) {
                return this.delegate.getUTF8Name();
            }
            return null;
        }

        @Override
        public int getTorrentType() {
            if (this.torrent_type != null) {
                return this.torrent_type;
            }
            if (this.fixup()) {
                int tt = this.delegate.getTorrentType();
                this.torrent_type = tt;
                return tt;
            }
            return 1;
        }

        @Override
        public boolean isExportable() {
            if (this.fixup()) {
                return this.delegate.isExportable();
            }
            return false;
        }

        @Override
        public boolean updateExportability(TOTorrent from) {
            if (this.fixup()) {
                return this.delegate.updateExportability(from);
            }
            return false;
        }

        @Override
        public boolean isSimpleTorrent() {
            if (this.simple_torrent != null) {
                return this.simple_torrent;
            }
            if (this.fixup()) {
                boolean st = this.delegate.isSimpleTorrent();
                this.simple_torrent = st;
                return st;
            }
            return false;
        }

        @Override
        public byte[] getComment() {
            Map c = this.cache;
            if (c != null) {
                return (byte[])c.get("comment");
            }
            if (this.fixup()) {
                return this.delegate.getComment();
            }
            return null;
        }

        @Override
        public void setComment(String comment) {
            if (this.fixup()) {
                this.delegate.setComment(comment);
            }
        }

        @Override
        public long getCreationDate() {
            if (this.fixup()) {
                return this.delegate.getCreationDate();
            }
            return 0L;
        }

        @Override
        public void setCreationDate(long date) {
            if (this.fixup()) {
                this.delegate.setCreationDate(date);
            }
        }

        @Override
        public byte[] getCreatedBy() {
            Map c = this.cache;
            if (c != null) {
                return (byte[])c.get("createdby");
            }
            if (this.fixup()) {
                return this.delegate.getCreatedBy();
            }
            return null;
        }

        @Override
        public void setCreatedBy(byte[] cb) {
            if (this.fixup()) {
                this.delegate.setCreatedBy(cb);
            }
        }

        @Override
        public boolean isCreated() {
            if (this.fixup()) {
                return this.delegate.isCreated();
            }
            return false;
        }

        @Override
        public boolean isDecentralised() {
            return TorrentUtils.isDecentralised(this.getAnnounceURL());
        }

        @Override
        public URL getAnnounceURL() {
            if (this.announce_url != null) {
                return this.announce_url;
            }
            if (this.fixup()) {
                return this.delegate.getAnnounceURL();
            }
            return null;
        }

        @Override
        public boolean setAnnounceURL(URL url) {
            if (this.announce_url != null && this.announce_url.toExternalForm().equals(url.toExternalForm())) {
                return false;
            }
            if (this.fixup()) {
                return this.delegate.setAnnounceURL(url);
            }
            this.announce_url = url;
            return false;
        }

        @Override
        public TOTorrentAnnounceURLGroup getAnnounceURLGroup() {
            if (this.announce_group != null) {
                return this.announce_group;
            }
            if (this.fixup()) {
                return this.delegate.getAnnounceURLGroup();
            }
            return null;
        }

        @Override
        public byte[][] getPieces() throws TOTorrentException {
            if (this.fixup()) {
                return this.delegate.getPieces();
            }
            throw this.fixup_failure;
        }

        @Override
        public void setPieces(byte[][] pieces) throws TOTorrentException {
            if (this.fixup()) {
                this.delegate.setPieces(pieces);
                return;
            }
            throw this.fixup_failure;
        }

        @Override
        public byte[][] peekPieces() throws TOTorrentException {
            if (this.fixup()) {
                return this.delegate.peekPieces();
            }
            throw this.fixup_failure;
        }

        @Override
        public void setDiscardFluff(boolean discard) {
            this.discard_fluff = discard;
            if (this.delegate != null) {
                this.delegate.setDiscardFluff(this.discard_fluff);
            }
        }

        @Override
        public long getPieceLength() {
            if (this.fixup()) {
                return this.delegate.getPieceLength();
            }
            return 0L;
        }

        @Override
        public int getNumberOfPieces() {
            if (this.fixup()) {
                return this.delegate.getNumberOfPieces();
            }
            return 0;
        }

        @Override
        public long getSize() {
            if (this.size > 0L) {
                return this.size;
            }
            if (this.fixup()) {
                this.size = this.delegate.getSize();
                return this.size;
            }
            return 0L;
        }

        @Override
        public int getFileCount() {
            if (this.file_count == 0 && this.fixup()) {
                this.file_count = this.delegate.getFileCount();
            }
            return this.file_count;
        }

        @Override
        public TOTorrentFile[] getFiles() {
            if (this.fixup()) {
                return this.delegate.getFiles();
            }
            return new TOTorrentFile[0];
        }

        @Override
        public byte[] getHash() throws TOTorrentException {
            return this.torrent_hash_wrapper.getBytes();
        }

        @Override
        public byte[] getFullHash(int type) throws TOTorrentException {
            if (this.fixup()) {
                return this.delegate.getFullHash(type);
            }
            return null;
        }

        @Override
        public HashWrapper getHashWrapper() throws TOTorrentException {
            return this.torrent_hash_wrapper;
        }

        @Override
        public TOTorrent selectHybridHashType(int type) throws TOTorrentException {
            if (this.fixup()) {
                return this.delegate.selectHybridHashType(type);
            }
            throw new TOTorrentException("fixup failed", 10);
        }

        @Override
        public void setHashOverride(byte[] hash) throws TOTorrentException {
            throw new TOTorrentException("Not supported", 8);
        }

        @Override
        public boolean hasSameHashAs(TOTorrent other) {
            try {
                byte[] other_hash = other.getHash();
                return Arrays.equals(this.getHash(), other_hash);
            }
            catch (TOTorrentException e) {
                Debug.printStackTrace(e);
                return false;
            }
        }

        @Override
        public boolean getPrivate() {
            if (this.is_private == null) {
                if (this.fixup()) {
                    return this.delegate.getPrivate();
                }
                return false;
            }
            return this.is_private;
        }

        @Override
        public void setPrivate(boolean _private) throws TOTorrentException {
            this.is_private = null;
            if (this.fixup()) {
                this.delegate.setPrivate(_private);
            }
        }

        @Override
        public String getSource() {
            if (this.fixup()) {
                return this.delegate.getSource();
            }
            return null;
        }

        @Override
        public void setSource(String str) throws TOTorrentException {
            if (this.fixup()) {
                this.delegate.setSource(str);
            }
        }

        @Override
        public void setAdditionalStringProperty(String name, String value) {
            if (this.fixup()) {
                this.delegate.setAdditionalStringProperty(name, value);
            }
        }

        @Override
        public String getAdditionalStringProperty(String name) {
            Map c = this.cache;
            if (c != null && (name.equals("encoding") || name.equals("torrent filename"))) {
                byte[] res = (byte[])c.get(name);
                if (res == null) {
                    return null;
                }
                try {
                    return new String(res, "UTF8");
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    return null;
                }
            }
            if (this.fixup()) {
                return this.delegate.getAdditionalStringProperty(name);
            }
            return null;
        }

        @Override
        public void setAdditionalByteArrayProperty(String name, byte[] value) {
            if (this.fixup()) {
                this.delegate.setAdditionalByteArrayProperty(name, value);
            }
        }

        @Override
        public byte[] getAdditionalByteArrayProperty(String name) {
            if (this.fixup()) {
                return this.delegate.getAdditionalByteArrayProperty(name);
            }
            return null;
        }

        @Override
        public void setAdditionalLongProperty(String name, Long value) {
            if (this.fixup()) {
                this.delegate.setAdditionalLongProperty(name, value);
            }
        }

        @Override
        public Long getAdditionalLongProperty(String name) {
            if (this.fixup()) {
                return this.delegate.getAdditionalLongProperty(name);
            }
            return null;
        }

        @Override
        public void setAdditionalListProperty(String name, List value) {
            if (this.fixup()) {
                this.delegate.setAdditionalListProperty(name, value);
            }
        }

        @Override
        public List getAdditionalListProperty(String name) {
            if (this.fixup()) {
                return this.delegate.getAdditionalListProperty(name);
            }
            return null;
        }

        @Override
        public void setAdditionalMapProperty(String name, Map value) {
            if (this.fixup()) {
                this.delegate.setAdditionalMapProperty(name, value);
            }
        }

        @Override
        public Map getAdditionalMapProperty(String name) {
            Map c = this.cache_attributes;
            if (c != null && name.equals(DownloadManagerStateImpl.ATTRIBUTE_KEY)) {
                return c;
            }
            c = this.cache_azp;
            if (c != null && name.equals(DownloadManagerStateImpl.AZUREUS_PROPERTIES_KEY)) {
                return c;
            }
            c = this.cache_azpp;
            if (c != null && name.equals(DownloadManagerStateImpl.AZUREUS_PRIVATE_PROPERTIES_KEY)) {
                return c;
            }
            if (this.fixup()) {
                return this.delegate.getAdditionalMapProperty(name);
            }
            return null;
        }

        @Override
        public Object getAdditionalProperty(String name) {
            if (this.fixup()) {
                return this.delegate.getAdditionalProperty(name);
            }
            return null;
        }

        @Override
        public void setAdditionalProperty(String name, Object value) {
            if (this.fixup()) {
                this.delegate.setAdditionalProperty(name, value);
            }
        }

        @Override
        public void removeAdditionalProperty(String name) {
            if (this.fixup()) {
                this.delegate.removeAdditionalProperty(name);
            }
        }

        @Override
        public void removeAdditionalProperties() {
            if (this.fixup()) {
                this.delegate.removeAdditionalProperties();
            }
        }

        @Override
        public void serialiseToBEncodedFile(File file) throws TOTorrentException {
            if (this.fixup()) {
                this.delegate.serialiseToBEncodedFile(file);
                return;
            }
            throw this.fixup_failure;
        }

        @Override
        public Map serialiseToMap() throws TOTorrentException {
            if (this.fixup()) {
                return this.delegate.serialiseToMap();
            }
            throw this.fixup_failure;
        }

        @Override
        public void serialiseToXMLFile(File file) throws TOTorrentException {
            if (this.fixup()) {
                this.delegate.serialiseToXMLFile(file);
                return;
            }
            throw this.fixup_failure;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addListener(TOTorrentListener l) {
            CachedStateWrapper cachedStateWrapper = this;
            synchronized (cachedStateWrapper) {
                if (this.delegate != null) {
                    this.delegate.addListener(l);
                } else {
                    if (this.pending_listeners == null) {
                        this.pending_listeners = new ArrayList<TOTorrentListener>(2);
                    }
                    this.pending_listeners.add(l);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeListener(TOTorrentListener l) {
            CachedStateWrapper cachedStateWrapper = this;
            synchronized (cachedStateWrapper) {
                if (this.delegate != null) {
                    this.delegate.removeListener(l);
                } else if (this.pending_listeners != null) {
                    this.pending_listeners.remove(l);
                }
            }
        }

        @Override
        public AEMonitor getMonitor() {
            if (this.fixup()) {
                return this.delegate.getMonitor();
            }
            return null;
        }

        @Override
        public void print() {
            if (this.fixup()) {
                this.delegate.print();
            }
        }

        @Override
        public String getRelationText() {
            return "Torrent: '" + new String(this.getName()) + "'";
        }

        @Override
        public Object[] getQueryableInterfaces() {
            try {
                return new Object[]{CoreFactory.getSingleton().getGlobalManager().getDownloadManager(this)};
            }
            catch (Exception exception) {
                return null;
            }
        }

        protected class cacheGroup
        implements TOTorrentAnnounceURLGroup {
            private TOTorrentAnnounceURLSet[] sets;
            private volatile long uid = TorrentUtils.getAnnounceGroupUID();

            protected cacheGroup(List group) throws Exception {
                this.sets = new TOTorrentAnnounceURLSet[group.size()];
                int i = 0;
                while (i < this.sets.length) {
                    List set = (List)group.get(i);
                    URL[] urls = new URL[set.size()];
                    int j = 0;
                    while (j < urls.length) {
                        urls[j] = StringInterner.internURL(new URL(new String((byte[])set.get(j), "UTF-8")));
                        ++j;
                    }
                    this.sets[i] = new cacheSet(urls);
                    ++i;
                }
            }

            @Override
            public long getUID() {
                TorrentUtils.ExtendedTorrent del = CachedStateWrapper.this.delegate;
                if (del != null) {
                    return del.getAnnounceURLGroup().getUID();
                }
                return this.uid;
            }

            @Override
            public TOTorrentAnnounceURLSet[] getAnnounceURLSets() {
                if (CachedStateWrapper.this.announce_group == null && CachedStateWrapper.this.fixup()) {
                    return CachedStateWrapper.this.delegate.getAnnounceURLGroup().getAnnounceURLSets();
                }
                return this.sets;
            }

            void fixGroup() {
                TOTorrentAnnounceURLSet[] realSets = CachedStateWrapper.this.delegate.getAnnounceURLGroup().getAnnounceURLSets();
                if (realSets.length == this.sets.length) {
                    int i = 0;
                    while (i < realSets.length) {
                        if (this.sets[i] instanceof cacheSet) {
                            ((cacheSet)this.sets[i]).delegateSet = realSets[i];
                        }
                        ++i;
                    }
                    this.sets = null;
                }
            }

            @Override
            public void setAnnounceURLSets(TOTorrentAnnounceURLSet[] toSet) {
                if (CachedStateWrapper.this.fixup()) {
                    TOTorrentAnnounceURLSet[] modToSet = new TOTorrentAnnounceURLSet[toSet.length];
                    int i = 0;
                    while (i < toSet.length) {
                        TOTorrentAnnounceURLSet set = toSet[i];
                        if (set instanceof cacheSet) {
                            modToSet[i] = ((cacheSet)set).delegateSet;
                        }
                        if (modToSet[i] == null) {
                            modToSet[i] = set;
                        }
                        ++i;
                    }
                    CachedStateWrapper.this.delegate.getAnnounceURLGroup().setAnnounceURLSets(modToSet);
                }
            }

            @Override
            public TOTorrentAnnounceURLSet createAnnounceURLSet(URL[] urls) {
                if (CachedStateWrapper.this.fixup()) {
                    return CachedStateWrapper.this.delegate.getAnnounceURLGroup().createAnnounceURLSet(urls);
                }
                return null;
            }

            protected class cacheSet
            implements TOTorrentAnnounceURLSet {
                private URL[] urls;
                TOTorrentAnnounceURLSet delegateSet;

                public cacheSet(URL[] urls) {
                    this.urls = urls;
                }

                @Override
                public URL[] getAnnounceURLs() {
                    if (((cacheGroup)cacheGroup.this).CachedStateWrapper.this.announce_group == null && CachedStateWrapper.this.fixup() && this.delegateSet != null) {
                        return this.delegateSet.getAnnounceURLs();
                    }
                    return this.urls;
                }

                @Override
                public void setAnnounceURLs(URL[] toSet) {
                    if (CachedStateWrapper.this.fixup() && this.delegateSet != null) {
                        this.delegateSet.setAnnounceURLs(toSet);
                    } else {
                        this.urls = toSet;
                        cacheGroup.this.uid = TorrentUtils.getAnnounceGroupUID();
                    }
                }
            }
        }
    }

    static class ResumeHistoryImpl
    implements DownloadManagerState.ResumeHistory {
        final long date;
        final Map resume_data;

        ResumeHistoryImpl(long _date, Map _resume_data) {
            this.date = _date;
            this.resume_data = _resume_data;
        }

        @Override
        public long getDate() {
            return this.date;
        }
    }

    protected static class nullState
    implements DownloadManagerState {
        protected final DownloadManager download_manager;

        protected nullState(DownloadManager _dm) {
            this.download_manager = _dm;
        }

        @Override
        public TOTorrent getTorrent() {
            return null;
        }

        @Override
        public File getStateFile() {
            return null;
        }

        @Override
        public boolean getAndClearRecoveredStatus() {
            return false;
        }

        @Override
        public DownloadManager getDownloadManager() {
            return this.download_manager;
        }

        @Override
        public void clearResumeData() {
        }

        @Override
        public Map getResumeData() {
            return new HashMap();
        }

        @Override
        public void setResumeData(Map data) {
        }

        @Override
        public boolean isResumeDataComplete() {
            return false;
        }

        @Override
        public List<DownloadManagerState.ResumeHistory> getResumeDataHistory() {
            return Collections.emptyList();
        }

        @Override
        public void restoreResumeData(DownloadManagerState.ResumeHistory history) {
        }

        @Override
        public void clearTrackerResponseCache() {
        }

        @Override
        public Map getTrackerResponseCache() {
            return new HashMap();
        }

        @Override
        public void setTrackerResponseCache(Map value) {
        }

        @Override
        public void setFlag(long flag, boolean set) {
        }

        @Override
        public boolean getFlag(long flag) {
            return false;
        }

        @Override
        public long getFlags() {
            return 0L;
        }

        @Override
        public void setTransientFlag(long flag, boolean set) {
        }

        @Override
        public boolean getTransientFlag(long flag) {
            return false;
        }

        @Override
        public long getTransientFlags() {
            return 0L;
        }

        @Override
        public Object getTransientAttribute(String name) {
            return null;
        }

        @Override
        public void setTransientAttribute(String name, Object value) {
        }

        @Override
        public void setParameterDefault(String name) {
        }

        @Override
        public long getLongParameter(String name) {
            return 0L;
        }

        @Override
        public void setLongParameter(String name, long value) {
        }

        @Override
        public int getIntParameter(String name) {
            return 0;
        }

        @Override
        public void setIntParameter(String name, int value) {
        }

        @Override
        public boolean getBooleanParameter(String name) {
            return false;
        }

        @Override
        public void setBooleanParameter(String name, boolean value) {
        }

        @Override
        public void setAttribute(String name, String value) {
        }

        @Override
        public void setAttribute(String name, String value, boolean setDirty) {
        }

        @Override
        public String getAttribute(String name) {
            return null;
        }

        @Override
        public String getTrackerClientExtensions() {
            return null;
        }

        @Override
        public void setTrackerClientExtensions(String value) {
        }

        @Override
        public void setListAttribute(String name, String[] values) {
        }

        @Override
        public String getListAttribute(String name, int idx) {
            return null;
        }

        @Override
        public String[] getListAttribute(String name) {
            return null;
        }

        @Override
        public void setMapAttribute(String name, Map value) {
        }

        @Override
        public Map getMapAttribute(String name) {
            return null;
        }

        @Override
        public boolean hasAttribute(String name) {
            return false;
        }

        @Override
        public void removeAttribute(String name) {
        }

        @Override
        public int getIntAttribute(String name) {
            return 0;
        }

        @Override
        public long getLongAttribute(String name) {
            return 0L;
        }

        @Override
        public boolean getBooleanAttribute(String name) {
            return false;
        }

        @Override
        public void setIntAttribute(String name, int value) {
        }

        @Override
        public void setLongAttribute(String name, long value) {
        }

        @Override
        public void setBooleanAttribute(String name, boolean value) {
        }

        @Override
        public Category getCategory() {
            return null;
        }

        @Override
        public void setCategory(Category cat) {
        }

        @Override
        public String[] getNetworks() {
            return new String[0];
        }

        @Override
        public boolean isNetworkEnabled(String network) {
            return false;
        }

        @Override
        public void setNetworks(String[] networks) {
        }

        @Override
        public void setNetworkEnabled(String network, boolean enabled) {
        }

        @Override
        public String[] getPeerSources() {
            return new String[0];
        }

        @Override
        public boolean isPeerSourcePermitted(String peerSource) {
            return false;
        }

        @Override
        public void setPeerSourcePermitted(String peerSource, boolean permitted) {
        }

        @Override
        public boolean isPeerSourceEnabled(String peerSource) {
            return false;
        }

        @Override
        public void suppressStateSave(boolean suppress) {
        }

        @Override
        public void setPeerSources(String[] networks) {
        }

        @Override
        public void setPeerSourceEnabled(String source, boolean enabled) {
        }

        @Override
        public void setFileLink(int source_index, File link_source, File link_destination) {
        }

        @Override
        public void setFileLinks(List<Integer> source_indexes, List<File> link_sources, List<File> link_destinations) {
        }

        @Override
        public void clearFileLinks() {
        }

        @Override
        public File getFileLink(int source_index, File link_source) {
            return null;
        }

        @Override
        public LinkFileMap getFileLinks() {
            return new LinkFileMap();
        }

        @Override
        public int getFileFlags(int file_index) {
            return 0;
        }

        @Override
        public void setFileFlags(int file_index, int flags) {
        }

        @Override
        public void setActive(boolean active) {
        }

        @Override
        public void discardFluff() {
        }

        @Override
        public boolean exportState(File target_dir) {
            return false;
        }

        @Override
        public void save(boolean interim) {
        }

        @Override
        public void delete() {
        }

        @Override
        public void addListener(DownloadManagerStateAttributeListener l, String attribute, int event_type) {
        }

        @Override
        public void removeListener(DownloadManagerStateAttributeListener l, String attribute, int event_type) {
        }

        @Override
        public void setDisplayName(String name) {
        }

        @Override
        public String getDisplayName() {
            return null;
        }

        @Override
        public void setUserComment(String name) {
        }

        @Override
        public String getUserComment() {
            return null;
        }

        public void setRelativeSavePath(String name) {
        }

        @Override
        public String getRelativeSavePath() {
            return null;
        }

        @Override
        public boolean parameterExists(String name) {
            return false;
        }

        @Override
        public void generateEvidence(IndentWriter writer) {
            writer.println("DownloadManagerState: broken torrent");
        }

        @Override
        public void dump(IndentWriter writer) {
        }

        @Override
        public boolean isOurContent() {
            return false;
        }

        @Override
        public DiskManagerFileInfo getPrimaryFile() {
            return null;
        }

        @Override
        public void setPrimaryFile(DiskManagerFileInfo dmfi) {
        }
    }
}

