/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.download.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.impl.DownloadManagerDefaultPaths;
import com.biglybt.core.download.impl.DownloadManagerMoveHandlerUtils;
import com.biglybt.core.util.FileUtil;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.savelocation.SaveLocationChange;
import com.biglybt.pif.download.savelocation.SaveLocationManager;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import java.io.File;
import java.util.ArrayList;

public class DownloadManagerMoveHandler
extends DownloadManagerMoveHandlerUtils {
    public static SaveLocationManager CURRENT_HANDLER = DownloadManagerDefaultPaths.DEFAULT_HANDLER;

    private static boolean isApplicableDownload(DownloadManager dm) {
        if (!dm.isPersistent()) {
            DownloadManagerMoveHandler.logInfo(String.valueOf(DownloadManagerMoveHandler.describe(dm)) + " is not persistent, auto-move disabled.", dm);
            return false;
        }
        if (dm.getDownloadState().getFlag(4L)) {
            DownloadManagerMoveHandler.logInfo(String.valueOf(DownloadManagerMoveHandler.describe(dm)) + " has auto-move exclusion flag set.", dm);
            return false;
        }
        return true;
    }

    public static SaveLocationChange onInitialisation(DownloadManager dm) {
        if (!DownloadManagerMoveHandler.isApplicableDownload(dm)) {
            return null;
        }
        try {
            return CURRENT_HANDLER.onInitialization(PluginCoreUtils.wrap(dm), true, true);
        }
        catch (Exception e) {
            DownloadManagerMoveHandler.logError("Error trying to determine initial download location.", dm, e);
            return null;
        }
    }

    public static SaveLocationChange onRemoval(DownloadManager dm) {
        if (!DownloadManagerMoveHandler.isApplicableDownload(dm)) {
            return null;
        }
        try {
            return CURRENT_HANDLER.onRemoval(PluginCoreUtils.wrap(dm), true, true);
        }
        catch (Exception e) {
            DownloadManagerMoveHandler.logError("Error trying to determine on-removal location.", dm, e);
            return null;
        }
    }

    public static SaveLocationChange onCompletion(DownloadManager dm, MoveCallback callback, boolean startOfDay) {
        SaveLocationChange sc;
        if (!DownloadManagerMoveHandler.isApplicableDownload(dm)) {
            return null;
        }
        if (dm.getDownloadState().getFlag(8L)) {
            if (!startOfDay) {
                DownloadManagerMoveHandler.logInfo("Completion flag already set on " + DownloadManagerMoveHandler.describe(dm) + ", skip move-on-completion behaviour.", dm);
            }
            return null;
        }
        try {
            sc = CURRENT_HANDLER.onCompletion(PluginCoreUtils.wrap(dm), true, true);
        }
        catch (Exception e) {
            DownloadManagerMoveHandler.logError("Error trying to determine on-completion location.", dm, e);
            return null;
        }
        if (callback != null && sc != null) {
            callback.perform(sc);
        }
        DownloadManagerMoveHandler.logInfo("Setting completion flag on " + DownloadManagerMoveHandler.describe(dm) + ", may have been set before.", dm);
        dm.getDownloadState().setFlag(8L, true);
        return sc;
    }

    public static boolean canGoToCompleteDir(DownloadManager dm) {
        return dm.isDownloadComplete(false) && DownloadManagerMoveHandler.isOnCompleteEnabled();
    }

    public static boolean isOnCompleteEnabled() {
        return COConfigurationManager.getBooleanParameter("Move Completed When Done");
    }

    public static boolean isOnRemovalEnabled() {
        return COConfigurationManager.getBooleanParameter("File.move.download.removed.enabled");
    }

    public static SaveLocationChange recalculatePath(DownloadManager dm) {
        Download download = PluginCoreUtils.wrap(dm);
        SaveLocationChange result = null;
        if (DownloadManagerMoveHandler.canGoToCompleteDir(dm)) {
            result = CURRENT_HANDLER.onCompletion(download, true, false);
        }
        if (result == null) {
            result = CURRENT_HANDLER.onInitialization(download, true, false);
        }
        return result;
    }

    public static File[] getRelatedDirs(DownloadManager dm) {
        ArrayList result = new ArrayList();
        Download d = PluginCoreUtils.wrap(dm);
        if (DownloadManagerMoveHandler.isOnCompleteEnabled()) {
            DownloadManagerMoveHandler.addFile(result, COConfigurationManager.getStringParameter("Completed Files Directory"));
            DownloadManagerMoveHandler.addFile(result, CURRENT_HANDLER.onCompletion(d, false, false));
            DownloadManagerMoveHandler.addFile(result, DownloadManagerDefaultPaths.DEFAULT_HANDLER.onCompletion(d, false, false));
        }
        if (DownloadManagerMoveHandler.isOnRemovalEnabled()) {
            DownloadManagerMoveHandler.addFile(result, COConfigurationManager.getStringParameter("File.move.download.removed.path"));
            DownloadManagerMoveHandler.addFile(result, CURRENT_HANDLER.onRemoval(d, false, false));
            DownloadManagerMoveHandler.addFile(result, DownloadManagerDefaultPaths.DEFAULT_HANDLER.onRemoval(d, false, false));
        }
        return result.toArray(new File[result.size()]);
    }

    private static void addFile(ArrayList l, SaveLocationChange slc) {
        if (slc != null) {
            DownloadManagerMoveHandler.addFile(l, slc.download_location);
        }
    }

    private static void addFile(ArrayList l, File f) {
        if (f != null && !l.contains(f)) {
            l.add(f);
        }
    }

    private static void addFile(ArrayList l, String s) {
        if (s != null && s.trim().length() != 0) {
            DownloadManagerMoveHandler.addFile(l, FileUtil.newFile(s, new String[0]));
        }
    }

    public static interface MoveCallback {
        public void perform(SaveLocationChange var1);
    }
}

