/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.download.impl;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.disk.DiskManagerFactory;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.disk.DiskManagerFileInfoListener;
import com.biglybt.core.disk.DiskManagerFileInfoSet;
import com.biglybt.core.disk.DiskManagerListener;
import com.biglybt.core.disk.DiskManagerPiece;
import com.biglybt.core.disk.DiskManagerReadRequest;
import com.biglybt.core.disk.DiskManagerReadRequestListener;
import com.biglybt.core.disk.impl.DiskManagerUtil;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerDiskListener;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.download.DownloadManagerStateAttributeListener;
import com.biglybt.core.download.impl.DownloadManagerImpl;
import com.biglybt.core.download.impl.DownloadManagerRateController;
import com.biglybt.core.download.impl.DownloadManagerStatsImpl;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.global.GlobalManagerStats;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.LogRelation;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.networkmanager.LimitedRateGroup;
import com.biglybt.core.networkmanager.NetworkConnection;
import com.biglybt.core.networkmanager.NetworkManager;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.PEPeerManagerAdapter;
import com.biglybt.core.peer.PEPeerManagerFactory;
import com.biglybt.core.peer.PEPeerManagerStats;
import com.biglybt.core.peer.PEPeerSource;
import com.biglybt.core.peer.PEPiece;
import com.biglybt.core.peermanager.PeerManager;
import com.biglybt.core.peermanager.PeerManagerRegistration;
import com.biglybt.core.peermanager.PeerManagerRegistrationAdapter;
import com.biglybt.core.peermanager.piecepicker.PiecePicker;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentException;
import com.biglybt.core.torrent.TOTorrentFile;
import com.biglybt.core.tracker.client.TRTrackerAnnouncer;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerDataProvider;
import com.biglybt.core.tracker.client.TRTrackerScraperResponse;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.AddressUtils;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.LightHashMap;
import com.biglybt.core.util.ListenerManager;
import com.biglybt.core.util.ListenerManagerDispatcher;
import com.biglybt.core.util.NonDaemonTask;
import com.biglybt.core.util.NonDaemonTaskRunner;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.core.util.bloom.BloomFilter;
import com.biglybt.core.util.bloom.BloomFilterFactory;
import com.biglybt.pif.PluginInterface;
import com.biglybt.plugin.extseed.ExternalSeedPeer;
import com.biglybt.plugin.extseed.ExternalSeedPlugin;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.net.InetSocketAddress;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DownloadManagerController
extends LogRelation
implements PEPeerManagerAdapter,
PeerManagerRegistrationAdapter,
SimpleTimer.TimerTickReceiver {
    private static final long STATE_FLAG_HASDND = 1L;
    private static final long STATE_FLAG_COMPLETE_NO_DND = 2L;
    static long skeleton_builds;
    static boolean tracker_stats_exclude_lan;
    private static ExternalSeedPlugin ext_seed_plugin;
    private static boolean ext_seed_plugin_tried;
    private static final int LDT_DL_ADDED = 1;
    private static final int LDT_DL_REMOVED = 2;
    static final ListenerManager disk_listeners_agregator;
    private final ListenerManager disk_listeners = ListenerManager.createManager("DMC:DiskListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object listener, int type, Object value) {
            disk_listeners_agregator.dispatch(listener, type, value);
        }
    });
    private final AEMonitor disk_listeners_mon = new AEMonitor("DownloadManagerController:DL");
    final AEMonitor control_mon = new AEMonitor("DownloadManagerController");
    private final AEMonitor state_mon = new AEMonitor("DownloadManagerController:State");
    final AEMonitor facade_mon = new AEMonitor("DownloadManagerController:Facade");
    final DownloadManagerImpl download_manager;
    DownloadManagerState download_manager_state;
    final DownloadManagerStatsImpl stats;
    private volatile int state_set_by_method = -1;
    private volatile int substate;
    private volatile boolean force_start;
    private volatile boolean is_force_rechecking;
    private volatile DiskManager disk_manager_use_accessors;
    private DiskManagerListener disk_manager_listener_use_accessors;
    private Object disk_manager_pieces_snapshot_lock = new Object();
    private volatile DiskManagerPiece[] disk_manager_pieces_snapshot;
    final FileInfoFacadeSet fileFacadeSet = new FileInfoFacadeSet();
    boolean files_facade_destroyed;
    private boolean cached_complete_excluding_dnd;
    private boolean cached_has_dnd_files;
    private boolean cached_values_set;
    private Set<String> cached_networks;
    final Object cached_networks_lock = new Object();
    private PeerManagerRegistration peer_manager_registration;
    private PEPeerManager peer_manager;
    private DownloadManagerStateAttributeListener dm_attribute_listener;
    private Object external_rate_limiters_cow_lock = new Object();
    private List<Object[]> external_rate_limiters_cow;
    private String errorDetail;
    private int errorType = 0;
    private int errorFlags = 0;
    final GlobalManagerStats global_stats;
    boolean bInitialized = false;
    long data_send_rate_at_close;
    private static final int ACTIVATION_REBUILD_TIME = 600000;
    private static final int BLOOM_SIZE = 64;
    private volatile BloomFilter activation_bloom;
    private volatile long activation_bloom_create_time = SystemTime.getMonotonousTime();
    private volatile int activation_count;
    private volatile long activation_count_time;
    private boolean piece_checking_enabled = true;
    private long priority_connection_count;
    private static final int HTTP_SEEDS_MAX = 64;
    private final LinkedList<ExternalSeedPeer> http_seeds = new LinkedList();
    private int md_info_dict_size;
    private volatile WeakReference<byte[]> md_info_dict_ref = new WeakReference<Object>(null);
    private static final int MD_INFO_PEER_HISTORY_MAX = 128;
    private final Map<String, int[]> md_info_peer_history = new LinkedHashMap<String, int[]>(128, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, int[]> eldest) {
            return this.size() > 128;
        }
    };

    static {
        COConfigurationManager.addAndFireParameterListener("Tracker Client Exclude LAN", new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                tracker_stats_exclude_lan = COConfigurationManager.getBooleanParameter(name);
            }
        });
        disk_listeners_agregator = ListenerManager.createAsyncManager("DMC:DiskListenAgregatorDispatcher", new ListenerManagerDispatcher(){

            public void dispatch(Object _listener, int type, Object value) {
                DownloadManagerDiskListener listener = (DownloadManagerDiskListener)_listener;
                if (type == 1) {
                    listener.diskManagerAdded((DiskManager)value);
                } else if (type == 2) {
                    listener.diskManagerRemoved((DiskManager)value);
                }
            }
        });
    }

    public static ExternalSeedPlugin getExternalSeedPlugin() {
        if (!ext_seed_plugin_tried) {
            ext_seed_plugin_tried = true;
            try {
                PluginInterface ext_pi = CoreFactory.getSingleton().getPluginManager().getPluginInterfaceByClass(ExternalSeedPlugin.class);
                if (ext_pi != null) {
                    ext_seed_plugin = (ExternalSeedPlugin)ext_pi.getPlugin();
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return ext_seed_plugin;
    }

    protected DownloadManagerController(DownloadManagerImpl _download_manager) {
        this.download_manager = _download_manager;
        GlobalManager gm = this.download_manager.getGlobalManager();
        this.global_stats = gm.getStats();
        this.stats = (DownloadManagerStatsImpl)this.download_manager.getStats();
        this.cached_values_set = false;
    }

    protected void setDownloadManagerState(DownloadManagerState dms) {
        this.download_manager_state = dms;
    }

    protected void setInitialState(int initial_state) {
        block7: {
            TOTorrent torrent;
            this.bInitialized = true;
            if (this.getState() == -1) {
                this.setState(initial_state, true);
            }
            if ((torrent = this.download_manager.getTorrent()) != null) {
                try {
                    this.peer_manager_registration = PeerManager.getSingleton().registerLegacyManager(torrent.getHashWrapper(), this);
                    this.md_info_dict_size = this.download_manager_state.getIntAttribute("mdinfodictsize");
                    if (this.md_info_dict_size != 0) break block7;
                    try {
                        this.md_info_dict_size = BEncoder.encode((Map)torrent.serialiseToMap().get("info")).length;
                    }
                    catch (Throwable e) {
                        this.md_info_dict_size = -1;
                    }
                    this.download_manager_state.setIntAttribute("mdinfodictsize", this.md_info_dict_size);
                }
                catch (TOTorrentException e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        if (this.download_manager_state.parameterExists("dndflags")) {
            long flags = this.download_manager_state.getLongParameter("dndflags");
            this.cached_complete_excluding_dnd = (flags & 2L) != 0L;
            this.cached_has_dnd_files = (flags & 1L) != 0L;
            this.cached_values_set = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDownload(TRTrackerAnnouncer tracker_client) {
        List<Object[]> limiters;
        DiskManager dm;
        try {
            this.control_mon.enter();
            if (this.download_manager.isDestroyed()) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent((Object)this, LogIDs.CORE, 3, "startDownload() after manager is destroyed"));
                }
                return;
            }
            if (this.getState() != 40) {
                Debug.out("DownloadManagerController::startDownload state must be ready, " + this.getState());
                this.setFailed("Inconsistent download state: startDownload, state = " + this.getState());
                return;
            }
            if (tracker_client == null) {
                Debug.out("DownloadManagerController:startDownload: tracker_client is null");
                this.stopIt(70, false, false, false);
                return;
            }
            if (this.peer_manager != null) {
                Debug.out("DownloadManagerController::startDownload: peer manager not null");
                this.peer_manager.stopAll();
                SimpleTimer.removeTickReceiver(this);
                DownloadManagerRateController.removePeerManager(this.peer_manager);
                this.peer_manager = null;
                this.download_manager_state.removeListener(this.dm_attribute_listener, "flags", 1);
                this.download_manager_state.removeListener(this.dm_attribute_listener, "mdlc", 1);
                this.dm_attribute_listener = null;
            }
            if ((dm = this.getDiskManager()) == null) {
                Debug.out("DownloadManagerController::startDownload: disk manager is null");
                return;
            }
            this.setState(50, false);
        }
        finally {
            this.control_mon.exit();
        }
        this.cacheNetworks();
        final PEPeerManager temp = PEPeerManagerFactory.create(tracker_client.getPeerId(), this, dm);
        this.download_manager.informWillBeStarted(temp);
        temp.start();
        tracker_client.setAnnounceDataProvider(new TRTrackerAnnouncerDataProvider(){
            private final PEPeerManagerStats pm_stats;
            private long last_reported_total_received;
            private long last_reported_total_received_data;
            private long last_reported_total_received_discard;
            private long last_reported_total_received_failed;
            {
                this.pm_stats = pEPeerManager.getStats();
            }

            @Override
            public String getName() {
                return DownloadManagerController.this.getDisplayName();
            }

            @Override
            public long getTotalSent() {
                return tracker_stats_exclude_lan ? this.pm_stats.getTotalDataBytesSentNoLan() : this.pm_stats.getTotalDataBytesSent();
            }

            @Override
            public long getTotalReceived() {
                long received = tracker_stats_exclude_lan ? this.pm_stats.getTotalDataBytesReceivedNoLan() : this.pm_stats.getTotalDataBytesReceived();
                long discarded = this.pm_stats.getTotalDiscarded();
                long failed = this.pm_stats.getTotalHashFailBytes();
                long verified = received - (discarded + failed);
                if ((verified -= temp.getHiddenBytes()) < this.last_reported_total_received) {
                    verified = this.last_reported_total_received;
                    if (this.last_reported_total_received_data != -1L) {
                        this.last_reported_total_received_data = -1L;
                    }
                } else {
                    this.last_reported_total_received = verified;
                    this.last_reported_total_received_data = received;
                    this.last_reported_total_received_discard = discarded;
                    this.last_reported_total_received_failed = failed;
                }
                return verified < 0L ? 0L : verified;
            }

            @Override
            public long getRemaining() {
                return Math.max(temp.getRemaining(), temp.getHiddenBytes());
            }

            @Override
            public long getFailedHashCheck() {
                return this.pm_stats.getTotalHashFailBytes();
            }

            @Override
            public String getExtensions() {
                return DownloadManagerController.this.getTrackerClientExtensions();
            }

            @Override
            public int getMaxNewConnectionsAllowed(String network) {
                return temp.getMaxNewConnectionsAllowed(network);
            }

            @Override
            public int getPendingConnectionCount() {
                return temp.getPendingPeerCount();
            }

            @Override
            public int getConnectedConnectionCount() {
                return temp.getNbPeers() + temp.getNbSeeds();
            }

            @Override
            public int getUploadSpeedKBSec(boolean estimate) {
                long current_local = DownloadManagerController.this.stats.getDataSendRate();
                if (estimate && (current_local = DownloadManagerController.this.data_send_rate_at_close) == 0L) {
                    int old_global;
                    int current_global = DownloadManagerController.this.global_stats.getDataSendRate();
                    if (current_global < (old_global = DownloadManagerController.this.global_stats.getDataSendRateAtClose())) {
                        current_global = old_global;
                    }
                    List<DownloadManager> managers = DownloadManagerController.this.download_manager.getGlobalManager().getDownloadManagers();
                    int num_dls = 0;
                    int i = 0;
                    while (i < managers.size()) {
                        int state;
                        DownloadManager dm = managers.get(i);
                        if (dm.getStats().getDownloadCompleted(false) != 1000 && (state = dm.getState()) != 100 && state != 65 && state != 70) {
                            ++num_dls;
                        }
                        ++i;
                    }
                    current_local = num_dls == 0 ? (long)current_global : (long)(current_global / num_dls);
                }
                return (int)((current_local + 1023L) / 1024L);
            }

            @Override
            public int getTCPListeningPortNumber() {
                return DownloadManagerController.this.getTCPListeningPortNumber();
            }

            @Override
            public int getCryptoLevel() {
                return DownloadManagerController.this.download_manager.getCryptoLevel();
            }

            @Override
            public void setPeerSources(String[] allowed_sources) {
                String[] sources = PEPeerSource.PS_SOURCES;
                int i = 0;
                while (i < sources.length) {
                    String s = sources[i];
                    boolean ok = false;
                    int j = 0;
                    while (j < allowed_sources.length) {
                        if (s.equals(allowed_sources[j])) {
                            ok = true;
                            break;
                        }
                        ++j;
                    }
                    if (!ok) {
                        DownloadManagerController.this.download_manager_state.setPeerSourcePermitted(s, false);
                    }
                    ++i;
                }
                PEPeerManager pm = DownloadManagerController.this.getPeerManager();
                if (pm != null) {
                    HashSet<String> allowed = new HashSet<String>();
                    allowed.addAll(Arrays.asList(allowed_sources));
                    for (PEPeer peer : pm.getPeers()) {
                        if (allowed.contains(peer.getPeerSource())) continue;
                        pm.removePeer(peer, "Peer source not permitted", 2);
                    }
                }
            }

            @Override
            public boolean isPeerSourceEnabled(String peer_source) {
                return DownloadManagerController.this.isPeerSourceEnabled(peer_source);
            }
        });
        try {
            this.control_mon.enter();
            this.peer_manager = temp;
            if (this.dm_attribute_listener != null) {
                this.download_manager_state.removeListener(this.dm_attribute_listener, "flags", 1);
                this.download_manager_state.removeListener(this.dm_attribute_listener, "mdlc", 1);
            }
            this.dm_attribute_listener = new DownloadManagerStateAttributeListener(){
                boolean did_set;

                @Override
                public void attributeEventOccurred(DownloadManager download, String attribute, int event_type) {
                    boolean seq = DownloadManagerController.this.download_manager_state.getFlag(8192L);
                    PiecePicker pp = temp.getPiecePicker();
                    if (seq) {
                        if (pp.getSequentialInfo() == 0) {
                            pp.setSequentialAscendingFrom(0);
                            this.did_set = true;
                        }
                    } else if (this.did_set) {
                        pp.clearSequential();
                    }
                    Boolean mask = DownloadManagerController.this.download_manager_state.getOptionalBooleanAttribute("mdlc");
                    temp.setMaskDownloadCompletion(mask);
                }
            };
            this.download_manager_state.addListener(this.dm_attribute_listener, "flags", 1);
            this.download_manager_state.addListener(this.dm_attribute_listener, "mdlc", 1);
            this.dm_attribute_listener.attributeEventOccurred(null, null, -1);
            DownloadManagerRateController.addPeerManager(this.peer_manager);
            SimpleTimer.addTickReceiver(this);
            Object object = this.external_rate_limiters_cow_lock;
            synchronized (object) {
                limiters = this.external_rate_limiters_cow;
            }
        }
        finally {
            this.control_mon.exit();
        }
        if (limiters != null) {
            int i = 0;
            while (i < limiters.size()) {
                Object[] entry = limiters.get(i);
                temp.addRateLimiter((LimitedRateGroup)entry[0], (Boolean)entry[1]);
                ++i;
            }
        }
        if (this.getState() == 50) {
            this.download_manager.informStateChanged();
        }
        this.download_manager.informStarted(temp);
    }

    public void initializeDiskManager(boolean open_for_seeding) {
        this.initializeDiskManagerSupport(10, new DiskManagerListener_Default(open_for_seeding));
    }

    protected void initializeDiskManagerSupport(int initialising_state, DiskManagerListener listener) {
        try {
            this.control_mon.enter();
            int entry_state = this.getState();
            if (entry_state != 0 && entry_state != 70 && entry_state != 75 && entry_state != 100) {
                Debug.out("DownloadManagerController::initializeDiskManager: Illegal initialize state, " + entry_state);
                this.setFailed("Inconsistent download state: initSupport, state = " + entry_state);
                return;
            }
            DiskManager old_dm = this.getDiskManager();
            if (old_dm != null) {
                Debug.out("DownloadManagerController::initializeDiskManager: disk manager is not null");
                old_dm.stop(false);
                this.setDiskManager(null, null);
            }
            this.errorDetail = "";
            this.errorType = 0;
            this.errorFlags = 0;
            this.setState(initialising_state, false);
            DiskManager dm = DiskManagerFactory.create(this.download_manager.getTorrent(), this.download_manager);
            this.disk_manager_pieces_snapshot = null;
            this.setDiskManager(dm, listener);
        }
        finally {
            this.control_mon.exit();
            this.download_manager.informStateChanged();
        }
    }

    public boolean canForceRecheck() {
        int state = this.getState();
        return state == 70 || state == 75 || state == 100 && this.getDiskManager() == null;
    }

    protected boolean isForceRechecking() {
        return this.is_force_rechecking;
    }

    public void forceRecheck(final Map resume_data) {
        try {
            this.control_mon.enter();
            if (this.getDiskManager() != null || !this.canForceRecheck()) {
                Debug.out("DownloadManagerController::forceRecheck: illegal entry state");
                return;
            }
            if (this.is_force_rechecking) {
                Debug.out("DownloadManagerController::forceRecheck: already active");
                return;
            }
            this.is_force_rechecking = true;
            int start_state = this.getState();
            if (resume_data == null) {
                this.download_manager_state.clearResumeData();
            } else {
                this.download_manager_state.setResumeData(resume_data);
            }
            boolean wasForceStarted = this.force_start;
            this.force_start = true;
            this.download_manager.setDataAlreadyAllocated(false);
            this.initializeDiskManagerSupport(30, new ForceRecheckDiskManagerListener(wasForceStarted, start_state, new ForceRecheckListener(){

                @Override
                public void forceRecheckComplete(DownloadManager dm, boolean cancelled) {
                    DownloadManagerController.this.is_force_rechecking = false;
                    if (resume_data == null) {
                        List<DownloadManagerState.ResumeHistory> history;
                        DownloadManagerController.this.download_manager.fireGlobalManagerEvent(2, new Object[]{true, cancelled});
                        if (cancelled && !(history = DownloadManagerController.this.download_manager_state.getResumeDataHistory()).isEmpty()) {
                            AEThread2.createAndStartDaemon("resetResume", () -> DownloadManagerController.this.download_manager_state.restoreResumeData((DownloadManagerState.ResumeHistory)history.get(history.size() - 1)));
                        }
                    }
                }
            }));
        }
        finally {
            this.control_mon.exit();
        }
    }

    public void setPieceCheckingEnabled(boolean enabled) {
        this.piece_checking_enabled = enabled;
        DiskManager dm = this.getDiskManager();
        if (dm != null) {
            dm.setPieceCheckingEnabled(enabled);
        }
    }

    public void stopIt(int _stateAfterStopping, final boolean remove_torrent, final boolean remove_data, final boolean for_removal) {
        boolean closing;
        long current_up = this.stats.getDataSendRate();
        if (current_up != 0L) {
            this.data_send_rate_at_close = current_up;
        }
        boolean bl = closing = _stateAfterStopping == 71;
        if (closing) {
            _stateAfterStopping = 70;
        }
        final int stateAfterStopping = _stateAfterStopping;
        try {
            this.control_mon.enter();
            int state = this.getState();
            if ((state == 70 || state == 100) && this.getDiskManager() == null) {
                if (stateAfterStopping != 100 && state == 100) {
                    this.errorType = 0;
                    this.errorDetail = "";
                    this.errorFlags = 0;
                }
                if (remove_data) {
                    this.download_manager.deleteDataFiles();
                } else if (for_removal && COConfigurationManager.getBooleanParameter("Delete Partial Files On Library Removal")) {
                    this.download_manager.deletePartialDataFiles();
                }
                if (remove_torrent) {
                    this.download_manager.deleteTorrentFile();
                }
                this.download_manager.informStopped(null, stateAfterStopping == 75);
                this.setState(_stateAfterStopping, false);
                return;
            }
            if (state == 65) {
                return;
            }
            try {
                this.setSubState(_stateAfterStopping);
                this.setState(65, false);
                NonDaemonTaskRunner.run(new NonDaemonTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Unable to fully structure code
                     */
                    @Override
                    public Object run() {
                        block28: {
                            try {
                                if (DownloadManagerController.access$4(DownloadManagerController.this) != null) {
                                    DownloadManagerController.access$4(DownloadManagerController.this).stopAll();
                                    DownloadManagerController.this.stats.saveSessionTotals();
                                    DownloadManagerController.this.download_manager_state.setLongParameter("stats.download.last.active.time", SystemTime.getCurrentTime());
                                    SimpleTimer.removeTickReceiver(DownloadManagerController.this);
                                    DownloadManagerRateController.removePeerManager(DownloadManagerController.access$4(DownloadManagerController.this));
                                    DownloadManagerController.this.download_manager_state.removeListener(DownloadManagerController.access$5(DownloadManagerController.this), "flags", 1);
                                    DownloadManagerController.this.download_manager_state.removeListener(DownloadManagerController.access$5(DownloadManagerController.this), "mdlc", 1);
                                    DownloadManagerController.access$6(DownloadManagerController.this, null);
                                }
                                DownloadManagerController.this.download_manager.informStopped(DownloadManagerController.access$4(DownloadManagerController.this), stateAfterStopping == 75);
                                DownloadManagerController.access$7(DownloadManagerController.this, null);
                                dm = DownloadManagerController.this.getDiskManager();
                                if (dm == null) break block28;
                                went_async = dm.stop(closing);
                                if (went_async) {
                                    try {
                                        wait_count = 0;
                                        Thread.sleep(10L);
                                        while (!dm.isStopped()) {
                                            if (++wait_count > 1200) {
                                                Debug.out("Download stop took too long to complete");
                                                break;
                                            }
                                            if (wait_count % 200 == 0) {
                                                Debug.out("Waiting for download to stop - elapsed=" + wait_count + " sec");
                                            }
                                            Thread.sleep(100L);
                                        }
                                    }
                                    catch (Throwable e) {
                                        Debug.out(e);
                                    }
                                }
                                DownloadManagerController.this.stats.setCompleted(DownloadManagerController.this.stats.getCompleted());
                                DownloadManagerController.this.stats.recalcDownloadCompleteBytes();
                                if (!DownloadManagerController.this.download_manager.getAssumedComplete()) {
                                    DownloadManagerController.this.download_manager_state.save(false);
                                }
                                DownloadManagerController.this.setDiskManager(null, null);
                                break block28;
                            }
                            catch (Throwable var4_5) {
                                DownloadManagerController.access$0(DownloadManagerController.this, false);
                                if (remove_data) {
                                    DownloadManagerController.this.download_manager.deleteDataFiles();
                                } else if (for_removal && COConfigurationManager.getBooleanParameter("Delete Partial Files On Library Removal")) {
                                    DownloadManagerController.this.download_manager.deletePartialDataFiles();
                                }
                                if (remove_torrent) {
                                    DownloadManagerController.this.download_manager.deleteTorrentFile();
                                }
                                to_remove = new ArrayList<E>();
                                var6_8 = DownloadManagerController.access$3(DownloadManagerController.this);
                                synchronized (var6_8) {
                                    to_remove.addAll(DownloadManagerController.access$3(DownloadManagerController.this));
                                    DownloadManagerController.access$3(DownloadManagerController.this).clear();
                                }
                                ** for (peer : to_remove)
                            }
lbl-1000:
                            // 1 sources

                            {
                                peer.remove();
                                continue;
                            }
lbl60:
                            // 1 sources

                            if (DownloadManagerController.this.getState() == 65) {
                                DownloadManagerController.this.setState(stateAfterStopping, true);
                            }
                            throw var4_5;
                        }
                        DownloadManagerController.access$0(DownloadManagerController.this, false);
                        if (remove_data) {
                            DownloadManagerController.this.download_manager.deleteDataFiles();
                        } else if (for_removal && COConfigurationManager.getBooleanParameter("Delete Partial Files On Library Removal")) {
                            DownloadManagerController.this.download_manager.deletePartialDataFiles();
                        }
                        if (remove_torrent) {
                            DownloadManagerController.this.download_manager.deleteTorrentFile();
                        }
                        to_remove = new ArrayList<E>();
                        peer = DownloadManagerController.access$3(DownloadManagerController.this);
                        synchronized (peer) {
                            to_remove.addAll(DownloadManagerController.access$3(DownloadManagerController.this));
                            DownloadManagerController.access$3(DownloadManagerController.this).clear();
                        }
                        for (Object peer : to_remove) {
                            peer.remove();
                        }
                        if (DownloadManagerController.this.getState() == 65) {
                            DownloadManagerController.this.setState(stateAfterStopping, true);
                        }
                        return null;
                    }

                    @Override
                    public String getName() {
                        return "Stopping '" + DownloadManagerController.this.getDisplayName() + "'";
                    }
                });
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        finally {
            this.control_mon.exit();
            Logger.log(new LogEvent(this, LogIDs.CORE, "Stopped - state=" + this.getState() + ",error=" + this.getErrorType() + "/" + this.getErrorDetail() + "/" + this.getErrorFlags()));
            this.download_manager.informStateChanged();
        }
    }

    protected void setStateWaiting() {
        this.setState(0, true);
    }

    @Override
    public void setStateFinishing() {
        this.setState(55, true);
    }

    public void setStateDownloading() {
        if (this.getState() == 60) {
            this.setState(50, true);
        } else if (this.getState() != 50) {
            Logger.log(new LogEvent((Object)this, LogIDs.CORE, 1, "Trying to set state to downloading when state is not seeding"));
        }
    }

    @Override
    public void setStateSeeding(boolean never_downloaded) {
        this.setStateFinishing();
        this.download_manager.downloadEnded(never_downloaded);
        this.setState(60, true);
        if (!never_downloaded && !COConfigurationManager.getBooleanParameter("StartStopManager_bRetainForceStartWhenComplete") && this.isForceStart()) {
            this.setForceStart(false);
        }
    }

    public boolean isStateSeeding() {
        return this.getState() == 60;
    }

    protected void setStateQueued() {
        this.setState(75, true);
    }

    public int getState() {
        if (this.state_set_by_method != 10) {
            return this.state_set_by_method;
        }
        DiskManager dm = this.getDiskManager();
        if (dm == null) {
            return 10;
        }
        int diskManagerState = dm.getState();
        if (diskManagerState == 1) {
            return 10;
        }
        if (diskManagerState == 2) {
            return 20;
        }
        if (diskManagerState == 3) {
            return 30;
        }
        if (diskManagerState == 4) {
            return 40;
        }
        if (diskManagerState == 10) {
            if (dm.getErrorType() == 3) {
                return 70;
            }
            return 100;
        }
        return 100;
    }

    protected int getSubState() {
        if (this.state_set_by_method == 65) {
            return this.substate;
        }
        return this.getState();
    }

    private void setSubState(int ss) {
        this.substate = ss;
    }

    void setState(int _state, boolean _inform_changed) {
        boolean call_filesExist = false;
        try {
            this.state_mon.enter();
            int old_state = this.state_set_by_method;
            if (old_state != _state) {
                File save_dir_file;
                TOTorrent torrent;
                this.state_set_by_method = _state;
                if (this.state_set_by_method != 75) {
                    this.activation_bloom = null;
                    if (this.state_set_by_method == 70 || this.state_set_by_method == 50 || this.state_set_by_method == 60) {
                        this.activation_count = 0;
                    }
                }
                if (this.state_set_by_method != 75 && this.state_set_by_method == 100 && (torrent = this.download_manager.getTorrent()) != null && !torrent.isSimpleTorrent() && (save_dir_file = this.download_manager.getAbsoluteSaveLocation()) != null && save_dir_file.exists() && save_dir_file.isDirectory()) {
                    TorrentUtils.recursiveEmptyDirDelete(save_dir_file, false);
                }
                if (old_state == 70) {
                    this.download_manager.setStopReason(null);
                }
            }
        }
        finally {
            this.state_mon.exit();
        }
        if (call_filesExist) {
            this.filesExist(true);
        }
        if (_inform_changed) {
            this.download_manager.informStateChanged();
        }
    }

    @Override
    public void restartDownload(boolean forceRecheck) {
        boolean was_force_start = this.isForceStart();
        this.stopIt(70, false, false, false);
        if (forceRecheck) {
            this.download_manager_state.clearResumeData();
        }
        this.download_manager.initialize();
        if (was_force_start) {
            this.setForceStart(true);
        }
    }

    protected void destroy() {
        if (this.peer_manager_registration != null) {
            this.peer_manager_registration.unregister();
            this.peer_manager_registration = null;
        }
        this.fileFacadeSet.destroyFileInfo();
    }

    @Override
    public void saveTorrentState() {
        TOTorrent dms_torrent = this.download_manager_state.getTorrent();
        if (dms_torrent.getEffectiveTorrentType() == 3 && !this.download_manager_state.getBooleanAttribute("tep")) {
            this.download_manager_state.setLongAttribute("tst", SystemTime.getCurrentTime());
            this.download_manager_state.save(false);
            if (dms_torrent.isExportable() && TorrentUtils.propagateExportability(dms_torrent, FileUtil.newFile(this.download_manager.getTorrentFileName(), new String[0]))) {
                this.download_manager_state.setBooleanAttribute("tep", true);
            }
        }
    }

    @Override
    public boolean isPeerSourceEnabled(String peer_source) {
        return this.download_manager_state.isPeerSourceEnabled(peer_source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheNetworks() {
        Object object = this.cached_networks_lock;
        synchronized (object) {
            if (this.cached_networks != null) {
                return;
            }
            this.cached_networks = new HashSet<String>(Arrays.asList(this.download_manager_state.getNetworks()));
            this.download_manager_state.addListener(new DownloadManagerStateAttributeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void attributeEventOccurred(DownloadManager download, String attribute, int event_type) {
                    Object object = DownloadManagerController.this.cached_networks_lock;
                    synchronized (object) {
                        DownloadManagerController.this.cached_networks = new HashSet<String>(Arrays.asList(DownloadManagerController.this.download_manager_state.getNetworks()));
                    }
                    PEPeerManager pm = DownloadManagerController.this.peer_manager;
                    if (pm != null) {
                        pm.removeAllPeers("Networks changed, reconnection required", 0);
                    }
                }
            }, "networks", 1);
        }
    }

    @Override
    public boolean isNetworkEnabled(String network) {
        Set<String> cache = this.cached_networks;
        if (cache == null) {
            return this.download_manager_state.isNetworkEnabled(network);
        }
        return cache.contains(network);
    }

    @Override
    public String[] getEnabledNetworks() {
        Set<String> cache = this.cached_networks;
        if (cache == null) {
            return this.download_manager_state.getNetworks();
        }
        return cache.toArray(new String[cache.size()]);
    }

    @Override
    public byte[][] getSecrets() {
        TOTorrent torrent = this.download_manager.getTorrent();
        try {
            byte[] secret1 = torrent.getHash();
            try {
                byte[] secret2 = this.getSecret2(torrent);
                return new byte[][]{secret1, secret2};
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                return new byte[][]{secret1};
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return new byte[0][];
        }
    }

    @Override
    public byte[] getHashOverride() {
        HashWrapper hw = this.download_manager.getTorrentHashOverride();
        if (hw != null) {
            return hw.getBytes();
        }
        return null;
    }

    @Override
    public byte[] getPeerID() {
        return this.download_manager.getTrackerClient().getPeerId();
    }

    @Override
    public int getNbPieces() {
        return this.download_manager.getTorrent().getNumberOfPieces();
    }

    @Override
    public int getHashOverrideLocalPort(boolean only_if_allocated) {
        return this.download_manager.getTCPPortOverride(only_if_allocated);
    }

    @Override
    public byte[][] getSecrets(int crypto_level) {
        TOTorrent torrent = this.download_manager.getTorrent();
        try {
            HashWrapper override;
            byte[] secret = crypto_level == 1 ? ((override = this.download_manager.getTorrentHashOverride()) != null ? override.getBytes() : torrent.getHash()) : this.getSecret2(torrent);
            return new byte[][]{secret};
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return new byte[0][];
        }
    }

    protected byte[] getSecret2(TOTorrent torrent) throws TOTorrentException {
        AbstractMap secrets_map = this.download_manager_state.getMapAttribute("secrets");
        secrets_map = secrets_map == null ? new HashMap() : new LightHashMap(secrets_map);
        if (secrets_map.size() == 0) {
            if (torrent.getEffectiveTorrentType() == 3) {
                TOTorrentFile[] files;
                TOTorrentFile[] tOTorrentFileArray = files = torrent.getFiles();
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    TOTorrentFile file = tOTorrentFileArray[n2];
                    if (file.getLength() > 0L) {
                        secrets_map.put("p1", file.getRootHash());
                        break;
                    }
                    ++n2;
                }
            } else {
                secrets_map.put("p1", torrent.getPieces()[0]);
            }
            this.download_manager_state.setMapAttribute("secrets", secrets_map);
        }
        return (byte[])secrets_map.get("p1");
    }

    @Override
    public boolean manualRoute(NetworkConnection connection) {
        return false;
    }

    @Override
    public long getRandomSeed() {
        return this.download_manager_state.getLongParameter("rand");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRateLimiter(LimitedRateGroup group, boolean upload) {
        PEPeerManager pm;
        boolean not_stopping = this.getState() != 65;
        try {
            if (not_stopping) {
                this.control_mon.enter();
            }
            Object object = this.external_rate_limiters_cow_lock;
            synchronized (object) {
                ArrayList<Object[]> new_limiters = new ArrayList<Object[]>(this.external_rate_limiters_cow == null ? 1 : this.external_rate_limiters_cow.size() + 1);
                if (this.external_rate_limiters_cow != null) {
                    new_limiters.addAll(this.external_rate_limiters_cow);
                }
                new_limiters.add(new Object[]{group, upload});
                this.external_rate_limiters_cow = new_limiters;
            }
            pm = this.peer_manager;
        }
        finally {
            if (not_stopping) {
                this.control_mon.exit();
            }
        }
        if (not_stopping && pm != null) {
            pm.addRateLimiter(group, upload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LimitedRateGroup[] getRateLimiters(boolean upload) {
        Object object = this.external_rate_limiters_cow_lock;
        synchronized (object) {
            if (this.external_rate_limiters_cow == null) {
                return new LimitedRateGroup[0];
            }
            ArrayList<LimitedRateGroup> result = new ArrayList<LimitedRateGroup>();
            for (Object[] entry : this.external_rate_limiters_cow) {
                if ((Boolean)entry[1] != upload) continue;
                result.add((LimitedRateGroup)entry[0]);
            }
            return result.toArray(new LimitedRateGroup[result.size()]);
        }
    }

    public void removeRateLimiter(LimitedRateGroup group, boolean upload) {
        PEPeerManager pm;
        boolean not_stopping = this.getState() != 65;
        try {
            if (not_stopping) {
                this.control_mon.enter();
            }
            if (this.external_rate_limiters_cow != null) {
                ArrayList<Object[]> new_limiters = new ArrayList<Object[]>(this.external_rate_limiters_cow.size() - 1);
                int i = 0;
                while (i < this.external_rate_limiters_cow.size()) {
                    Object[] entry = this.external_rate_limiters_cow.get(i);
                    if (entry[0] != group) {
                        new_limiters.add(entry);
                    }
                    ++i;
                }
                this.external_rate_limiters_cow = new_limiters.size() == 0 ? null : new_limiters;
            }
            pm = this.peer_manager;
        }
        finally {
            if (not_stopping) {
                this.control_mon.exit();
            }
        }
        if (not_stopping && pm != null) {
            pm.removeRateLimiter(group, upload);
        }
    }

    @Override
    public void enqueueReadRequest(PEPeer peer, DiskManagerReadRequest request2, DiskManagerReadRequestListener listener) {
        this.getDiskManager().enqueueReadRequest(request2, listener);
    }

    @Override
    public int activateRequest(InetSocketAddress address) {
        if (this.getState() == 75) {
            byte[] address_bytes;
            int hit_count;
            if (this.download_manager.isLightSeedTracker(address)) {
                return 2;
            }
            long now = SystemTime.getMonotonousTime();
            BloomFilter bloom = this.activation_bloom;
            if (bloom == null) {
                this.activation_bloom = bloom = BloomFilterFactory.createAddRemove4Bit(64);
                this.activation_bloom_create_time = now;
            }
            if ((hit_count = bloom.add(address_bytes = AddressUtils.getAddressBytes(address))) > 5) {
                Logger.log(new LogEvent((Object)this, LogIDs.CORE, 1, "Activate request for " + this.getDisplayName() + " from " + address + " denied as too many recently received"));
                return 0;
            }
            Logger.log(new LogEvent(this, LogIDs.CORE, "Activate request for " + this.getDisplayName() + " from " + address));
            if (now - this.activation_bloom_create_time > 600000L) {
                this.activation_bloom = BloomFilterFactory.createAddRemove4Bit(64);
                this.activation_bloom_create_time = now;
            }
            this.activation_count = bloom.getEntryCount();
            this.activation_count_time = now;
            if (this.download_manager.activateRequest(this.activation_count)) {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public void deactivateRequest(InetSocketAddress address) {
        BloomFilter bloom = this.activation_bloom;
        if (bloom != null) {
            byte[] address_bytes = AddressUtils.getAddressBytes(address);
            int count = bloom.count(address_bytes);
            int i = 0;
            while (i < count) {
                bloom.remove(address_bytes);
                ++i;
            }
            this.activation_count = bloom.getEntryCount();
        }
    }

    @Override
    public byte[] getTargetHash() {
        HashWrapper hw = this.download_manager.getTorrentHashOverride();
        if (hw != null) {
            return hw.getBytes();
        }
        TOTorrent torrent = this.download_manager.getTorrent();
        if (torrent != null) {
            try {
                return torrent.getHash();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public int getTCPListeningPortNumber() {
        return this.download_manager.getTCPListeningPortNumber();
    }

    public int getActivationCount() {
        long now = SystemTime.getMonotonousTime();
        if (this.activation_count > 0 && this.activation_count_time != 0L && now - this.activation_count_time > 600000L) {
            this.activation_count = 0;
        }
        return this.activation_count;
    }

    @Override
    public PeerManagerRegistration getPeerManagerRegistration() {
        return this.peer_manager_registration;
    }

    public boolean isForceStart() {
        return this.force_start;
    }

    public void setForceStart(boolean _force_start) {
        try {
            this.state_mon.enter();
            if (this.force_start != _force_start) {
                this.force_start = _force_start;
                int state = this.getState();
                if (this.force_start && (state == 100 || state == 70 || state == 75)) {
                    this.setState(0, false);
                }
            }
        }
        finally {
            this.state_mon.exit();
        }
        this.download_manager.informStateChanged();
    }

    private void setFailed(DiskManager dm) {
        this.setFailed(dm.getErrorType(), dm.getErrorMessage());
    }

    protected void setFailed(String reason) {
        this.setFailed(1, reason);
    }

    protected void setFailed(String reason, Throwable cause) {
        if (DiskManagerUtil.isNoSpaceException(cause)) {
            this.setFailed(2, MessageText.getString("DiskManager.error.nospace"));
        } else {
            Debug.out(cause);
            this.setFailed(1, String.valueOf(reason) + ": " + Debug.getNestedExceptionMessage(cause));
        }
    }

    protected void setErrorState(int type, String reason, int flags) {
        this.errorFlags = flags;
        this.setFailed(type, reason, true);
    }

    protected void setFailed(int type, String reason) {
        this.setFailed(type, reason, false);
    }

    private void setFailed(int type, String reason, boolean recovering) {
        if (type == 3) {
            this.stopIt(70, false, false, false);
        } else {
            if (reason != null) {
                this.errorDetail = reason;
            }
            this.errorType = type;
            if (!recovering) {
                this.errorFlags = this.force_start ? 1 : 0;
            }
            this.stopIt(100, false, false, false);
        }
    }

    public boolean filesExist(boolean expected_to_be_allocated) {
        if (!expected_to_be_allocated && !this.download_manager.isDataAlreadyAllocated()) {
            return false;
        }
        DiskManager dm = this.getDiskManager();
        if (dm != null) {
            return dm.filesExist();
        }
        this.fileFacadeSet.makeSureFilesFacadeFilled(false);
        DiskManagerFileInfo[] files = this.fileFacadeSet.getFiles();
        int i = 0;
        while (i < files.length) {
            DiskManagerFileInfo fileInfo2 = files[i];
            if (!fileInfo2.getTorrentFile().isPadFile() && !fileInfo2.isSkipped()) {
                File file;
                block10: {
                    try {
                        File save_path;
                        long start = SystemTime.getMonotonousTime();
                        boolean exists = fileInfo2.exists();
                        file = fileInfo2.getFile(true);
                        long elapsed = SystemTime.getMonotonousTime() - start;
                        if (elapsed >= 500L) {
                            Debug.out("Accessing '" + file.getAbsolutePath() + "' in '" + this.getDisplayName() + "' took " + elapsed + "ms - possibly offline");
                        }
                        if (exists) break block10;
                        if (!this.download_manager.getTorrent().isSimpleTorrent() && FileUtil.isAncestorOf(save_path = this.download_manager.getAbsoluteSaveLocation(), file) && !save_path.exists()) {
                            file = save_path;
                        }
                        this.setFailed(4, String.valueOf(MessageText.getString("DownloadManager.error.datamissing")) + ": " + file.getAbsolutePath());
                        return false;
                    }
                    catch (Throwable e) {
                        this.setFailed("Existance check failed", e);
                        return false;
                    }
                }
                if (fileInfo2.getLength() < file.length() && !COConfigurationManager.getBooleanParameter("File.truncate.if.too.large")) {
                    this.setFailed(String.valueOf(MessageText.getString("DownloadManager.error.badsize")) + " " + file + "(" + fileInfo2.getLength() + "/" + file.length() + ")");
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public DiskManagerFileInfoSet getDiskManagerFileInfoSet() {
        this.fileFacadeSet.makeSureFilesFacadeFilled(false);
        return this.fileFacadeSet;
    }

    public DiskManagerFileInfo[] getDiskManagerFileInfo() {
        this.fileFacadeSet.makeSureFilesFacadeFilled(false);
        return this.fileFacadeSet.getFiles();
    }

    protected void fileInfoChanged() {
        this.fileFacadeSet.makeSureFilesFacadeFilled(true);
    }

    protected void filePrioritiesChanged(List files) {
        if (!this.cached_values_set) {
            this.fileFacadeSet.makeSureFilesFacadeFilled(false);
        }
        if (!this.cached_has_dnd_files && files.size() == 1 && !((DiskManagerFileInfo)files.get(0)).isSkipped()) {
            return;
        }
        this.fileFacadeSet.makeSureFilesFacadeFilled(false);
        this.calculateCompleteness(this.fileFacadeSet.facadeFiles);
        this.disk_manager_pieces_snapshot = null;
    }

    protected void calculateCompleteness(DiskManagerFileInfo[] active) {
        boolean complete_excluding_dnd = true;
        boolean has_dnd_files = false;
        int i = 0;
        while (i < active.length) {
            DiskManagerFileInfo file = active[i];
            if (file.isSkipped()) {
                has_dnd_files = true;
            } else if (file.getDownloaded() != file.getLength()) {
                complete_excluding_dnd = false;
            }
            if (has_dnd_files && !complete_excluding_dnd) break;
            ++i;
        }
        this.cached_complete_excluding_dnd = complete_excluding_dnd;
        this.cached_has_dnd_files = has_dnd_files;
        this.cached_values_set = true;
        long flags = (this.cached_complete_excluding_dnd ? 2L : 0L) | (this.cached_has_dnd_files ? 1L : 0L);
        this.download_manager_state.setLongParameter("dndflags", flags);
    }

    protected boolean isDownloadComplete(boolean bIncludeDND) {
        int dm_state;
        if (!this.cached_values_set) {
            this.fileFacadeSet.makeSureFilesFacadeFilled(false);
        }
        if (!this.cached_has_dnd_files) {
            return this.stats.getRemaining() == 0L;
        }
        DiskManager dm = this.getDiskManager();
        if (dm != null && (dm_state = dm.getState()) == 4) {
            long remaining;
            long l = remaining = bIncludeDND ? dm.getRemaining() : dm.getRemainingExcludingDND();
            return remaining == 0L;
        }
        if (bIncludeDND) {
            return false;
        }
        return this.cached_complete_excluding_dnd;
    }

    protected PEPeerManager getPeerManager() {
        return this.peer_manager;
    }

    protected DiskManager getDiskManager() {
        return this.disk_manager_use_accessors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiskManagerPiece[] getDiskManagerPiecesSnapshot() {
        Object object = this.disk_manager_pieces_snapshot_lock;
        synchronized (object) {
            if (this.disk_manager_pieces_snapshot == null) {
                this.disk_manager_pieces_snapshot = DiskManagerUtil.getDiskManagerPiecesSnapshot(this.download_manager);
            }
            return this.disk_manager_pieces_snapshot;
        }
    }

    protected String getErrorDetail() {
        return this.errorDetail;
    }

    protected int getErrorType() {
        return this.errorType;
    }

    protected int getErrorFlags() {
        return this.errorFlags;
    }

    protected void setDiskManager(DiskManager new_disk_manager, DiskManagerListener new_disk_manager_listener) {
        if (new_disk_manager != null) {
            new_disk_manager.setPieceCheckingEnabled(this.piece_checking_enabled);
        }
        try {
            this.disk_listeners_mon.enter();
            DiskManager old_disk_manager = this.disk_manager_use_accessors;
            if (old_disk_manager != null && this.disk_manager_listener_use_accessors != null) {
                old_disk_manager.removeListener(this.disk_manager_listener_use_accessors);
            }
            this.disk_manager_use_accessors = new_disk_manager;
            this.disk_manager_listener_use_accessors = new_disk_manager_listener;
            if (new_disk_manager != null) {
                new_disk_manager.addListener(new_disk_manager_listener);
            }
            this.fileInfoChanged();
            if (new_disk_manager == null && old_disk_manager != null) {
                this.disk_listeners.dispatch(2, old_disk_manager);
            } else if (new_disk_manager != null && old_disk_manager == null) {
                this.disk_listeners.dispatch(1, new_disk_manager);
            } else {
                Debug.out("inconsistent DiskManager state - " + new_disk_manager + "/" + old_disk_manager);
            }
        }
        finally {
            this.disk_listeners_mon.exit();
        }
    }

    public void addDiskListener(DownloadManagerDiskListener listener) {
        try {
            this.disk_listeners_mon.enter();
            this.disk_listeners.addListener(listener);
            DiskManager dm = this.getDiskManager();
            if (dm != null) {
                this.disk_listeners.dispatch(listener, 1, dm);
            }
        }
        finally {
            this.disk_listeners_mon.exit();
        }
    }

    public void removeDiskListener(DownloadManagerDiskListener listener) {
        try {
            this.disk_listeners_mon.enter();
            this.disk_listeners.removeListener(listener);
        }
        finally {
            this.disk_listeners_mon.exit();
        }
    }

    public long getDiskListenerCount() {
        return this.disk_listeners.size();
    }

    @Override
    public String getDisplayName() {
        return this.download_manager.getDisplayName();
    }

    @Override
    public int getEffectiveUploadRateLimitBytesPerSecond() {
        return this.download_manager.getEffectiveUploadRateLimitBytesPerSecond();
    }

    @Override
    public int getUploadRateLimitBytesPerSecond() {
        return this.stats.getUploadRateLimitBytesPerSecond();
    }

    @Override
    public void setUploadRateLimitBytesPerSecond(int b) {
        this.stats.setUploadRateLimitBytesPerSecond(b);
    }

    @Override
    public int getDownloadRateLimitBytesPerSecond() {
        return this.stats.getDownloadRateLimitBytesPerSecond();
    }

    @Override
    public void setDownloadRateLimitBytesPerSecond(int b) {
        this.stats.setDownloadRateLimitBytesPerSecond(b);
    }

    @Override
    public int getPermittedBytesToReceive() {
        return NetworkManager.getSingleton().getRateHandler(false, false).getCurrentNumBytesAllowed()[0];
    }

    @Override
    public void permittedReceiveBytesUsed(int bytes) {
        NetworkManager.getSingleton().getRateHandler(false, false).bytesProcessed(bytes, 0);
    }

    @Override
    public int getPermittedBytesToSend() {
        return NetworkManager.getSingleton().getRateHandler(true, false).getCurrentNumBytesAllowed()[0];
    }

    @Override
    public void permittedSendBytesUsed(int bytes) {
        NetworkManager.getSingleton().getRateHandler(true, false).bytesProcessed(bytes, 0);
    }

    @Override
    public int getMaxUploads() {
        return this.download_manager.getEffectiveMaxUploads();
    }

    @Override
    public int[] getMaxConnections() {
        int[] result = this.download_manager.isMaxConnectionsWhenSeedingEnabled() && this.isStateSeeding() ? this.download_manager.getMaxConnectionsWhenSeeding(this.getEnabledNetworks().length > 1) : this.download_manager.getMaxConnections(this.getEnabledNetworks().length > 1);
        return result;
    }

    @Override
    public int[] getMaxSeedConnections() {
        return this.download_manager.getMaxSeedConnections(this.getEnabledNetworks().length > 1);
    }

    @Override
    public int getUploadPriority() {
        return this.download_manager.getEffectiveUploadPriority();
    }

    @Override
    public int getExtendedMessagingMode() {
        return this.download_manager.getExtendedMessagingMode();
    }

    @Override
    public boolean isPeerExchangeEnabled() {
        return this.download_manager_state.isPeerSourceEnabled("PeerExchange");
    }

    @Override
    public int getCryptoLevel() {
        return this.download_manager.getCryptoLevel();
    }

    @Override
    public boolean isPeriodicRescanEnabled() {
        return this.download_manager_state.getFlag(2L);
    }

    @Override
    public TRTrackerScraperResponse getTrackerScrapeResponse() {
        return this.download_manager.getTrackerScrapeResponse();
    }

    @Override
    public String getTrackerClientExtensions() {
        return this.download_manager_state.getTrackerClientExtensions();
    }

    @Override
    public void setTrackerRefreshDelayOverrides(int percent) {
        this.download_manager.setTrackerRefreshDelayOverrides(percent);
    }

    @Override
    public boolean isNATHealthy() {
        return (Integer)this.download_manager.getNATStatus()[0] == 1;
    }

    @Override
    public boolean isMetadataDownload() {
        return this.download_manager_state.getFlag(512L);
    }

    @Override
    public int getTorrentInfoDictSize() {
        return this.md_info_dict_size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getTorrentInfoDict(PEPeer peer) {
        try {
            String ip = peer.getIp();
            Map<String, int[]> map = this.md_info_peer_history;
            synchronized (map) {
                int now_secs = (int)(SystemTime.getMonotonousTime() / 1000L);
                int[] stats2 = this.md_info_peer_history.get(ip);
                if (stats2 == null) {
                    int[] nArray = new int[2];
                    nArray[0] = now_secs;
                    stats2 = nArray;
                    this.md_info_peer_history.put(ip, stats2);
                }
                if (now_secs - stats2[0] > 300) {
                    stats2[1] = 16384;
                } else {
                    int bytes = stats2[1];
                    if (bytes >= this.md_info_dict_size * 3) {
                        return null;
                    }
                    stats2[1] = bytes + 16384;
                }
            }
            byte[] data = (byte[])this.md_info_dict_ref.get();
            if (data == null) {
                TOTorrent torrent = this.download_manager.getTorrent();
                data = BEncoder.encode((Map)torrent.serialiseToMap().get("info"));
                this.md_info_dict_ref = new WeakReference<byte[]>(data);
            }
            return data;
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Override
    public void addPeer(PEPeer peer) {
        this.download_manager.addPeer(peer);
    }

    @Override
    public void removePeer(PEPeer peer) {
        this.download_manager.removePeer(peer);
    }

    @Override
    public void addPiece(PEPiece piece) {
        this.download_manager.addPiece(piece);
    }

    @Override
    public void removePiece(PEPiece piece) {
        this.download_manager.removePiece(piece);
    }

    @Override
    public void discarded(PEPeer peer, int bytes) {
        if (this.global_stats != null) {
            this.global_stats.discarded(bytes);
        }
    }

    @Override
    public void protocolBytesReceived(PEPeer peer, int bytes) {
        if (this.global_stats != null) {
            this.global_stats.protocolBytesReceived(bytes, peer.isLANLocal());
        }
    }

    @Override
    public void dataBytesReceived(PEPeer peer, int bytes) {
        if (this.global_stats != null) {
            this.global_stats.dataBytesReceived(bytes, peer.isLANLocal());
        }
    }

    @Override
    public void protocolBytesSent(PEPeer peer, int bytes) {
        if (this.global_stats != null) {
            this.global_stats.protocolBytesSent(bytes, peer.isLANLocal());
        }
    }

    @Override
    public void dataBytesSent(PEPeer peer, int bytes) {
        if (this.global_stats != null) {
            this.global_stats.dataBytesSent(bytes, peer.isLANLocal());
        }
    }

    @Override
    public int getPosition() {
        return this.download_manager.getPosition();
    }

    @Override
    public void tick(long mono_now, int tick_count) {
        this.stats.timerTick(tick_count);
    }

    @Override
    public void statsRequest(PEPeer originator, Map request2, Map reply) {
        GlobalManager gm = this.download_manager.getGlobalManager();
        gm.statsRequest(request2, reply);
        HashMap<String, Serializable> info = new HashMap<String, Serializable>();
        reply.put("dl", info);
        try {
            info.put("u_lim", new Long(this.getUploadRateLimitBytesPerSecond()));
            info.put("d_lim", new Long(this.getDownloadRateLimitBytesPerSecond()));
            info.put("u_rate", new Long(this.stats.getProtocolSendRate() + this.stats.getDataSendRate()));
            info.put("d_rate", new Long(this.stats.getProtocolReceiveRate() + this.stats.getDataReceiveRate()));
            info.put("u_slot", new Long(this.getMaxUploads()));
            info.put("c_max", new Long(this.getMaxConnections()[0]));
            info.put("c_leech", new Long(this.download_manager.getNbPeers()));
            info.put("c_seed", new Long(this.download_manager.getNbSeeds()));
            PEPeerManager pm = this.peer_manager;
            if (pm != null) {
                info.put("c_rem", Integer.valueOf(pm.getNbRemoteTCPConnections()));
                info.put("c_rem_utp", Integer.valueOf(pm.getNbRemoteUTPConnections()));
                info.put("c_rem_udp", Integer.valueOf(pm.getNbRemoteUDPConnections()));
                List<PEPeer> peers = pm.getPeers();
                ArrayList<Long> slot_up = new ArrayList<Long>();
                info.put("slot_up", slot_up);
                for (PEPeer p : peers) {
                    if (p.isChokedByMe()) continue;
                    long up = p.getStats().getDataSendRate() + p.getStats().getProtocolSendRate();
                    slot_up.add(up);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHTTPSeed(String address, int port) {
        block7: {
            ExternalSeedPlugin plugin = DownloadManagerController.getExternalSeedPlugin();
            try {
                if (plugin == null) break block7;
                HashMap<String, Cloneable> config = new HashMap<String, Cloneable>();
                ArrayList<byte[]> urls = new ArrayList<byte[]>();
                String seed_url = "http://" + UrlUtils.convertIPV6Host(address) + ":" + port + "/webseed";
                urls.add(seed_url.getBytes());
                config.put("httpseeds", urls);
                HashMap<String, Long> params = new HashMap<String, Long>();
                params.put("supports_503", new Long(0L));
                params.put("transient", new Long(1L));
                config.put("httpseeds-params", params);
                List<ExternalSeedPeer> new_seeds = plugin.addSeed(com.biglybt.pifimpl.local.download.DownloadManagerImpl.getDownloadStatic(this.download_manager), config);
                if (new_seeds.size() <= 0) break block7;
                ArrayList<ExternalSeedPeer> to_remove = new ArrayList<ExternalSeedPeer>();
                LinkedList<ExternalSeedPeer> linkedList = this.http_seeds;
                synchronized (linkedList) {
                    this.http_seeds.addAll(new_seeds);
                    while (this.http_seeds.size() > 64) {
                        ExternalSeedPeer x = this.http_seeds.removeFirst();
                        to_remove.add(x);
                    }
                }
                for (ExternalSeedPeer peer : to_remove) {
                    peer.remove();
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void priorityConnectionChanged(boolean added) {
        DownloadManagerController downloadManagerController = this;
        synchronized (downloadManagerController) {
            this.priority_connection_count = added ? ++this.priority_connection_count : --this.priority_connection_count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasPriorityConnection() {
        DownloadManagerController downloadManagerController = this;
        synchronized (downloadManagerController) {
            return this.priority_connection_count > 0L;
        }
    }

    @Override
    public String getDescription() {
        return this.download_manager.getDisplayName();
    }

    @Override
    public LogRelation getLogRelation() {
        return this;
    }

    @Override
    public String getRelationText() {
        return this.download_manager.getRelationText();
    }

    @Override
    public Object[] getQueryableInterfaces() {
        ArrayList<Object> interfaces = new ArrayList<Object>();
        Object[] intf = this.download_manager.getQueryableInterfaces();
        Collections.addAll(interfaces, intf);
        interfaces.add(this.download_manager);
        DiskManager dm = this.getDiskManager();
        if (dm != null) {
            interfaces.add(dm);
        }
        return interfaces.toArray();
    }

    public void generateEvidence(IndentWriter writer) {
        writer.println("DownloadManager Controller:");
        writer.indent();
        try {
            writer.println("cached info: complete w/o DND=" + this.cached_complete_excluding_dnd + "; hasDND? " + this.cached_has_dnd_files);
            writer.println("Complete w/DND? " + this.isDownloadComplete(true) + "; w/o DND? " + this.isDownloadComplete(false));
            writer.println("filesFacade length: " + this.fileFacadeSet.nbFiles());
            if (this.force_start) {
                writer.println("Force Start");
            }
            writer.println("FilesExist? " + this.filesExist(this.download_manager.isDataAlreadyAllocated()));
        }
        finally {
            writer.exdent();
        }
    }

    static /* synthetic */ LinkedList access$3(DownloadManagerController downloadManagerController) {
        return downloadManagerController.http_seeds;
    }

    static /* synthetic */ DownloadManagerStateAttributeListener access$5(DownloadManagerController downloadManagerController) {
        return downloadManagerController.dm_attribute_listener;
    }

    static /* synthetic */ void access$6(DownloadManagerController downloadManagerController, DownloadManagerStateAttributeListener downloadManagerStateAttributeListener) {
        downloadManagerController.dm_attribute_listener = downloadManagerStateAttributeListener;
    }

    static /* synthetic */ void access$7(DownloadManagerController downloadManagerController, PEPeerManager pEPeerManager) {
        downloadManagerController.peer_manager = pEPeerManager;
    }

    private class DiskManagerListener_Default
    implements DiskManagerListener {
        private final boolean open_for_seeding;

        public DiskManagerListener_Default(boolean open_for_seeding) {
            this.open_for_seeding = open_for_seeding;
        }

        @Override
        public void stateChanged(DiskManager dm, int oldDMState, int newDMState) {
            try {
                DownloadManagerController.this.control_mon.enter();
                DiskManager latest_dm = DownloadManagerController.this.getDiskManager();
                if (latest_dm == null || latest_dm != dm) {
                    return;
                }
            }
            finally {
                DownloadManagerController.this.control_mon.exit();
            }
            try {
                if (newDMState == 10) {
                    DownloadManagerController.this.setFailed(dm);
                }
                if (oldDMState == 3 && newDMState != 3) {
                    DownloadManagerController.this.fileFacadeSet.makeSureFilesFacadeFilled(true);
                    DownloadManagerController.this.stats.recalcDownloadCompleteBytes();
                    DownloadManagerController.this.download_manager.setAssumedComplete(DownloadManagerController.this.isDownloadComplete(false));
                }
                if (newDMState == 4) {
                    int completed = DownloadManagerController.this.stats.getDownloadCompleted(false);
                    if (DownloadManagerController.this.stats.getTotalDataBytesReceived() == 0L && DownloadManagerController.this.stats.getTotalDataBytesSent() == 0L && DownloadManagerController.this.stats.getSecondsDownloading() == 0L) {
                        if (completed < 1000) {
                            if (this.open_for_seeding) {
                                DownloadManagerController.this.setFailed("File check failed");
                                DownloadManagerController.this.download_manager_state.clearResumeData();
                            } else {
                                long amount_downloaded = (long)completed * dm.getTotalLength() / 1000L;
                                boolean sr1 = COConfigurationManager.getBooleanParameter("StartStopManager_bAddForDownloadingSR1");
                                if (sr1) {
                                    DownloadManagerController.this.stats.setSavedDownloadedUploaded(amount_downloaded, amount_downloaded);
                                } else {
                                    DownloadManagerController.this.stats.setSavedDownloadedUploaded(amount_downloaded, 0L);
                                }
                            }
                        } else {
                            int dl_copies = COConfigurationManager.getIntParameter("StartStopManager_iAddForSeedingDLCopyCount");
                            if (dl_copies > 0) {
                                DownloadManagerController.this.stats.setSavedDownloadedUploaded(DownloadManagerController.this.download_manager.getSize() * (long)dl_copies, DownloadManagerController.this.stats.getTotalDataBytesSent());
                            }
                            DownloadManagerController.this.download_manager_state.setFlag(1L, true);
                        }
                    }
                    if (completed == 1000) {
                        DownloadManagerController.this.download_manager_state.discardFluff();
                    }
                }
            }
            finally {
                DownloadManagerController.this.download_manager.informStateChanged();
            }
        }

        @Override
        public void filePriorityChanged(DiskManager dm, DiskManagerFileInfo file) {
            DownloadManagerController.this.download_manager.informPriorityChange(file);
        }

        @Override
        public void pieceDoneChanged(DiskManager dm, DiskManagerPiece piece) {
        }

        @Override
        public void fileCompleted(DiskManager dm, DiskManagerFileInfo file) {
            DownloadManagerController.this.download_manager.informFileCompletionChange(file);
        }
    }

    protected class FileInfoFacadeSet
    implements DiskManagerFileInfoSet {
        DiskManagerFileInfoSet delegate;
        fileInfoFacade[] facadeFiles = new fileInfoFacade[0];

        protected FileInfoFacadeSet() {
        }

        @Override
        public void load(int[] priorities, boolean[] skipped) {
            this.delegate.load(priorities, skipped);
        }

        @Override
        public DiskManagerFileInfo[] getFiles() {
            return this.facadeFiles;
        }

        @Override
        public int nbFiles() {
            if (this.delegate == null) {
                return 0;
            }
            return this.delegate.nbFiles();
        }

        @Override
        public void setPriority(int[] newPriorities) {
            this.delegate.setPriority(newPriorities);
        }

        @Override
        public void setSkipped(boolean[] toChange, boolean setSkipped) {
            this.delegate.setSkipped(toChange, setSkipped);
        }

        @Override
        public boolean[] setStorageTypes(boolean[] toChange, int newStorageType, boolean force) {
            return this.delegate.setStorageTypes(toChange, newStorageType, force);
        }

        protected void fixupFileInfo(fileInfoFacade[] info) {
            if (info.length == 0) {
                return;
            }
            final ArrayList delayed_prio_changes = new ArrayList(0);
            try {
                int dm_state;
                DownloadManagerController.this.facade_mon.enter();
                if (DownloadManagerController.this.files_facade_destroyed) {
                    return;
                }
                DiskManager dm = DownloadManagerController.this.getDiskManager();
                DiskManagerFileInfoSet active = null;
                if (dm != null && ((dm_state = dm.getState()) == 3 || dm_state == 4)) {
                    active = dm.getFileSet();
                }
                if (active == null) {
                    final boolean[] initialising = new boolean[]{true};
                    try {
                        if (++skeleton_builds % 1000L == 0L) {
                            Debug.outNoStack("Skeleton builds: " + skeleton_builds);
                        }
                        active = DiskManagerFactory.getFileInfoSkeleton(DownloadManagerController.this.download_manager, new DiskManagerListener(){

                            @Override
                            public void stateChanged(DiskManager dm, int oldState, int newState) {
                            }

                            @Override
                            public void filePriorityChanged(DiskManager dm, DiskManagerFileInfo file) {
                                if (initialising[0]) {
                                    delayed_prio_changes.add(file);
                                } else {
                                    ((FileInfoFacadeSet)FileInfoFacadeSet.this).DownloadManagerController.this.download_manager.informPriorityChange(file);
                                }
                            }

                            @Override
                            public void pieceDoneChanged(DiskManager dm, DiskManagerPiece piece) {
                            }

                            @Override
                            public void fileCompleted(DiskManager dm, DiskManagerFileInfo file) {
                            }
                        });
                    }
                    finally {
                        initialising[0] = false;
                    }
                    DownloadManagerController.this.calculateCompleteness(active.getFiles());
                }
                DiskManagerFileInfo[] activeFiles = active.getFiles();
                int i = 0;
                while (i < info.length) {
                    info[i].setDelegate(activeFiles[i]);
                    ++i;
                }
                this.delegate = active;
            }
            finally {
                DownloadManagerController.this.facade_mon.exit();
            }
            DownloadManagerController.this.fileFacadeSet.facadeFiles = info;
            DownloadManagerController.this.download_manager.informPrioritiesChange(delayed_prio_changes);
            delayed_prio_changes.clear();
        }

        void makeSureFilesFacadeFilled(boolean refresh) {
            if (!DownloadManagerController.this.bInitialized) {
                return;
            }
            if (this.facadeFiles.length == 0) {
                fileInfoFacade[] newFacadeFiles = new fileInfoFacade[DownloadManagerController.this.download_manager.getTorrent() == null ? 0 : DownloadManagerController.this.download_manager.getTorrent().getFiles().length];
                int i = 0;
                while (i < newFacadeFiles.length) {
                    newFacadeFiles[i] = new fileInfoFacade();
                    ++i;
                }
                DownloadManagerController.this.fileFacadeSet.fixupFileInfo(newFacadeFiles);
            } else if (refresh) {
                this.fixupFileInfo(this.facadeFiles);
            }
        }

        protected void destroyFileInfo() {
            try {
                DownloadManagerController.this.facade_mon.enter();
                if (DownloadManagerController.this.fileFacadeSet == null || DownloadManagerController.this.files_facade_destroyed) {
                    return;
                }
                DownloadManagerController.this.files_facade_destroyed = true;
                int i = 0;
                while (i < this.facadeFiles.length) {
                    this.facadeFiles[i].close();
                    ++i;
                }
            }
            finally {
                DownloadManagerController.this.facade_mon.exit();
            }
        }
    }

    public class ForceRecheckDiskManagerListener
    implements DiskManagerListener {
        private final boolean wasForceStarted;
        private final int start_state;
        private final ForceRecheckListener l;

        public ForceRecheckDiskManagerListener(boolean wasForceStarted, int start_state, ForceRecheckListener l) {
            this.wasForceStarted = wasForceStarted;
            this.start_state = start_state;
            this.l = l;
        }

        @Override
        public void stateChanged(DiskManager dm, int oldDMState, int newDMState) {
            DiskManager latest_dm;
            try {
                DownloadManagerController.this.control_mon.enter();
                latest_dm = DownloadManagerController.this.getDiskManager();
                if (latest_dm == null || latest_dm != dm) {
                    DownloadManagerController.this.download_manager.setAssumedComplete(false);
                    if (this.l != null) {
                        this.l.forceRecheckComplete(DownloadManagerController.this.download_manager, dm.getRecheckCancelled());
                    }
                    return;
                }
            }
            finally {
                DownloadManagerController.this.control_mon.exit();
            }
            if (newDMState == 3) {
                DownloadManagerController.this.fileFacadeSet.makeSureFilesFacadeFilled(true);
            }
            if (newDMState == 4 || newDMState == 10) {
                DownloadManagerController.this.force_start = this.wasForceStarted;
                DownloadManagerController.this.stats.recalcDownloadCompleteBytes();
                if (newDMState == 4) {
                    try {
                        boolean only_seeding = false;
                        boolean update_only_seeding = false;
                        try {
                            DownloadManagerController.this.control_mon.enter();
                            DiskManager latest_dm2 = DownloadManagerController.this.getDiskManager();
                            if (latest_dm2 != null && latest_dm2 == dm) {
                                dm.stop(false);
                                only_seeding = dm.getRemainingExcludingDND() == 0L;
                                update_only_seeding = true;
                                DownloadManagerController.this.setDiskManager(null, null);
                                if (this.start_state == 100) {
                                    DownloadManagerController.this.setState(70, false);
                                } else {
                                    DownloadManagerController.this.setState(this.start_state, false);
                                }
                            }
                        }
                        finally {
                            DownloadManagerController.this.control_mon.exit();
                            DownloadManagerController.this.download_manager.informStateChanged();
                        }
                        if (update_only_seeding) {
                            DownloadManagerController.this.download_manager.setAssumedComplete(only_seeding);
                        }
                    }
                    catch (Exception e) {
                        DownloadManagerController.this.setFailed("Resume data save fails", e);
                    }
                } else {
                    try {
                        DownloadManagerController.this.control_mon.enter();
                        latest_dm = DownloadManagerController.this.getDiskManager();
                        if (latest_dm != null && latest_dm == dm) {
                            dm.stop(false);
                            DownloadManagerController.this.setDiskManager(null, null);
                            DownloadManagerController.this.setFailed(dm);
                        }
                    }
                    finally {
                        DownloadManagerController.this.control_mon.exit();
                    }
                    DownloadManagerController.this.download_manager.setAssumedComplete(false);
                }
                if (this.l != null) {
                    this.l.forceRecheckComplete(DownloadManagerController.this.download_manager, dm.getRecheckCancelled());
                }
            }
        }

        @Override
        public void filePriorityChanged(DiskManager dm, DiskManagerFileInfo file) {
            DownloadManagerController.this.download_manager.informPriorityChange(file);
        }

        @Override
        public void pieceDoneChanged(DiskManager dm, DiskManagerPiece piece) {
        }

        @Override
        public void fileCompleted(DiskManager dm, DiskManagerFileInfo file) {
            DownloadManagerController.this.download_manager.informFileCompletionChange(file);
        }
    }

    static interface ForceRecheckListener {
        public void forceRecheckComplete(DownloadManager var1, boolean var2);
    }

    protected class fileInfoFacade
    implements DiskManagerFileInfo {
        private volatile DiskManagerFileInfo delegate;
        private List<DiskManagerFileInfoListener> listeners;

        protected fileInfoFacade() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setDelegate(DiskManagerFileInfo new_delegate) {
            ArrayList<DiskManagerFileInfoListener> existing_listeners;
            DiskManagerFileInfo old_delegate;
            fileInfoFacade fileInfoFacade2 = this;
            synchronized (fileInfoFacade2) {
                if (new_delegate == this.delegate) {
                    return;
                }
                old_delegate = this.delegate;
                this.delegate = new_delegate;
                existing_listeners = this.listeners == null ? null : new ArrayList<DiskManagerFileInfoListener>(this.listeners);
            }
            if (old_delegate != null) {
                old_delegate.close();
            }
            if (existing_listeners != null) {
                int i = 0;
                while (i < existing_listeners.size()) {
                    new_delegate.addListener((DiskManagerFileInfoListener)existing_listeners.get(i));
                    ++i;
                }
            }
        }

        @Override
        public void setPriority(int b) {
            this.delegate.setPriority(b);
        }

        @Override
        public void setSkipped(boolean b) {
            this.delegate.setSkipped(b);
        }

        @Override
        public Boolean isSkipping() {
            return this.delegate.isSkipping();
        }

        @Override
        public boolean setLink(File link_destination, boolean no_delete) {
            return this.delegate.setLink(link_destination, no_delete);
        }

        @Override
        public String getLastError() {
            return this.delegate.getLastError();
        }

        @Override
        public boolean setLinkAtomic(File link_destination, boolean no_delete) {
            return this.delegate.setLinkAtomic(link_destination, no_delete);
        }

        @Override
        public boolean setLinkAtomic(File link_destination, boolean no_delete, FileUtil.ProgressListener pl) {
            return this.delegate.setLinkAtomic(link_destination, no_delete, pl);
        }

        @Override
        public File getLink() {
            return this.delegate.getLink();
        }

        @Override
        public boolean setStorageType(int type, boolean force) {
            return this.delegate.setStorageType(type, force);
        }

        @Override
        public int getStorageType() {
            return this.delegate.getStorageType();
        }

        @Override
        public int getAccessMode() {
            return this.delegate.getAccessMode();
        }

        @Override
        public long getDownloaded() {
            return this.delegate.getDownloaded();
        }

        @Override
        public long getLastModified() {
            return this.delegate.getLastModified();
        }

        @Override
        public String getExtension() {
            return this.delegate.getExtension();
        }

        @Override
        public int getFirstPieceNumber() {
            return this.delegate.getFirstPieceNumber();
        }

        @Override
        public int getLastPieceNumber() {
            return this.delegate.getLastPieceNumber();
        }

        @Override
        public long getLength() {
            return this.delegate.getLength();
        }

        @Override
        public int getNbPieces() {
            return this.delegate.getNbPieces();
        }

        @Override
        public int getPriority() {
            return this.delegate.getPriority();
        }

        @Override
        public boolean isSkipped() {
            return this.delegate.isSkipped();
        }

        @Override
        public boolean exists() {
            return this.delegate.exists();
        }

        @Override
        public int getIndex() {
            return this.delegate.getIndex();
        }

        @Override
        public DiskManager getDiskManager() {
            return this.delegate.getDiskManager();
        }

        @Override
        public DownloadManager getDownloadManager() {
            return DownloadManagerController.this.download_manager;
        }

        @Override
        public File getFile(boolean follow_link) {
            return this.delegate.getFile(follow_link);
        }

        @Override
        public TOTorrentFile getTorrentFile() {
            return this.delegate.getTorrentFile();
        }

        @Override
        public void flushCache() throws Exception {
            try {
                DownloadManagerController.this.facade_mon.enter();
                this.delegate.flushCache();
            }
            finally {
                DownloadManagerController.this.facade_mon.exit();
            }
        }

        @Override
        public DirectByteBuffer read(long offset, int length) throws IOException {
            try {
                DownloadManagerController.this.facade_mon.enter();
                DirectByteBuffer directByteBuffer = this.delegate.read(offset, length);
                return directByteBuffer;
            }
            finally {
                DownloadManagerController.this.facade_mon.exit();
            }
        }

        @Override
        public int getReadBytesPerSecond() {
            return this.delegate.getReadBytesPerSecond();
        }

        @Override
        public int getWriteBytesPerSecond() {
            return this.delegate.getWriteBytesPerSecond();
        }

        @Override
        public long getETA() {
            return this.delegate.getETA();
        }

        @Override
        public void recheck() {
            this.delegate.recheck();
        }

        @Override
        public void close() {
            try {
                DownloadManagerController.this.facade_mon.enter();
                this.delegate.close();
            }
            finally {
                DownloadManagerController.this.facade_mon.exit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addListener(DiskManagerFileInfoListener listener) {
            DiskManagerFileInfo existing_delegate;
            fileInfoFacade fileInfoFacade2 = this;
            synchronized (fileInfoFacade2) {
                if (this.listeners == null) {
                    this.listeners = new ArrayList<DiskManagerFileInfoListener>();
                }
                this.listeners.add(listener);
                existing_delegate = this.delegate;
            }
            if (existing_delegate != null) {
                existing_delegate.addListener(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeListener(DiskManagerFileInfoListener listener) {
            DiskManagerFileInfo existing_delegate;
            fileInfoFacade fileInfoFacade2 = this;
            synchronized (fileInfoFacade2) {
                this.listeners.remove(listener);
                existing_delegate = this.delegate;
            }
            if (existing_delegate != null) {
                existing_delegate.removeListener(listener);
            }
        }
    }
}

