/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.download;

import com.biglybt.core.Core;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.EnhancedDownloadManager;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.global.GlobalManagerListener;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.disk.DiskManagerChannel;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.pifimpl.local.disk.DiskManagerChannelImpl;
import com.biglybt.util.ExternalStimulusHandler;
import com.biglybt.util.ExternalStimulusListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DownloadManagerEnhancer {
    public static final int TICK_PERIOD = 1000;
    private static TagManager tag_manager = TagManagerFactory.getTagManager();
    private static DownloadManagerEnhancer singleton;
    Core core;
    Map<DownloadManager, EnhancedDownloadManager> download_map = new IdentityHashMap<DownloadManager, EnhancedDownloadManager>();
    private Set<HashWrapper> pause_set = new HashSet<HashWrapper>();
    private boolean progressive_enabled;
    long progressive_active_counter;
    TimerEventPeriodic pa_timer;

    public static synchronized DownloadManagerEnhancer initialise(Core core) {
        if (singleton == null) {
            singleton = new DownloadManagerEnhancer(core);
        }
        return singleton;
    }

    public static synchronized DownloadManagerEnhancer getSingleton() {
        return singleton;
    }

    protected DownloadManagerEnhancer(Core _core) {
        this.core = _core;
        this.core.getGlobalManager().addListener(new GlobalManagerListener(){

            @Override
            public void downloadManagerAdded(DownloadManager dm) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void downloadManagerRemoved(DownloadManager dm) {
                EnhancedDownloadManager edm;
                Map<DownloadManager, EnhancedDownloadManager> map = DownloadManagerEnhancer.this.download_map;
                synchronized (map) {
                    edm = DownloadManagerEnhancer.this.download_map.remove(dm);
                }
                if (edm != null) {
                    edm.destroy();
                }
            }

            @Override
            public void destroyInitiated() {
                DownloadManagerEnhancer.this.resume();
            }

            @Override
            public void destroyed() {
            }

            @Override
            public void seedingStatusChanged(boolean seeding_only_mode, boolean b) {
            }
        }, false);
        ExternalStimulusHandler.addListener(new ExternalStimulusListener(){

            @Override
            public boolean receive(String name, Map values) {
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int query(String name, Map values) {
                if (name.equals("az3.downloadmanager.stream.eta")) {
                    ArrayList<EnhancedDownloadManager> edms_copy;
                    Object hash = values.get("hash");
                    byte[] b_hash = null;
                    if (hash instanceof String) {
                        String hash_str = (String)hash;
                        b_hash = hash_str.length() == 32 ? Base32.decode(hash_str) : ByteFormatter.decodeString(hash_str);
                    }
                    if (b_hash != null) {
                        DownloadManagerEnhancer.this.getEnhancedDownload(b_hash);
                    }
                    Map<DownloadManager, EnhancedDownloadManager> map = DownloadManagerEnhancer.this.download_map;
                    synchronized (map) {
                        edms_copy = new ArrayList<EnhancedDownloadManager>(DownloadManagerEnhancer.this.download_map.values());
                    }
                    for (EnhancedDownloadManager edm : edms_copy) {
                        if (b_hash != null) {
                            long eta;
                            byte[] d_hash = edm.getHash();
                            if (d_hash == null || !Arrays.equals(b_hash, d_hash)) continue;
                            if (edm.getDownloadManager().isDownloadComplete(false)) {
                                return 0;
                            }
                            if (!edm.supportsProgressiveMode()) {
                                return Integer.MIN_VALUE;
                            }
                            if (!edm.getProgressiveMode()) {
                                edm.setProgressiveMode(true);
                            }
                            if ((eta = edm.getProgressivePlayETA()) > Integer.MAX_VALUE) {
                                return Integer.MAX_VALUE;
                            }
                            return (int)eta;
                        }
                        if (!edm.getProgressiveMode()) continue;
                        long eta = edm.getProgressivePlayETA();
                        if (eta > Integer.MAX_VALUE) {
                            return Integer.MAX_VALUE;
                        }
                        return (int)eta;
                    }
                }
                return Integer.MIN_VALUE;
            }
        });
        DiskManagerChannelImpl.addListener(new DiskManagerChannelImpl.channelCreateListener(){

            @Override
            public void channelCreated(DiskManagerChannel channel2) {
                try {
                    EnhancedDownloadManager edm = DownloadManagerEnhancer.this.getEnhancedDownload(PluginCoreUtils.unwrap(channel2.getFile().getDownload()));
                    if (edm == null) {
                        return;
                    }
                    if (edm.getDownloadManager().isDownloadComplete(true)) {
                        return;
                    }
                    if (!edm.getProgressiveMode() && edm.supportsProgressiveMode()) {
                        Debug.out("Enabling progressive mode for '" + edm.getName() + "' due to external stream");
                        edm.setProgressiveMode(true);
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void progressiveActivated() {
        DownloadManagerEnhancer downloadManagerEnhancer = this;
        synchronized (downloadManagerEnhancer) {
            ++this.progressive_active_counter;
            if (this.pa_timer == null) {
                this.pa_timer = SimpleTimer.addPeriodicEvent("DownloadManagerEnhancer:speedChecker", 1000L, new TimerEventPerformer(){
                    private int tick_count;
                    private long last_inactive_marker = 0L;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void perform(TimerEvent event2) {
                        long current_marker;
                        ++this.tick_count;
                        DownloadManagerEnhancer downloadManagerEnhancer = DownloadManagerEnhancer.this;
                        synchronized (downloadManagerEnhancer) {
                            current_marker = DownloadManagerEnhancer.this.progressive_active_counter;
                            if (this.last_inactive_marker == current_marker) {
                                DownloadManagerEnhancer.this.pa_timer.cancel();
                                DownloadManagerEnhancer.this.pa_timer = null;
                                return;
                            }
                        }
                        List<DownloadManager> downloads = DownloadManagerEnhancer.this.core.getGlobalManager().getDownloadManagers();
                        boolean is_active = false;
                        int i = 0;
                        while (i < downloads.size()) {
                            DownloadManager download = downloads.get(i);
                            EnhancedDownloadManager edm = DownloadManagerEnhancer.this.getEnhancedDownload(download);
                            if (edm != null && edm.updateStats(this.tick_count)) {
                                is_active = true;
                            }
                            ++i;
                        }
                        if (!is_active) {
                            this.last_inactive_marker = current_marker;
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pause(DownloadManager dm) {
        TOTorrent torrent = dm.getTorrent();
        if (torrent == null) {
            return;
        }
        try {
            HashWrapper hw = torrent.getHashWrapper();
            Set<HashWrapper> set = this.pause_set;
            synchronized (set) {
                if (this.pause_set.contains(hw)) {
                    return;
                }
                this.pause_set.add(hw);
            }
            dm.pause(false);
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resume(DownloadManager dm) {
        TOTorrent torrent = dm.getTorrent();
        if (torrent == null) {
            return;
        }
        try {
            HashWrapper hw = torrent.getHashWrapper();
            Set<HashWrapper> set = this.pause_set;
            synchronized (set) {
                if (!this.pause_set.remove(hw)) {
                    return;
                }
            }
            dm.resume();
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resume() {
        HashSet<HashWrapper> copy;
        Set<HashWrapper> set = this.pause_set;
        synchronized (set) {
            copy = new HashSet<HashWrapper>(this.pause_set);
            this.pause_set.clear();
        }
        GlobalManager gm = this.core.getGlobalManager();
        for (HashWrapper hw : copy) {
            DownloadManager dm = gm.getDownloadManager(hw);
            if (dm == null) continue;
            dm.resume();
        }
    }

    protected void prepareForProgressiveMode(DownloadManager dm, boolean active) {
        if (active) {
            GlobalManager gm = this.core.getGlobalManager();
            List<DownloadManager> dms = gm.getDownloadManagers();
            for (DownloadManager this_dm : dms) {
                int state;
                if (this_dm == dm || this_dm.isDownloadComplete(false) || (state = this_dm.getState()) != 50 && state != 75) continue;
                this.pause(this_dm);
            }
            if (dm.isPaused()) {
                dm.resume();
            }
        } else {
            this.resume();
        }
    }

    public EnhancedDownloadManager getEnhancedDownload(byte[] hash) {
        DownloadManager dm = this.core.getGlobalManager().getDownloadManager(new HashWrapper(hash));
        if (dm == null) {
            return null;
        }
        return this.getEnhancedDownload(dm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnhancedDownloadManager getEnhancedDownload(DownloadManager manager) {
        TOTorrent torrent = manager.getTorrent();
        if (torrent == null) {
            return null;
        }
        DownloadManager dm2 = manager.getGlobalManager().getDownloadManager(torrent);
        if (dm2 != manager) {
            return null;
        }
        Map<DownloadManager, EnhancedDownloadManager> map = this.download_map;
        synchronized (map) {
            EnhancedDownloadManager res = this.download_map.get(manager);
            if (res == null) {
                res = new EnhancedDownloadManager(this, manager);
                this.download_map.put(manager, res);
            }
            return res;
        }
    }

    public boolean isProgressiveAvailable() {
        if (this.progressive_enabled) {
            return true;
        }
        PluginInterface ms_pi = this.core.getPluginManager().getPluginInterfaceByID("azupnpav", true);
        if (ms_pi != null) {
            this.progressive_enabled = true;
        }
        return this.progressive_enabled;
    }
}

