/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.download;

import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.QTFastStartRAF;
import com.biglybt.core.util.SHA1Simple;
import com.biglybt.pif.disk.DiskManagerChannel;
import com.biglybt.pif.disk.DiskManagerEvent;
import com.biglybt.pif.disk.DiskManagerFileInfo;
import com.biglybt.pif.disk.DiskManagerListener;
import com.biglybt.pif.disk.DiskManagerRandomReadRequest;
import com.biglybt.pif.disk.DiskManagerRequest;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadException;
import com.biglybt.pif.utils.PooledByteBuffer;
import com.biglybt.pifimpl.local.utils.PooledByteBufferImpl;
import java.io.File;

public class DiskManagerFileInfoFile
implements DiskManagerFileInfo {
    private byte[] hash;
    File file;

    public DiskManagerFileInfoFile(File _file) {
        this.file = _file;
        try {
            this.hash = new SHA1Simple().calculateHash(this.file.getAbsolutePath().getBytes("UTF-8"));
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    @Override
    public void setPriority(boolean b) {
    }

    @Override
    public int getNumericPriority() {
        return 0;
    }

    @Override
    public void setNumericPriority(int priority) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public void setSkipped(boolean b) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public Boolean isSkipping() {
        return null;
    }

    @Override
    public void setDeleted(boolean b) {
    }

    @Override
    public void setLink(File link_destination, boolean no_delete) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public File getLink() {
        return null;
    }

    @Override
    public int getAccessMode() {
        return 1;
    }

    @Override
    public long getDownloaded() {
        return this.getLength();
    }

    @Override
    public long getLastModified() {
        return this.file.lastModified();
    }

    @Override
    public long getLength() {
        return this.file.length();
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public File getFile(boolean follow_link) {
        return this.file;
    }

    @Override
    public int getIndex() {
        return 0;
    }

    @Override
    public int getFirstPieceNumber() {
        return 0;
    }

    @Override
    public long getPieceSize() {
        return 32768L;
    }

    @Override
    public int getNumPieces() {
        long piece_size = this.getPieceSize();
        return (int)((this.getLength() + piece_size - 1L) / piece_size);
    }

    @Override
    public boolean isPriority() {
        return false;
    }

    @Override
    public boolean isSkipped() {
        return false;
    }

    @Override
    public boolean isDeleted() {
        return false;
    }

    @Override
    public byte[] getDownloadHash() {
        return this.hash;
    }

    @Override
    public Download getDownload() throws DownloadException {
        throw new DownloadException("Not supported");
    }

    @Override
    public DiskManagerChannel createChannel() throws DownloadException {
        return new channel();
    }

    @Override
    public DiskManagerRandomReadRequest createRandomReadRequest(long file_offset, long length, boolean reverse_order, DiskManagerListener listener) throws DownloadException {
        throw new DownloadException("Not supported");
    }

    protected class channel
    implements DiskManagerChannel {
        volatile boolean channel_destroyed;
        volatile long channel_position;

        protected channel() {
        }

        @Override
        public DiskManagerRequest createRequest() {
            return new request();
        }

        @Override
        public DiskManagerFileInfo getFile() {
            return DiskManagerFileInfoFile.this;
        }

        @Override
        public long getPosition() {
            return this.channel_position;
        }

        @Override
        public boolean isDestroyed() {
            return this.channel_destroyed;
        }

        @Override
        public void destroy() {
            this.channel_destroyed = true;
        }

        protected class request
        implements DiskManagerRequest {
            private long offset;
            private long length;
            private long position;
            private int max_read_chunk = 131072;
            private volatile boolean cancelled;
            private String user_agent;
            private CopyOnWriteList<DiskManagerListener> listeners = new CopyOnWriteList();

            protected request() {
            }

            @Override
            public void setType(int type) {
                if (type != 1) {
                    throw new RuntimeException("Not supported");
                }
            }

            @Override
            public void setOffset(long _offset) {
                this.offset = _offset;
            }

            @Override
            public void setLength(long _length) {
                if (_length < 0L) {
                    throw new RuntimeException("Illegal argument");
                }
                this.length = _length;
            }

            @Override
            public void setMaximumReadChunkSize(int size) {
                this.max_read_chunk = size;
            }

            @Override
            public void setUserAgent(String agent) {
                this.user_agent = agent;
            }

            @Override
            public long getAvailableBytes() {
                return this.getRemaining();
            }

            @Override
            public long getRemaining() {
                return this.offset + this.length - this.position;
            }

            @Override
            public void run() {
                block15: {
                    QTFastStartRAF raf = null;
                    String name = ((channel)channel.this).DiskManagerFileInfoFile.this.file.getName();
                    int dot_pos = name.lastIndexOf(46);
                    String ext = dot_pos < 0 ? "" : name.substring(dot_pos + 1);
                    try {
                        try {
                            raf = new QTFastStartRAF(((channel)channel.this).DiskManagerFileInfoFile.this.file, this.user_agent != null && QTFastStartRAF.isSupportedExtension(ext));
                            raf.seek(this.offset);
                            byte[] buffer = new byte[this.max_read_chunk];
                            long rem = this.length;
                            long pos = this.offset;
                            while (rem > 0L) {
                                if (this.cancelled) {
                                    throw new Exception("Cancelled");
                                }
                                if (channel.this.channel_destroyed) {
                                    throw new Exception("Destroyed");
                                }
                                int chunk = (int)Math.min(rem, (long)this.max_read_chunk);
                                int len = raf.read(buffer, 0, chunk);
                                this.sendEvent(new event(new PooledByteBufferImpl(buffer, 0, len), pos, len));
                                rem -= (long)len;
                                pos += (long)len;
                            }
                        }
                        catch (Throwable e) {
                            this.sendEvent(new event(e));
                            if (raf == null) break block15;
                            try {
                                raf.close();
                            }
                            catch (Throwable e2) {
                                Debug.out(e2);
                            }
                        }
                    }
                    finally {
                        if (raf != null) {
                            try {
                                raf.close();
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                    }
                }
            }

            @Override
            public void cancel() {
                this.cancelled = true;
            }

            protected void sendEvent(event ev) {
                for (DiskManagerListener l : this.listeners) {
                    l.eventOccurred(ev);
                }
            }

            @Override
            public void addListener(DiskManagerListener listener) {
                this.listeners.add(listener);
            }

            @Override
            public void removeListener(DiskManagerListener listener) {
                this.listeners.remove(listener);
            }

            protected class event
            implements DiskManagerEvent {
                private int event_type;
                private Throwable error;
                private PooledByteBuffer buffer;
                private long event_offset;
                private int event_length;

                protected event(Throwable _error) {
                    this.event_type = 2;
                    this.error = _error;
                }

                protected event(PooledByteBuffer _buffer, long _offset, int _length) {
                    this.event_type = 1;
                    this.buffer = _buffer;
                    this.event_offset = _offset;
                    this.event_length = _length;
                    ((request)request.this).channel.this.channel_position = _offset + (long)_length - 1L;
                }

                @Override
                public int getType() {
                    return this.event_type;
                }

                public DiskManagerRequest getRequest() {
                    return request.this;
                }

                @Override
                public long getOffset() {
                    return this.event_offset;
                }

                @Override
                public int getLength() {
                    return this.event_length;
                }

                @Override
                public PooledByteBuffer getBuffer() {
                    return this.buffer;
                }

                @Override
                public Throwable getFailure() {
                    return this.error;
                }
            }
        }
    }
}

