/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.diskmanager.file.impl;

import com.biglybt.core.diskmanager.file.FMFileManagerException;
import com.biglybt.core.diskmanager.file.impl.FMFileAccess;
import com.biglybt.core.diskmanager.file.impl.FMFileImpl;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentFile;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.FileUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class FMFileAccessCompact
implements FMFileAccess {
    private static final byte SS = 4;
    private final File controlFileDir;
    private final String controlFileName;
    private final FMFileAccess delegate;
    private volatile long current_length;
    private static final long version = 0L;
    private volatile boolean write_required;
    private long first_piece_start;
    private long first_piece_length;
    private long last_piece_start;
    private long last_piece_length;

    protected FMFileAccessCompact(TOTorrentFile torrent_file, File _controlFileDir, String _controlFileName, FMFileAccess _delegate) throws FMFileManagerException {
        this.controlFileDir = _controlFileDir;
        this.controlFileName = _controlFileName;
        this.delegate = _delegate;
        try {
            int piece_size = (int)torrent_file.getTorrent().getPieceLength();
            TOTorrent torrent = torrent_file.getTorrent();
            long file_length = torrent_file.getLength();
            long file_offset_in_torrent = 0L;
            int i = 0;
            while (i < torrent.getFiles().length) {
                TOTorrentFile f = torrent.getFiles()[i];
                if (f == torrent_file) break;
                file_offset_in_torrent += f.getLength();
                ++i;
            }
            int piece_offset = piece_size - (int)(file_offset_in_torrent % (long)piece_size);
            if (piece_offset == piece_size) {
                piece_offset = 0;
            }
            this.first_piece_length = piece_offset;
            this.first_piece_start = 0L;
            if (this.first_piece_length >= file_length) {
                this.first_piece_length = file_length;
                this.last_piece_start = file_length;
                this.last_piece_length = 0L;
            } else {
                this.last_piece_length = (file_length - (long)piece_offset) % (long)piece_size;
                this.last_piece_start = file_length - this.last_piece_length;
            }
            if (!FileUtil.newFile(this.controlFileDir, this.controlFileName).exists()) {
                if (!this.controlFileDir.isDirectory() && !FileUtil.mkdirs(this.controlFileDir)) {
                    throw new FMFileManagerException("Directory creation failed: " + this.controlFileDir);
                }
            } else {
                this.readState();
            }
        }
        catch (Throwable e) {
            throw new FMFileManagerException("Compact file init fail", e);
        }
    }

    protected long getFirstPieceStart() {
        return this.first_piece_start;
    }

    protected long getFirstPieceLength() {
        return this.first_piece_length;
    }

    protected long getLastPieceStart() {
        return this.last_piece_start;
    }

    protected long getLastPieceLength() {
        return this.last_piece_length;
    }

    @Override
    public void aboutToOpen() throws FMFileManagerException {
        this.delegate.aboutToOpen();
    }

    @Override
    public long getLength(FMFileAccess.FileAccessor fa) throws FMFileManagerException {
        return this.current_length;
    }

    @Override
    public void setLength(FMFileAccess.FileAccessor fa, long length) throws FMFileManagerException {
        if (length != this.current_length) {
            this.current_length = length;
            this.write_required = true;
        }
    }

    protected void read(FMFileAccess.FileAccessor fa, DirectByteBuffer buffer, long position) throws FMFileManagerException {
        int original_limit = buffer.limit((byte)4);
        try {
            int len = original_limit - buffer.position((byte)4);
            if (position < this.first_piece_start + this.first_piece_length) {
                int available = (int)(this.first_piece_start + this.first_piece_length - position);
                if (available >= len) {
                    this.delegate.read(fa, new DirectByteBuffer[]{buffer}, position);
                    position += (long)len;
                    len = 0;
                } else {
                    buffer.limit((byte)4, buffer.position((byte)4) + available);
                    this.delegate.read(fa, new DirectByteBuffer[]{buffer}, position);
                    buffer.limit((byte)4, original_limit);
                    position += (long)available;
                    len -= available;
                }
            }
            if (len == 0) {
                return;
            }
            long space = this.last_piece_start - position;
            if (space > 0L) {
                if (space >= (long)len) {
                    buffer.position((byte)4, original_limit);
                    position += (long)len;
                    len = 0;
                } else {
                    buffer.position((byte)4, buffer.position((byte)4) + (int)space);
                    position += space;
                    len = (int)((long)len - space);
                }
            }
            if (len == 0) {
                return;
            }
            this.delegate.read(fa, new DirectByteBuffer[]{buffer}, position - this.last_piece_start + this.first_piece_length);
        }
        finally {
            buffer.limit((byte)4, original_limit);
        }
    }

    @Override
    public void read(FMFileAccess.FileAccessor fa, DirectByteBuffer[] buffers, long position) throws FMFileManagerException {
        int i = 0;
        while (i < buffers.length) {
            DirectByteBuffer buffer = buffers[i];
            int len = buffers[i].limit((byte)4) - buffers[i].position((byte)4);
            this.read(fa, buffer, position);
            int rem = buffers[i].remaining((byte)4);
            position += (long)(len - rem);
            if (rem > 0) break;
            ++i;
        }
        if (position > this.current_length) {
            this.setLength(fa, position);
        }
    }

    protected void write(FMFileAccess.FileAccessor fa, DirectByteBuffer buffer, long position) throws FMFileManagerException {
        int original_limit = buffer.limit((byte)4);
        try {
            int len = original_limit - buffer.position((byte)4);
            if (position < this.first_piece_start + this.first_piece_length) {
                int available = (int)(this.first_piece_start + this.first_piece_length - position);
                if (available >= len) {
                    this.delegate.write(fa, new DirectByteBuffer[]{buffer}, position);
                    position += (long)len;
                    len = 0;
                } else {
                    buffer.limit((byte)4, buffer.position((byte)4) + available);
                    this.delegate.write(fa, new DirectByteBuffer[]{buffer}, position);
                    buffer.limit((byte)4, original_limit);
                    position += (long)available;
                    len -= available;
                }
            }
            if (len == 0) {
                return;
            }
            long space = this.last_piece_start - position;
            if (space > 0L) {
                if (space >= (long)len) {
                    buffer.position((byte)4, original_limit);
                    position += (long)len;
                    len = 0;
                } else {
                    buffer.position((byte)4, buffer.position((byte)4) + (int)space);
                    position += space;
                    len = (int)((long)len - space);
                }
            }
            if (len == 0) {
                return;
            }
            this.delegate.write(fa, new DirectByteBuffer[]{buffer}, position - this.last_piece_start + this.first_piece_length);
        }
        finally {
            buffer.limit((byte)4, original_limit);
        }
    }

    @Override
    public void write(FMFileAccess.FileAccessor fa, DirectByteBuffer[] buffers, long position) throws FMFileManagerException {
        int i = 0;
        while (i < buffers.length) {
            DirectByteBuffer buffer = buffers[i];
            int len = buffers[i].limit((byte)4) - buffers[i].position((byte)4);
            this.write(fa, buffer, position);
            position += (long)len;
            ++i;
        }
        if (position > this.current_length) {
            this.setLength(fa, position);
        }
    }

    @Override
    public void flush() throws FMFileManagerException {
        this.writeState();
    }

    @Override
    public boolean isPieceCompleteProcessingNeeded(int piece_number) {
        return false;
    }

    @Override
    public void setPieceComplete(FMFileAccess.FileAccessor fa, int piece_number, DirectByteBuffer piece_data) throws FMFileManagerException {
    }

    protected void readState() throws FMFileManagerException {
        try {
            Map data = FileUtil.readResilientFile(this.controlFileDir, this.controlFileName, false);
            if (data != null && data.size() > 0) {
                Long length = (Long)data.get("length");
                this.current_length = length;
            }
        }
        catch (Throwable e) {
            throw new FMFileManagerException("Failed to read control file state", e);
        }
    }

    protected void writeState() throws FMFileManagerException {
        boolean write = this.write_required;
        if (write) {
            this.write_required = false;
            try {
                HashMap<String, Long> data = new HashMap<String, Long>();
                data.put("version", 0L);
                data.put("length", this.current_length);
                FileUtil.writeResilientFile(this.controlFileDir, this.controlFileName, data, false);
            }
            catch (Throwable e) {
                throw new FMFileManagerException("Failed to write control file state", e);
            }
        }
    }

    @Override
    public FMFileImpl getFile() {
        return this.delegate.getFile();
    }

    @Override
    public String getString() {
        return "compact";
    }
}

