/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.diskmanager.cache.impl;

import com.biglybt.core.diskmanager.cache.CacheFileManagerStats;
import com.biglybt.core.diskmanager.cache.impl.CacheFileManagerImpl;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.Average;

public class CacheFileManagerStatsImpl
implements CacheFileManagerStats {
    protected final CacheFileManagerImpl manager;
    protected final Average cache_read_average = Average.getInstance(1000, 10);
    protected final Average cache_write_average = Average.getInstance(1000, 10);
    protected final Average file_read_average = Average.getInstance(1000, 10);
    protected final Average file_write_average = Average.getInstance(1000, 5);
    protected long last_cache_read;
    protected long last_cache_write;
    protected long last_file_read;
    protected long last_file_write;
    protected final AEMonitor this_mon = new AEMonitor("CacheFileManagerStats");

    protected CacheFileManagerStatsImpl(CacheFileManagerImpl _manager) {
        this.manager = _manager;
    }

    protected void update() {
        try {
            this.this_mon.enter();
            long cache_read = this.manager.getBytesReadFromCache();
            long cache_read_diff = cache_read - this.last_cache_read;
            this.last_cache_read = cache_read;
            this.cache_read_average.addValue(cache_read_diff);
            long cache_write = this.manager.getBytesWrittenToCache();
            long cache_write_diff = cache_write - this.last_cache_write;
            this.last_cache_write = cache_write;
            this.cache_write_average.addValue(cache_write_diff);
            long file_read = this.manager.getBytesReadFromFile();
            long file_read_diff = file_read - this.last_file_read;
            this.last_file_read = file_read;
            this.file_read_average.addValue(file_read_diff);
            long file_write = this.manager.getBytesWrittenToFile();
            long file_write_diff = file_write - this.last_file_write;
            this.last_file_write = file_write;
            this.file_write_average.addValue(file_write_diff);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public long getSize() {
        return this.manager.getCacheSize();
    }

    @Override
    public long getUsedSize() {
        return this.manager.getCacheUsed();
    }

    @Override
    public long getBytesWrittenToCache() {
        return this.manager.getBytesWrittenToCache();
    }

    @Override
    public long getBytesWrittenToFile() {
        return this.manager.getBytesWrittenToFile();
    }

    @Override
    public long getBytesReadFromCache() {
        return this.manager.getBytesReadFromCache();
    }

    @Override
    public long getBytesReadFromFile() {
        return this.manager.getBytesReadFromFile();
    }

    @Override
    public long getAverageBytesWrittenToCache() {
        return this.cache_write_average.getAverage();
    }

    @Override
    public long getAverageBytesWrittenToFile() {
        return this.file_write_average.getAverage();
    }

    @Override
    public long getAverageBytesReadFromCache() {
        return this.cache_read_average.getAverage();
    }

    @Override
    public long getAverageBytesReadFromFile() {
        return this.file_read_average.getAverage();
    }

    @Override
    public long getCacheReadCount() {
        return this.manager.getCacheReadCount();
    }

    @Override
    public long getCacheWriteCount() {
        return this.manager.getCacheWriteCount();
    }

    @Override
    public long getFileReadCount() {
        return this.manager.getFileReadCount();
    }

    @Override
    public long getFileWriteCount() {
        return this.manager.getFileWriteCount();
    }

    @Override
    public boolean[] getBytesInCache(TOTorrent torrent, long[] absoluteOffsets, long[] lengths) {
        return this.manager.getBytesInCache(torrent, absoluteOffsets, lengths);
    }
}

