/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.disk.impl.piecemapper.impl;

import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.disk.impl.piecemapper.DMPieceList;
import com.biglybt.core.disk.impl.piecemapper.DMPieceMap;
import com.biglybt.core.disk.impl.piecemapper.DMPieceMapEntry;
import com.biglybt.core.torrent.TOTorrent;

public class DMPieceMapSimple
implements DMPieceMap {
    final int piece_length;
    final int piece_count;
    final int last_piece_length;
    final DiskManagerFileInfo file;

    protected DMPieceMapSimple(TOTorrent torrent, DiskManagerFileInfo _file) {
        this.piece_length = (int)torrent.getPieceLength();
        this.piece_count = torrent.getNumberOfPieces();
        int lpl = (int)(torrent.getSize() % (long)this.piece_length);
        if (lpl == 0) {
            lpl = this.piece_length;
        }
        this.last_piece_length = lpl;
        this.file = _file;
    }

    @Override
    public DMPieceList getPieceList(int piece_number) {
        return new pieceList(piece_number);
    }

    protected class pieceList
    implements DMPieceList,
    DMPieceMapEntry {
        private final int piece_number;

        protected pieceList(int _piece_number) {
            this.piece_number = _piece_number;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public DMPieceMapEntry get(int index) {
            return this;
        }

        @Override
        public int getCumulativeLengthToPiece(int file_index) {
            return this.getLength();
        }

        @Override
        public DiskManagerFileInfo getFile() {
            return DMPieceMapSimple.this.file;
        }

        @Override
        public long getOffset() {
            return (long)this.piece_number * (long)DMPieceMapSimple.this.piece_length;
        }

        @Override
        public int getLength() {
            if (this.piece_number == DMPieceMapSimple.this.piece_count - 1) {
                return DMPieceMapSimple.this.last_piece_length;
            }
            return DMPieceMapSimple.this.piece_length;
        }
    }
}

