/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.disk.impl.access.impl;

import com.biglybt.core.disk.DiskManagerReadRequest;
import com.biglybt.core.disk.impl.access.impl.DiskManagerRequestImpl;
import com.biglybt.core.util.SystemTime;

public class DiskManagerReadRequestImpl
extends DiskManagerRequestImpl
implements DiskManagerReadRequest {
    private static final int EXPIRATION_TIME = 60000;
    private final int pieceNumber;
    private final int offset;
    private final int length;
    private final int hashcode;
    private long timeCreatedMono;
    private long timeSent;
    private boolean flush;
    private boolean cancelled;
    private boolean use_cache = true;
    private boolean latency_test;

    public DiskManagerReadRequestImpl(int _pieceNumber, int _offset, int _length) {
        this.pieceNumber = _pieceNumber;
        this.offset = _offset;
        this.length = _length;
        this.timeCreatedMono = SystemTime.getMonotonousTime();
        this.hashcode = this.pieceNumber + this.offset + this.length;
    }

    @Override
    protected String getName() {
        return "Read: " + this.pieceNumber + ",off=" + this.offset + ",len=" + this.length + ",fl=" + this.flush + ",uc=" + this.use_cache;
    }

    @Override
    public boolean isExpired() {
        long mono_now = SystemTime.getMonotonousTime();
        return mono_now - this.timeCreatedMono > 60000L;
    }

    @Override
    public void resetTimeMono(long mono_now) {
        this.timeCreatedMono = mono_now;
    }

    @Override
    public int getPieceNumber() {
        return this.pieceNumber;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public void setFlush(boolean _flush) {
        this.flush = _flush;
    }

    @Override
    public boolean getFlush() {
        return this.flush;
    }

    @Override
    public void setUseCache(boolean cache) {
        this.use_cache = cache;
    }

    @Override
    public boolean getUseCache() {
        return this.use_cache;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DiskManagerReadRequestImpl)) {
            return false;
        }
        DiskManagerReadRequestImpl otherRequest = (DiskManagerReadRequestImpl)o;
        if (otherRequest.pieceNumber != this.pieceNumber) {
            return false;
        }
        if (otherRequest.offset != this.offset) {
            return false;
        }
        return otherRequest.length == this.length;
    }

    @Override
    public int hashCode() {
        return this.hashcode;
    }

    @Override
    public long getTimeCreatedMono() {
        return this.timeCreatedMono;
    }

    @Override
    public void setTimeSent(long time) {
        this.timeSent = time;
    }

    @Override
    public long getTimeSent() {
        return this.timeSent;
    }

    @Override
    public void setLatencyTest() {
        this.latency_test = true;
    }

    @Override
    public boolean isLatencyTest() {
        return this.latency_test;
    }
}

