/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.disk.impl;

import com.biglybt.core.CoreOperation;
import com.biglybt.core.CoreOperationTask;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.disk.DiskManagerCheckRequest;
import com.biglybt.core.disk.DiskManagerCheckRequestListener;
import com.biglybt.core.disk.DiskManagerFactory;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.disk.DiskManagerFileInfoListener;
import com.biglybt.core.disk.DiskManagerFileInfoSet;
import com.biglybt.core.disk.DiskManagerListener;
import com.biglybt.core.disk.DiskManagerPiece;
import com.biglybt.core.disk.DiskManagerReadRequest;
import com.biglybt.core.disk.DiskManagerReadRequestListener;
import com.biglybt.core.disk.DiskManagerWriteRequest;
import com.biglybt.core.disk.DiskManagerWriteRequestListener;
import com.biglybt.core.disk.impl.DiskManagerFileInfoHelper;
import com.biglybt.core.disk.impl.DiskManagerFileInfoImpl;
import com.biglybt.core.disk.impl.DiskManagerFileInfoSetImpl;
import com.biglybt.core.disk.impl.DiskManagerHelper;
import com.biglybt.core.disk.impl.DiskManagerImpl;
import com.biglybt.core.disk.impl.DiskManagerOperationScheduler;
import com.biglybt.core.disk.impl.DiskManagerPieceImpl;
import com.biglybt.core.disk.impl.DiskManagerRecheckScheduler;
import com.biglybt.core.disk.impl.piecemapper.DMPieceList;
import com.biglybt.core.disk.impl.piecemapper.DMPieceMap;
import com.biglybt.core.disk.impl.piecemapper.DMPieceMapper;
import com.biglybt.core.disk.impl.piecemapper.DMPieceMapperFactory;
import com.biglybt.core.disk.impl.piecemapper.DMPieceMapperFile;
import com.biglybt.core.disk.impl.resume.RDResumeHandler;
import com.biglybt.core.diskmanager.access.DiskAccessController;
import com.biglybt.core.diskmanager.cache.CacheFile;
import com.biglybt.core.diskmanager.cache.CacheFileManagerFactory;
import com.biglybt.core.diskmanager.cache.CacheFileOwner;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerException;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.download.DownloadManagerStats;
import com.biglybt.core.download.impl.DownloadManagerStatsImpl;
import com.biglybt.core.internat.LocaleTorrentUtil;
import com.biglybt.core.internat.LocaleUtilDecoder;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.peermanager.piecepicker.util.BitFlags;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentException;
import com.biglybt.core.torrent.TOTorrentFile;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.DirectByteBufferPool;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.IndentWriter;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DiskManagerUtil {
    private static final LogIDs LOGID = LogIDs.DISK;
    protected static int max_read_block_size;
    static final AEMonitor cache_read_mon;
    private static List<CoreOperationTask> move_tasks;

    static {
        ParameterListener param_listener = new ParameterListener(){

            @Override
            public void parameterChanged(String str) {
                max_read_block_size = COConfigurationManager.getIntParameter("BT Request Max Block Size");
            }
        };
        COConfigurationManager.addAndFireParameterListener("BT Request Max Block Size", param_listener);
        cache_read_mon = new AEMonitor("DiskManager:cacheRead");
        move_tasks = new ArrayList<CoreOperationTask>();
    }

    public static boolean checkBlockConsistencyForHint(DiskManager dm, String originator, int pieceNumber, int offset, int length) {
        if (length <= 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)dm, LOGID, 3, "Hint invalid: " + originator + " length=" + length + " <= 0"));
            }
            return false;
        }
        if (pieceNumber < 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)dm, LOGID, 3, "Hint invalid: " + originator + " pieceNumber=" + pieceNumber + " < 0"));
            }
            return false;
        }
        if (pieceNumber >= dm.getNbPieces()) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)dm, LOGID, 3, "Hint invalid: " + originator + " pieceNumber=" + pieceNumber + " >= this.nbPieces=" + dm.getNbPieces()));
            }
            return false;
        }
        int pLength = dm.getPieceLength(pieceNumber);
        if (offset < 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)dm, LOGID, 3, "Hint invalid: " + originator + " offset=" + offset + " < 0"));
            }
            return false;
        }
        if (offset > pLength) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)dm, LOGID, 3, "Hint invalid: " + originator + " offset=" + offset + " > pLength=" + pLength));
            }
            return false;
        }
        if (offset + length > pLength) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)dm, LOGID, 3, "Hint invalid: " + originator + " offset=" + offset + " + length=" + length + " > pLength=" + pLength));
            }
            return false;
        }
        return true;
    }

    public static boolean checkBlockConsistencyForRead(DiskManager dm, String originator, boolean peer_request, int pieceNumber, int offset, int length) {
        if (!DiskManagerUtil.checkBlockConsistencyForHint(dm, originator, pieceNumber, offset, length)) {
            return false;
        }
        if (length > max_read_block_size && peer_request) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)dm, LOGID, 3, "Read invalid: " + originator + " length=" + length + " > " + max_read_block_size));
            }
            return false;
        }
        if (!dm.getPiece(pieceNumber).isDone()) {
            Logger.log(new LogEvent((Object)dm, LOGID, 3, "Read invalid: " + originator + " piece #" + pieceNumber + " not done"));
            return false;
        }
        return true;
    }

    public static void doFileExistenceChecksAfterSkipChange(DiskManagerFileInfoSet fileSet, boolean[] toCheck, boolean isSkipped, DownloadManager dm) {
        if (!dm.isConstructed()) {
            return;
        }
        DiskManagerFileInfo[] files = fileSet.getFiles();
        boolean[] interesting = new boolean[files.length];
        int i = 0;
        while (i < files.length) {
            DiskManagerFileInfo file = files[i];
            if (toCheck[i]) {
                interesting[i] = true;
                int firstPiece = file.getFirstPieceNumber();
                int j = i - 1;
                while (j >= 0) {
                    if (files[j].getLastPieceNumber() != firstPiece) break;
                    interesting[j] = true;
                    --j;
                }
                int lastPiece = file.getLastPieceNumber();
                int j2 = i + 1;
                while (j2 < files.length) {
                    if (files[j2].getFirstPieceNumber() != lastPiece) break;
                    interesting[j2] = true;
                    ++j2;
                }
            }
            ++i;
        }
        ArrayList<DiskManagerFileInfo> reallocs = new ArrayList<DiskManagerFileInfo>();
        String[] types = DiskManagerImpl.getStorageTypes(dm);
        int i2 = 0;
        while (i2 < interesting.length) {
            if (interesting[i2]) {
                File currentFile;
                int st;
                DiskManagerFileInfo file = files[i2];
                if (RDResumeHandler.fileMustExist(dm, fileSet, file)) {
                    if (!isSkipped && !file.exists()) {
                        reallocs.add(file);
                    }
                } else if (isSkipped && ((st = DiskManagerUtil.convertDMStorageTypeFromString(types[i2])) == 2 || st == 4) && (currentFile = file.getFile(true)).exists()) {
                    FileUtil.log("Deleting \"" + currentFile.getAbsolutePath() + "\" as no longer required", true);
                    boolean no_recycle = true;
                    FileUtil.deleteWithRecycle(currentFile, dm.getDownloadState().getFlag(16L) || no_recycle);
                }
            }
            ++i2;
        }
        if (!reallocs.isEmpty()) {
            dm.requestAllocation(reallocs);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static String setFileLink(DownloadManager download_manager, DiskManagerFileInfo[] info, DiskManagerFileInfo file_info, File from_file, File to_link, boolean dont_delete_existing, FileUtil.ProgressListener pl) {
        block10: {
            File existing_file;
            block12: {
                block13: {
                    block11: {
                        if (to_link == null) break block10;
                        existing_file = file_info.getFile(true);
                        if (!to_link.equals(existing_file)) break block11;
                        if (!FileUtil.areFilePathsIdentical(to_link, existing_file) && existing_file.exists() && !FileUtil.renameFile(existing_file, to_link)) {
                            String error = "Failed to rename '" + existing_file.toString() + "' to '" + to_link.toString() + "'";
                            Logger.log(new LogAlert((Object)download_manager, true, 3, error));
                            return error;
                        }
                        break block10;
                    }
                    int i = 0;
                    while (i < info.length) {
                        if (to_link.equals(info[i].getFile(true))) {
                            String error = "Attempt to link to existing file '" + info[i].getFile(true) + "'";
                            Logger.log(new LogAlert((Object)download_manager, true, 3, error));
                            return error;
                        }
                        ++i;
                    }
                    if (!to_link.exists()) break block12;
                    if (existing_file.exists()) break block13;
                    download_manager.recheckFile(file_info);
                    break block10;
                }
                if (to_link.getParent().equals(existing_file.getParent()) && to_link.getName().equalsIgnoreCase(existing_file.getName())) {
                    if (!FileUtil.renameFile(existing_file, to_link)) {
                        String error = "Failed to rename '" + existing_file.toString() + "' to '" + to_link.toString() + "'";
                        Logger.log(new LogAlert((Object)download_manager, true, 3, error));
                        return error;
                    }
                    break block10;
                } else if (dont_delete_existing) {
                    download_manager.recheckFile(file_info);
                    break block10;
                } else {
                    int st = file_info.getStorageType();
                    boolean no_recycle = st == 2 || st == 4;
                    FileUtil.log("Deleting \"" + existing_file.getAbsolutePath() + "\" as no longer required", true);
                    if (!FileUtil.deleteWithRecycle(existing_file, download_manager.getDownloadState().getFlag(16L) || no_recycle)) {
                        String error = "Failed to delete '" + existing_file.toString() + "'";
                        Logger.log(new LogAlert((Object)download_manager, true, 3, error));
                        return error;
                    }
                    download_manager.recheckFile(file_info);
                }
                break block10;
            }
            if (existing_file.exists() && !FileUtil.renameFile(existing_file, to_link, pl)) {
                String error = "Failed to rename '" + existing_file.toString() + "' to '" + to_link.toString() + "'";
                Logger.log(new LogAlert((Object)download_manager, true, 3, error));
                return error;
            }
        }
        DownloadManagerState state = download_manager.getDownloadState();
        state.setFileLink(file_info.getIndex(), from_file, to_link);
        state.save(false);
        return null;
    }

    public static DiskManagerFileInfoSet getFileInfoSkeleton(final DownloadManager download_manager, DiskManagerListener listener) {
        TOTorrent torrent = download_manager.getTorrent();
        if (torrent == null) {
            return new DiskManagerFileInfoSetImpl(new DiskManagerFileInfoImpl[0], null);
        }
        File tempRootDir = download_manager.getAbsoluteSaveLocation().getParentFile();
        if (tempRootDir == null) {
            tempRootDir = download_manager.getAbsoluteSaveLocation();
        }
        if (!torrent.isSimpleTorrent()) {
            tempRootDir = FileUtil.newFile(tempRootDir, download_manager.getAbsoluteSaveLocation().getName());
        }
        boolean[] loading = new boolean[]{true};
        File root_dir = tempRootDir;
        try {
            LocaleUtilDecoder locale_decoder = LocaleTorrentUtil.getTorrentEncoding(torrent);
            TOTorrentFile[] torrent_files = torrent.getFiles();
            DiskManagerFileInfoHelper[] res = new FileSkeleton[torrent_files.length];
            String incomplete_suffix = download_manager.getDownloadState().getAttribute("incompfilesuffix");
            DiskManagerFileInfoSet fileSetSkeleton = new DiskManagerFileInfoSet((FileSkeleton[])res, loading, download_manager, listener){
                private final /* synthetic */ FileSkeleton[] val$res;
                private final /* synthetic */ boolean[] val$loading;
                private final /* synthetic */ DownloadManager val$download_manager;
                private final /* synthetic */ DiskManagerListener val$listener;
                {
                    this.val$res = fileSkeletonArray;
                    this.val$loading = blArray;
                    this.val$download_manager = downloadManager;
                    this.val$listener = diskManagerListener;
                }

                @Override
                public void load(int[] priorities, boolean[] skipped) {
                    int i = 0;
                    while (i < priorities.length) {
                        this.val$res[i].load(priorities[i], skipped[i]);
                        ++i;
                    }
                }

                @Override
                public DiskManagerFileInfo[] getFiles() {
                    return this.val$res;
                }

                private DiskManager getDiskManager() {
                    return null;
                }

                @Override
                public int nbFiles() {
                    return this.val$res.length;
                }

                @Override
                public void setPriority(int[] newPriorities) {
                    if (newPriorities.length != this.val$res.length) {
                        throw new IllegalArgumentException("array length mismatches the number of files");
                    }
                    int i = 0;
                    while (i < this.val$res.length) {
                        this.val$res[i].priority = newPriorities[i];
                        ++i;
                    }
                    if (!this.val$loading[0]) {
                        DiskManagerImpl.storeFilePriorities(this.val$download_manager, this.val$res);
                    }
                    i = 0;
                    while (i < this.val$res.length) {
                        if (newPriorities[i] != 0) {
                            this.val$listener.filePriorityChanged(this.getDiskManager(), this.val$res[i]);
                        }
                        ++i;
                    }
                }

                @Override
                public void setSkipped(boolean[] toChange, boolean setSkipped) {
                    if (toChange.length != this.val$res.length) {
                        throw new IllegalArgumentException("array length mismatches the number of files");
                    }
                    if (!setSkipped) {
                        String[] types = DiskManagerImpl.getStorageTypes(this.val$download_manager);
                        boolean[] toLinear = new boolean[toChange.length];
                        boolean[] toReorder = new boolean[toChange.length];
                        int num_linear = 0;
                        int num_reorder = 0;
                        int i = 0;
                        while (i < toChange.length) {
                            if (toChange[i]) {
                                int old_type = DiskManagerUtil.convertDMStorageTypeFromString(types[i]);
                                if (old_type == 2) {
                                    toLinear[i] = true;
                                    ++num_linear;
                                } else if (old_type == 4) {
                                    toReorder[i] = true;
                                    ++num_reorder;
                                }
                            }
                            ++i;
                        }
                        if (num_linear > 0 && !Arrays.equals(toLinear, this.setStorageTypes(toLinear, 1))) {
                            return;
                        }
                        if (num_reorder > 0 && !Arrays.equals(toReorder, this.setStorageTypes(toReorder, 3))) {
                            return;
                        }
                    }
                    File[] to_link = new File[this.val$res.length];
                    int i = 0;
                    while (i < this.val$res.length) {
                        if (toChange[i]) {
                            to_link[i] = this.val$res[i].setSkippedInternal(setSkipped);
                        }
                        ++i;
                    }
                    if (!this.val$loading[0]) {
                        DiskManagerImpl.storeFilePriorities(this.val$download_manager, this.val$res);
                    }
                    ArrayList<Integer> from_indexes = new ArrayList<Integer>();
                    ArrayList<File> from_links = new ArrayList<File>();
                    ArrayList<File> to_links = new ArrayList<File>();
                    int i2 = 0;
                    while (i2 < this.val$res.length) {
                        if (to_link[i2] != null) {
                            from_indexes.add(i2);
                            from_links.add(this.val$res[i2].getFile(false));
                            to_links.add(to_link[i2]);
                        }
                        ++i2;
                    }
                    if (from_links.size() > 0) {
                        this.val$download_manager.getDownloadState().setFileLinks(from_indexes, from_links, to_links);
                    }
                    i2 = 0;
                    while (i2 < this.val$res.length) {
                        if (toChange[i2]) {
                            this.val$listener.filePriorityChanged(this.getDiskManager(), this.val$res[i2]);
                        }
                        ++i2;
                    }
                    DiskManagerUtil.doFileExistenceChecksAfterSkipChange(this, toChange, setSkipped, this.val$download_manager);
                }

                @Override
                public boolean[] setStorageTypes(boolean[] toChange, int newStorageType, boolean force) {
                    if (toChange.length != this.val$res.length) {
                        throw new IllegalArgumentException("array length mismatches the number of files");
                    }
                    String[] types = DiskManagerImpl.getStorageTypes(this.val$download_manager);
                    boolean[] modified = new boolean[this.val$res.length];
                    boolean[] toSkip = new boolean[this.val$res.length];
                    int toSkipCount = 0;
                    DownloadManagerState dmState = this.val$download_manager.getDownloadState();
                    try {
                        dmState.suppressStateSave(true);
                        boolean recalc_dl = false;
                        int i = 0;
                        while (i < this.val$res.length) {
                            if (toChange[i]) {
                                final int idx = i;
                                int old_type = DiskManagerUtil.convertDMStorageTypeFromString(types[i]);
                                if (newStorageType == old_type) {
                                    modified[i] = true;
                                } else {
                                    try {
                                        File target_file = this.val$res[i].getFile(true);
                                        if (target_file.exists()) {
                                            CacheFile cache_file = CacheFileManagerFactory.getSingleton().createFile(new CacheFileOwner(){

                                                @Override
                                                public String getCacheFileOwnerName() {
                                                    return val$download_manager.getInternalName();
                                                }

                                                @Override
                                                public TOTorrentFile getCacheFileTorrentFile() {
                                                    return val$res[idx].getTorrentFile();
                                                }

                                                @Override
                                                public File getCacheFileControlFileDir() {
                                                    return val$download_manager.getDownloadState().getStateFile();
                                                }

                                                @Override
                                                public int getCacheMode() {
                                                    return 1;
                                                }
                                            }, target_file, DiskManagerUtil.convertDMStorageTypeToCache(newStorageType), force);
                                            cache_file.getLength();
                                            cache_file.close();
                                        }
                                        boolean bl = toSkip[i] = (newStorageType == 2 || newStorageType == 4) && !this.val$res[i].isSkipped();
                                        if (toSkip[i]) {
                                            ++toSkipCount;
                                        }
                                        modified[i] = true;
                                    }
                                    catch (Throwable e) {
                                        Debug.printStackTrace(e);
                                        Logger.log(new LogAlert((Object)this.val$download_manager, true, 3, "Failed to change storage type for '" + this.val$res[i].getFile(true) + "': " + Debug.getNestedExceptionMessage(e)));
                                        RDResumeHandler.recheckFile(this.val$download_manager, this.val$res[i]);
                                    }
                                    types[i] = DiskManagerUtil.convertDMStorageTypeToString(newStorageType);
                                }
                            }
                            ++i;
                        }
                        dmState.setListAttribute("storetypes", types);
                        if (toSkipCount > 0) {
                            this.setSkipped(toSkip, true);
                        }
                        i = 0;
                        while (i < this.val$res.length) {
                            int cleared;
                            if (toChange[i] && (cleared = RDResumeHandler.storageTypeChanged(this.val$download_manager, this.val$res[i])) > 0) {
                                this.val$res[i].downloaded -= (long)cleared * this.val$res[i].getTorrentFile().getTorrent().getPieceLength();
                                if (this.val$res[i].downloaded < 0L) {
                                    this.val$res[i].downloaded = 0L;
                                }
                                recalc_dl = true;
                            }
                            ++i;
                        }
                        if (recalc_dl) {
                            this.val$download_manager.getStats().setDownloadCompletedBytes(-1L);
                        }
                        DiskManagerImpl.storeFileDownloaded(this.val$download_manager, this.val$res, true, false);
                    }
                    finally {
                        dmState.suppressStateSave(false);
                        dmState.save(false);
                    }
                    int i = 0;
                    while (i < this.val$res.length) {
                        if (toChange[i]) {
                            this.val$listener.filePriorityChanged(this.getDiskManager(), this.val$res[i]);
                        }
                        ++i;
                    }
                    return modified;
                }
            };
            int i = 0;
            while (i < res.length) {
                TOTorrentFile torrent_file = torrent_files[i];
                int file_index = i;
                FileSkeleton info = new FileSkeleton((FileSkeleton[])res, listener, file_index, fileSetSkeleton, incomplete_suffix, torrent_file, root_dir, locale_decoder){
                    private volatile CacheFile read_cache_file;
                    private WeakReference dataFile = new WeakReference<Object>(null);
                    private volatile Boolean skipping;
                    private final /* synthetic */ FileSkeleton[] val$res;
                    private final /* synthetic */ DiskManagerListener val$listener;
                    private final /* synthetic */ int val$file_index;
                    private final /* synthetic */ DiskManagerFileInfoSet val$fileSetSkeleton;
                    private final /* synthetic */ String val$incomplete_suffix;
                    private final /* synthetic */ TOTorrentFile val$torrent_file;
                    private final /* synthetic */ File val$root_dir;
                    private final /* synthetic */ LocaleUtilDecoder val$locale_decoder;
                    {
                        this.val$res = fileSkeletonArray;
                        this.val$listener = diskManagerListener;
                        this.val$file_index = n;
                        this.val$fileSetSkeleton = diskManagerFileInfoSet;
                        this.val$incomplete_suffix = string;
                        this.val$torrent_file = tOTorrentFile;
                        this.val$root_dir = file;
                        this.val$locale_decoder = localeUtilDecoder;
                    }

                    @Override
                    public void setPriority(int b) {
                        this.priority = b;
                        DiskManagerImpl.storeFilePriorities(download_manager, this.val$res);
                        this.val$listener.filePriorityChanged(this.getDiskManager(), this);
                    }

                    @Override
                    public void setSkipped(boolean skipped) {
                        try {
                            this.skipping = skipped;
                            if (!skipped && this.getStorageType() == 2 && !this.setStorageType(1)) {
                                return;
                            }
                            if (!skipped && this.getStorageType() == 4 && !this.setStorageType(3)) {
                                return;
                            }
                            File to_link = this.setSkippedInternal(skipped);
                            DiskManagerImpl.storeFilePriorities(download_manager, this.val$res);
                            if (to_link != null) {
                                download_manager.getDownloadState().setFileLink(this.val$file_index, this.getFile(false), to_link);
                            }
                            this.val$listener.filePriorityChanged(this.getDiskManager(), this);
                            boolean[] toCheck = new boolean[this.val$fileSetSkeleton.nbFiles()];
                            toCheck[this.val$file_index] = true;
                            DiskManagerUtil.doFileExistenceChecksAfterSkipChange(this.val$fileSetSkeleton, toCheck, skipped, download_manager);
                        }
                        finally {
                            this.skipping = null;
                        }
                    }

                    @Override
                    public Boolean isSkipping() {
                        return this.skipping;
                    }

                    @Override
                    public int getAccessMode() {
                        return 1;
                    }

                    @Override
                    public long getDownloaded() {
                        return this.downloaded;
                    }

                    @Override
                    public long getLastModified() {
                        return this.getFile(true).lastModified();
                    }

                    @Override
                    public void setDownloaded(long l) {
                        this.downloaded = l;
                    }

                    @Override
                    public String getExtension() {
                        int separator;
                        String ext = this.lazyGetFile().getName();
                        if (this.val$incomplete_suffix != null && ext.endsWith(this.val$incomplete_suffix)) {
                            ext = ext.substring(0, ext.length() - this.val$incomplete_suffix.length());
                        }
                        if ((separator = ext.lastIndexOf(".")) == -1) {
                            separator = 0;
                        }
                        return ext.substring(separator);
                    }

                    @Override
                    public int getFirstPieceNumber() {
                        return this.val$torrent_file.getFirstPieceNumber();
                    }

                    @Override
                    public int getLastPieceNumber() {
                        return this.val$torrent_file.getLastPieceNumber();
                    }

                    @Override
                    public long getLength() {
                        return this.val$torrent_file.getLength();
                    }

                    @Override
                    public int getIndex() {
                        return this.val$file_index;
                    }

                    @Override
                    public int getNbPieces() {
                        return this.val$torrent_file.getNumberOfPieces();
                    }

                    @Override
                    public int getPriority() {
                        return this.priority;
                    }

                    @Override
                    protected File setSkippedInternal(boolean _skipped) {
                        DownloadManagerState dm_state;
                        String dnd_sf;
                        this.skipped_internal = _skipped;
                        if (!download_manager.isDestroyed() && (dnd_sf = (dm_state = download_manager.getDownloadState()).getAttribute("dnd_sf")) != null) {
                            File new_parent;
                            File new_file;
                            File parent;
                            File link = this.getLink();
                            File file = this.getFile(false);
                            if (_skipped) {
                                File parent2;
                                if ((link == null || link.equals(file)) && (parent2 = file.getParentFile()) != null) {
                                    File new_parent2;
                                    File new_file2;
                                    String prefix = dm_state.getAttribute("dnd_pfx");
                                    String file_name = file.getName();
                                    if (prefix != null && !file_name.startsWith(prefix)) {
                                        file_name = String.valueOf(prefix) + file_name;
                                    }
                                    if (!(new_file2 = FileUtil.newFile(new_parent2 = FileUtil.newFile(parent2, dnd_sf), file_name)).exists()) {
                                        boolean ok;
                                        if (!new_parent2.exists()) {
                                            new_parent2.mkdirs();
                                        }
                                        if (new_parent2.canWrite() && (ok = file.exists() ? FileUtil.renameFile(file, new_file2) : true)) {
                                            return new_file2;
                                        }
                                    }
                                }
                            } else if (link != null && !file.exists() && (parent = file.getParentFile()) != null && parent.canWrite() && (new_file = FileUtil.newFile(new_parent = parent.getName().equals(dnd_sf) ? parent : FileUtil.newFile(parent, dnd_sf), link.getName())).equals(link)) {
                                String incomp_ext = dm_state.getAttribute("incompfilesuffix");
                                String file_name = file.getName();
                                String prefix = dm_state.getAttribute("dnd_pfx");
                                boolean prefix_removed = false;
                                if (prefix != null && file_name.startsWith(prefix)) {
                                    file_name = file_name.substring(prefix.length());
                                    prefix_removed = true;
                                }
                                if (incomp_ext != null && incomp_ext.length() > 0 && this.getDownloaded() != this.getLength()) {
                                    if (prefix == null) {
                                        prefix = "";
                                    }
                                    file = FileUtil.newFile(file.getParentFile(), String.valueOf(prefix) + file_name + incomp_ext);
                                } else if (prefix_removed) {
                                    file = FileUtil.newFile(file.getParentFile(), file_name);
                                }
                                boolean ok = new_file.exists() ? FileUtil.renameFile(new_file, file) : true;
                                if (ok) {
                                    File[] files = new_parent.listFiles();
                                    if (files != null && files.length == 0) {
                                        new_parent.delete();
                                    }
                                    return file;
                                }
                            }
                        }
                        return null;
                    }

                    @Override
                    public boolean isSkipped() {
                        return this.skipped_internal;
                    }

                    @Override
                    public DiskManager getDiskManager() {
                        return null;
                    }

                    @Override
                    public DownloadManager getDownloadManager() {
                        return download_manager;
                    }

                    @Override
                    public boolean exists() {
                        if (this.val$torrent_file.isPadFile()) {
                            return true;
                        }
                        return this.getFile(true).exists();
                    }

                    @Override
                    public File getFile(boolean follow_link) {
                        File link;
                        if (follow_link && (link = this.getLink()) != null) {
                            return link;
                        }
                        return this.lazyGetFile();
                    }

                    private File lazyGetFile() {
                        File toReturn = (File)this.dataFile.get();
                        if (toReturn != null) {
                            return toReturn;
                        }
                        TOTorrent tor = download_manager.getTorrent();
                        File dataPath = this.val$root_dir;
                        File simpleFile = null;
                        if (tor == null || tor.isSimpleTorrent()) {
                            simpleFile = download_manager.getAbsoluteSaveLocation();
                        } else {
                            byte[][] path_comps = this.val$torrent_file.getPathComponents();
                            int j = 0;
                            while (j < path_comps.length) {
                                String comp2;
                                try {
                                    comp2 = this.val$locale_decoder.decodeString(path_comps[j]);
                                }
                                catch (UnsupportedEncodingException e) {
                                    Debug.printStackTrace(e);
                                    comp2 = "undecodableFileName" + this.val$file_index;
                                }
                                comp2 = FileUtil.convertOSSpecificChars(comp2, j != path_comps.length - 1);
                                dataPath = FileUtil.newFile(dataPath, comp2);
                                ++j;
                            }
                        }
                        toReturn = simpleFile != null ? simpleFile : dataPath;
                        this.dataFile = new WeakReference<File>(toReturn);
                        return toReturn;
                    }

                    @Override
                    public TOTorrentFile getTorrentFile() {
                        return this.val$torrent_file;
                    }

                    @Override
                    public boolean setLink(File link_destination, boolean no_delete) {
                        this.last_error = null;
                        if (download_manager.getTorrent().isSimpleTorrent()) {
                            try {
                                download_manager.moveDataFiles(link_destination.getParentFile(), link_destination.getName());
                                return true;
                            }
                            catch (DownloadManagerException e) {
                                Debug.out(e);
                                this.last_error = Debug.getNestedExceptionMessage(e);
                                return false;
                            }
                        }
                        return this.setLinkAtomic(link_destination, no_delete);
                    }

                    @Override
                    public String getLastError() {
                        return this.last_error;
                    }

                    @Override
                    public boolean setLinkAtomic(File link_destination, boolean no_delete) {
                        this.last_error = DiskManagerUtil.setFileLink(download_manager, this.val$res, this, this.lazyGetFile(), link_destination, no_delete, null);
                        return this.last_error == null;
                    }

                    @Override
                    public boolean setLinkAtomic(File link_destination, boolean no_delete, FileUtil.ProgressListener pl) {
                        this.last_error = DiskManagerUtil.setFileLink(download_manager, this.val$res, this, this.lazyGetFile(), link_destination, no_delete, pl);
                        return this.last_error == null;
                    }

                    @Override
                    public File getLink() {
                        return download_manager.getDownloadState().getFileLink(this.val$file_index, this.lazyGetFile());
                    }

                    @Override
                    public boolean setStorageType(int type, boolean force) {
                        boolean[] change = new boolean[this.val$res.length];
                        change[this.val$file_index] = true;
                        return this.val$fileSetSkeleton.setStorageTypes(change, type, force)[this.val$file_index];
                    }

                    @Override
                    public int getStorageType() {
                        return DiskManagerUtil.convertDMStorageTypeFromString(DiskManagerImpl.getStorageType(download_manager, this.val$file_index));
                    }

                    @Override
                    public void flushCache() {
                    }

                    @Override
                    public DirectByteBuffer read(long offset, int length) throws IOException {
                        CacheFile temp;
                        try {
                            cache_read_mon.enter();
                            if (this.read_cache_file == null) {
                                try {
                                    int type = DiskManagerUtil.convertDMStorageTypeFromString(DiskManagerImpl.getStorageType(download_manager, this.val$file_index));
                                    this.read_cache_file = CacheFileManagerFactory.getSingleton().createFile(new CacheFileOwner(){

                                        @Override
                                        public String getCacheFileOwnerName() {
                                            return download_manager.getInternalName();
                                        }

                                        @Override
                                        public TOTorrentFile getCacheFileTorrentFile() {
                                            return val$torrent_file;
                                        }

                                        @Override
                                        public File getCacheFileControlFileDir() {
                                            return download_manager.getDownloadState().getStateFile();
                                        }

                                        @Override
                                        public int getCacheMode() {
                                            return 1;
                                        }
                                    }, this.getFile(true), DiskManagerUtil.convertDMStorageTypeToCache(type), false);
                                }
                                catch (Throwable e) {
                                    Debug.printStackTrace(e);
                                    throw new IOException(e.getMessage());
                                }
                            }
                            temp = this.read_cache_file;
                        }
                        finally {
                            cache_read_mon.exit();
                        }
                        DirectByteBuffer buffer = DirectByteBufferPool.getBuffer((byte)6, length);
                        try {
                            temp.read(buffer, offset, (short)1);
                        }
                        catch (Throwable e) {
                            buffer.returnToPool();
                            Debug.printStackTrace(e);
                            throw new IOException(e.getMessage());
                        }
                        return buffer;
                    }

                    @Override
                    public int getReadBytesPerSecond() {
                        CacheFile temp = this.read_cache_file;
                        if (temp == null) {
                            return 0;
                        }
                        return 0;
                    }

                    @Override
                    public int getWriteBytesPerSecond() {
                        return 0;
                    }

                    @Override
                    public long getETA() {
                        return -1L;
                    }

                    @Override
                    public void recheck() {
                        DiskManagerFactory.recheckFile(this.getDownloadManager(), this);
                    }

                    @Override
                    public void close() {
                        CacheFile temp;
                        try {
                            cache_read_mon.enter();
                            temp = this.read_cache_file;
                            this.read_cache_file = null;
                        }
                        finally {
                            cache_read_mon.exit();
                        }
                        if (temp != null) {
                            try {
                                temp.close();
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                    }

                    @Override
                    public void addListener(DiskManagerFileInfoListener listener) {
                        if (this.getDownloaded() == this.getLength()) {
                            try {
                                listener.dataWritten(0L, this.getLength(), null);
                                listener.dataChecked(0L, this.getLength());
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                    }

                    @Override
                    public void removeListener(DiskManagerFileInfoListener listener) {
                    }
                };
                res[i] = info;
                ++i;
            }
            DiskManagerUtil.loadFilePriorities(download_manager, fileSetSkeleton);
            DiskManagerUtil.loadFileDownloaded(download_manager, res);
            DiskManagerFileInfoSet diskManagerFileInfoSet = fileSetSkeleton;
            loading[0] = false;
            return diskManagerFileInfoSet;
        }
        catch (Throwable throwable) {
            try {
                loading[0] = false;
                throw throwable;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                return new DiskManagerFileInfoSetImpl(new DiskManagerFileInfoImpl[0], null);
            }
        }
    }

    public static int convertDMStorageTypeFromString(String str) {
        char c = str.charAt(0);
        switch (c) {
            case 'L': {
                return 1;
            }
            case 'C': {
                return 2;
            }
            case 'R': {
                return 3;
            }
            case 'X': {
                return 4;
            }
        }
        Debug.out("eh?");
        return 1;
    }

    public static String convertDMStorageTypeToString(int dm_type) {
        switch (dm_type) {
            case 1: {
                return "L";
            }
            case 2: {
                return "C";
            }
            case 3: {
                return "R";
            }
            case 4: {
                return "X";
            }
        }
        Debug.out("eh?");
        return "?";
    }

    public static String convertCacheStorageTypeToString(int cache_type) {
        switch (cache_type) {
            case 1: {
                return "L";
            }
            case 2: {
                return "C";
            }
            case 3: {
                return "R";
            }
            case 4: {
                return "X";
            }
        }
        Debug.out("eh?");
        return "?";
    }

    public static int convertDMStorageTypeToCache(int dm_type) {
        switch (dm_type) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
        }
        Debug.out("eh?");
        return 1;
    }

    protected static void storeFilePriorities(DownloadManager download_manager, DiskManagerFileInfo[] files) {
        if (files == null) {
            return;
        }
        ArrayList<Long> file_priorities = new ArrayList<Long>(files.length);
        int i = 0;
        while (i < files.length) {
            int value;
            DiskManagerFileInfo file = files[i];
            if (file == null) {
                return;
            }
            boolean skipped = file.isSkipped();
            int priority = file.getPriority();
            if (skipped) {
                value = 0;
            } else if (priority > 0) {
                value = priority;
            } else {
                value = priority - 1;
                if (value > 0) {
                    value = Integer.MIN_VALUE;
                }
            }
            file_priorities.add(i, Long.valueOf(value));
            ++i;
        }
        download_manager.setUserData("file_priorities", file_priorities);
        if (files.length > 0 && !(files[0] instanceof DiskManagerFileInfoImpl)) {
            long skipped_file_set_size = 0L;
            long skipped_but_downloaded = 0L;
            int i2 = 0;
            while (i2 < files.length) {
                DiskManagerFileInfo file = files[i2];
                if (file.isSkipped()) {
                    skipped_file_set_size += file.getLength();
                    skipped_but_downloaded += file.getDownloaded();
                }
                ++i2;
            }
            DownloadManagerStats stats2 = download_manager.getStats();
            if (stats2 instanceof DownloadManagerStatsImpl) {
                ((DownloadManagerStatsImpl)stats2).setSkippedFileStats(skipped_file_set_size, skipped_but_downloaded);
            }
        }
    }

    static void loadFilePriorities(DownloadManager download_manager, DiskManagerFileInfoSet fileSet) {
        try {
            DiskManagerFileInfo[] files = fileSet.getFiles();
            if (files == null) {
                return;
            }
            List file_priorities = (List)download_manager.getUserData("file_priorities");
            if (file_priorities == null) {
                return;
            }
            boolean[] toSkip = new boolean[files.length];
            int[] prio = new int[files.length];
            int i = 0;
            while (i < files.length) {
                DiskManagerFileInfo file = files[i];
                if (file == null) {
                    return;
                }
                try {
                    int priority = ((Long)file_priorities.get(i)).intValue();
                    if (priority == 0) {
                        toSkip[i] = true;
                    } else {
                        if (priority < 0) {
                            // empty if block
                        }
                        prio[i] = ++priority;
                    }
                }
                catch (Throwable t2) {
                    Debug.printStackTrace(t2);
                }
                ++i;
            }
            fileSet.load(prio, toSkip);
        }
        catch (Throwable t) {
            Debug.printStackTrace(t);
        }
    }

    protected static void loadFileDownloaded(DownloadManager download_manager, DiskManagerFileInfoHelper[] files) {
        DownloadManagerState state = download_manager.getDownloadState();
        Map details = state.getMapAttribute("filedownloaded");
        if (details == null) {
            return;
        }
        List downloaded = (List)details.get("downloaded");
        if (downloaded == null) {
            return;
        }
        try {
            int i = 0;
            int max = Math.min(files.length, downloaded.size());
            while (i < max) {
                files[i].setDownloaded((Long)downloaded.get(i));
                ++i;
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public static boolean isNoSpaceException(Throwable e) {
        String exception_str = Debug.getNestedExceptionMessage(e);
        String lc = exception_str.toLowerCase(Locale.US);
        return lc.contains(" space");
    }

    public static DiskManagerPiece[] getDiskManagerPiecesSnapshot(final DownloadManager dm) {
        try {
            TOTorrent torrent = dm.getTorrent();
            if (torrent == null) {
                return new DiskManagerPiece[0];
            }
            DMPieceMapper piece_mapper = DMPieceMapperFactory.create(torrent);
            final int nbPieces = torrent.getNumberOfPieces();
            final int pieceLength = (int)torrent.getPieceLength();
            final int lastPieceLength = piece_mapper.getLastPieceLength();
            final DiskManagerPiece[] pieces = new DiskManagerPiece[nbPieces];
            DiskManagerFileInfoSet file_set = DiskManagerUtil.getFileInfoSkeleton(dm, new DiskManagerListener(){

                @Override
                public void stateChanged(DiskManager dm, int oldState, int newState) {
                }

                @Override
                public void pieceDoneChanged(DiskManager dm, DiskManagerPiece piece) {
                }

                @Override
                public void filePriorityChanged(DiskManager dm, DiskManagerFileInfo file) {
                }
            });
            DiskManagerFileInfo[] files = file_set.getFiles();
            LocaleUtilDecoder locale_decoder = LocaleTorrentUtil.getTorrentEncoding(torrent);
            piece_mapper.construct(locale_decoder, dm.getAbsoluteSaveLocation().getName());
            DMPieceMapperFile[] pm_files = piece_mapper.getFiles();
            int i = 0;
            while (i < pm_files.length) {
                pm_files[i].setFileInfo(files[i]);
                ++i;
            }
            final DMPieceMap piece_map = piece_mapper.getPieceMap();
            DiskManagerHelper disk_manager = new DiskManagerHelper(){

                @Override
                public String getDisplayName() {
                    return "";
                }

                @Override
                public DownloadManager getDownload() {
                    return dm;
                }

                @Override
                public boolean stop(boolean closing) {
                    return false;
                }

                @Override
                public void start() {
                }

                @Override
                public void setPieceCheckingEnabled(boolean enabled) {
                }

                @Override
                public void setMoveState(int state) {
                }

                @Override
                public void saveState(boolean interim) {
                }

                @Override
                public void saveResumeData(boolean interim_save) throws Exception {
                }

                @Override
                public void removeListener(DiskManagerListener l) {
                }

                @Override
                public DirectByteBuffer readBlock(int pieceNumber, int offset, int length) {
                    return null;
                }

                @Override
                public void moveDataFiles(File new_parent_dir, String dl_name) {
                }

                @Override
                public boolean isStopped() {
                    return true;
                }

                @Override
                public boolean isInteresting(int pieceNumber) {
                    return false;
                }

                @Override
                public boolean isDone(int pieceNumber) {
                    return false;
                }

                @Override
                public boolean hasOutstandingWriteRequestForPiece(int piece_number) {
                    return false;
                }

                @Override
                public boolean hasOutstandingReadRequestForPiece(int piece_number) {
                    return false;
                }

                @Override
                public boolean hasOutstandingCheckRequestForPiece(int piece_number) {
                    return false;
                }

                @Override
                public boolean hasListener(DiskManagerListener l) {
                    return false;
                }

                @Override
                public long getTotalLength() {
                    return 0L;
                }

                @Override
                public int getState() {
                    return 0;
                }

                @Override
                public long getSizeExcludingDND() {
                    return 0L;
                }

                @Override
                public File getSaveLocation() {
                    return null;
                }

                @Override
                public long getRemainingExcludingDND() {
                    return 0L;
                }

                @Override
                public long getRemaining() {
                    return 0L;
                }

                @Override
                public long[] getReadStats() {
                    return null;
                }

                @Override
                public long[] getWriteStats() {
                    return null;
                }

                @Override
                public long getPriorityChangeMarker() {
                    return 0L;
                }

                @Override
                public DiskManagerPiece[] getPieces() {
                    return pieces;
                }

                @Override
                public DMPieceMap getPieceMap() {
                    return piece_map;
                }

                @Override
                public BitFlags getAvailability() {
                    return null;
                }

                @Override
                public int getPieceLength(int piece_number) {
                    return piece_number == nbPieces - 1 ? lastPieceLength : pieceLength;
                }

                @Override
                public int getPieceLength() {
                    return pieceLength;
                }

                @Override
                public DiskManagerPiece getPiece(int piece_number) {
                    return pieces[piece_number];
                }

                @Override
                public int getPercentDoneExcludingDND() {
                    return 0;
                }

                @Override
                public int getPercentDone() {
                    return 0;
                }

                @Override
                public int getPercentAllocated() {
                    return 0;
                }

                @Override
                public int getNbPieces() {
                    return pieces.length;
                }

                @Override
                public String getMoveSubTask() {
                    return null;
                }

                @Override
                public long[] getMoveProgress() {
                    return null;
                }

                @Override
                public DiskManagerFileInfo[] getFiles() {
                    return null;
                }

                @Override
                public DiskManagerFileInfoSet getFileSet() {
                    return null;
                }

                @Override
                public int getErrorType() {
                    return 0;
                }

                @Override
                public String getErrorMessage() {
                    return null;
                }

                @Override
                public int getCompleteRecheckStatus() {
                    return 0;
                }

                @Override
                public boolean getRecheckCancelled() {
                    return false;
                }

                @Override
                public int getCacheMode() {
                    return 0;
                }

                @Override
                public void generateEvidence(IndentWriter writer) {
                }

                @Override
                public boolean filesExist() {
                    return false;
                }

                @Override
                public void enqueueWriteRequest(DiskManagerWriteRequest request2, DiskManagerWriteRequestListener listener) {
                }

                @Override
                public void enqueueReadRequest(DiskManagerReadRequest request2, DiskManagerReadRequestListener listener) {
                }

                @Override
                public void enqueueCompleteRecheckRequest(DiskManagerCheckRequest request2, DiskManagerCheckRequestListener listener) {
                }

                @Override
                public void enqueueCheckRequest(DiskManagerCheckRequest request2, DiskManagerCheckRequestListener listener) {
                }

                @Override
                public void downloadRemoved() {
                }

                @Override
                public DiskManager.DownloadEndedProgress downloadEnded(boolean start_of_day) {
                    return new DiskManager.DownloadEndedProgress(){

                        @Override
                        public boolean isComplete() {
                            return true;
                        }
                    };
                }

                @Override
                public DiskManagerWriteRequest createWriteRequest(int pieceNumber, int offset, DirectByteBuffer data, Object user_data) {
                    return null;
                }

                @Override
                public DiskManagerReadRequest createReadRequest(int pieceNumber, int offset, int length) {
                    return null;
                }

                @Override
                public DiskManagerCheckRequest createCheckRequest(int pieceNumber, Object user_data) {
                    return null;
                }

                @Override
                public boolean checkBlockConsistencyForWrite(String originator, int pieceNumber, int offset, DirectByteBuffer data) {
                    return false;
                }

                @Override
                public boolean checkBlockConsistencyForRead(String originator, boolean peer_request, int pieceNumber, int offset, int length) {
                    return false;
                }

                @Override
                public boolean checkBlockConsistencyForHint(String originator, int pieceNumber, int offset, int length) {
                    return false;
                }

                @Override
                public void addListener(DiskManagerListener l) {
                }

                @Override
                public void skippedFileSetChanged(DiskManagerFileInfo file) {
                }

                @Override
                public void setPieceDone(DiskManagerPieceImpl piece, boolean done) {
                    piece.setDoneSupport(done);
                }

                @Override
                public void setFailedAndRecheck(DiskManagerFileInfo file, String reason) {
                }

                @Override
                public void setFailed(int type, String reason, Throwable cause) {
                }

                @Override
                public void priorityChanged(DiskManagerFileInfo file) {
                }

                @Override
                public void storageTypeChanged(DiskManagerFileInfo file) {
                }

                @Override
                public TOTorrent getTorrent() {
                    return null;
                }

                @Override
                public String[] getStorageTypes() {
                    return null;
                }

                @Override
                public String getStorageType(int fileIndex) {
                    return null;
                }

                @Override
                public DiskManagerRecheckScheduler getRecheckScheduler() {
                    return null;
                }

                @Override
                public DMPieceList getPieceList(int piece_number) {
                    return piece_map.getPieceList(piece_number);
                }

                @Override
                public byte[] getPieceHash(int piece_number) throws TOTorrentException {
                    return null;
                }

                @Override
                public String getInternalName() {
                    return null;
                }

                @Override
                public DownloadManagerState getDownloadState() {
                    return null;
                }

                @Override
                public DiskAccessController getDiskAccessController() {
                    return null;
                }
            };
            int i2 = 0;
            while (i2 < nbPieces) {
                pieces[i2] = new DiskManagerPieceImpl(disk_manager, i2, i2 == nbPieces - 1 ? lastPieceLength : pieceLength);
                ++i2;
            }
            RDResumeHandler.setupPieces(dm.getDownloadState(), pieces);
            i2 = 0;
            while (i2 < nbPieces) {
                pieces[i2].calcNeeded();
                ++i2;
            }
            return pieces;
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
    }

    public static void runMoveTask(final DownloadManager download_manager, final File destination, final Runnable target, MoveTaskAapter adapter) throws DownloadManagerException {
        try {
            DownloadManagerStats stats2 = download_manager.getStats();
            if (stats2.getTotalDataBytesReceived() == 0L && stats2.getPercentDoneExcludingDND() == 0) {
                boolean found_file = false;
                DiskManagerFileInfo[] diskManagerFileInfoArray = download_manager.getDiskManagerFileInfoSet().getFiles();
                int n = diskManagerFileInfoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DiskManagerFileInfo info = diskManagerFileInfoArray[n2];
                    if (!info.getTorrentFile().isPadFile() && info.exists()) {
                        found_file = true;
                        break;
                    }
                    ++n2;
                }
                if (!found_file) {
                    target.run();
                    return;
                }
            }
            FileUtil.runAsTask(new CoreOperationTask(adapter){
                private boolean queued = true;
                private CoreOperationTask.ProgressCallback callback;
                {
                    this.callback = new CoreOperationTask.ProgressCallbackAdapter(){
                        private volatile int current_state = 0;

                        @Override
                        public int getProgress() {
                            long[] mp = moveTaskAapter.getMoveProgress();
                            return mp == null ? 0 : (int)mp[0];
                        }

                        @Override
                        public long getSize() {
                            long[] mp = moveTaskAapter.getMoveProgress();
                            return mp == null ? downloadManager.getStats().getSizeExcludingDND() : mp[1];
                        }

                        @Override
                        public String getSubTaskName() {
                            return moveTaskAapter.getMoveSubTask();
                        }

                        @Override
                        public int getSupportedTaskStates() {
                            return 15;
                        }

                        @Override
                        public void setTaskState(int state) {
                            if (this.current_state == 4) {
                                return;
                            }
                            if (state == 1) {
                                moveTaskAapter.setMoveState(2);
                                this.current_state = state;
                            } else if (state == 2) {
                                moveTaskAapter.setMoveState(1);
                                this.current_state = 0;
                            } else if (state == 4) {
                                moveTaskAapter.setMoveState(3);
                                this.current_state = 4;
                            }
                        }

                        @Override
                        public int getTaskState() {
                            if (this.current_state == 0 && queued) {
                                return 16;
                            }
                            return this.current_state;
                        }
                    };
                }

                @Override
                public String getName() {
                    return download_manager.getDisplayName();
                }

                @Override
                public DownloadManager getDownload() {
                    return download_manager;
                }

                @Override
                public String[] getAffectedFileSystems() {
                    return FileUtil.getFileStoreNames(download_manager.getAbsoluteSaveLocation(), destination);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run(CoreOperation operation) {
                    block29: {
                        has_scheduler = DiskManagerOperationScheduler.isEnabled();
                        if (!has_scheduler) {
                            while ((checkBeforeMove = COConfigurationManager.getBooleanParameter("Check Pieces on Completion Before Move")) && (dm = download_manager.getDiskManager()) != null && dm.getCompleteRecheckStatus() >= 0) {
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (Throwable var5_7) {
                                    // empty catch block
                                }
                                if (this.callback.getTaskState() != 4) continue;
                                throw new RuntimeException("Cancelled");
                            }
                        }
                        var4_4 = DiskManagerUtil.access$0();
                        synchronized (var4_4) {
                            DiskManagerUtil.access$0().add(this);
                            ready = DiskManagerUtil.access$0().size() == 1;
                        }
                        try {
                            if (has_scheduler) {
                                while (true) {
                                    if (this.callback.getTaskState() != 1) {
                                        if (this.callback.getTaskState() == 4) {
                                            throw new RuntimeException("Cancelled");
                                        }
                                        break block29;
                                    }
                                    try {
                                        Thread.sleep(500L);
                                    }
                                    catch (Throwable var4_5) {
                                        // empty catch block
                                    }
                                }
                            }
                            ** GOTO lbl62
                        }
                        catch (Throwable var8_11) {
                            var9_12 = DiskManagerUtil.access$0();
                            synchronized (var9_12) {
                                DiskManagerUtil.access$0().remove(this);
                                throw var8_11;
                            }
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (Throwable var4_6) {
                                // empty catch block
                            }
                            if (this.callback.getTaskState() == 4) {
                                throw new RuntimeException("Cancelled");
                            }
                            var4_4 = DiskManagerUtil.access$0();
                            synchronized (var4_4) {
                                for (CoreOperationTask task : DiskManagerUtil.access$0()) {
                                    state = task.getProgressCallback().getTaskState();
                                    if (state == 1) continue;
                                    if (task != this || state != 16) break;
                                    ready = true;
                                    break;
                                }
                                continue;
                            }
lbl62:
                            // 2 sources

                            ** while (!ready)
                        }
                    }
                    this.queued = false;
                    target.run();
                    var9_13 = DiskManagerUtil.access$0();
                    synchronized (var9_13) {
                        DiskManagerUtil.access$0().remove(this);
                        return;
                    }
                }

                @Override
                public CoreOperationTask.ProgressCallback getProgressCallback() {
                    return this.callback;
                }
            });
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DownloadManagerException) {
                throw (DownloadManagerException)cause;
            }
            throw e;
        }
    }

    static /* synthetic */ List access$0() {
        return move_tasks;
    }

    static abstract class FileSkeleton
    implements DiskManagerFileInfoHelper {
        protected int priority;
        protected boolean skipped_internal;
        protected long downloaded;
        protected String last_error;

        FileSkeleton() {
        }

        protected void load(int _priority, boolean _skipped) {
            this.priority = _priority;
            this.skipped_internal = _skipped;
        }

        protected abstract File setSkippedInternal(boolean var1);
    }

    public static interface MoveTaskAapter {
        public long[] getMoveProgress();

        public String getMoveSubTask();

        public void setMoveState(int var1);
    }
}

