/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.disk;

import com.biglybt.core.Core;
import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.disk.DiskManagerFileInfoSet;
import com.biglybt.core.disk.DiskManagerListener;
import com.biglybt.core.disk.impl.DiskManagerImpl;
import com.biglybt.core.disk.impl.DiskManagerOperationScheduler;
import com.biglybt.core.disk.impl.DiskManagerUtil;
import com.biglybt.core.disk.impl.resume.RDResumeHandler;
import com.biglybt.core.diskmanager.access.DiskAccessController;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.util.LinkFileMap;

public class DiskManagerFactory {
    public static void initialise(Core core) {
        DiskManagerOperationScheduler.initialise(core);
    }

    public static DiskAccessController getDiskAccessController() {
        return DiskManagerImpl.getDefaultDiskAccessController();
    }

    public static DiskManager create(TOTorrent torrent, DownloadManager manager) {
        DiskManagerImpl dm = new DiskManagerImpl(torrent, manager);
        if (dm.getState() != 10) {
            dm.start();
        }
        return dm;
    }

    public static void setResumeDataCompletelyValid(DownloadManagerState download_manager_state) {
        RDResumeHandler.setTorrentResumeDataComplete(download_manager_state);
    }

    public static void setResumeDataTotallyIncomplete(DownloadManagerState download_manager_state) {
        RDResumeHandler.setTorrentResumeTotallyIncomplete(download_manager_state);
    }

    public static void setTorrentResumeDataNearlyComplete(DownloadManagerState dms) {
        RDResumeHandler.setTorrentResumeDataNearlyComplete(dms);
    }

    public static boolean isTorrentResumeDataComplete(DownloadManagerState dms) {
        return RDResumeHandler.isTorrentResumeDataComplete(dms);
    }

    public static boolean isTorrentResumeDataValid(DownloadManagerState dms) {
        return RDResumeHandler.isTorrentResumeDataValid(dms);
    }

    public static void deleteDataFiles(TOTorrent torrent, String torrent_save_dir, String torrent_save_file, boolean force_no_recycle) {
        DiskManagerImpl.deleteDataFiles(torrent, torrent_save_dir, torrent_save_file, force_no_recycle);
    }

    public static DiskManagerFileInfoSet getFileInfoSkeleton(DownloadManager download_manager, DiskManagerListener listener) {
        return DiskManagerUtil.getFileInfoSkeleton(download_manager, listener);
    }

    public static void setFileLinks(DownloadManager download_manager, LinkFileMap links) {
        DiskManagerImpl.setFileLinks(download_manager, links);
    }

    public static void clearResumeData(DownloadManager download_manager, DiskManagerFileInfo file) {
        RDResumeHandler.clearResumeData(download_manager, file);
    }

    public static void recheckFile(DownloadManager download_manager, DiskManagerFileInfo file) {
        RDResumeHandler.recheckFile(download_manager, file);
    }
}

