/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.dht.transport.udp.impl;

import com.biglybt.core.dht.transport.udp.impl.DHTTransportUDPContactImpl;
import com.biglybt.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.biglybt.core.dht.transport.udp.impl.DHTUDPPacketRequest;
import com.biglybt.core.dht.transport.udp.impl.DHTUDPUtils;
import com.biglybt.core.dht.transport.udp.impl.packethandler.DHTUDPPacketNetworkHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class DHTUDPPacketRequestPing
extends DHTUDPPacketRequest {
    private static final int[] EMPTY_INTS = new int[0];
    private int[] alt_networks = EMPTY_INTS;
    private int[] alt_network_counts = EMPTY_INTS;
    private Object upload_stats;

    public DHTUDPPacketRequestPing(DHTTransportUDPImpl _transport, long _connection_id, DHTTransportUDPContactImpl _local_contact, DHTTransportUDPContactImpl _remote_contact) {
        super(_transport, 1024, _connection_id, _local_contact, _remote_contact);
    }

    protected DHTUDPPacketRequestPing(DHTUDPPacketNetworkHandler network_handler, DataInputStream is, long con_id, int trans_id) throws IOException {
        super(network_handler, is, 1024, con_id, trans_id);
        byte protocol_version = this.getProtocolVersion();
        if (protocol_version >= 52) {
            DHTUDPUtils.deserialiseAltContactRequest(this, is);
        }
        if (this.getNetwork() == 4 && protocol_version >= 55) {
            this.upload_stats = DHTUDPUtils.deserialiseUploadStats(is);
        }
    }

    @Override
    public void serialise(DataOutputStream os) throws IOException {
        super.serialise(os);
        byte protocol_version = this.getProtocolVersion();
        if (protocol_version >= 52) {
            DHTUDPUtils.serialiseAltContactRequest(this, os);
        }
        if (this.getNetwork() == 4) {
            DHTUDPUtils.serialiseUploadStats(protocol_version, this.getAction(), os);
        }
    }

    protected void setAltContactRequest(int[] networks, int[] counts) {
        this.alt_networks = networks;
        this.alt_network_counts = counts;
    }

    protected int[] getAltNetworks() {
        return this.alt_networks;
    }

    protected int[] getAltNetworkCounts() {
        return this.alt_network_counts;
    }

    protected Object getUploadStats() {
        return this.upload_stats;
    }

    @Override
    public String getString() {
        return super.getString();
    }
}

