/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.dht.transport.udp.impl;

import com.biglybt.core.dht.transport.DHTTransportContact;
import com.biglybt.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.biglybt.core.dht.transport.udp.impl.DHTUDPPacketReply;
import com.biglybt.core.dht.transport.udp.impl.DHTUDPPacketRequestStore;
import com.biglybt.core.dht.transport.udp.impl.DHTUDPUtils;
import com.biglybt.core.dht.transport.udp.impl.packethandler.DHTUDPPacketNetworkHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;

public class DHTUDPPacketReplyStore
extends DHTUDPPacketReply {
    private byte[] diversify;
    private Object upload_stats;

    public DHTUDPPacketReplyStore(DHTTransportUDPImpl transport, DHTUDPPacketRequestStore request2, DHTTransportContact local_contact, DHTTransportContact remote_contact) {
        super(transport, 1027, request2, local_contact, remote_contact);
    }

    protected DHTUDPPacketReplyStore(DHTUDPPacketNetworkHandler network_handler, InetSocketAddress originator, DataInputStream is, int trans_id) throws IOException {
        super(network_handler, originator, is, 1027, trans_id);
        byte protocol_version = this.getProtocolVersion();
        if (protocol_version >= 6) {
            this.diversify = DHTUDPUtils.deserialiseByteArray(is, 255);
        }
        if (this.getNetwork() == 4 && protocol_version >= 55 && is.available() > 0) {
            this.upload_stats = DHTUDPUtils.deserialiseUploadStats(is);
        }
    }

    @Override
    public void serialise(DataOutputStream os) throws IOException {
        super.serialise(os);
        byte protocol_version = this.getProtocolVersion();
        if (protocol_version >= 6) {
            DHTUDPUtils.serialiseByteArray(os, this.diversify, 255);
        }
        if (this.getNetwork() == 4) {
            DHTUDPUtils.serialiseUploadStats(protocol_version, this.getAction(), os);
        }
    }

    public void setDiversificationTypes(byte[] _diversify) {
        this.diversify = _diversify;
    }

    public byte[] getDiversificationTypes() {
        return this.diversify;
    }

    protected Object getUploadStats() {
        return this.upload_stats;
    }
}

