/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.dht.transport;

import com.biglybt.core.dht.transport.DHTTransportContact;
import com.biglybt.core.dht.transport.DHTTransportException;
import com.biglybt.core.dht.transport.DHTTransportListener;
import com.biglybt.core.dht.transport.DHTTransportProgressListener;
import com.biglybt.core.dht.transport.DHTTransportRequestHandler;
import com.biglybt.core.dht.transport.DHTTransportStats;
import com.biglybt.core.dht.transport.DHTTransportTransferHandler;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;

public interface DHTTransport {
    public static final byte GF_NONE = 0;
    public static final byte GF_DHT_SLEEPING = 1;

    public byte getProtocolVersion();

    public byte getMinimumProtocolVersion();

    public int getNetwork();

    public boolean isIPV6();

    public byte getGenericFlags();

    public void setGenericFlag(byte var1, boolean var2);

    public void setSuspended(boolean var1);

    public DHTTransportContact getLocalContact();

    public int getPort();

    public void setPort(int var1) throws DHTTransportException;

    default public InetAddress getCurrentBindAddress() {
        return null;
    }

    default public InetAddress getExplicitBindAddress() {
        return null;
    }

    default public void setExplicitBindAddress(InetAddress address, boolean autoDelegate) {
    }

    public long getTimeout();

    public void setTimeout(long var1);

    public DHTTransportContact importContact(DataInputStream var1, boolean var2) throws IOException, DHTTransportException;

    public void setRequestHandler(DHTTransportRequestHandler var1);

    public DHTTransportStats getStats();

    public void registerTransferHandler(byte[] var1, DHTTransportTransferHandler var2);

    public void registerTransferHandler(byte[] var1, DHTTransportTransferHandler var2, Map<String, Object> var3);

    public void unregisterTransferHandler(byte[] var1, DHTTransportTransferHandler var2);

    public byte[] readTransfer(DHTTransportProgressListener var1, DHTTransportContact var2, byte[] var3, byte[] var4, long var5) throws DHTTransportException;

    public void writeTransfer(DHTTransportProgressListener var1, DHTTransportContact var2, byte[] var3, byte[] var4, byte[] var5, long var6) throws DHTTransportException;

    public byte[] writeReadTransfer(DHTTransportProgressListener var1, DHTTransportContact var2, byte[] var3, byte[] var4, long var5) throws DHTTransportException;

    public boolean supportsStorage();

    public boolean isReachable();

    public DHTTransportContact[] getReachableContacts();

    public DHTTransportContact[] getRecentContacts();

    public void addListener(DHTTransportListener var1);

    public void removeListener(DHTTransportListener var1);
}

