/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.dht.netcoords;

import com.biglybt.core.dht.DHTStorageAdapter;
import com.biglybt.core.dht.impl.DHTLog;
import com.biglybt.core.dht.netcoords.DHTNetworkPosition;
import com.biglybt.core.dht.netcoords.DHTNetworkPositionListener;
import com.biglybt.core.dht.netcoords.DHTNetworkPositionProvider;
import com.biglybt.core.dht.netcoords.DHTNetworkPositionProviderInstance;
import com.biglybt.core.dht.netcoords.DHTNetworkPositionProviderListener;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;

public class DHTNetworkPositionManager {
    private static DHTNetworkPositionProvider[] providers = new DHTNetworkPositionProvider[0];
    private static final Object providers_lock = new Object();
    private static DHTStorageAdapter storage_adapter = null;
    private static final CopyOnWriteList<DHTNetworkPositionProviderListener> provider_listeners = new CopyOnWriteList();
    private static volatile CopyOnWriteList<DHTNetworkPositionListener> position_listeners;
    private static final DHTNetworkPosition[] NP_EMPTY_ARRAY;

    static {
        NP_EMPTY_ARRAY = new DHTNetworkPosition[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialise(DHTStorageAdapter adapter) {
        Object object = providers_lock;
        synchronized (object) {
            if (storage_adapter == null) {
                storage_adapter = adapter;
                int i = 0;
                while (i < providers.length) {
                    DHTNetworkPositionProvider provider = providers[i];
                    try {
                        DHTNetworkPositionManager.startUp(provider);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    ++i;
                }
            }
        }
    }

    private static void startUp(DHTNetworkPositionProvider provider) {
        byte[] data = null;
        if (storage_adapter != null) {
            data = storage_adapter.getStorageForKey("NPP:" + provider.getPositionType());
        }
        if (data == null) {
            data = new byte[]{};
        }
        try {
            provider.startUp(new DataInputStream(new ByteArrayInputStream(data)));
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    private static void shutDown(DHTNetworkPositionProvider provider) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            provider.shutDown(dos);
            dos.flush();
            byte[] data = baos.toByteArray();
            storage_adapter.setStorageForKey("NPP:" + provider.getPositionType(), data);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy(DHTStorageAdapter adapter) {
        Object object = providers_lock;
        synchronized (object) {
            if (storage_adapter == adapter) {
                int i = 0;
                while (i < providers.length) {
                    DHTNetworkPositionManager.shutDown(providers[i]);
                    ++i;
                }
                storage_adapter = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DHTNetworkPositionProviderInstance registerProvider(final DHTNetworkPositionProvider provider) {
        boolean fire_added = false;
        Object object = providers_lock;
        synchronized (object) {
            boolean found = false;
            DHTNetworkPositionProvider type_found = null;
            DHTNetworkPositionProvider[] dHTNetworkPositionProviderArray = providers;
            int n = providers.length;
            int n2 = 0;
            while (n2 < n) {
                DHTNetworkPositionProvider p = dHTNetworkPositionProviderArray[n2];
                if (p == provider) {
                    found = true;
                    break;
                }
                if (p.getPositionType() == provider.getPositionType()) {
                    type_found = p;
                }
                ++n2;
            }
            if (!found) {
                if (type_found != null) {
                    Debug.out("Registration of " + provider + " found previous provider for same position type, removing it");
                    DHTNetworkPositionManager.unregisterProviderSupport(type_found);
                }
                DHTNetworkPositionProvider[] new_providers = new DHTNetworkPositionProvider[providers.length + 1];
                System.arraycopy(providers, 0, new_providers, 0, providers.length);
                new_providers[DHTNetworkPositionManager.providers.length] = provider;
                providers = new_providers;
                if (storage_adapter != null) {
                    DHTNetworkPositionManager.startUp(provider);
                }
                fire_added = true;
            }
        }
        if (fire_added) {
            for (DHTNetworkPositionProviderListener l : provider_listeners) {
                try {
                    l.providerAdded(provider);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
        return new DHTNetworkPositionProviderInstance(){

            @Override
            public void log(String log) {
                DHTLog.log("NetPos " + provider.getPositionType() + ": " + log);
            }
        };
    }

    public static void unregisterProvider(DHTNetworkPositionProvider provider) {
        if (DHTNetworkPositionManager.unregisterProviderSupport(provider)) {
            for (DHTNetworkPositionProviderListener l : provider_listeners) {
                try {
                    l.providerRemoved(provider);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean unregisterProviderSupport(DHTNetworkPositionProvider provider) {
        boolean removed = false;
        Object object = providers_lock;
        synchronized (object) {
            block9: {
                if (providers.length != 0) break block9;
                return false;
            }
            DHTNetworkPositionProvider[] new_providers = new DHTNetworkPositionProvider[providers.length - 1];
            int pos = 0;
            int i = 0;
            while (i < providers.length) {
                if (providers[i] == provider) {
                    if (storage_adapter != null) {
                        DHTNetworkPositionManager.shutDown(provider);
                    }
                } else {
                    new_providers[pos++] = providers[i];
                }
                ++i;
            }
            if (pos == new_providers.length) {
                providers = new_providers;
                removed = true;
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DHTNetworkPositionProvider getProvider(byte type) {
        Object object = providers_lock;
        synchronized (object) {
            int i = 0;
            while (i < providers.length) {
                if (providers[i].getPositionType() == type) {
                    return providers[i];
                }
                ++i;
            }
        }
        return null;
    }

    public static DHTNetworkPosition[] getLocalPositions() {
        DHTNetworkPositionProvider[] prov = providers;
        ArrayList<DHTNetworkPosition> res = new ArrayList<DHTNetworkPosition>();
        int i = 0;
        while (i < prov.length) {
            try {
                DHTNetworkPosition pos = prov[i].getLocalPosition();
                if (pos != null) {
                    res.add(pos);
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
        return res.toArray(new DHTNetworkPosition[res.size()]);
    }

    public static DHTNetworkPosition getBestLocalPosition() {
        DHTNetworkPosition best_position = null;
        DHTNetworkPosition[] positions = DHTNetworkPositionManager.getLocalPositions();
        byte best_provider = 0;
        int i = 0;
        while (i < positions.length) {
            DHTNetworkPosition position = positions[i];
            byte type = position.getPositionType();
            if (type > best_provider) {
                best_position = position;
            }
            ++i;
        }
        return best_position;
    }

    public static DHTNetworkPosition[] createPositions(byte[] ID, boolean is_local) {
        DHTNetworkPositionProvider[] prov = providers;
        if (prov.length == 0) {
            return NP_EMPTY_ARRAY;
        }
        DHTNetworkPosition[] res = new DHTNetworkPosition[prov.length];
        int skipped = 0;
        int i = 0;
        while (i < res.length) {
            try {
                res[i] = prov[i].create(ID, is_local);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                ++skipped;
            }
            ++i;
        }
        if (skipped > 0) {
            DHTNetworkPosition[] x = new DHTNetworkPosition[res.length - skipped];
            int pos = 0;
            int i2 = 0;
            while (i2 < res.length) {
                if (res[i2] != null) {
                    x[pos++] = res[i2];
                }
                ++i2;
            }
            res = x;
            if (res.length == 0) {
                Debug.out("hmm");
            }
        }
        return res;
    }

    public static float estimateRTT(DHTNetworkPosition[] p1s, DHTNetworkPosition[] p2s) {
        byte best_provider = 0;
        float best_result = Float.NaN;
        int i = 0;
        while (i < p1s.length) {
            DHTNetworkPosition p1 = p1s[i];
            byte p1_type = p1.getPositionType();
            int j = 0;
            while (j < p2s.length) {
                DHTNetworkPosition p2 = p2s[j];
                if (p1_type == p2.getPositionType()) {
                    try {
                        float f = p1.estimateRTT(p2);
                        if (Float.isNaN(f) || p1_type <= best_provider) break;
                        best_result = f;
                        best_provider = p1_type;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    break;
                }
                ++j;
            }
            ++i;
        }
        return best_result;
    }

    public static void update(DHTNetworkPosition[] local_positions, byte[] remote_id, DHTNetworkPosition[] remote_positions, float rtt) {
        int i = 0;
        while (i < local_positions.length) {
            DHTNetworkPosition p1 = local_positions[i];
            int j = 0;
            while (j < remote_positions.length) {
                DHTNetworkPosition p2 = remote_positions[j];
                if (p1.getPositionType() == p2.getPositionType()) {
                    try {
                        p1.update(remote_id, p2, rtt);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    public static byte[] serialisePosition(DHTNetworkPosition pos) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeByte(1);
        dos.writeByte(pos.getPositionType());
        pos.serialise(dos);
        dos.close();
        return baos.toByteArray();
    }

    public static DHTNetworkPosition deserialisePosition(InetAddress originator, byte[] bytes) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        DataInputStream dis = new DataInputStream(bais);
        dis.readByte();
        byte position_type = dis.readByte();
        return DHTNetworkPositionManager.deserialise(originator, position_type, dis);
    }

    public static DHTNetworkPosition deserialise(InetAddress originator, byte position_type, DataInputStream is) throws IOException {
        DHTNetworkPositionProvider[] prov = providers;
        is.mark(512);
        int i = 0;
        while (i < prov.length) {
            if (prov[i].getPositionType() == position_type) {
                DHTNetworkPositionProvider provider = prov[i];
                try {
                    DHTNetworkPosition np = provider.deserialisePosition(is);
                    CopyOnWriteList<DHTNetworkPositionListener> listeners = position_listeners;
                    if (listeners != null) {
                        Iterator<DHTNetworkPositionListener> it = listeners.iterator();
                        while (it.hasNext()) {
                            try {
                                it.next().positionFound(provider, originator, np);
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                    }
                    return np;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    is.reset();
                    break;
                }
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPositionListener(DHTNetworkPositionListener listener) {
        Class<DHTNetworkPositionManager> clazz = DHTNetworkPositionManager.class;
        synchronized (DHTNetworkPositionManager.class) {
            if (position_listeners == null) {
                position_listeners = new CopyOnWriteList();
            }
            position_listeners.add(listener);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePositionListener(DHTNetworkPositionListener listener) {
        Class<DHTNetworkPositionManager> clazz = DHTNetworkPositionManager.class;
        synchronized (DHTNetworkPositionManager.class) {
            if (position_listeners != null) {
                position_listeners.remove(listener);
                if (position_listeners.size() == 0) {
                    position_listeners = null;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void addProviderListener(DHTNetworkPositionProviderListener listener) {
        provider_listeners.add(listener);
    }

    public static void removeProviderListener(DHTNetworkPositionProviderListener listener) {
        provider_listeners.remove(listener);
    }
}

