/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.devices.impl;

import com.biglybt.core.devices.TranscodeActionVetoException;
import com.biglybt.core.devices.TranscodeAnalysisListener;
import com.biglybt.core.devices.TranscodeException;
import com.biglybt.core.devices.TranscodeJob;
import com.biglybt.core.devices.TranscodeProfile;
import com.biglybt.core.devices.TranscodeTarget;
import com.biglybt.core.devices.impl.DeviceImpl;
import com.biglybt.core.devices.impl.TranscodeFileImpl;
import com.biglybt.core.devices.impl.TranscodeQueueImpl;
import com.biglybt.core.download.DiskManagerFileInfoFile;
import com.biglybt.core.download.DiskManagerFileInfoURL;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.pif.disk.DiskManagerFileInfo;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadException;
import com.biglybt.pif.download.DownloadRemovalVetoException;
import com.biglybt.pif.download.DownloadWillBeRemovedListener;
import com.biglybt.pif.peers.PeerManager;
import com.biglybt.pif.peers.PeerManagerStats;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.util.MapUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class TranscodeJobImpl
implements TranscodeJob,
DownloadWillBeRemovedListener {
    private static final int TRANSCODE_OK_DL_PERCENT = 90;
    private TranscodeQueueImpl queue;
    private TranscodeTarget target;
    private TranscodeProfile profile;
    private DiskManagerFileInfo file;
    private TranscodeFileImpl transcode_file;
    private boolean is_stream;
    private volatile InputStream stream;
    private AESemaphore stream_sem = new AESemaphore("TJ:s");
    private int transcode_requirement;
    private int state = 0;
    private int percent_complete = 0;
    private int eta = Integer.MAX_VALUE;
    private String error;
    private long started_on;
    private long paused_on;
    private long process_time;
    private boolean use_direct_input;
    private boolean prefer_direct_input;
    private boolean auto_retry_enabled = true;
    private boolean auto_retry;
    private int auto_retry_count;
    private Download download;
    private volatile boolean download_ok;

    protected TranscodeJobImpl(TranscodeQueueImpl _queue, TranscodeTarget _target, TranscodeProfile _profile, DiskManagerFileInfo _file, boolean _add_stopped, int _transcode_requirement, boolean _is_stream) throws TranscodeException {
        this.queue = _queue;
        this.target = _target;
        this.profile = _profile;
        this.file = _file;
        this.transcode_requirement = _transcode_requirement;
        this.is_stream = _is_stream;
        if (_add_stopped) {
            this.state = 6;
        }
        this.init();
    }

    protected TranscodeJobImpl(TranscodeQueueImpl _queue, Map<String, Object> map) throws IOException, TranscodeException {
        this.queue = _queue;
        this.state = MapUtils.importInt(map, "state", 0);
        if (this.state == 1) {
            this.state = 0;
        }
        this.error = MapUtils.getMapString(map, "error", null);
        String target_id = MapUtils.getMapString(map, "target", null);
        this.target = this.queue.lookupTarget(target_id);
        String profile_id = MapUtils.getMapString(map, "profile", null);
        this.profile = this.queue.lookupProfile(profile_id);
        String file_str = MapUtils.getMapString(map, "file", null);
        if (file_str == null) {
            byte[] dl_hash = ByteFormatter.decodeString(MapUtils.getMapString(map, "dl_hash", null));
            int file_index = MapUtils.importInt(map, "file_index", 0);
            this.file = this.queue.lookupFile(dl_hash, file_index);
        } else {
            this.file = new DiskManagerFileInfoFile(new File(file_str));
        }
        this.transcode_requirement = MapUtils.importInt(map, "trans_req", -1);
        this.auto_retry_enabled = MapUtils.getMapBoolean(map, "ar_enable", true);
        this.prefer_direct_input = MapUtils.getMapBoolean(map, "pdi", false);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> toMap() throws IOException {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            TranscodeJobImpl transcodeJobImpl = this;
            synchronized (transcodeJobImpl) {
                MapUtils.exportInt(map, "state", this.state);
                MapUtils.setMapString(map, "error", this.error);
                MapUtils.setMapString(map, "target", this.target.getID());
                MapUtils.setMapString(map, "profile", this.profile.getUID());
                try {
                    Download download = this.file.getDownload();
                    MapUtils.setMapString(map, "dl_hash", ByteFormatter.encodeString(download.getTorrent().getHash()));
                    MapUtils.exportInt(map, "file_index", this.file.getIndex());
                }
                catch (DownloadException e) {
                    MapUtils.setMapString(map, "file", this.file.getFile().getAbsolutePath());
                }
                MapUtils.exportInt(map, "trans_req", this.transcode_requirement);
                MapUtils.exportBooleanAsLong(map, "ar_enable", this.auto_retry_enabled);
                MapUtils.exportBooleanAsLong(map, "pdi", this.prefer_direct_input);
            }
            return map;
        }
        catch (Throwable e) {
            throw new IOException("Export failed: " + Debug.getNestedExceptionMessage(e));
        }
    }

    protected void init() throws TranscodeException {
        this.transcode_file = ((DeviceImpl)this.target.getDevice()).allocateFile(this.profile, this.getTranscodeRequirement() == 1, this.file, true);
        try {
            this.download = this.file.getDownload();
            if (this.download != null) {
                this.download.addDownloadWillBeRemovedListener(this);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.updateStatus(false);
    }

    protected void updateStatus() {
        this.updateStatus(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateStatus(boolean report_change) {
        TranscodeJobImpl transcodeJobImpl = this;
        synchronized (transcodeJobImpl) {
            if (this.download_ok) {
                return;
            }
            long downloaded = this.file.getDownloaded();
            long length = this.file.getLength();
            if (this.download == null || downloaded == length) {
                this.download_ok = true;
            } else {
                int percent_done = (int)(100L * downloaded / length);
                if (percent_done >= 90) {
                    this.download_ok = true;
                } else {
                    PeerManager pm = this.download.getPeerManager();
                    if (pm != null) {
                        PeerManagerStats stats2 = pm.getStats();
                        int connected_seeds = stats2.getConnectedSeeds();
                        int connected_leechers = stats2.getConnectedLeechers();
                        if (connected_seeds > 10 && connected_seeds > connected_leechers) {
                            this.download_ok = true;
                        }
                    } else {
                        int state = this.download.getState();
                        if (state == 7) {
                            try {
                                this.download.restart();
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                    }
                }
            }
        }
        if (this.download_ok && report_change) {
            this.queue.jobChanged(this, true, false);
        }
    }

    @Override
    public long getDownloadETA() {
        long eta;
        block7: {
            if (this.download_ok) {
                return 0L;
            }
            if (this.file.getDownloaded() == this.file.getLength()) {
                return 0L;
            }
            if (this.file.isSkipped() || this.file.isDeleted()) {
                return Long.MAX_VALUE;
            }
            try {
                eta = PluginCoreUtils.unwrap(this.download).getStats().getSmoothedETA();
                if (eta >= 0L) break block7;
                return Long.MAX_VALUE;
            }
            catch (Throwable e) {
                Debug.out(e);
                return Long.MAX_VALUE;
            }
        }
        long adjusted = eta * 100L / 90L;
        if (adjusted == 0L) {
            adjusted = 1L;
        }
        return adjusted;
    }

    protected boolean canUseDirectInput() {
        if (this.file instanceof DiskManagerFileInfoURL) {
            return true;
        }
        long length = this.file.getLength();
        return this.file.getDownloaded() == length && this.file.getFile().length() == length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean useDirectInput() {
        TranscodeJobImpl transcodeJobImpl = this;
        synchronized (transcodeJobImpl) {
            return this.use_direct_input || this.getPreferDirectInput() && this.canUseDirectInput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUseDirectInput() {
        TranscodeJobImpl transcodeJobImpl = this;
        synchronized (transcodeJobImpl) {
            this.use_direct_input = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPreferDirectInput(boolean prefer) {
        TranscodeJobImpl transcodeJobImpl = this;
        synchronized (transcodeJobImpl) {
            this.prefer_direct_input = prefer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getPreferDirectInput() {
        TranscodeJobImpl transcodeJobImpl = this;
        synchronized (transcodeJobImpl) {
            return this.prefer_direct_input;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAutoRetry(boolean _auto_retry) {
        TranscodeJobImpl transcodeJobImpl = this;
        synchronized (transcodeJobImpl) {
            if (_auto_retry) {
                this.auto_retry = true;
                ++this.auto_retry_count;
            } else {
                this.auto_retry = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isAutoRetry() {
        TranscodeJobImpl transcodeJobImpl = this;
        synchronized (transcodeJobImpl) {
            return this.auto_retry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getAutoRetryCount() {
        TranscodeJobImpl transcodeJobImpl = this;
        synchronized (transcodeJobImpl) {
            return this.auto_retry_count;
        }
    }

    @Override
    public void setEnableAutoRetry(boolean enabled) {
        this.auto_retry_enabled = enabled;
    }

    @Override
    public boolean getEnableAutoRetry() {
        return this.auto_retry_enabled;
    }

    protected boolean isStream() {
        return this.is_stream;
    }

    protected void setStream(InputStream _stream) {
        this.stream = _stream;
        this.stream_sem.releaseForever();
    }

    protected InputStream getStream(int wait_for_millis) throws IOException {
        if (this.state == 5) {
            throw new IOException("Transcode job failed: " + this.error);
        }
        if (this.state == 4) {
            throw new IOException("Transcode job cancelled");
        }
        if (this.state == 7) {
            throw new IOException("Transcode job removed");
        }
        this.stream_sem.reserve(wait_for_millis);
        return this.stream;
    }

    @Override
    public void downloadWillBeRemoved(Download download) throws DownloadRemovalVetoException {
        if (this.queue.getIndex(this) != 0 && this.state != 3) {
            throw new DownloadRemovalVetoException(MessageText.getString("devices.xcode.remove.vetoed", new String[]{download.getName()}));
        }
        download.removeDownloadWillBeRemovedListener(this);
    }

    @Override
    public String getName() {
        if (this.download != null) {
            if (this.download.getDiskManagerFileInfo().length == 1) {
                return this.download.getName();
            }
            return String.valueOf(this.download.getName()) + ": " + this.file.getFile().getName();
        }
        return this.file.getFile().getName();
    }

    protected void reset() {
        this.state = 0;
        this.error = null;
        this.percent_complete = 0;
        this.eta = Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void starts() {
        TranscodeJobImpl transcodeJobImpl = this;
        synchronized (transcodeJobImpl) {
            this.started_on = SystemTime.getMonotonousTime();
            this.paused_on = 0L;
            if (this.state != 2) {
                this.state = 1;
            }
        }
        this.queue.jobChanged(this, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void failed(Throwable e) {
        this.queue.log("Transcode failed", e);
        TranscodeJobImpl transcodeJobImpl = this;
        synchronized (transcodeJobImpl) {
            if (this.state != 6) {
                this.state = 5;
                this.error = Debug.getNestedExceptionMessage(e);
                this.process_time += SystemTime.getMonotonousTime() - this.started_on;
                this.paused_on = 0L;
                this.started_on = 0L;
            }
        }
        this.queue.jobChanged(this, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void complete() {
        TranscodeJobImpl transcodeJobImpl = this;
        synchronized (transcodeJobImpl) {
            this.state = 3;
            this.process_time += SystemTime.getMonotonousTime() - this.started_on;
            this.paused_on = 0L;
            this.started_on = 0L;
        }
        if (this.download != null) {
            this.download.removeDownloadWillBeRemovedListener(this);
        }
        this.transcode_file.setComplete(true);
        this.queue.jobChanged(this, false, false);
    }

    protected void updateProgress(int _done, int _eta) {
        if (this.percent_complete != _done || this.eta != _eta) {
            this.percent_complete = _done;
            this.eta = _eta;
            this.queue.jobChanged(this, false, false);
        }
    }

    @Override
    public TranscodeTarget getTarget() {
        return this.target;
    }

    @Override
    public int getTranscodeRequirement() {
        if (this.transcode_requirement >= 0) {
            return this.transcode_requirement;
        }
        return this.getDevice().getTranscodeRequirement();
    }

    @Override
    public void analyseNow(TranscodeAnalysisListener listener) throws TranscodeException {
        this.queue.analyse(this, listener);
    }

    protected DeviceImpl getDevice() {
        return (DeviceImpl)((Object)this.target);
    }

    @Override
    public TranscodeProfile getProfile() {
        return this.profile;
    }

    @Override
    public DiskManagerFileInfo getFile() {
        return this.file;
    }

    @Override
    public TranscodeFileImpl getTranscodeFile() {
        return this.transcode_file;
    }

    @Override
    public int getIndex() {
        return this.queue.getIndex(this);
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public int getPercentComplete() {
        return this.percent_complete;
    }

    @Override
    public long getETASecs() {
        if (this.eta <= 0) {
            return 0L;
        }
        if (this.eta == Integer.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return this.eta;
    }

    @Override
    public String getETA() {
        if (this.eta < 0) {
            return null;
        }
        if (this.eta == Integer.MAX_VALUE) {
            return "\u221e";
        }
        return TimeFormatter.format(this.eta);
    }

    @Override
    public String getError() {
        return this.error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canPause() {
        TranscodeJobImpl transcodeJobImpl = this;
        synchronized (transcodeJobImpl) {
            return !this.use_direct_input;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        TranscodeJobImpl transcodeJobImpl = this;
        synchronized (transcodeJobImpl) {
            if (this.use_direct_input) {
                return;
            }
            if (this.state != 1) {
                return;
            }
            this.state = 2;
            this.paused_on = SystemTime.getMonotonousTime();
        }
        this.queue.jobChanged(this, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        TranscodeJobImpl transcodeJobImpl = this;
        synchronized (transcodeJobImpl) {
            if (this.state == 2) {
                this.state = 1;
                if (this.paused_on > 0L && this.started_on > 0L) {
                    this.process_time -= SystemTime.getMonotonousTime() - this.paused_on;
                }
            } else {
                return;
            }
        }
        this.queue.jobChanged(this, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queue() {
        boolean do_resume;
        TranscodeJobImpl transcodeJobImpl = this;
        synchronized (transcodeJobImpl) {
            do_resume = this.state == 2;
        }
        if (do_resume) {
            this.resume();
            return;
        }
        transcodeJobImpl = this;
        synchronized (transcodeJobImpl) {
            if (this.state != 0) {
                if (this.state == 1 || this.state == 2) {
                    this.stop();
                }
            } else {
                return;
            }
            this.reset();
            this.use_direct_input = false;
            this.auto_retry = false;
            this.auto_retry_count = 0;
            this.is_stream = false;
        }
        this.queue.jobChanged(this, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        TranscodeJobImpl transcodeJobImpl = this;
        synchronized (transcodeJobImpl) {
            if (this.state == 6) {
                return;
            }
            this.state = 6;
            this.process_time = 0L;
            this.started_on = 0L;
        }
        this.queue.jobChanged(this, true, true);
    }

    @Override
    public void remove() throws TranscodeActionVetoException {
        this.queue.remove(this, false);
    }

    @Override
    public void removeForce() {
        try {
            this.queue.remove(this, true);
        }
        catch (TranscodeActionVetoException e) {
            Debug.out(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        boolean delete_file;
        TranscodeJobImpl transcodeJobImpl = this;
        synchronized (transcodeJobImpl) {
            delete_file = this.state != 3;
            this.state = 7;
        }
        if (delete_file && !this.isStream()) {
            try {
                this.transcode_file.delete(true);
            }
            catch (Throwable e) {
                this.queue.log("Faile to destroy job", e);
            }
        }
    }

    @Override
    public void moveUp() {
        this.queue.moveUp(this);
    }

    @Override
    public void moveDown() {
        this.queue.moveDown(this);
    }

    @Override
    public long getProcessTime() {
        if (this.state == 3) {
            return this.process_time;
        }
        if (this.started_on == 0L) {
            if (this.process_time > 0L) {
                return this.process_time;
            }
            return 0L;
        }
        return SystemTime.getMonotonousTime() - this.started_on + this.process_time;
    }

    public void generate(IndentWriter writer) {
        writer.println("target=" + this.target.getID() + ", profile=" + this.profile.getName() + ", file=" + this.file);
        writer.println("tfile=" + this.transcode_file.getString());
        writer.println("stream=" + this.is_stream + ", state=" + this.state + ", treq=" + this.transcode_requirement + ", %=" + this.percent_complete + ", error=" + this.error);
    }
}

