/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.devices.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.devices.DeviceManagerException;
import com.biglybt.core.devices.impl.DeviceImpl;
import com.biglybt.core.devices.impl.DeviceManagerImpl;
import com.biglybt.core.devices.impl.DeviceTivo;
import com.biglybt.core.networkmanager.admin.NetworkAdmin;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DelayedEvent;
import com.biglybt.core.util.RandomUtils;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.tracker.web.TrackerWebContext;
import com.biglybt.pif.tracker.web.TrackerWebPageGenerator;
import com.biglybt.pif.tracker.web.TrackerWebPageRequest;
import com.biglybt.pif.tracker.web.TrackerWebPageResponse;
import com.biglybt.pifimpl.local.PluginInitializer;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;

public class DeviceTivoManager {
    private static final String LF = "\n";
    private static final int CONTROL_PORT = 2190;
    private DeviceManagerImpl device_manager;
    PluginInterface plugin_interface;
    boolean is_enabled;
    private String uid;
    Searcher current_search;
    volatile boolean manager_destroyed;

    protected DeviceTivoManager(DeviceManagerImpl _dm) {
        this.device_manager = _dm;
    }

    protected void startUp() {
        this.plugin_interface = PluginInitializer.getDefaultInterface();
        this.is_enabled = COConfigurationManager.getStringParameter("ui").equals("az2") ? false : COConfigurationManager.getBooleanParameter("devices.tivo.enabled", true);
        this.uid = COConfigurationManager.getStringParameter("devices.tivo.uid", null);
        if (this.uid == null) {
            byte[] bytes = new byte[8];
            RandomUtils.nextBytes(bytes);
            this.uid = Base32.encode(bytes);
            COConfigurationManager.setParameter("devices.tivo.uid", this.uid);
        }
        boolean found_tivo = false;
        DeviceImpl[] deviceImplArray = this.device_manager.getDevices();
        int n = deviceImplArray.length;
        int n2 = 0;
        while (n2 < n) {
            DeviceImpl device = deviceImplArray[n2];
            if (device instanceof DeviceTivo) {
                found_tivo = true;
                break;
            }
            ++n2;
        }
        if (found_tivo || this.device_manager.getAutoSearch()) {
            this.search(found_tivo, false);
        }
    }

    protected boolean isEnabled() {
        return this.is_enabled;
    }

    protected void setEnabled(boolean enabled) {
        COConfigurationManager.setParameter("devices.tivo.enabled", enabled);
        if (enabled) {
            this.search(false, true);
        } else {
            DeviceImpl[] deviceImplArray = this.device_manager.getDevices();
            int n = deviceImplArray.length;
            int n2 = 0;
            while (n2 < n) {
                DeviceImpl device = deviceImplArray[n2];
                if (device instanceof DeviceTivo) {
                    device.remove();
                }
                ++n2;
            }
        }
    }

    protected void search() {
        this.search(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void search(boolean persistent, boolean async) {
        try {
            DeviceTivoManager deviceTivoManager = this;
            synchronized (deviceTivoManager) {
                if (this.current_search == null) {
                    this.current_search = new Searcher(persistent, async);
                } else if (!this.current_search.wakeup()) {
                    this.current_search = new Searcher(persistent, async);
                }
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    protected byte[] encodeBeacon(boolean is_broadcast, int my_port) throws IOException {
        String beacon = "tivoconnect=1\nswversion=1\nmethod=" + (is_broadcast ? "broadcast" : "connected") + LF + "identity=" + this.uid + LF + "machine=" + this.device_manager.getLocalServiceName() + LF + "platform=pc" + LF + "services=TiVoMediaServer:" + my_port + "/http";
        return beacon.getBytes("ISO-8859-1");
    }

    protected Map<String, String> decodeBeacon(byte[] buffer, int length) throws IOException {
        String str = new String(buffer, 0, length, "ISO-8859-1");
        String[] lines = str.split(LF);
        HashMap<String, String> map = new HashMap<String, String>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            int pos = line.indexOf(61);
            if (pos > 0) {
                map.put(line.substring(0, pos).trim().toLowerCase(), line.substring(pos + 1).trim());
            }
            ++n2;
        }
        return map;
    }

    protected boolean receiveBeacon(InetAddress sender, byte[] buffer, int length) {
        if (this.is_enabled) {
            String id;
            Map<String, String> map;
            block5: {
                map = this.decodeBeacon(buffer, length);
                id = map.get("identity");
                if (id != null && !id.equals(this.uid)) break block5;
                return false;
            }
            try {
                String platform = map.get("platform");
                if (platform != null && platform.toLowerCase().startsWith("tcd/")) {
                    String classification = "tivo." + platform.substring(4).toLowerCase();
                    this.foundTiVo(sender, id, classification, map.get("machine"));
                    return true;
                }
            }
            catch (Throwable e) {
                this.log("Failed to decode beacon", e);
            }
        }
        return false;
    }

    protected DeviceTivo foundTiVo(InetAddress address, String uid, String classification, String machine) {
        DeviceTivo new_device;
        DeviceTivo result;
        uid = "tivo:" + uid;
        DeviceImpl[] devices = this.device_manager.getDevices();
        String server_name = this.device_manager.getLocalServiceName();
        DeviceImpl[] deviceImplArray = devices;
        int n = devices.length;
        int n2 = 0;
        while (n2 < n) {
            DeviceImpl device = deviceImplArray[n2];
            if (device instanceof DeviceTivo) {
                DeviceTivo tivo = (DeviceTivo)device;
                if (device.getID().equals(uid)) {
                    String existing_classification;
                    if (classification != null && !classification.equals(existing_classification = device.getClassification())) {
                        device.setPersistentStringProperty("tt_rend_class", classification);
                    }
                    tivo.found(this, address, server_name, machine);
                    return tivo;
                }
            }
            ++n2;
        }
        if (classification == null) {
            classification = "tivo.series3";
        }
        if ((result = (DeviceTivo)this.device_manager.addDevice(new_device = new DeviceTivo(this.device_manager, uid, classification))) == new_device) {
            new_device.found(this, address, server_name, machine);
        }
        return result;
    }

    protected void log(String str) {
        if (this.device_manager == null) {
            System.out.println(str);
        } else {
            this.device_manager.log("TiVo: " + str);
        }
    }

    protected void log(String str, Throwable e) {
        if (this.device_manager == null) {
            System.out.println(str);
            e.printStackTrace();
        } else {
            this.device_manager.log("TiVo: " + str, e);
        }
    }

    protected class Searcher {
        private static final int LIFE_MILLIS = 10000;
        long start = SystemTime.getMonotonousTime();
        private int tcp_port;
        DatagramSocket control_socket;
        private TrackerWebContext twc;
        private TimerEventPeriodic timer_event;
        volatile boolean persistent;
        volatile boolean search_destroyed;

        protected Searcher(boolean _persistent, boolean _async) throws DeviceManagerException {
            try {
                int last_port = COConfigurationManager.getIntParameter("devices.tivo.net.tcp.port", 0);
                if (last_port > 0) {
                    try {
                        Throwable throwable = null;
                        Object var6_10 = null;
                        try (ServerSocket ss = new ServerSocket(last_port);){
                            ss.setReuseAddress(true);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Throwable e) {
                        last_port = 0;
                    }
                }
                this.twc = DeviceTivoManager.this.plugin_interface.getTracker().createWebContext("Tivo", last_port, 1);
                this.tcp_port = this.twc.getURLs()[0].getPort();
                COConfigurationManager.setParameter("devices.tivo.net.tcp.port", this.tcp_port);
                this.twc.addPageGenerator(new TrackerWebPageGenerator(){

                    @Override
                    public boolean generate(TrackerWebPageRequest request2, TrackerWebPageResponse response) throws IOException {
                        String id = (String)request2.getHeaders().get("tsn");
                        if (id == null) {
                            id = (String)request2.getHeaders().get("tivo_tcd_id");
                        }
                        if (id != null && ((Searcher)Searcher.this).DeviceTivoManager.this.is_enabled) {
                            Searcher.this.persistent = true;
                            DeviceTivo tivo = DeviceTivoManager.this.foundTiVo(request2.getClientAddress2().getAddress(), id, null, null);
                            return tivo.generate(request2, response);
                        }
                        return false;
                    }
                });
                this.control_socket = new DatagramSocket(null);
                this.control_socket.setReuseAddress(true);
                try {
                    this.control_socket.setSoTimeout(60000);
                }
                catch (Throwable e) {
                    // empty catch block
                }
                InetAddress bind = NetworkAdmin.getSingleton().getSingleHomedServiceBindAddress();
                this.control_socket.bind(new InetSocketAddress(bind, 2190));
                this.timer_event = SimpleTimer.addPeriodicEvent("Tivo:Beacon", 60000L, new TimerEventPerformer(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void perform(TimerEvent event2) {
                        if (!((Searcher)Searcher.this).DeviceTivoManager.this.manager_destroyed && !Searcher.this.search_destroyed) {
                            Searcher.this.sendBeacon();
                        }
                        if (!Searcher.this.persistent) {
                            DeviceTivoManager deviceTivoManager = DeviceTivoManager.this;
                            synchronized (deviceTivoManager) {
                                if (SystemTime.getMonotonousTime() - Searcher.this.start >= 10000L) {
                                    DeviceTivoManager.this.log("Terminating search, no devices found");
                                    ((Searcher)Searcher.this).DeviceTivoManager.this.current_search = null;
                                    Searcher.this.destroy();
                                }
                            }
                        }
                    }
                });
                final AESemaphore start_sem = new AESemaphore("TiVo:CtrlListener");
                new AEThread2("TiVo:CtrlListener", true){

                    @Override
                    public void run() {
                        start_sem.release();
                        long successful_accepts = 0L;
                        long failed_accepts = 0L;
                        while (!((Searcher)Searcher.this).DeviceTivoManager.this.manager_destroyed && !Searcher.this.search_destroyed) {
                            try {
                                byte[] buf = new byte[8192];
                                DatagramPacket packet = new DatagramPacket(buf, buf.length);
                                Searcher.this.control_socket.receive(packet);
                                ++successful_accepts;
                                failed_accepts = 0L;
                                if (!DeviceTivoManager.this.receiveBeacon(packet.getAddress(), packet.getData(), packet.getLength())) continue;
                                Searcher.this.persistent = true;
                            }
                            catch (SocketTimeoutException buf) {
                            }
                            catch (Throwable e) {
                                if (Searcher.this.control_socket != null && !Searcher.this.search_destroyed && !((Searcher)Searcher.this).DeviceTivoManager.this.manager_destroyed) {
                                    ++failed_accepts;
                                    DeviceTivoManager.this.log("UDP receive on port 2190 failed", e);
                                }
                                if ((failed_accepts <= 100L || successful_accepts != 0L) && failed_accepts <= 1000L) continue;
                                DeviceTivoManager.this.log("    too many failures, abandoning");
                                break;
                            }
                        }
                    }
                }.start();
                if (_async) {
                    new DelayedEvent("search:delay", 5000L, new AERunnable(){

                        @Override
                        public void runSupport() {
                            Searcher.this.sendBeacon();
                        }
                    });
                } else {
                    start_sem.reserve(5000L);
                    this.sendBeacon();
                }
                DeviceTivoManager.this.log("Initiated device search");
            }
            catch (Throwable e) {
                DeviceTivoManager.this.log("Failed to initialise search", e);
                this.destroy();
                throw new DeviceManagerException("Creation failed", e);
            }
        }

        protected void sendBeacon() {
            if (DeviceTivoManager.this.is_enabled) {
                try {
                    byte[] bytes = DeviceTivoManager.this.encodeBeacon(true, this.tcp_port);
                    this.control_socket.send(new DatagramPacket(bytes, bytes.length, InetAddress.getByName("255.255.255.255"), 2190));
                }
                catch (Throwable e) {
                    DeviceTivoManager.this.log("Failed to send beacon", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean wakeup() {
            DeviceTivoManager deviceTivoManager = DeviceTivoManager.this;
            synchronized (deviceTivoManager) {
                block4: {
                    if (!this.search_destroyed) break block4;
                    return false;
                }
                this.start = SystemTime.getMonotonousTime();
            }
            this.sendBeacon();
            return true;
        }

        protected void destroy() {
            this.search_destroyed = true;
            if (this.twc != null) {
                this.twc.destroy();
                this.twc = null;
            }
            if (this.timer_event != null) {
                this.timer_event.cancel();
                this.timer_event = null;
            }
            if (this.control_socket != null) {
                try {
                    this.control_socket.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.control_socket = null;
            }
        }
    }
}

