/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.devices.impl;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreLifecycleAdapter;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.config.impl.ConfigurationDefaults;
import com.biglybt.core.devices.Device;
import com.biglybt.core.devices.DeviceManager;
import com.biglybt.core.devices.DeviceManagerDiscoveryListener;
import com.biglybt.core.devices.DeviceManagerException;
import com.biglybt.core.devices.DeviceManagerListener;
import com.biglybt.core.devices.DeviceMediaRenderer;
import com.biglybt.core.devices.DeviceSearchListener;
import com.biglybt.core.devices.DeviceTemplate;
import com.biglybt.core.devices.TranscodeManager;
import com.biglybt.core.devices.TranscodeProfile;
import com.biglybt.core.devices.TranscodeProvider;
import com.biglybt.core.devices.impl.DeviceDriveManager;
import com.biglybt.core.devices.impl.DeviceImpl;
import com.biglybt.core.devices.impl.DeviceManagerRSSFeed;
import com.biglybt.core.devices.impl.DeviceManagerUPnPImpl;
import com.biglybt.core.devices.impl.DeviceMediaRendererImpl;
import com.biglybt.core.devices.impl.DeviceMediaRendererManual;
import com.biglybt.core.devices.impl.DeviceMediaRendererTemplateImpl;
import com.biglybt.core.devices.impl.DeviceTivoManager;
import com.biglybt.core.devices.impl.DeviceUPnPImpl;
import com.biglybt.core.devices.impl.DeviceiTunesManager;
import com.biglybt.core.devices.impl.TranscodeFileImpl;
import com.biglybt.core.devices.impl.TranscodeManagerImpl;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.AEDiagnosticsEvidenceGenerator;
import com.biglybt.core.util.AEDiagnosticsLogger;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DelayedEvent;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.ListenerManager;
import com.biglybt.core.util.ListenerManagerDispatcher;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.vuzefile.VuzeFile;
import com.biglybt.core.vuzefile.VuzeFileComponent;
import com.biglybt.core.vuzefile.VuzeFileHandler;
import com.biglybt.core.vuzefile.VuzeFileProcessor;
import com.biglybt.net.upnp.UPnPDevice;
import com.biglybt.pif.disk.DiskManagerFileInfo;
import com.biglybt.pif.ipc.IPCInterface;
import com.biglybt.pif.torrent.TorrentAttribute;
import com.biglybt.pif.tracker.web.TrackerWebPageRequest;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.utils.PowerManagementListener;
import com.biglybt.pif.utils.StaticUtilities;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.platform.PlatformManagerFactory;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DeviceManagerImpl
implements DeviceManager,
PowerManagementListener,
AEDiagnosticsEvidenceGenerator {
    private static final String LOGGER_NAME = "Devices";
    private static final String CONFIG_FILE = "devices.config";
    private static final String AUTO_SEARCH_CONFIG_KEY = "devices.config.auto_search";
    private static final int AUTO_HIDE_OLD_DAYS_DEFAULT = 31;
    private static final String AUTO_HIDE_OLD_CONFIG_KEY = "devices.config.auto_hide_old";
    private static final String RSS_ENABLE_CONFIG_KEY = "devices.config.rss_enable";
    private static final String OD_ENABLED_CONFIG_KEY = "devices.config.od.enabled";
    private static final String OD_IS_AUTO_CONFIG_KEY = "devices.config.od.auto";
    private static final String OD_INCLUDE_PRIVATE_CONFIG_KEY = "devices.config.od.inc_priv";
    private static final String TRANSCODE_DIR_DEFAULT = "transcodes";
    private static final String CONFIG_DEFAULT_WORK_DIR = "devices.config.def_work_dir";
    private static final String CONFIG_DISABLE_SLEEP = "devices.config.disable_sleep";
    protected static final int DEVICE_UPDATE_PERIOD = 5000;
    protected static final int DEVICE_AUTO_HIDE_CHECK_PERIOD = 120000;
    protected static final int DEVICE_AUTO_HIDE_CHECK_TICKS = 24;
    private static boolean pre_initialised;
    private static DeviceManagerImpl singleton;
    private Core core;
    private TorrentAttribute od_manual_ta;
    List<DeviceImpl> device_list = new ArrayList<DeviceImpl>();
    private Map<String, DeviceImpl> device_map = new HashMap<String, DeviceImpl>();
    DeviceTivoManager tivo_manager;
    DeviceManagerUPnPImpl upnp_manager;
    DeviceDriveManager drive_manager;
    private Set<Device> disable_events = Collections.synchronizedSet(new HashSet());
    private static final int LT_DEVICE_ADDED = 1;
    private static final int LT_DEVICE_CHANGED = 2;
    private static final int LT_DEVICE_ATTENTION = 3;
    private static final int LT_DEVICE_REMOVED = 4;
    private static final int LT_INITIALIZED = 5;
    private ListenerManager<DeviceManagerListener> listeners = ListenerManager.createAsyncManager("DM:ld", new ListenerManagerDispatcher<DeviceManagerListener>(){

        @Override
        public void dispatch(DeviceManagerListener listener, int type, Object value) {
            DeviceImpl device = (DeviceImpl)value;
            switch (type) {
                case 1: {
                    listener.deviceAdded(device);
                    break;
                }
                case 2: {
                    if (!this.deviceAdded(device)) break;
                    device.fireChanged();
                    listener.deviceChanged(device);
                    break;
                }
                case 3: {
                    if (!this.deviceAdded(device)) break;
                    listener.deviceAttentionRequest(device);
                    break;
                }
                case 4: {
                    listener.deviceRemoved(device);
                    break;
                }
                case 5: {
                    listener.deviceManagerLoaded();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean deviceAdded(Device device) {
            DeviceManagerImpl deviceManagerImpl = DeviceManagerImpl.this;
            synchronized (deviceManagerImpl) {
                return DeviceManagerImpl.this.device_list.contains(device);
            }
        }
    });
    boolean auto_search;
    int auto_hide_old_days = 31;
    private DeviceManagerRSSFeed rss_publisher;
    boolean closing;
    boolean config_unclean;
    boolean config_dirty;
    int explicit_search;
    volatile TranscodeManagerImpl transcode_manager;
    private CopyOnWriteList<DeviceManagerDiscoveryListener> discovery_listeners = new CopyOnWriteList();
    private int getMimeType_fails;
    private Object logger_lock = new Object();
    private AEDiagnosticsLogger logger;
    private AESemaphore init_sem = new AESemaphore("dm:init");
    private volatile boolean initialized = false;
    private Object lsn_lock = new Object();
    private String local_service_name;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void preInitialise() {
        Class<DeviceManagerImpl> clazz = DeviceManagerImpl.class;
        synchronized (DeviceManagerImpl.class) {
            if (pre_initialised) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            pre_initialised = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            VuzeFileHandler.getSingleton().addProcessor(new VuzeFileProcessor(){

                @Override
                public void process(VuzeFile[] files, int expected_types) {
                    int i = 0;
                    while (i < files.length) {
                        VuzeFile vf = files[i];
                        VuzeFileComponent[] comps = vf.getComponents();
                        int j = 0;
                        while (j < comps.length) {
                            VuzeFileComponent comp2 = comps[j];
                            int type = comp2.getType();
                            if (type == 512) {
                                try {
                                    ((DeviceManagerImpl)DeviceManagerImpl.getSingleton()).importVuzeFile(comp2.getContent(), (expected_types & 0x200) == 0);
                                    comp2.setProcessed();
                                }
                                catch (Throwable e) {
                                    Debug.printStackTrace(e);
                                }
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
            });
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeviceManager getSingleton() {
        Class<DeviceManagerImpl> clazz = DeviceManagerImpl.class;
        synchronized (DeviceManagerImpl.class) {
            if (singleton == null) {
                singleton = new DeviceManagerImpl();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    protected DeviceManagerImpl() {
        AEDiagnostics.addWeakEvidenceGenerator(this);
        String def_dir = COConfigurationManager.getStringParameter("Default save path");
        ConfigurationDefaults.getInstance().addParameter(CONFIG_DEFAULT_WORK_DIR, new File(def_dir, TRANSCODE_DIR_DEFAULT).getAbsolutePath());
        CoreFactory.addCoreRunningListener(new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                DeviceManagerImpl.this.initWithCore(core);
            }
        });
    }

    private TranscodeManager ensureInitialised(boolean partial) {
        Core core = CoreFactory.getSingleton();
        if (core.isStarted()) {
            this.initWithCore(core);
        } else if (core.isInitThread()) {
            Debug.out("This is bad");
            this.initWithCore(core);
        }
        if (partial) {
            long start = SystemTime.getMonotonousTime();
            while (!this.init_sem.reserve(250L)) {
                if (this.transcode_manager == null) {
                    if (SystemTime.getMonotonousTime() - start < 30000L) continue;
                    Debug.out("Timeout waiting for init");
                    AEDiagnostics.dumpThreads();
                }
                break;
            }
        } else if (!this.init_sem.reserve(30000L)) {
            Debug.out("Timeout waiting for init");
            AEDiagnostics.dumpThreads();
        }
        return this.transcode_manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initWithCore(Core _core) {
        DeviceManagerImpl deviceManagerImpl = this;
        synchronized (deviceManagerImpl) {
            if (this.core != null) {
                return;
            }
            this.core = _core;
        }
        try {
            this.od_manual_ta = PluginInitializer.getDefaultInterface().getTorrentManager().getPluginAttribute("device.manager.od.ta.manual");
            this.rss_publisher = new DeviceManagerRSSFeed(this);
            COConfigurationManager.addAndFireParameterListeners(new String[]{AUTO_SEARCH_CONFIG_KEY, AUTO_HIDE_OLD_CONFIG_KEY}, new ParameterListener(){

                @Override
                public void parameterChanged(String name) {
                    DeviceManagerImpl.this.auto_search = COConfigurationManager.getBooleanParameter(DeviceManagerImpl.AUTO_SEARCH_CONFIG_KEY, true);
                    DeviceManagerImpl.this.auto_hide_old_days = COConfigurationManager.getIntParameter(DeviceManagerImpl.AUTO_HIDE_OLD_CONFIG_KEY, 31);
                }
            });
            this.tivo_manager = new DeviceTivoManager(this);
            this.upnp_manager = new DeviceManagerUPnPImpl(this);
            this.loadConfig();
            new DeviceiTunesManager(this);
            this.drive_manager = new DeviceDriveManager(this);
            this.transcode_manager = new TranscodeManagerImpl(this);
            this.transcode_manager.initialise();
            this.core.addLifecycleListener(new CoreLifecycleAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void stopping(Core core) {
                    DeviceManagerImpl deviceManagerImpl = DeviceManagerImpl.this;
                    synchronized (deviceManagerImpl) {
                        DeviceImpl[] devices;
                        if (DeviceManagerImpl.this.config_dirty || DeviceManagerImpl.this.config_unclean) {
                            DeviceManagerImpl.this.saveConfig();
                        }
                        DeviceManagerImpl.this.closing = true;
                        DeviceManagerImpl.this.transcode_manager.close();
                        DeviceImpl[] deviceImplArray = devices = DeviceManagerImpl.this.getDevices();
                        int n = devices.length;
                        int n2 = 0;
                        while (n2 < n) {
                            DeviceImpl device = deviceImplArray[n2];
                            device.close();
                            ++n2;
                        }
                    }
                }
            });
            this.upnp_manager.initialise();
            SimpleTimer.addPeriodicEvent("DeviceManager:update", 5000L, new TimerEventPerformer(){
                private int tick_count = 0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void perform(TimerEvent event2) {
                    ArrayList<DeviceImpl> copy;
                    ++this.tick_count;
                    DeviceManagerImpl.this.transcode_manager.updateStatus(this.tick_count);
                    DeviceManagerImpl deviceManagerImpl = DeviceManagerImpl.this;
                    synchronized (deviceManagerImpl) {
                        if (DeviceManagerImpl.this.device_list.size() == 0) {
                            return;
                        }
                        copy = new ArrayList<DeviceImpl>(DeviceManagerImpl.this.device_list);
                    }
                    for (DeviceImpl device : copy) {
                        device.updateStatus(this.tick_count);
                    }
                    if (DeviceManagerImpl.this.auto_hide_old_days > 0 && this.tick_count % 24 == 0) {
                        long now = SystemTime.getCurrentTime();
                        int num_hidden = 0;
                        for (DeviceImpl device : copy) {
                            DeviceMediaRenderer rend;
                            int type;
                            if (!device.isLivenessDetectable() || device.isTagged() || (type = device.getType()) != 2 && (type != 3 || (rend = (DeviceMediaRenderer)((Object)device)).getRendererSpecies() != 6)) continue;
                            long age = now - device.getLastSeen();
                            if (age > (long)(DeviceManagerImpl.this.auto_hide_old_days * 24 * 60 * 60) * 1000L) {
                                if (device.isHidden()) continue;
                                DeviceManagerImpl.this.log("Auto-hiding '" + device.getName() + "'");
                                device.setHidden(true);
                                device.setAutoHidden(true);
                                ++num_hidden;
                                continue;
                            }
                            if (!device.isHidden() || !device.isAutoHidden()) continue;
                            DeviceManagerImpl.this.log("Auto-showing '" + device.getName() + "'");
                            device.setAutoHidden(false);
                            device.setHidden(false);
                        }
                        if (num_hidden > 0) {
                            Logger.log(new LogAlert(true, 0, MessageText.getString("device.autohide.alert", new String[]{String.valueOf(num_hidden), String.valueOf(DeviceManagerImpl.this.auto_hide_old_days)})));
                        }
                    }
                }
            });
            this.initialized = true;
            this.listeners.dispatch(5, null);
            this.core.addPowerManagementListener(this);
        }
        finally {
            this.init_sem.releaseForever();
        }
    }

    protected void UPnPManagerStarted() {
        DeviceImpl[] devices;
        this.tivo_manager.startUp();
        DeviceImpl[] deviceImplArray = devices = this.getDevices();
        int n = devices.length;
        int n2 = 0;
        while (n2 < n) {
            DeviceImpl device = deviceImplArray[n2];
            if (device instanceof DeviceUPnPImpl) {
                ((DeviceUPnPImpl)device).UPnPInitialised();
            }
            ++n2;
        }
    }

    protected Core getCore() {
        return this.core;
    }

    protected DeviceManagerUPnPImpl getUPnPManager() {
        return this.upnp_manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLocalServiceName() {
        Object object = this.lsn_lock;
        synchronized (object) {
            if (this.local_service_name == null) {
                try {
                    IPCInterface ipc = this.getUPnPManager().getUPnPAVIPC();
                    if (ipc != null) {
                        this.local_service_name = (String)ipc.invoke("getServiceName", new Object[0]);
                    }
                }
                catch (Throwable ipc) {
                    // empty catch block
                }
                if (this.local_service_name == null) {
                    this.local_service_name = Constants.APP_NAME;
                    try {
                        String cn = PlatformManagerFactory.getPlatformManager().getComputerName();
                        if (cn != null && cn.length() > 0) {
                            this.local_service_name = String.valueOf(this.local_service_name) + " on " + cn;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            return this.local_service_name;
        }
    }

    @Override
    public boolean isTiVoEnabled() {
        return this.tivo_manager.isEnabled();
    }

    @Override
    public void setTiVoEnabled(boolean enabled) {
        this.tivo_manager.setEnabled(enabled);
    }

    public TranscodeProvider[] getProviders() {
        TranscodeManager tm = this.ensureInitialised(true);
        if (tm == null) {
            return new TranscodeProvider[0];
        }
        return tm.getProviders();
    }

    @Override
    public DeviceTemplate[] getDeviceTemplates(int device_type) {
        if (this.transcode_manager == null || device_type != 3) {
            return new DeviceTemplate[0];
        }
        TranscodeProvider[] providers = this.transcode_manager.getProviders();
        ArrayList<DeviceMediaRendererTemplateImpl> result = new ArrayList<DeviceMediaRendererTemplateImpl>();
        TranscodeProvider[] transcodeProviderArray = providers;
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            TranscodeProvider provider = transcodeProviderArray[n2];
            TranscodeProfile[] profiles = provider.getProfiles();
            HashMap<String, DeviceMediaRendererTemplateImpl> class_map = new HashMap<String, DeviceMediaRendererTemplateImpl>();
            TranscodeProfile[] transcodeProfileArray = profiles;
            int n3 = profiles.length;
            int n4 = 0;
            while (n4 < n3) {
                TranscodeProfile profile = transcodeProfileArray[n4];
                String classification = profile.getDeviceClassification();
                if (classification.startsWith("apple.")) {
                    classification = "apple.";
                }
                boolean auto = classification.equals("sony.PS3") || classification.equals("microsoft.XBox") || classification.equals("apple.") || classification.equals("nintendo.Wii") || classification.equals("browser.generic");
                DeviceMediaRendererTemplateImpl temp = (DeviceMediaRendererTemplateImpl)class_map.get(classification);
                if (temp == null) {
                    temp = new DeviceMediaRendererTemplateImpl(this, classification, auto);
                    class_map.put(classification, temp);
                    result.add(temp);
                }
                temp.addProfile(profile);
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new DeviceTemplate[result.size()]);
    }

    @Override
    public DeviceManager.DeviceManufacturer[] getDeviceManufacturers(int device_type) {
        DeviceTemplate[] templates = this.getDeviceTemplates(device_type);
        HashMap<String, DeviceManufacturerImpl> map = new HashMap<String, DeviceManufacturerImpl>();
        DeviceTemplate[] deviceTemplateArray = templates;
        int n = templates.length;
        int n2 = 0;
        while (n2 < n) {
            DeviceTemplate template = deviceTemplateArray[n2];
            if (template.getType() == device_type) {
                String man_str = template.getManufacturer();
                DeviceManufacturerImpl man = (DeviceManufacturerImpl)map.get(man_str);
                if (man == null) {
                    man = new DeviceManufacturerImpl(man_str);
                    map.put(man_str, man);
                }
                man.addTemplate(template);
            }
            ++n2;
        }
        return map.values().toArray(new DeviceManager.DeviceManufacturer[map.size()]);
    }

    @Override
    public Device addVirtualDevice(int type, String uid, String classification, String name) throws DeviceManagerException {
        return this.createDevice(type, uid, classification, name, true);
    }

    @Override
    public Device addInetDevice(int type, String uid, String classification, String name, InetAddress address) throws DeviceManagerException {
        Device device = this.createDevice(type, uid, classification, name, false);
        device.setAddress(address);
        return device;
    }

    protected Device createDevice(int device_type, String uid, String classification, String name, boolean manual) throws DeviceManagerException {
        if (device_type == 3) {
            DeviceImpl res = manual ? new DeviceMediaRendererManual(this, uid, classification, true, name) : new DeviceMediaRendererImpl(this, uid, classification, true, name);
            res = this.addDevice(res);
            return res;
        }
        throw new DeviceManagerException("Can't manually create this device type");
    }

    @Override
    public void search(final int millis, final DeviceSearchListener listener) {
        new AEThread2("DM:search", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DeviceManagerImpl deviceManagerImpl = DeviceManagerImpl.this;
                synchronized (deviceManagerImpl) {
                    ++DeviceManagerImpl.this.explicit_search;
                }
                DeviceManagerImpl.this.tivo_manager.search();
                DeviceManagerImpl.this.drive_manager.search();
                AESemaphore sem = new AESemaphore("DM:search");
                DeviceManagerListener dm_listener = new DeviceManagerListener(){

                    @Override
                    public void deviceAdded(Device device) {
                        listener.deviceFound(device);
                    }

                    @Override
                    public void deviceChanged(Device device) {
                    }

                    @Override
                    public void deviceAttentionRequest(Device device) {
                    }

                    @Override
                    public void deviceRemoved(Device device) {
                    }

                    @Override
                    public void deviceManagerLoaded() {
                    }
                };
                try {
                    DeviceManagerImpl.this.addListener(dm_listener);
                    DeviceManagerImpl.this.upnp_manager.search();
                    sem.reserve(millis);
                }
                catch (Throwable throwable) {
                    DeviceManagerImpl deviceManagerImpl2 = DeviceManagerImpl.this;
                    synchronized (deviceManagerImpl2) {
                        --DeviceManagerImpl.this.explicit_search;
                    }
                    DeviceManagerImpl.this.removeListener(dm_listener);
                    listener.complete();
                    throw throwable;
                }
                DeviceManagerImpl deviceManagerImpl3 = DeviceManagerImpl.this;
                synchronized (deviceManagerImpl3) {
                    --DeviceManagerImpl.this.explicit_search;
                }
                DeviceManagerImpl.this.removeListener(dm_listener);
                listener.complete();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DeviceImpl getDevice(String id) {
        DeviceManagerImpl deviceManagerImpl = this;
        synchronized (deviceManagerImpl) {
            return this.device_map.get(id);
        }
    }

    protected DeviceImpl addDevice(DeviceImpl device) {
        return this.addDevice(device, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DeviceImpl addDevice(DeviceImpl device, boolean is_alive) {
        DeviceImpl existing = null;
        DeviceManagerImpl deviceManagerImpl = this;
        synchronized (deviceManagerImpl) {
            DeviceMediaRenderer renderer;
            existing = this.device_map.get(device.getID());
            if (existing != null) {
                existing.updateFrom(device, is_alive);
            } else if (device.getType() == 3 && (renderer = (DeviceMediaRenderer)((Object)device)).getRendererSpecies() == 2 && !renderer.isManual()) {
                for (DeviceImpl d : this.device_list) {
                    DeviceMediaRenderer r;
                    if (d.getType() != 3 || (r = (DeviceMediaRenderer)((Object)d)).getRendererSpecies() != 2 || !r.isManual()) continue;
                    existing = d;
                    this.log("Merging " + device.getString() + " -> " + existing.getString());
                    String secondary_id = device.getID();
                    existing.setSecondaryID(secondary_id);
                    existing.updateFrom(device, is_alive);
                }
            }
            if (existing == null) {
                this.device_list.add(device);
                this.device_map.put(device.getID(), device);
            }
        }
        if (existing != null) {
            this.applyUpdates(existing);
            return existing;
        }
        try {
            this.disable_events.add(device);
            device.initialise();
            if (is_alive) {
                device.alive();
            }
            this.applyUpdates(device);
        }
        finally {
            this.disable_events.remove(device);
        }
        this.deviceAdded(device);
        this.configDirty();
        return device;
    }

    protected void applyUpdates(DeviceImpl device) {
        UPnPDevice upnp_device;
        DeviceMediaRenderer renderer;
        if (device.getType() == 3 && (renderer = (DeviceMediaRenderer)((Object)device)) instanceof DeviceUPnPImpl && (upnp_device = ((DeviceUPnPImpl)((Object)renderer)).getUPnPDevice()) != null) {
            String model_number;
            String lc_manufacturer = this.getOptionalLC(upnp_device.getManufacturer());
            String lc_model = this.getOptionalLC(upnp_device.getModelName());
            String lc_fname = this.getOptionalLC(upnp_device.getFriendlyName());
            if (lc_manufacturer.startsWith("samsung")) {
                device.setPersistentStringProperty("tt_rend_class", "samsung.generic");
                TranscodeProfile[] profiles = device.getTranscodeProfiles();
                if (profiles.length == 0) {
                    device.setTranscodeRequirement(1);
                } else {
                    device.setTranscodeRequirement(2);
                }
            } else if (lc_manufacturer.startsWith("western digital")) {
                device.setPersistentStringProperty("tt_rend_class", "western.digital.generic");
                TranscodeProfile[] profiles = device.getTranscodeProfiles();
                if (profiles.length == 0) {
                    device.setTranscodeRequirement(1);
                } else {
                    device.setTranscodeRequirement(2);
                }
            } else if (lc_manufacturer.startsWith("sony") && lc_fname.startsWith("bravia")) {
                device.setPersistentStringProperty("tt_rend_class", "sony.bravia");
            } else if (lc_model.equals("windows media player") && (model_number = upnp_device.getModelNumber()) != null) {
                try {
                    int num = Integer.parseInt(model_number);
                    if (num >= 12) {
                        device.setPersistentStringProperty("tt_rend_class", "ms_wmp.generic");
                        TranscodeProfile[] profiles = device.getTranscodeProfiles();
                        if (profiles.length == 0) {
                            device.setTranscodeRequirement(1);
                        } else {
                            device.setTranscodeRequirement(2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private String getOptionalLC(String str) {
        if (str == null) {
            return "";
        }
        return str.toLowerCase().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDevice(DeviceImpl device) {
        DeviceManagerImpl deviceManagerImpl = this;
        synchronized (deviceManagerImpl) {
            DeviceImpl existing = this.device_map.remove(device.getID());
            if (existing == null) {
                return;
            }
            this.device_list.remove(device);
            String secondary_id = device.getSecondaryID();
            if (secondary_id != null) {
                this.device_map.remove(secondary_id);
            }
        }
        device.destroy();
        this.deviceRemoved(device);
        this.configDirty();
    }

    @Override
    public boolean isBusy(int device_type) {
        DeviceImpl[] devices;
        if ((device_type == 0 || device_type == 3) && this.getTranscodeManager().getQueue().isTranscoding()) {
            return true;
        }
        DeviceImpl[] deviceImplArray = devices = this.getDevices();
        int n = devices.length;
        int n2 = 0;
        while (n2 < n) {
            DeviceImpl device = deviceImplArray[n2];
            if (device.isBusy() && (device_type == 0 || device_type == device.getType())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceImpl[] getDevices() {
        DeviceManagerImpl deviceManagerImpl = this;
        synchronized (deviceManagerImpl) {
            return this.device_list.toArray(new DeviceImpl[this.device_list.size()]);
        }
    }

    @Override
    public boolean getAutoSearch() {
        return this.auto_search;
    }

    @Override
    public void setAutoSearch(boolean auto) {
        COConfigurationManager.setParameter(AUTO_SEARCH_CONFIG_KEY, auto);
    }

    @Override
    public int getAutoHideOldDevicesDays() {
        return COConfigurationManager.getIntParameter(AUTO_HIDE_OLD_CONFIG_KEY, 31);
    }

    @Override
    public void setAutoHideOldDevicesDays(int days) {
        COConfigurationManager.setParameter(AUTO_HIDE_OLD_CONFIG_KEY, days);
    }

    @Override
    public boolean isRSSPublishEnabled() {
        return COConfigurationManager.getBooleanParameter(RSS_ENABLE_CONFIG_KEY, false);
    }

    @Override
    public void setRSSPublishEnabled(boolean enabled) {
        COConfigurationManager.setParameter(RSS_ENABLE_CONFIG_KEY, enabled);
    }

    @Override
    public String getRSSLink() {
        return this.rss_publisher.getFeedURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isExplicitSearch() {
        DeviceManagerImpl deviceManagerImpl = this;
        synchronized (deviceManagerImpl) {
            return this.explicit_search > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isClosing() {
        DeviceManagerImpl deviceManagerImpl = this;
        synchronized (deviceManagerImpl) {
            return this.closing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadConfig() {
        if (!FileUtil.resilientConfigFileExists(CONFIG_FILE)) {
            return;
        }
        this.log("Loading configuration");
        DeviceManagerImpl deviceManagerImpl = this;
        synchronized (deviceManagerImpl) {
            Map map = FileUtil.readResilientConfigFile(CONFIG_FILE);
            List l_devices = (List)map.get("devices");
            if (l_devices != null) {
                int i = 0;
                while (i < l_devices.size()) {
                    Map m = (Map)l_devices.get(i);
                    try {
                        DeviceImpl device = DeviceImpl.importFromBEncodedMapStatic(this, m);
                        this.device_list.add(device);
                        this.device_map.put(device.getID(), device);
                        String secondary_id = device.getSecondaryID();
                        if (secondary_id != null) {
                            this.device_map.put(secondary_id, device);
                        }
                        device.initialise();
                        this.log("    loaded " + device.getString());
                    }
                    catch (Throwable e) {
                        this.log("Failed to import subscription from " + m, e);
                    }
                    ++i;
                }
            }
        }
    }

    protected void configDirty(DeviceImpl device, boolean save_changes) {
        this.deviceChanged(device, save_changes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configDirty() {
        DeviceManagerImpl deviceManagerImpl = this;
        synchronized (deviceManagerImpl) {
            if (this.config_dirty) {
                return;
            }
            this.config_dirty = true;
            new DelayedEvent("Subscriptions:save", 5000L, new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void runSupport() {
                    DeviceManagerImpl deviceManagerImpl = DeviceManagerImpl.this;
                    synchronized (deviceManagerImpl) {
                        if (!DeviceManagerImpl.this.config_dirty) {
                            return;
                        }
                        DeviceManagerImpl.this.saveConfig();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveConfig() {
        this.log("Saving configuration");
        DeviceManagerImpl deviceManagerImpl = this;
        synchronized (deviceManagerImpl) {
            if (this.closing) {
                return;
            }
            this.config_dirty = false;
            this.config_unclean = false;
            if (this.device_list.size() == 0) {
                FileUtil.deleteResilientConfigFile(CONFIG_FILE);
            } else {
                HashMap map = new HashMap();
                ArrayList l_devices = new ArrayList();
                map.put("devices", l_devices);
                for (DeviceImpl device : this.device_list) {
                    try {
                        HashMap d = new HashMap();
                        device.exportToBEncodedMap(d, false);
                        l_devices.add(d);
                    }
                    catch (Throwable e) {
                        this.log("Failed to save device " + device.getString(), e);
                    }
                }
                FileUtil.writeResilientConfigFile(CONFIG_FILE, map);
            }
        }
    }

    protected void deviceAdded(DeviceImpl device) {
        this.configDirty();
        this.listeners.dispatch(1, device);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deviceChanged(DeviceImpl device, boolean save_changes) {
        if (save_changes) {
            this.configDirty();
        } else {
            DeviceManagerImpl deviceManagerImpl = this;
            synchronized (deviceManagerImpl) {
                this.config_unclean = true;
            }
        }
        if (!this.disable_events.contains(device)) {
            this.listeners.dispatch(2, device);
        }
    }

    protected void deviceRemoved(DeviceImpl device) {
        this.configDirty();
        this.listeners.dispatch(4, device);
    }

    protected void requestAttention(DeviceImpl device) {
        this.listeners.dispatch(3, device);
    }

    protected URL getStreamURL(TranscodeFileImpl file, String host) {
        IPCInterface ipc = this.upnp_manager.getUPnPAVIPC();
        if (ipc != null) {
            try {
                DiskManagerFileInfo f = file.getTargetFile();
                String str = (String)ipc.invoke("getContentURL", new Object[]{f});
                if (str != null && str.length() > 0) {
                    if (host != null) {
                        str = str.replace("127.0.0.1", host);
                    }
                    return new URL(str);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    protected String getMimeType(TranscodeFileImpl file) {
        if (this.getMimeType_fails > 5) {
            return null;
        }
        IPCInterface ipc = this.upnp_manager.getUPnPAVIPC();
        if (ipc != null) {
            try {
                DiskManagerFileInfo f = file.getTargetFile();
                String[] strs = (String[])ipc.invoke("getMimeTypes", new Object[]{f});
                if (strs != null && strs.length > 0) {
                    return strs[0];
                }
            }
            catch (Throwable e) {
                ++this.getMimeType_fails;
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public File getDefaultWorkingDirectory() {
        return this.getDefaultWorkingDirectory(false);
    }

    public File getDefaultWorkingDirectory(boolean persist) {
        String def = COConfigurationManager.getStringParameter(CONFIG_DEFAULT_WORK_DIR).trim();
        File f = new File(def);
        if (!f.exists() && persist) {
            f.mkdirs();
        }
        return f;
    }

    @Override
    public void setDefaultWorkingDirectory(File dir) {
        File existing = this.getDefaultWorkingDirectory(false);
        if (!existing.getAbsolutePath().equals(dir.getAbsolutePath())) {
            DeviceImpl[] devices;
            DeviceImpl[] deviceImplArray = devices = this.getDevices();
            int n = devices.length;
            int n2 = 0;
            while (n2 < n) {
                DeviceImpl device = deviceImplArray[n2];
                device.resetWorkingDirectory();
                ++n2;
            }
        }
        COConfigurationManager.setParameter(CONFIG_DEFAULT_WORK_DIR, dir.getAbsolutePath());
    }

    @Override
    public boolean getDisableSleep() {
        return COConfigurationManager.getBooleanParameter(CONFIG_DISABLE_SLEEP, true);
    }

    @Override
    public void setDisableSleep(boolean b) {
        COConfigurationManager.setParameter(CONFIG_DISABLE_SLEEP, b);
    }

    @Override
    public TranscodeManagerImpl getTranscodeManager() {
        if (this.transcode_manager == null) {
            this.ensureInitialised(false);
        }
        return this.transcode_manager;
    }

    @Override
    public boolean isTranscodeManagerInitialized() {
        return this.transcode_manager != null;
    }

    @Override
    public DeviceManager.UnassociatedDevice[] getUnassociatedDevices() {
        return this.upnp_manager.getUnassociatedDevices();
    }

    @Override
    public String getPowerName() {
        return "Transcode";
    }

    @Override
    public boolean requestPowerStateChange(int new_state, Object data) {
        return !this.getDisableSleep() || !this.getTranscodeManager().getQueue().isTranscoding();
    }

    @Override
    public void informPowerStateChange(int new_state, Object data) {
    }

    @Override
    public void addListener(DeviceManagerListener listener) {
        this.listeners.addListener(listener);
        if (this.initialized) {
            this.listeners.dispatch(listener, 5, null);
        }
    }

    protected boolean browseReceived(TrackerWebPageRequest request2, Map<String, Object> browser_args) {
        for (DeviceManagerDiscoveryListener l : this.discovery_listeners) {
            try {
                if (!l.browseReceived(request2, browser_args)) continue;
                return true;
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        return false;
    }

    protected VuzeFile exportVuzeFile(DeviceImpl device) throws IOException {
        VuzeFile vf = VuzeFileHandler.getSingleton().create();
        HashMap map = new HashMap();
        HashMap device_map = new HashMap();
        map.put("device", device_map);
        device.exportToBEncodedMap(device_map, true);
        vf.addComponent(512, map);
        return vf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void importVuzeFile(Map map, boolean warn_user) {
        Map m = (Map)map.get("device");
        try {
            UIManager ui_manager;
            DeviceImpl existing;
            DeviceImpl device = DeviceImpl.importFromBEncodedMapStatic(this, m);
            DeviceManagerImpl deviceManagerImpl = this;
            synchronized (deviceManagerImpl) {
                existing = this.device_map.get(device.getID());
            }
            if (existing == null) {
                if (warn_user) {
                    ui_manager = StaticUtilities.getUIManager(120000L);
                    String details = MessageText.getString("device.import.desc", new String[]{device.getName()});
                    long res = ui_manager.showMessageBox("device.import.title", "!" + details + "!", 12L);
                    if (res != 4L) {
                        return;
                    }
                }
                this.addDevice(device, false);
            } else if (warn_user) {
                ui_manager = StaticUtilities.getUIManager(120000L);
                String details = MessageText.getString("device.import.dup.desc", new String[]{existing.getName()});
                ui_manager.showMessageBox("device.import.dup.title", "!" + details + "!", 1L);
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    @Override
    public void addDiscoveryListener(DeviceManagerDiscoveryListener listener) {
        this.discovery_listeners.add(listener);
    }

    @Override
    public void removeDiscoveryListener(DeviceManagerDiscoveryListener listener) {
        this.discovery_listeners.remove(listener);
    }

    @Override
    public void removeListener(DeviceManagerListener listener) {
        this.listeners.removeListener(listener);
    }

    @Override
    public Device findDevice(UPnPDevice upnpDevice) {
        DeviceImpl[] devices;
        DeviceImpl[] deviceImplArray = devices = this.getDevices();
        int n = devices.length;
        int n2 = 0;
        while (n2 < n) {
            DeviceUPnPImpl deviceUPnP;
            UPnPDevice uPnPDevice2;
            DeviceImpl device = deviceImplArray[n2];
            if (device instanceof DeviceUPnPImpl && upnpDevice.equals(uPnPDevice2 = (deviceUPnP = (DeviceUPnPImpl)device).getUPnPDevice())) {
                return device;
            }
            ++n2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AEDiagnosticsLogger getLogger() {
        Object object = this.logger_lock;
        synchronized (object) {
            if (this.logger == null) {
                this.logger = AEDiagnostics.getLogger(LOGGER_NAME);
            }
            return this.logger;
        }
    }

    public void log(String s, Throwable e) {
        AEDiagnosticsLogger diag_logger = this.getLogger();
        diag_logger.log(s);
        diag_logger.log(e);
    }

    public void log(String s) {
        AEDiagnosticsLogger diag_logger = this.getLogger();
        diag_logger.log(s);
    }

    @Override
    public void generate(IndentWriter writer) {
        writer.println(LOGGER_NAME);
        try {
            DeviceImpl[] devices;
            writer.indent();
            DeviceImpl[] deviceImplArray = devices = this.getDevices();
            int n = devices.length;
            int n2 = 0;
            while (n2 < n) {
                DeviceImpl device = deviceImplArray[n2];
                device.generate(writer);
                ++n2;
            }
            if (this.transcode_manager != null) {
                this.transcode_manager.generate(writer);
            }
        }
        finally {
            writer.exdent();
        }
    }

    protected static class DeviceManufacturerImpl
    implements DeviceManager.DeviceManufacturer {
        private String name;
        private List<DeviceTemplate> templates = new ArrayList<DeviceTemplate>();

        protected DeviceManufacturerImpl(String _name) {
            this.name = _name;
        }

        protected void addTemplate(DeviceTemplate t) {
            this.templates.add(t);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public DeviceTemplate[] getDeviceTemplates() {
            return this.templates.toArray(new DeviceTemplate[this.templates.size()]);
        }
    }
}

