/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.devices;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.devices.DeviceManager;
import com.biglybt.core.util.Debug;

public class DeviceManagerFactory {
    private static final Class<DeviceManager> impl_class;
    private static DeviceManager singleton;

    static {
        String impl = System.getProperty("az.factory.devicemanager.impl", "com.biglybt.core.devices.impl.DeviceManagerImpl");
        Class<?> temp = null;
        if (impl.length() > 0) {
            try {
                temp = DeviceManagerFactory.class.getClassLoader().loadClass(impl);
            }
            catch (Throwable e) {
                Debug.out("Failed to load DeviceManagerFactory class: " + impl);
            }
        }
        impl_class = temp;
    }

    public static void preInitialise() {
        if (impl_class != null) {
            try {
                impl_class.getMethod("preInitialise", new Class[0]).invoke(null, null);
            }
            catch (Throwable e) {
                Debug.out("preInitialise failed", e);
            }
        }
    }

    public static DeviceManager getSingleton() {
        Class<DeviceManagerFactory> clazz = DeviceManagerFactory.class;
        synchronized (DeviceManagerFactory.class) {
            block8: {
                if (singleton != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return singleton;
                }
                if (impl_class == null) {
                    throw new RuntimeException("No Implementation");
                }
                boolean isAZ3 = COConfigurationManager.getStringParameter("ui").equals("az3");
                if (isAZ3) break block8;
                Debug.out("DeviceManager is only fully functional with BiglyBT (not classic) UI - some features unavailable");
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
            try {
                singleton = (DeviceManager)impl_class.getMethod("getSingleton", new Class[0]).invoke(null, null);
                // ** MonitorExit[var0] (shouldn't be in output)
                return singleton;
            }
            catch (Throwable e) {
                throw new RuntimeException("No Implementation", e);
            }
        }
    }
}

