/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.category.impl;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.category.Category;
import com.biglybt.core.category.CategoryListener;
import com.biglybt.core.category.CategoryManagerListener;
import com.biglybt.core.category.impl.CategoryImpl;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagException;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.TagType;
import com.biglybt.core.tag.impl.TagTypeBase;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.ListenerManager;
import com.biglybt.core.util.ListenerManagerDispatcher;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.core.xml.util.XMLEscapeWriter;
import com.biglybt.core.xml.util.XUXmlWriter;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadScrapeResult;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pif.tracker.web.TrackerWebPageRequest;
import com.biglybt.pif.tracker.web.TrackerWebPageResponse;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.plugin.rssgen.RSSGeneratorPlugin;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

public class CategoryManagerImpl
extends TagTypeBase
implements RSSGeneratorPlugin.Provider,
CategoryListener {
    private static final int[] color_default = new int[]{189, 178, 57};
    private static final String PROVIDER = "categories";
    private static final String UNCAT_NAME = "__uncategorised__";
    private static final String ALL_NAME = "__all__";
    private static CategoryManagerImpl catMan;
    private static final AEMonitor class_mon;
    private CategoryImpl catAll = null;
    private CategoryImpl catUncategorized = null;
    private boolean doneLoading = false;
    private final Map<String, CategoryImpl> categories = new HashMap<String, CategoryImpl>();
    private final AEMonitor categories_mon = new AEMonitor("Categories");
    private final AtomicInteger dms_with_cats = new AtomicInteger();
    private static final int LDT_CATEGORY_ADDED = 1;
    private static final int LDT_CATEGORY_REMOVED = 2;
    private static final int LDT_CATEGORY_CHANGED = 3;
    private final ListenerManager category_listeners = ListenerManager.createManager("CatListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object _listener, int type, Object value) {
            CategoryManagerListener target = (CategoryManagerListener)_listener;
            if (type == 1) {
                target.categoryAdded((Category)value);
            } else if (type == 2) {
                target.categoryRemoved((Category)value);
            } else if (type == 3) {
                target.categoryChanged((Category)value);
            }
        }
    });

    static {
        class_mon = new AEMonitor("CategoryManager:class");
    }

    private CategoryManagerImpl() {
        super(1, 511, "Category");
        this.addTagType();
        this.loadCategories();
    }

    public void addCategoryManagerListener(CategoryManagerListener l) {
        this.category_listeners.addListener(l);
    }

    public void removeCategoryManagerListener(CategoryManagerListener l) {
        this.category_listeners.removeListener(l);
    }

    public static CategoryManagerImpl getInstance() {
        try {
            class_mon.enter();
            if (catMan == null) {
                catMan = new CategoryManagerImpl();
            }
            CategoryManagerImpl categoryManagerImpl = catMan;
            return categoryManagerImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    protected void loadCategories() {
        if (this.doneLoading) {
            return;
        }
        this.doneLoading = true;
        FileInputStream fin = null;
        BufferedInputStream bin = null;
        this.makeSpecialCategories();
        try {
            try {
                File configFile = FileUtil.getUserFile("categories.config");
                fin = FileUtil.newFileInputStream(configFile);
                bin = new BufferedInputStream(fin, 8192);
                Map<String, Object> map = BDecoder.decode(bin);
                List catList = (List)map.get(PROVIDER);
                int i = 0;
                while (i < catList.size()) {
                    Map mCategory = (Map)catList.get(i);
                    String catName = new String((byte[])mCategory.get("name"), Constants.DEFAULT_ENCODING_CHARSET);
                    Long l_maxup = (Long)mCategory.get("maxup");
                    Long l_maxdown = (Long)mCategory.get("maxdown");
                    HashMap<String, String> attributes = BDecoder.decodeStrings((Map)mCategory.get("attr"));
                    if (attributes == null) {
                        attributes = new HashMap<String, String>();
                    }
                    if (catName.equals(UNCAT_NAME)) {
                        this.catUncategorized.setUploadSpeed(l_maxup == null ? 0 : l_maxup.intValue());
                        this.catUncategorized.setDownloadSpeed(l_maxdown == null ? 0 : l_maxdown.intValue());
                        this.catUncategorized.setAttributes(attributes);
                    } else if (catName.equals(ALL_NAME)) {
                        this.catAll.setAttributes(attributes);
                    } else {
                        CategoryImpl cat = new CategoryImpl(this, catName, l_maxup == null ? 0 : l_maxup.intValue(), l_maxdown == null ? 0 : l_maxdown.intValue(), attributes);
                        cat.addCategoryListener(this);
                        this.categories.put(catName, cat);
                    }
                    ++i;
                }
            }
            catch (FileNotFoundException configFile) {
                try {
                    if (bin != null) {
                        bin.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (fin != null) {
                        fin.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.checkConfig();
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
                try {
                    if (bin != null) {
                        bin.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (fin != null) {
                        fin.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.checkConfig();
            }
        }
        finally {
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception exception) {}
            this.checkConfig();
        }
    }

    protected void saveCategories(Category category) {
        this.saveCategories();
        this.category_listeners.dispatch(3, category);
    }

    protected void saveCategories() {
        try {
            this.categories_mon.enter();
            HashMap map = new HashMap();
            ArrayList list = new ArrayList(this.categories.size());
            for (CategoryImpl cat : this.categories.values()) {
                if (cat.getType() != 0) continue;
                HashMap<String, Object> catMap = new HashMap<String, Object>();
                catMap.put("name", cat.getName());
                catMap.put("maxup", new Long(cat.getUploadSpeed()));
                catMap.put("maxdown", new Long(cat.getDownloadSpeed()));
                catMap.put("attr", cat.getAttributes());
                list.add(catMap);
            }
            HashMap<String, Object> uncat = new HashMap<String, Object>();
            uncat.put("name", UNCAT_NAME);
            uncat.put("maxup", new Long(this.catUncategorized.getUploadSpeed()));
            uncat.put("maxdown", new Long(this.catUncategorized.getDownloadSpeed()));
            uncat.put("attr", this.catUncategorized.getAttributes());
            list.add(uncat);
            HashMap<String, Object> allcat = new HashMap<String, Object>();
            allcat.put("name", ALL_NAME);
            allcat.put("attr", this.catAll.getAttributes());
            list.add(allcat);
            map.put(PROVIDER, list);
            FileOutputStream fos = null;
            try {
                try {
                    byte[] torrentData = BEncoder.encode(map);
                    File oldFile = FileUtil.getUserFile("categories.config");
                    File newFile = FileUtil.getUserFile("categories.config.new");
                    fos = FileUtil.newFileOutputStream(newFile);
                    fos.write(torrentData);
                    fos.flush();
                    fos.getFD().sync();
                    fos.close();
                    fos = null;
                    if (!oldFile.exists() || oldFile.delete()) {
                        newFile.renameTo(oldFile);
                    }
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            this.checkConfig();
            this.categories_mon.exit();
        }
    }

    public Category createCategory(String name) {
        this.makeSpecialCategories();
        CategoryImpl newCategory = this.getCategory(name);
        if (newCategory == null) {
            newCategory = new CategoryImpl(this, name, 0, 0, new HashMap<String, String>());
            newCategory.addCategoryListener(this);
            this.categories.put(name, newCategory);
            this.saveCategories();
            this.category_listeners.dispatch(1, newCategory);
            return this.categories.get(name);
        }
        return newCategory;
    }

    public void removeCategory(Category category) {
        if (this.categories.containsKey(category.getName())) {
            CategoryImpl old = this.categories.remove(category.getName());
            this.saveCategories();
            this.category_listeners.dispatch(2, category);
            if (old != null) {
                old.destroy();
            }
        }
    }

    public Category[] getCategories() {
        if (this.categories.size() > 0) {
            return this.categories.values().toArray(new Category[this.categories.size()]);
        }
        return new Category[0];
    }

    public CategoryImpl getCategory(String name) {
        return this.categories.get(name);
    }

    public Category getCategory(int type) {
        if (type == 1) {
            return this.catAll;
        }
        if (type == 2) {
            return this.catUncategorized;
        }
        return null;
    }

    private void makeSpecialCategories() {
        if (this.catAll == null) {
            this.catAll = new CategoryImpl(this, "Categories.all", 1, new HashMap<String, String>());
            this.categories.put("Categories.all", this.catAll);
        }
        if (this.catUncategorized == null) {
            this.catUncategorized = new CategoryImpl(this, "Categories.uncategorized", 2, new HashMap<String, String>());
            this.categories.put("Categories.uncategorized", this.catUncategorized);
        }
    }

    @Override
    public void downloadManagerAdded(Category cat, DownloadManager manager) {
        this.dms_with_cats.incrementAndGet();
    }

    @Override
    public void downloadManagerRemoved(Category cat, DownloadManager manager) {
        this.dms_with_cats.decrementAndGet();
    }

    public int getCategorisedDownloadCount() {
        int num = this.dms_with_cats.get();
        if (num < 0) {
            num = 0;
        }
        return num;
    }

    @Override
    public int[] getColorDefault() {
        return color_default;
    }

    @Override
    public int getTagCount() {
        return this.categories.size();
    }

    @Override
    public List<Tag> getTags() {
        return new ArrayList<Tag>(this.categories.values());
    }

    @Override
    public Tag createTag(String name, boolean auto_add) throws TagException {
        if (!auto_add) {
            throw new TagException("Not supported - must be auto-add");
        }
        Category cat = this.getCategory(name);
        if (cat == null) {
            cat = this.createCategory(name);
        }
        return cat;
    }

    @Override
    protected void sync() {
        super.sync();
    }

    private void checkConfig() {
        boolean gen_enabled = false;
        for (CategoryImpl cat : this.categories.values()) {
            if (!cat.getBooleanAttribute("at_rss_gen")) continue;
            gen_enabled = true;
            break;
        }
        if (gen_enabled) {
            RSSGeneratorPlugin.registerProvider(PROVIDER, this);
        } else {
            RSSGeneratorPlugin.unregisterProvider(PROVIDER);
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean generate(TrackerWebPageRequest request2, TrackerWebPageResponse response) throws IOException {
        URL url = request2.getAbsoluteURL();
        String path = url.getPath();
        int pos = path.indexOf(63);
        if (pos != -1) {
            path = path.substring(0, pos);
        }
        path = path.substring(PROVIDER.length() + 1);
        XMLEscapeWriter pw = new XMLEscapeWriter(new PrintWriter(new OutputStreamWriter(response.getOutputStream(), "UTF-8")));
        pw.setEnabled(false);
        if (path.length() <= 1) {
            ArrayList<CategoryImpl> cats;
            response.setContentType("text/html; charset=UTF-8");
            pw.println("<HTML><HEAD><TITLE>" + Constants.APP_NAME + " Category Feeds</TITLE></HEAD><BODY>");
            TreeMap<String, String> lines = new TreeMap<String, String>();
            try {
                this.categories_mon.enter();
                cats = new ArrayList<CategoryImpl>(this.categories.values());
            }
            finally {
                this.categories_mon.exit();
            }
            for (CategoryImpl c : cats) {
                if (!c.getBooleanAttribute("at_rss_gen")) continue;
                String name = this.getDisplayName(c);
                String cat_url = "categories/" + URLEncoder.encode(c.getName(), "UTF-8");
                lines.put(name, "<LI><A href=\"" + cat_url + "\">" + name + "</A></LI>");
            }
            for (String line : lines.values()) {
                pw.println(line);
            }
            pw.println("</BODY></HTML>");
        } else {
            CategoryImpl cat;
            String cat_name = URLDecoder.decode(path.substring(1), "UTF-8");
            try {
                this.categories_mon.enter();
                cat = this.categories.get(cat_name);
            }
            finally {
                this.categories_mon.exit();
            }
            if (cat == null) {
                response.setReplyStatus(404);
                return true;
            }
            List<DownloadManager> dms = cat.getDownloadManagers(CoreFactory.getSingleton().getGlobalManager().getDownloadManagers());
            ArrayList<Download> downloads = new ArrayList<Download>(dms.size());
            long dl_marker = 0L;
            for (DownloadManager dm : dms) {
                TOTorrent torrent = dm.getTorrent();
                if (torrent == null || TorrentUtils.isReallyPrivate(torrent)) continue;
                dl_marker += dm.getDownloadState().getLongParameter("stats.download.added.time");
                downloads.add(PluginCoreUtils.wrap(dm));
            }
            String config_key = "cat.rss.config." + Base32.encode(cat.getName().getBytes("UTF-8"));
            long old_marker = COConfigurationManager.getLongParameter(String.valueOf(config_key) + ".marker", 0L);
            long last_modified = COConfigurationManager.getLongParameter(String.valueOf(config_key) + ".last_mod", 0L);
            long now = SystemTime.getCurrentTime();
            if (old_marker == dl_marker) {
                if (last_modified == 0L) {
                    last_modified = now;
                }
            } else {
                COConfigurationManager.setParameter(String.valueOf(config_key) + ".marker", dl_marker);
                last_modified = now;
            }
            if (last_modified == now) {
                COConfigurationManager.setParameter(String.valueOf(config_key) + ".last_mod", last_modified);
            }
            response.setContentType("application/xml; charset=UTF-8");
            pw.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            pw.println("<rss version=\"2.0\" xmlns:vuze=\"http://www.vuze.com\">");
            pw.println("<channel>");
            pw.println("<title>" + this.escape(this.getDisplayName(cat)) + "</title>");
            Collections.sort(downloads, new Comparator<Download>(){

                @Override
                public int compare(Download d1, Download d2) {
                    long added1 = CategoryManagerImpl.this.getAddedTime(d1) / 1000L;
                    long added2 = CategoryManagerImpl.this.getAddedTime(d2) / 1000L;
                    return (int)(added2 - added1);
                }
            });
            pw.println("<pubDate>" + TimeFormatter.getHTTPDate(last_modified) + "</pubDate>");
            int i = 0;
            while (i < downloads.size()) {
                String dl_cat;
                Download download = (Download)downloads.get(i);
                DownloadManager core_download = PluginCoreUtils.unwrap(download);
                Torrent torrent = download.getTorrent();
                byte[] hash = torrent.getHash();
                String hash_str = Base32.encode(hash);
                pw.println("<item>");
                pw.println("<title>" + this.escape(download.getName()) + "</title>");
                pw.println("<guid>" + hash_str + "</guid>");
                String magnet_url = this.escape(UrlUtils.getMagnetURI(download));
                pw.println("<link>" + magnet_url + "</link>");
                long added = core_download.getDownloadState().getLongParameter("stats.download.added.time");
                pw.println("<pubDate>" + TimeFormatter.getHTTPDate(added) + "</pubDate>");
                pw.println("<vuze:size>" + torrent.getSize() + "</vuze:size>");
                pw.println("<vuze:assethash>" + hash_str + "</vuze:assethash>");
                pw.println("<vuze:downloadurl>" + magnet_url + "</vuze:downloadurl>");
                DownloadScrapeResult scrape = download.getLastScrapeResult();
                if (scrape != null && scrape.getResponseType() == 1) {
                    pw.println("<vuze:seeds>" + scrape.getSeedCount() + "</vuze:seeds>");
                    pw.println("<vuze:peers>" + scrape.getNonSeedCount() + "</vuze:peers>");
                }
                if ((dl_cat = download.getCategoryName()) != null && dl_cat.length() > 0 && !dl_cat.equalsIgnoreCase("Categories.uncategorized")) {
                    pw.println("<category>" + this.escape(dl_cat) + "</category>");
                }
                List<Tag> dl_tags = TagManagerFactory.getTagManager().getTagsForTaggable(core_download);
                for (Tag dl_tag : dl_tags) {
                    boolean[] autos;
                    TagType tt = dl_tag.getTagType();
                    if (tt.isTagTypeAuto() || tt.getTagType() != 3 || (autos = dl_tag.isTagAuto())[0] || autos[1]) continue;
                    pw.println("<tag>" + this.escape(dl_tag.getTagName(true)) + "</tag>");
                }
                pw.println("</item>");
                ++i;
            }
            pw.println("</channel>");
            pw.println("</rss>");
        }
        pw.flush();
        return true;
    }

    private String getDisplayName(CategoryImpl c) {
        if (c == this.catAll) {
            return MessageText.getString("Categories.all");
        }
        if (c == this.catUncategorized) {
            return MessageText.getString("Categories.uncategorized");
        }
        return c.getName();
    }

    protected long getAddedTime(Download download) {
        DownloadManager core_download = PluginCoreUtils.unwrap(download);
        return core_download.getDownloadState().getLongParameter("stats.download.added.time");
    }

    protected String escape(String str) {
        return XUXmlWriter.escapeXML(str);
    }
}

