/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core;

import com.biglybt.core.CoreOperation;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.util.FileUtil;

public interface CoreOperationTask {
    public String getName();

    public DownloadManager getDownload();

    default public String[] getAffectedFileSystems() {
        DownloadManager dm = this.getDownload();
        if (dm != null) {
            return FileUtil.getFileStoreNames(dm.getAbsoluteSaveLocation());
        }
        return null;
    }

    default public void run(CoreOperation operation) {
    }

    public ProgressCallback getProgressCallback();

    public static interface ProgressCallback
    extends Comparable<ProgressCallback> {
        public static final int ST_NONE = 0;
        public static final int ST_PAUSE = 1;
        public static final int ST_RESUME = 2;
        public static final int ST_CANCEL = 4;
        public static final int ST_SUBTASKS = 8;
        public static final int ST_QUEUED = 16;
        public static final int ST_MINIMIZE = 32;
        public static final int ST_BUTTONS = 7;
        public static final int STYLE_NONE = 0;
        public static final int STYLE_NO_CLOSE = 1;
        public static final int STYLE_MODAL = 2;
        public static final int STYLE_MINIMIZE = 4;

        default public int getStyle() {
            return 0;
        }

        public int getProgress();

        default public void setProgress(int thousandths) {
        }

        public long getSize();

        public void setSize(long var1);

        public String getSubTaskName();

        default public void setSubTaskName(String name) {
        }

        default public int getDelay() {
            return 0;
        }

        public boolean isAutoPause();

        public void setAutoPause(boolean var1);

        public int getOrder();

        public void setOrder(int var1);

        public int getSupportedTaskStates();

        public int getTaskState();

        public void setTaskState(int var1);
    }

    public static class ProgressCallbackAdapter
    implements ProgressCallback {
        private volatile int thousandths;
        private volatile long size;
        private volatile int state = 0;
        private volatile String subtask;
        private volatile boolean auto_pause;
        private volatile int order;

        @Override
        public int getProgress() {
            return this.thousandths;
        }

        @Override
        public void setProgress(int _thousandths) {
            this.thousandths = _thousandths;
        }

        @Override
        public long getSize() {
            return this.size;
        }

        @Override
        public void setSize(long _size) {
            this.size = _size;
        }

        @Override
        public String getSubTaskName() {
            return this.subtask;
        }

        @Override
        public void setSubTaskName(String name) {
            this.subtask = name;
        }

        @Override
        public boolean isAutoPause() {
            return this.auto_pause;
        }

        @Override
        public void setAutoPause(boolean b) {
            this.auto_pause = b;
        }

        @Override
        public int getOrder() {
            return this.order;
        }

        @Override
        public void setOrder(int _order) {
            this.order = _order;
        }

        @Override
        public int getSupportedTaskStates() {
            return this.state;
        }

        @Override
        public void setTaskState(int _state) {
            if (_state == 2) {
                _state = 0;
            }
            this.state = _state;
        }

        @Override
        public int getTaskState() {
            return this.state;
        }

        @Override
        public int compareTo(ProgressCallback o) {
            long l = this.getSize() - o.getSize();
            if (l < 0L) {
                return -1;
            }
            if (l > 0L) {
                return 1;
            }
            return 0;
        }
    }
}

