/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.util;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GlobMatcher {
    public final String globPattern;
    public final Matcher matcher;

    public GlobMatcher(String string) throws PatternSyntaxException {
        this.globPattern = string;
        Pattern pattern = Pattern.compile(GlobMatcher.globToRegexp(string));
        this.matcher = pattern.matcher("dummy");
    }

    private static final String globToRegexp(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '*': {
                    stringBuilder.append(".*");
                    continue block7;
                }
                case '?': {
                    stringBuilder.append('.');
                    continue block7;
                }
                case '[': {
                    int n2 = GlobMatcher.findClosingSquareBracket(string, i);
                    if (n2 <= i + 1) {
                        stringBuilder.append("\\[");
                        continue block7;
                    }
                    stringBuilder.append(string.substring(i, n2 + 1));
                    i = n2;
                    continue block7;
                }
                case '{': {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    int n3 = GlobMatcher.splitCurlyBraceGroup(string, i, arrayList);
                    int n4 = arrayList.size();
                    if (n3 <= i + 1 || n4 == 0) {
                        stringBuilder.append("\\{");
                        continue block7;
                    }
                    if (n4 == 1) {
                        stringBuilder.append('(');
                        stringBuilder.append(GlobMatcher.globToRegexp(arrayList.get(0)));
                        stringBuilder.append(')');
                    } else {
                        stringBuilder.append('(');
                        for (int j = 0; j < n4; ++j) {
                            if (j > 0) {
                                stringBuilder.append('|');
                            }
                            stringBuilder.append('(');
                            stringBuilder.append(GlobMatcher.globToRegexp(arrayList.get(j)));
                            stringBuilder.append(')');
                        }
                        stringBuilder.append(')');
                    }
                    i = n3;
                    continue block7;
                }
                case '\\': {
                    stringBuilder.append(c);
                    if (i + 1 >= n) continue block7;
                    stringBuilder.append(string.charAt(++i));
                    continue block7;
                }
                default: {
                    if (!Character.isLetterOrDigit(c)) {
                        stringBuilder.append('\\');
                    }
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    private static int findClosingSquareBracket(String string, int n) {
        int n2 = 0;
        char c = '\u0000';
        int n3 = string.length();
        for (int i = n; i < n3; ++i) {
            char c2 = string.charAt(i);
            switch (c2) {
                case '[': {
                    if (c == '\\') break;
                    ++n2;
                    break;
                }
                case ']': {
                    if (c != '\\' && i != n + 1) {
                        --n2;
                    }
                    if (n2 != 0) break;
                    return i;
                }
            }
            c = c2;
        }
        return -1;
    }

    private static int splitCurlyBraceGroup(String string, int n, ArrayList<String> arrayList) {
        int n2 = n;
        int n3 = 0;
        char c = '\u0000';
        int n4 = string.length();
        for (int i = n; i < n4; ++i) {
            char c2 = string.charAt(i);
            switch (c2) {
                case '{': {
                    if (c == '\\') break;
                    ++n3;
                    break;
                }
                case '}': {
                    if (c != '\\') {
                        --n3;
                    }
                    if (n3 != 0) break;
                    String string2 = string.substring(n2 + 1, i);
                    if (string2.length() > 0) {
                        arrayList.add(string2);
                    }
                    return i;
                }
                case ',': {
                    if (n3 != true) break;
                    String string2 = string.substring(n2 + 1, i);
                    if (string2.length() > 0) {
                        arrayList.add(string2);
                    }
                    n2 = i;
                }
            }
            c = c2;
        }
        return -1;
    }

    public boolean matches(String string) {
        this.matcher.reset(string);
        return this.matcher.matches();
    }

    public static GlobMatcher create(String string) {
        GlobMatcher globMatcher = null;
        try {
            globMatcher = new GlobMatcher(string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return globMatcher;
    }

    public static boolean containsGlobChar(String string, boolean bl) {
        int n = string.length();
        block4: for (int i = 0; i < n; ++i) {
            switch (string.charAt(i)) {
                case '*': 
                case '?': 
                case '[': 
                case '{': {
                    return true;
                }
                case '~': {
                    if (!bl) continue block4;
                    return true;
                }
            }
        }
        return false;
    }
}

