/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.op;

import com.qizx.api.EvaluationException;
import com.qizx.xquery.BaseValue;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.ExprDisplay;
import com.qizx.xquery.Focus;
import com.qizx.xquery.ModuleContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.impl.EmptyException;
import com.qizx.xquery.op.Comparison;
import com.qizx.xquery.op.Expression;
import com.qizx.xquery.op.ValueEqOp;
import com.qizx.xquery.op.ValueNeOp;

public abstract class ValueComparison
extends Comparison {
    public ValueComparison(Expression expression, Expression expression2) {
        super(expression, expression2);
    }

    public Expression staticCheck(ModuleContext moduleContext, int n) {
        this.operands[0] = moduleContext.staticCheck(this.operands[0], 0);
        this.operands[1] = moduleContext.staticCheck(this.operands[1], 0);
        XQItemType xQItemType = this.operands[0].getType().itemType();
        XQItemType xQItemType2 = this.operands[1].getType().itemType();
        Comparison.Exec exec = null;
        switch (ValueComparison.combinedTypes(xQItemType, xQItemType2)) {
            case 17: {
                exec = new ExecInt();
                break;
            }
            case 20: 
            case 65: 
            case 68: {
                exec = new ExecDouble();
                break;
            }
            default: {
                exec = new ExecAny();
            }
        }
        exec.test = this.getTest();
        return this.transfer(exec, this.operands);
    }

    public static class ExecAny
    extends Comparison.Exec {
        public void dump(ExprDisplay exprDisplay) {
            exprDisplay.header(this);
            exprDisplay.property("test", this.test.getName());
            exprDisplay.child("left", this.args[0]);
            exprDisplay.child("right", this.args[1]);
        }

        public boolean evalAsBoolean(Focus focus, EvalContext evalContext) throws EvaluationException {
            int n;
            XQItem xQItem = this.args[0].evalAsOptItem(focus, evalContext);
            XQItem xQItem2 = this.args[1].evalAsOptItem(focus, evalContext);
            if (xQItem == null || xQItem2 == null) {
                throw EmptyException.instance();
            }
            evalContext.at(this);
            int n2 = 2;
            if (this.test != ValueEqOp.TEST && this.test != ValueNeOp.TEST) {
                ++n2;
            }
            if (Math.abs(n = xQItem.compareTo(xQItem2, evalContext, n2)) == 2) {
                evalContext.error("XPTY0004", (Expression)this, "values are not comparable");
            }
            return this.test.make(n);
        }
    }

    public static class ExecDouble
    extends Comparison.Exec {
        public void dump(ExprDisplay exprDisplay) {
            exprDisplay.header(this);
            exprDisplay.property("test", this.test.getName());
            exprDisplay.child("left", this.args[0]);
            exprDisplay.child("right", this.args[1]);
        }

        public boolean evalAsBoolean(Focus focus, EvalContext evalContext) throws EvaluationException {
            double d = this.args[0].evalAsOptDouble(focus, evalContext);
            double d2 = this.args[1].evalAsOptDouble(focus, evalContext);
            evalContext.at(this);
            if (d != d || d2 != d2) {
                return this.test == ValueNeOp.TEST;
            }
            return this.test.make(BaseValue.compare(d, d2));
        }
    }

    public static class ExecInt
    extends Comparison.Exec {
        public void dump(ExprDisplay exprDisplay) {
            exprDisplay.header(this);
            exprDisplay.property("test", this.test.getName());
            exprDisplay.child("left", this.args[0]);
            exprDisplay.child("right", this.args[1]);
        }

        public boolean evalAsBoolean(Focus focus, EvalContext evalContext) throws EvaluationException {
            long l = this.args[0].evalAsOptInteger(focus, evalContext);
            long l2 = this.args[1].evalAsOptInteger(focus, evalContext);
            evalContext.at(this);
            return this.test.make(BaseValue.compare(l - l2));
        }
    }
}

