/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.op;

import com.qizx.api.DataModelException;
import com.qizx.api.EvaluationException;
import com.qizx.xdm.BasicNode;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.ExprDisplay;
import com.qizx.xquery.Focus;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.ArraySequence;
import com.qizx.xquery.op.Expression;
import java.util.Arrays;
import java.util.Comparator;

public class NodeSortExpr
extends Expression {
    public Expression expr;

    public NodeSortExpr(Expression expression) {
        this.expr = expression;
        this.type = expression.getType();
    }

    public Expression child(int n) {
        return n == 0 ? this.expr : null;
    }

    public void dump(ExprDisplay exprDisplay) {
        exprDisplay.header(this);
        exprDisplay.child("expr", this.expr);
    }

    public int getFlags() {
        return 8;
    }

    public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
        XQValue xQValue = this.expr.eval(focus, evalContext);
        return new Sequence(xQValue);
    }

    public static class Sequence
    extends ArraySequence {
        public boolean needsSort = true;
        public boolean isDistinct;

        public Sequence(XQValue xQValue) throws EvaluationException {
            super(new XQItem[16], 0);
            while (xQValue.next()) {
                this.addItem((BasicNode)xQValue.getNode());
            }
            this.setOrigin(xQValue);
        }

        public Sequence(BasicNode[] basicNodeArray, int n) {
            super(basicNodeArray, n);
        }

        public void addNodes(BasicNode[] basicNodeArray, int n) {
            super.addItems(basicNodeArray, n);
        }

        public void sort() {
            this.pack();
            Arrays.sort(this.items, 0, this.size, new Comparator(){

                public int compare(Object object, Object object2) {
                    BasicNode basicNode = (BasicNode)object;
                    BasicNode basicNode2 = (BasicNode)object2;
                    try {
                        return basicNode.documentOrderCompareTo(basicNode2);
                    }
                    catch (DataModelException dataModelException) {
                        return 0;
                    }
                }
            });
            if (!this.isDistinct && this.size > 0) {
                Object object = this.items[0];
                int n = Math.min(this.size, 1);
                for (int i = 1; i < this.size; ++i) {
                    Object object2 = this.items[i];
                    if (object2.equals(object)) continue;
                    object = object2;
                    this.items[n++] = object2;
                }
                this.size = n;
                this.isDistinct = true;
            }
            this.needsSort = false;
        }

        public boolean next() throws EvaluationException {
            if (this.needsSort || this.overflow != null) {
                this.sort();
            }
            return super.next();
        }

        public long quickCount(EvalContext evalContext) throws EvaluationException {
            if (!this.isDistinct) {
                this.sort();
            }
            return super.quickCount(evalContext);
        }
    }
}

