/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.op;

import com.qizx.api.EvaluationException;
import com.qizx.api.util.time.DateTimeException;
import com.qizx.api.util.time.Duration;
import com.qizx.xdm.Conversion;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.ExprDisplay;
import com.qizx.xquery.Focus;
import com.qizx.xquery.ModuleContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.SingleDecimal;
import com.qizx.xquery.dt.SingleDouble;
import com.qizx.xquery.dt.SingleDuration;
import com.qizx.xquery.dt.SingleFloat;
import com.qizx.xquery.dt.SingleInteger;
import com.qizx.xquery.dt.SingleMoment;
import com.qizx.xquery.fn.Function;
import com.qizx.xquery.fn.Prototype;
import com.qizx.xquery.op.Expression;
import com.qizx.xquery.op.NumericOp;

public class MinusOp
extends NumericOp {
    public MinusOp(Expression expression, Expression expression2) {
        super(expression, expression2);
    }

    public Prototype[] getProtos() {
        return null;
    }

    public void dump(ExprDisplay exprDisplay) {
        exprDisplay.multi(this, this.operands);
    }

    public Expression staticCheck(ModuleContext moduleContext, int n) {
        switch (this.combinedArgTypes(moduleContext)) {
            case 17: {
                return this.transfer(new ExecInt(), this.operands);
            }
            case 20: 
            case 36: 
            case 52: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                return this.transfer(new ExecDouble(), this.operands);
            }
        }
        return this.transfer(new ExecAny(), this.operands);
    }

    public static class ExecAny
    extends Function.NumericCall {
        public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
            evalContext.at(this);
            XQItem xQItem = this.args[0].evalAsOptItem(focus, evalContext);
            XQItem xQItem2 = this.args[1].evalAsOptItem(focus, evalContext);
            if (xQItem == null || xQItem2 == null) {
                return XQValue.empty;
            }
            try {
                switch (NumericOp.combinedArgTypes(xQItem, xQItem2)) {
                    case 17: {
                        long l = xQItem.getInteger();
                        long l2 = xQItem2.getInteger();
                        if (!Conversion.isIntegerRange((double)l - (double)l2)) {
                            evalContext.error("FOAR0002", (Expression)this, "integer overflow");
                        }
                        return new SingleInteger(l - l2);
                    }
                    case 18: 
                    case 33: 
                    case 34: {
                        return new SingleDecimal(xQItem.getDecimal().subtract(xQItem2.getDecimal()));
                    }
                    case 19: 
                    case 35: 
                    case 49: 
                    case 50: 
                    case 51: {
                        return new SingleFloat(xQItem.getFloat() - xQItem2.getFloat());
                    }
                    case 20: 
                    case 36: 
                    case 52: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: {
                        return new SingleDouble(xQItem.getDouble() - xQItem2.getDouble());
                    }
                    case 170: {
                        Duration duration = xQItem.getDuration();
                        Duration duration2 = xQItem2.getDuration();
                        return SingleDuration.newYM(Duration.newYearMonth(duration.getTotalMonths() - duration2.getTotalMonths()));
                    }
                    case 187: {
                        Duration duration = xQItem.getDuration();
                        Duration duration3 = xQItem2.getDuration();
                        return SingleDuration.newDT(Duration.newDayTime(duration.getTotalSeconds() - duration3.getTotalSeconds()));
                    }
                    case 119: 
                    case 136: 
                    case 153: {
                        double d = xQItem.getMoment().getMillisecondsFromEpoch();
                        double d2 = xQItem2.getMoment().getMillisecondsFromEpoch();
                        return SingleDuration.newDT(Duration.newDayTime((d - d2) / 1000.0));
                    }
                    case 138: 
                    case 139: {
                        return SingleMoment.dateTime(xQItem.getMoment().subtract(xQItem2.getDuration()));
                    }
                    case 154: 
                    case 155: {
                        return SingleMoment.date(xQItem.getMoment().subtract(xQItem2.getDuration()));
                    }
                    case 123: {
                        return SingleMoment.time(xQItem.getMoment().subtract(xQItem2.getDuration()));
                    }
                }
                evalContext.error("XPTY0004", (Expression)this, "invalid types for operator -");
            }
            catch (DateTimeException dateTimeException) {
                evalContext.error("XPTY0004", (Expression)this, "should not happen: " + dateTimeException);
            }
            return null;
        }
    }

    public static class ExecDouble
    extends Function.OptDoubleCall {
        public double evalAsOptDouble(Focus focus, EvalContext evalContext) throws EvaluationException {
            double d = this.args[0].evalAsOptDouble(focus, evalContext);
            double d2 = this.args[1].evalAsOptDouble(focus, evalContext);
            evalContext.at(this);
            return d - d2;
        }
    }

    public static class ExecInt
    extends Function.OptIntegerCall {
        public long evalAsOptInteger(Focus focus, EvalContext evalContext) throws EvaluationException {
            long l = this.args[0].evalAsInteger(focus, evalContext);
            long l2 = this.args[1].evalAsInteger(focus, evalContext);
            evalContext.at(this);
            if (!Conversion.isIntegerRange((double)l - (double)l2)) {
                evalContext.error("FOAR0002", (Expression)this, "integer overflow");
            }
            return l - l2;
        }
    }
}

